/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.balance.CreditBalanceSeletor;
import com.kingdee.eas.scm.credit.app.balance.CreditBalanceUpdateStrategy;
import com.kingdee.eas.scm.credit.app.balance.IAlterPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IAuditPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IDeletePushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IHandClosedPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.ISubmitPushCreditBalance;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillInfo;
import java.math.BigDecimal;

public class NetOrderBalanceUpdateProxy
extends CreditBalanceUpdateStrategy
implements IAuditPushCreditBalance,
IAlterPushCreditBalance,
IHandClosedPushCreditBalance,
ISubmitPushCreditBalance,
IDeletePushCreditBalance {
    public NetOrderBalanceUpdateProxy(Context ctx) {
        super(ctx);
    }

    @Override
    public boolean isNeedUpdateCreditBalanceForBill(CreditParamInfo param) throws BOSException, EASBizException {
        return true;
    }

    @Override
    protected void updateRule(String operator, BigDecimal locTotalAmt) {
        if (operator.equals("DELETE")) {
            this.pushBalance("FUnOutSaleOrderBillAmt", locTotalAmt.negate());
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.DELETE);
        } else if (operator.equals("AUDIT")) {
            this.pushBalance("FUnOutSaleOrderBillAmt", locTotalAmt.negate());
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.AUDIT);
        } else if (operator.equals("CLOSE")) {
            this.pushBalance("FUnOutSaleOrderBillAmt", locTotalAmt.negate());
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.CLOSE);
        } else if (operator.equals("UPDATE")) {
            this.pushBalance("FUnOutSaleOrderBillAmt", locTotalAmt.negate());
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.SUBMIT);
        } else if (operator.equals("UNAUDIT")) {
            this.pushBalance("FUnOutSaleOrderBillAmt", locTotalAmt);
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNAUDIT);
        } else if (operator.equals("UNCLOSE")) {
            this.pushBalance("FUnOutSaleOrderBillAmt", locTotalAmt);
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNCLOSE);
        }
    }

    @Override
    protected CreditFormulaSceneEnum getBillSecene() {
        return CreditFormulaSceneEnum.NETORDERBILL;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtAudit(IObjectValue billInfo) throws BOSException, EASBizException {
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.AUDIT);
        return this.pushCreditBalanceAtDelete(billInfo);
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtHandClosed(IObjectValue billInfo) throws BOSException, EASBizException {
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.CLOSE);
        return this.pushCreditBalanceAtDelete(billInfo);
    }

    public CreditBalanceUpdateStrategy pushCreditBalanceAtHandClosed(IObjectValue billInfo, BigDecimal amt) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector((NetOrderBillInfo)billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.CLOSE);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        selector.pushBalance("FUnOutSaleOrderBillAmt", SCMUtils.effectualNumeric((BigDecimal)amt).negate());
        return this;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtDelete(IObjectValue billInfo) throws BOSException, EASBizException {
        CreditOperationEnum oper = this.visitOperation();
        if (oper.getValue() == 0) {
            oper = CreditOperationEnum.DELETE;
        }
        CreditBalanceSeletor selector = this.getSelector((NetOrderBillInfo)billInfo);
        this.creditBalance.put("REDITOPERATION", oper);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        BigDecimal amt = SCMUtils.effectualNumeric((BigDecimal)this.visitNetOrderBillInfo().getAmount());
        selector.pushBalance("FUnOutSaleOrderBillAmt", amt.negate());
        return this;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtAlter(IObjectValue billInfo, IObjectValue oldBillInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector((NetOrderBillInfo)billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.ALTER);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        NetOrderBillInfo oldBill = NetOrderBalanceUpdateProxy.readFullNetOrderBillInfo(this.ctx, (NetOrderBillInfo)oldBillInfo);
        selector.pushBalance("FUnOutSaleOrderBillAmt", SCMUtils.effectualNumeric((BigDecimal)((NetOrderBillInfo)billInfo).getAmount().subtract(oldBill.getAmount())));
        return this;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtSubmit(IObjectValue billInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector((NetOrderBillInfo)billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.SUBMIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        BigDecimal amt = SCMUtils.effectualNumeric((BigDecimal)((NetOrderBillInfo)billInfo).getAmount());
        selector.pushBalance("FUnOutSaleOrderBillAmt", amt);
        return this;
    }

    public NetOrderBillInfo visitNetOrderBillInfo() {
        NetOrderBillInfo order = null;
        IObjectValue o = super.visitBillInfo();
        if (o != null && o instanceof NetOrderBillInfo) {
            order = (NetOrderBillInfo)o;
        }
        return order;
    }

    private CreditBalanceSeletor getSelector(NetOrderBillInfo billInfo) throws BOSException, EASBizException {
        this.billChanged();
        this.pushCommonBalance(billInfo);
        CreditBalanceSeletor selector = new CreditBalanceSeletor(this);
        selector.setCompany(this.visitCompany());
        return selector;
    }

    private void pushCommonBalance(NetOrderBillInfo billInfo) throws EASBizException, BOSException {
        this.creditBalance.clear();
        NetOrderBillInfo netOrder = NetOrderBalanceUpdateProxy.readFullNetOrderBillInfo(this.ctx, billInfo);
        if (netOrder != null) {
            this.creditBalance.put("BILLINFO", netOrder);
            this.creditBalance.put("COMPANY", CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(this.ctx, (OrgUnitInfo)netOrder.getCompanyOrgUnit()));
            this.creditBalance.put("CUSTOMER", CreditUtils.readFullCustomerInfo(this.ctx, netOrder.getCustomer()));
            this.creditBalance.put("BILLDATE", netOrder.getBizDate());
            this.creditBalance.put("BILLTYPE", "PQmB0qv6S02gx+xypWAQo8LWunc=");
            this.creditBalance.put("BILLID", netOrder.getId().toString());
            this.creditBalance.put("BILLNUMBER", netOrder.getNumber().toString());
            this.creditBalance.put("REMARK", "");
            this.creditBalance.put("REMARK_L1", "");
            this.creditBalance.put("REMARK_L2", "");
            this.creditBalance.put("REMARK_L3", "");
        }
    }

    public static NetOrderBillInfo readFullNetOrderBillInfo(Context ctx, NetOrderBillInfo netOrder) throws EASBizException, BOSException {
        NetOrderBillInfo so = netOrder;
        if (!(netOrder == null || netOrder.getId() == null || netOrder.containsKey("saleOrgUnit") && netOrder.containsKey("customer") && netOrder.containsKey("companyOrgUnit") && netOrder.containsKey("amount") && netOrder.containsKey("number") && netOrder.containsKey("bizDate") && netOrder.containsKey("billType") && netOrder.containsKey("baseStatus"))) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("number"));
            selectors.add(new SelectorItemInfo("bizDate"));
            selectors.add(new SelectorItemInfo("billType"));
            selectors.add(new SelectorItemInfo("saleOrgUnit.id"));
            selectors.add(new SelectorItemInfo("customer.id"));
            selectors.add(new SelectorItemInfo("companyOrgUnit.id"));
            selectors.add(new SelectorItemInfo("amount"));
            selectors.add(new SelectorItemInfo("baseStatus"));
            so = NetOrderBillFactory.getLocalInstance((Context)ctx).getNetOrderBillInfo((IObjectPK)new ObjectStringPK(netOrder.getId().toString()), selectors);
        }
        return so;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtHandUnClosed(IObjectValue billInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public boolean isNeedCreditLog() {
        return true;
    }

    @Override
    public String getCreditAccount() {
        return "DawAAAAPiJDuN4KI";
    }
}

