/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.app.balance.CreditBalanceUpdateStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlHelper;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PostbillUpdateProxy
extends CreditBalanceUpdateStrategy {
    public PostbillUpdateProxy(Context ctx) {
        super(ctx);
    }

    @Override
    public boolean isNeedUpdateCreditBalanceForBill(CreditParamInfo param) throws BOSException, EASBizException {
        PaymentTypeInfo paymentType;
        if (param == null || !param.isCtrlPostbillAmount()) {
            return false;
        }
        boolean isNeed = false;
        PostRequisitionInfo billInfo = CreditControlHelper.readFullPostRequisitionInfo(this.ctx, this.visitPostRequisitionInfo());
        if (billInfo != null && (paymentType = billInfo.getPaymentType()) != null && paymentType.getId() != null) {
            isNeed = "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5".equalsIgnoreCase(paymentType.getId().toString());
        }
        return isNeed;
    }

    public void udpateAtSubmited(PostRequisitionInfo billInfo, PostRequisitionInfo oldInfo) throws BOSException, EASBizException {
        if (oldInfo != null) {
            PostRequisitionInfo newBill = CreditControlHelper.readFullPostRequisitionInfo(this.ctx, billInfo);
            PostRequisitionInfo oldBill = CreditControlHelper.readFullPostRequisitionInfo(this.ctx, oldInfo);
            if (oldBill.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                String oldPayId;
                String newPayId = newBill.getPaymentType().getId().toString();
                if (newPayId.equals(oldPayId = oldBill.getPaymentType().getId().toString()) && newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                    String newCustId = newBill.getEntries().get(0).getDeliveryCustomer().getId().toString();
                    String oldCustId = oldBill.getEntries().get(0).getDeliveryCustomer().getId().toString();
                    String newCompId = newBill.getSaleOrgUnit().getId().toString();
                    String oldCompId = oldBill.getSaleOrgUnit().getId().toString();
                    if (newCustId.equals(oldCustId) && newCompId.equals(oldCompId)) {
                        this.updateAtUpdated(newBill, oldBill);
                    } else {
                        ArrayList<String> idLst = new ArrayList<String>();
                        idLst.add(oldBill.getId().toString());
                        this.updateAtDeleted(idLst);
                        this.udpateAtSubmited(newBill);
                    }
                } else if (newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                    this.udpateAtSubmited(newBill);
                } else if (oldPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                    ArrayList<String> idLst = new ArrayList<String>();
                    idLst.add(oldBill.getId().toString());
                    this.updateAtDeleted(idLst);
                }
            } else {
                this.udpateAtSubmited(newBill);
            }
        } else {
            this.udpateAtSubmited(billInfo);
        }
    }

    private void udpateAtSubmited(PostRequisitionInfo billInfo) throws BOSException, EASBizException {
        this.init(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.SUBMIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            return;
        }
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || creditParamInfo.getPostbill_CtrlTime() != 1) {
            return;
        }
        BigDecimal locTotalAmt = CreditUtils.sumPostbillLocalAmount(billInfo);
        this.pushBalance("FUnAuditPostBillAmt", locTotalAmt);
        this.updateCreditBalance();
    }

    public void updateAtUpdated(PostRequisitionInfo billInfo, PostRequisitionInfo oldInfo) throws BOSException, EASBizException {
        this.init(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.SUBMIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            return;
        }
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || creditParamInfo.getPostbill_CtrlTime() != 1) {
            return;
        }
        oldInfo = CreditControlHelper.readFullPostRequisitionInfo(this.ctx, oldInfo);
        if (billInfo != null && oldInfo != null) {
            BigDecimal locTotalAmt = CreditUtils.sumPostbillLocalAmount(billInfo);
            BigDecimal oldLLocTotalAmt = CreditUtils.sumPostbillLocalAmount(oldInfo);
            BigDecimal diffAmt = locTotalAmt.subtract(oldLLocTotalAmt);
            this.pushBalance("FUnAuditPostBillAmt", diffAmt);
            this.updateCreditBalance();
        }
    }

    public void updateAtAudited(List idLst) throws BOSException, EASBizException {
        if (idLst == null || idLst.size() <= 0) {
            return;
        }
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(idLst.iterator(), params);
        this.batchUpdate(this.getSelectBillSql(paramStr), params, "AUDIT");
    }

    public void updateAtUnAudited(List idLst) throws BOSException, EASBizException {
        if (idLst == null || idLst.size() <= 0) {
            return;
        }
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(idLst.iterator(), params);
        this.batchUpdate(this.getSelectBillSql(paramStr), params, "UNAUDIT");
    }

    public void updateAtAudited_IssuedWB(List issuedEntryIdLst) throws BOSException, EASBizException {
        if (issuedEntryIdLst == null || issuedEntryIdLst.size() <= 0) {
            return;
        }
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(issuedEntryIdLst.iterator(), params);
        String tempTable = "IssuedWBTemp__1";
        if ((tempTable = this.buildIssuedWBTempTable(paramStr, params, tempTable)) != null) {
            String sql = this.getSelectBillSql_IssuedWB(tempTable, "AUDIT_WB");
            this.batchUpdate(sql, null, "AUDIT_WB");
        }
        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
    }

    public void updateAtUnAudited_IssuedWB(List issuedEntryIdLst) throws BOSException, EASBizException {
        if (issuedEntryIdLst == null || issuedEntryIdLst.size() <= 0) {
            return;
        }
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(issuedEntryIdLst.iterator(), params);
        String tempTable = "IssuedWBTemp__2";
        if ((tempTable = this.buildIssuedWBTempTable(paramStr, params, tempTable)) != null) {
            String sql = this.getSelectBillSql_IssuedWB(tempTable, "UNAUDIT_WB");
            this.batchUpdate(sql, null, "UNAUDIT_WB");
        }
        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
    }

    private String getSelectBillSql(String paramStr) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("SELECT orgRe.FToUnitID as FCompanyOrgUnitId,t1.FDeliveryCustomerID as FOrderCustomerID,").append(" t0.FID as FID, t0.FNumber as FNumber, t0.FBizDate as FBizDate, t0.FBilltypeID as FBilltypeID, ").append(" SUM(t1.flocalAmount) AS locAmt ").append(" FROM T_SD_PostRequisition t0 ").append("  INNER JOIN T_SD_PostRequisitionEntry t1 ON  t0.FID = t1.FParentID ").append("  INNER JOIN T_BD_Customer t2 ON t1.FDeliveryCustomerID = t2.FID").append("  INNER JOIN T_ORG_UnitRelation orgRe ON orgRe.FFromUnitID = t0.FSaleOrgUnitID AND ").append("      orgRe.FTypeRelationID = '00000000-0000-0000-0000-0000000000050FE9F8B5' ").append(" WHERE t0.FID in ").append(paramStr).append(" AND t2.FIsCredited = 1 ").append(" GROUP BY orgRe.FToUnitID,t1.FDeliveryCustomerID,t0.FID,t0.FNumber,t0.FBizDate,t0.FBilltypeID ");
        return strSQL.toString();
    }

    private String getSql_delete(String paramStr) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("SELECT orgRe.FToUnitID as FCompanyOrgUnitId,t1.FDeliveryCustomerID as FOrderCustomerID,").append(" t0.FID as FID, t0.FNumber as FNumber, t0.FBizDate as FBizDate, t0.FBilltypeID as FBilltypeID, ").append(" SUM(t1.flocalAmount) AS locAmt ").append(" FROM T_SD_PostRequisition t0 ").append("  INNER JOIN T_SD_PostRequisitionEntry t1 ON  t0.FID = t1.FParentID ").append("  INNER JOIN T_BD_Customer t2 ON t1.FDeliveryCustomerID = t2.FID").append("  INNER JOIN T_ORG_UnitRelation orgRe ON orgRe.FFromUnitID = t0.FSaleOrgUnitID AND ").append("      orgRe.FTypeRelationID = '00000000-0000-0000-0000-0000000000050FE9F8B5' ").append(" WHERE t0.FID in ").append(paramStr).append(" AND t0.FBaseStatus = ").append(2).append(" AND t2.FIsCredited = 1 ").append(" GROUP BY orgRe.FToUnitID,t1.FDeliveryCustomerID,t0.FID,t0.FNumber,t0.FBizDate,t0.FBilltypeID ");
        return strSQL.toString();
    }

    private String getSelectBillSql_Close(String paramStr) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("SELECT orgRe.FToUnitID as FCompanyOrgUnitId,t1.FDeliveryCustomerID as FOrderCustomerID,").append(" t0.FID as FID, t0.FNumber as FNumber, t0.FBizDate as FBizDate, t0.FBilltypeID as FBilltypeID, ").append(" SUM(case when abs(t1.FQty) - abs(t1.FShippedQty)<=0 then 0 ").append(" when t1.fqty > 0  ").append("  then to_decimal(to_decimal((t1.FQty - t1.FShippedQty) / t1.FQty,21,10) * t1.flocalAmount,19,4)  ").append(" when t1.fqty < 0  ").append("  then to_decimal(to_decimal((abs(t1.FQty) - abs(t1.FShippedQty)) / t1.FQty,21,10) * abs(t1.flocalAmount),19,4)  ").append("   else 0 end ) AS locAmt ").append(" FROM T_SD_PostRequisition t0 ").append("  INNER JOIN T_SD_PostRequisitionEntry t1 ON  t0.FID = t1.FParentID ").append("  INNER JOIN T_BD_Customer t2 ON t1.FDeliveryCustomerID = t2.FID").append("  INNER JOIN T_ORG_UnitRelation orgRe ON orgRe.FFromUnitID = t0.FSaleOrgUnitID AND ").append("      orgRe.FTypeRelationID = '00000000-0000-0000-0000-0000000000050FE9F8B5' ").append(" WHERE t1.FID in ").append(paramStr).append(" AND t2.FIsCredited = 1 ").append(" GROUP BY orgRe.FToUnitID,t1.FDeliveryCustomerID,t0.FID,t0.FNumber,t0.FBizDate,t0.FBilltypeID ");
        return strSQL.toString();
    }

    private String getSelectBillSql_IssuedWB(String paramStr, String operator) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("SELECT orgRe.FToUnitID as FCompanyOrgUnitId, t1.FDeliveryCustomerID as FOrderCustomerID, ").append(" t0.FID as FID, t3.FNumber as FNumber, t0.FBizDate as FBizDate, t0.FBilltypeID as FBilltypeID, ").append(" SUM(case when t1.FQty = 0 then 0 ").append(" when t3.FIsReversed = 0 and t3.FQty < 0 then 0 ");
        strSQL.append(" when t3.FIsReversed=0 and abs(t1.FShippedQty)-abs(CASE WHEN t3.FUnitID=t1.FUnitID THEN t3.FQty ELSE t3.FQty*mmu2.FBaseConvsRate/mmu.FBaseConvsRate END)>=abs(t1.FQty) ").append("\tthen 0 ");
        if ("AUDIT_WB".equals(operator)) {
            strSQL.append(" when t3.FIsReversed=0 and abs(t1.FShippedQty)<=abs(t1.FQty) ");
        } else if ("UNAUDIT_WB".equals(operator)) {
            strSQL.append(" when t3.FIsReversed=0 and abs(t1.FShippedQty)<=abs(t1.FQty) and t1.FBaseStatus <> 7 ");
        }
        strSQL.append(" then to_decimal(to_decimal(abs(CASE WHEN t3.FUnitID=t1.FUnitID THEN t3.FQty ELSE t3.FQty*mmu2.FBaseConvsRate/mmu.FBaseConvsRate END)*t1.FLocalAmount,19,4)/t1.FQty,19,4) ").append(" when FIsReversed=0 then to_decimal(to_decimal((abs(t1.FQty)-(abs(t1.FShippedQty)-abs(CASE WHEN t3.FUnitID=t1.FUnitID THEN t3.FQty ELSE t3.FQty*mmu2.FBaseConvsRate/mmu.FBaseConvsRate END)))*t1.FLocalAmount,19,4)/t1.FQty,19,4) ").append(" when t3.FIsReversed=1 and abs(t1.FShippedQty)>=abs(t1.FQty) then 0 ").append(" when t3.FIsReversed=1 and abs(t1.FShippedQty)+abs(CASE WHEN t3.FUnitID=t1.FUnitID THEN t3.FQty ELSE t3.FQty*mmu2.FBaseConvsRate/mmu.FBaseConvsRate END)<=abs(t1.FQty) ").append(" then to_decimal(to_decimal(abs(CASE WHEN t3.FUnitID=t1.FUnitID THEN t3.FQty ELSE t3.FQty*mmu2.FBaseConvsRate/mmu.FBaseConvsRate END)*t1.FLocalAmount,19,4)/t1.FQty,19,4) ").append(" when t3.FIsReversed=1 then to_decimal(to_decimal((abs(t1.FQty)-abs(t1.FShippedQty))*t1.FLocalAmount,19,4)/t1.FQty,19,4) ");
        strSQL.append(" end) AS locAmt ").append(" FROM T_SD_PostRequisition t0 ").append(" INNER JOIN T_SD_PostRequisitionEntry t1 ON t0.FID = t1.FParentID ").append(" INNER JOIN ").append(paramStr).append(" T3 ON t1.FID = t3.FSourceBillEntryID ").append(" INNER JOIN T_BD_Customer t2 ON t1.FDeliveryCustomerID = t2.FID ").append(" INNER JOIN T_ORG_UnitRelation orgRe ON orgRe.FFromUnitID = t0.FSaleOrgUnitID AND ").append("\torgRe.FTypeRelationID = '00000000-0000-0000-0000-0000000000050FE9F8B5' ").append(" LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=t1.FMaterialID AND mmu.FMeasureUnitID=t1.FUnitID ").append(" LEFT JOIN T_BD_MultiMeasureUnit mmu2 ON mmu2.FMaterialID=t3.FMaterialID AND mmu2.FMeasureUnitID=t3.FUnitID ").append(" WHERE t2.FIsCredited = 1 GROUP BY orgRe.FToUnitID, t1.FDeliveryCustomerID,t0.FID, t3.FNumber,t0.FBizDate,t0.FBilltypeID ");
        return strSQL.toString();
    }

    private String buildIssuedWBTempTable(String paramStr, List params, String tempTable) throws BOSException {
        if (tempTable == null) {
            return null;
        }
        String sp = "\r\n";
        StringBuffer createTableSQL = new StringBuffer();
        createTableSQL.append("Create Table ").append(tempTable).append(sp).append(" (FNumber NVARCHAR(80),FSourceBillEntryID VARCHAR(44),FIsReversed INT,").append(sp).append("FMaterialID VARCHAR(44),FUnitID VARCHAR(44),FQty DECIMAL(21,8))");
        try {
            tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(createTableSQL.toString());
        }
        catch (Exception e) {
            throw new SQLDataException(e.getMessage());
        }
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("INSERT INTO ").append(tempTable).append(sp);
        insertSQL.append(" SELECT t4.FNumber, t3.FSourceBillEntryID,t4.FIsReversed,t3.FMaterialID,t3.FUnitID,t3.FQty ").append(sp).append(" FROM T_IM_SaleIssueEntry T3 INNER JOIN T_IM_SaleIssueBill T4 ON t3.FParentID = t4.FID ").append(sp).append(" WHERE t3.FID IN ").append(paramStr);
        int length = params.size();
        SqlParams sqlParams = new SqlParams();
        for (int i = 0; i < length; ++i) {
            sqlParams.addString(params.get(i).toString());
        }
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            if (DBUtil.executeUpdate((String)insertSQL.toString(), (SqlParams)sqlParams, (Connection)con) != 0) {
                String string = tempTable;
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + insertSQL.toString()));
            throw new SQLDataException(e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(null, null, (Connection)con);
        }
    }

    public void updateAtDeleted(List idLst) throws BOSException, EASBizException {
        if (idLst == null || idLst.size() <= 0) {
            return;
        }
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(idLst.iterator(), params);
        this.batchUpdate(this.getSql_delete(paramStr), params, "DELETE");
    }

    public void updateAtClosed(List entryIdLst) throws BOSException, EASBizException {
        if (entryIdLst == null || entryIdLst.size() <= 0) {
            return;
        }
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(entryIdLst.iterator(), params);
        this.batchUpdate(this.getSelectBillSql_Close(paramStr), params, "CLOSE");
    }

    public void updateAtUnClosed(List entryIdLst) throws BOSException, EASBizException {
        if (entryIdLst == null || entryIdLst.size() <= 0) {
            return;
        }
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(entryIdLst.iterator(), params);
        this.batchUpdate(this.getSelectBillSql_Close(paramStr), params, "UNCLOSE");
    }

    @Override
    protected void updateRule(String operator, BigDecimal locTotalAmt) {
        try {
            this.creditParam = CreditServerUtil.getCreditParamInfo(this.ctx, this.visitCompany().getId().toString());
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        if (operator.equals("CLOSE")) {
            this.pushBalance("FUnOutPostBillAmt", locTotalAmt.negate());
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.CLOSE);
        } else if (operator.equals("UNCLOSE")) {
            this.pushBalance("FUnOutPostBillAmt", locTotalAmt);
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNCLOSE);
        } else if (operator.equals("DELETE")) {
            if (this.creditParam != null && this.creditParam.getPostbill_CtrlTime() == 1) {
                this.pushBalance("FUnAuditPostBillAmt", locTotalAmt.negate());
            }
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.DELETE);
        } else if (operator.equals("AUDIT")) {
            if (this.creditParam != null && this.creditParam.getPostbill_CtrlTime() == 1) {
                this.pushBalance("FUnAuditPostBillAmt", locTotalAmt.negate());
            }
            this.pushBalance("FUnOutPostBillAmt", locTotalAmt);
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.AUDIT);
        } else if (operator.equals("UNAUDIT")) {
            this.pushBalance("FUnOutPostBillAmt", locTotalAmt.negate());
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNAUDIT);
        } else if (operator.equals("AUDIT_WB")) {
            this.pushBalance("FUnOutPostBillAmt", locTotalAmt.negate());
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.AUDIT);
            this.creditBalance.put("BILLTYPE", "50957179-0105-1000-e000-015bc0a812fd463ED552");
        } else if (operator.equals("UNAUDIT_WB")) {
            this.pushBalance("FUnOutPostBillAmt", locTotalAmt);
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNAUDIT);
            this.creditBalance.put("BILLTYPE", "50957179-0105-1000-e000-015bc0a812fd463ED552");
        }
    }

    private void init(PostRequisitionInfo billInfo) throws BOSException, EASBizException {
        this.billChanged();
        billInfo = CreditControlHelper.readFullPostRequisitionInfo(this.ctx, billInfo);
        this.creditBalance.clear();
        if (billInfo != null) {
            this.creditBalance.put("BILLINFO", billInfo);
            this.creditBalance.put("COMPANY", CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(this.ctx, (OrgUnitInfo)billInfo.getSaleOrgUnit()));
            CustomerInfo cust = billInfo.getEntries().get(0).getDeliveryCustomer();
            this.creditBalance.put("CUSTOMER", CreditUtils.readFullCustomerInfo(this.ctx, cust));
            this.creditBalance.put("BILLDATE", billInfo.getBizDate());
            this.creditBalance.put("BILLTYPE", "510b6503-0105-1000-e000-011bc0a812fd463ED552");
            this.creditBalance.put("BILLID", billInfo.getId().toString());
            this.creditBalance.put("BILLNUMBER", billInfo.getNumber().toString());
            this.creditBalance.put("REMARK", "");
            this.creditBalance.put("REMARK_L1", "");
            this.creditBalance.put("REMARK_L2", "");
            this.creditBalance.put("REMARK_L3", "");
        }
    }

    @Override
    protected CreditFormulaSceneEnum getBillSecene() {
        return CreditFormulaSceneEnum.POSTBILL;
    }

    public PostRequisitionInfo visitPostRequisitionInfo() {
        PostRequisitionInfo postRequisitionInfo = null;
        IObjectValue o = super.visitBillInfo();
        if (o != null && o instanceof PostRequisitionInfo) {
            postRequisitionInfo = (PostRequisitionInfo)o;
        }
        return postRequisitionInfo;
    }

    @Override
    public boolean isNeedCreditLog() {
        return true;
    }

    @Override
    public String getCreditAccount() {
        return "DawAAAAPiJDuN4KI";
    }
}

