/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fi.arap.api.IArApBillHeadInfo;
import com.kingdee.eas.fi.arap.api.IArapBillEntryInfo;
import com.kingdee.eas.framework.AbstractBillEntryBaseInfo;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.balance.CreditBalanceSeletor;
import com.kingdee.eas.scm.credit.app.balance.CreditBalanceUpdateStrategy;
import com.kingdee.eas.scm.credit.app.balance.IAuditPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IUnAuditPushCreditBalance;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

public class ReceivableBillBalanceProxy
extends CreditBalanceUpdateStrategy
implements IAuditPushCreditBalance,
IUnAuditPushCreditBalance {
    public static final String CREDITBALANCE_KEY_ORDERCUSTOMERS = "ORDERCUSTOMERS";
    public static final String CREDITBALANCE_KEY_RECEIVECUSTOMERS = "RECEIVECUSTOMERS";

    public ReceivableBillBalanceProxy(Context ctx) throws BOSException {
        super(ctx);
    }

    private void pushCommonBalance(IObjectValue billInfo) throws EASBizException, BOSException {
        this.creditBalance.clear();
        IArApBillHeadInfo receivable = ReceivableBillBalanceProxy.readFullReceivableBillInfo(this.ctx, ReceivableBillBalanceProxy.visitReceivableBillInfo(billInfo));
        if (receivable != null) {
            this.creditBalance.put("BILLINFO", receivable);
            this.creditBalance.put("BILLDATE", receivable.get("billDate"));
            this.creditBalance.put("BILLTYPE", "510b6503-0105-1000-e000-0117c0a812fd463ED552");
            this.creditBalance.put("BILLID", receivable.getId().toString());
            this.creditBalance.put("BILLNUMBER", receivable.getNumber().toString());
            this.creditBalance.put("REMARK", "");
            this.creditBalance.put("REMARK_L1", "");
            this.creditBalance.put("REMARK_L2", "");
            this.creditBalance.put("REMARK_L3", "");
            if (this.isNeedUpdateCreditBalanceForBill(null)) {
                this.creditBalance.put("COMPANY", CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(this.ctx, (OrgUnitInfo)receivable.getCompany()));
                CustomerInfo customer = new CustomerInfo();
                customer.setId(BOSUuid.read((String)receivable.getAsstActID()));
                this.creditBalance.put("CUSTOMER", CreditUtils.readFullCustomerInfo(this.ctx, customer));
                HashMap ocHashMap = new HashMap();
                this.creditBalance.put(CREDITBALANCE_KEY_ORDERCUSTOMERS, ocHashMap);
                HashMap rcHashMap = new HashMap();
                this.creditBalance.put(CREDITBALANCE_KEY_RECEIVECUSTOMERS, rcHashMap);
                IObjectCollection obeCollection = receivable.getEntries();
                int n = obeCollection.size();
                for (int i = 0; i < n; ++i) {
                    AbstractBillEntryBaseInfo obEntryInfo = (AbstractBillEntryBaseInfo)obeCollection.getObject(i);
                    this.insertIntoHaspMap(ocHashMap, (CustomerInfo)obEntryInfo.get("orderCustomer"));
                    this.insertIntoHaspMap(rcHashMap, (CustomerInfo)obEntryInfo.get("serviceCustomer"));
                }
            } else {
                this.isUpdateCredite = false;
            }
        }
    }

    private void insertIntoHaspMap(HashMap hm, CustomerInfo customerInfo) throws EASBizException, BOSException {
        String customerID;
        if (hm != null && customerInfo != null && !hm.containsKey(customerID = customerInfo.getId().toString())) {
            Object[] infos = new Object[]{CreditUtils.readFullCustomerInfo(this.ctx, customerInfo), SysConstant.BIGZERO, SysConstant.BIGZERO};
            hm.put(customerID, infos);
        }
    }

    @Override
    public final CreditBalanceUpdateStrategy pushCreditBalanceAtAudit(IObjectValue billInfo) throws BOSException, EASBizException {
        this.pushCreditBalance(billInfo, true);
        return this;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtUnAudit(IObjectValue billInfo) throws BOSException, EASBizException {
        this.pushCreditBalance(billInfo, false);
        return this;
    }

    private void pushCreditBalance(IObjectValue billInfo, boolean atAudit) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        if (!this.isUpdateCredite) {
            return;
        }
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return;
        }
        if (atAudit) {
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.AUDIT);
        } else {
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNAUDIT);
        }
        IArApBillHeadInfo receivable = ReceivableBillBalanceProxy.visitReceivableBillInfo(billInfo);
        if (receivable != null) {
            BigDecimal tmp;
            BigDecimal tmp2;
            Object[] Infos;
            BigDecimal receivableAmountForSO = SysConstant.BIGZERO;
            BigDecimal receivableAmountForSI = SysConstant.BIGZERO;
            IArapBillEntryInfo entry = null;
            HashMap ocHashMap = (HashMap)this.creditBalance.get(CREDITBALANCE_KEY_ORDERCUSTOMERS);
            HashMap rcHashMap = (HashMap)this.creditBalance.get(CREDITBALANCE_KEY_RECEIVECUSTOMERS);
            StringBuffer sourceCoreSOEntryID = new StringBuffer("");
            StringBuffer coreSOEntryID = new StringBuffer("");
            StringBuffer coreSREntryID = new StringBuffer("");
            StringBuffer sourceSIEntryID = new StringBuffer("");
            String coreBillTypeId = null;
            int size = receivable.getEntries().size();
            for (int i = 0; i < size; ++i) {
                entry = (IArapBillEntryInfo)receivable.getEntries().getObject(i);
                if (entry != null && entry.getCoreBillTypeId() != null && entry.getCoreBillEntryId() != null) {
                    coreBillTypeId = entry.getCoreBillTypeId();
                    if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equalsIgnoreCase(coreBillTypeId)) {
                        if (entry.getOrderCustomer() == null) {
                            throw new CreditControlException(CreditControlException.FAILE_GET_ORDER_CUSTOMER);
                        }
                        if (entry.getCoreBillEntryId() != null) {
                            if (entry.getCoreBillEntryId().equals(entry.getSourceBillEntryId())) {
                                sourceCoreSOEntryID.append("'").append(entry.getSourceBillEntryId()).append("',");
                            }
                            coreSOEntryID.append("'").append(entry.getCoreBillEntryId()).append("',");
                        }
                    }
                    if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equalsIgnoreCase(coreBillTypeId)) {
                        if (entry.getOrderCustomer() == null) {
                            throw new CreditControlException(CreditControlException.FAILE_GET_ORDER_CUSTOMER);
                        }
                        if (entry.getCoreBillEntryId() != null) {
                            coreSREntryID.append("'").append(entry.getCoreBillEntryId()).append("',");
                        }
                    }
                }
                if (entry == null || entry.getSourceBillId() == null || entry.getSourceBillEntryId() == null) continue;
                BOSObjectType srcBosType = BOSUuid.read((String)entry.getSourceBillId()).getType();
                if (!new SaleIssueBillInfo().getBOSType().equals((Object)srcBosType)) continue;
                sourceSIEntryID.append("'").append(entry.getSourceBillEntryId()).append("',");
            }
            StringBuffer querySQL = new StringBuffer("");
            BigDecimal needBackAmt = null;
            String arCompanyID = receivable.getCompany().getId().toString();
            if (coreSOEntryID.length() > 0) {
                coreSOEntryID.setLength(coreSOEntryID.length() - 1);
                querySQL.append("Select sorderE.fid fid,sorderE.FQty as FQty,isnull(sorderE.FTotalInvoicedQty,0) as totalARQty,isnull(sorderE.FTotalIssueQty,0) as FTotalIssueQty ,");
                querySQL.append(" sorderE.FLocalTaxAmount as FAmount, isnull(sorderE.FArClosedStatus,0) as FArClosedStatus,");
                querySQL.append(" case when sorderE.FUnitID = otherBillE.FMeasureUnitID then otherBillE.FQuantity ");
                querySQL.append(" else Round(Decimal(otherBillE.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) end  FQuantity");
                querySQL.append(" From T_SD_SaleOrderEntry sorderE inner join T_SD_SaleOrder sorder on sorder.fid=sorderE.fparentid inner join ");
                querySQL.append(" (select arEntry.FCoreBillEntryID FCoreBillEntryID,arEntry.FMaterialID FMaterialID ,arEntry.FMeasureUnitID FMeasureUnitID,sum(arEntry.FQuantity) FQuantity,");
                querySQL.append(" sum(arEntry.FBaseQty) FBaseQty from T_AR_OtherBillEntry arEntry where arEntry.FParentID = '").append(receivable.getId().toString()).append("'");
                querySQL.append(" group by arEntry.FCoreBillEntryID,arEntry.FMaterialID,arEntry.FMeasureUnitID) otherBillE ON otherBillE.FCoreBillEntryID = sorderE.FID");
                querySQL.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON sorderE.FMaterialID = mmu.FMaterialID AND sorderE.FUnitID=mmu.FMeasureUnitID where ");
                if (sourceCoreSOEntryID.length() > 0) {
                    sourceCoreSOEntryID.setLength(sourceCoreSOEntryID.length() - 1);
                    querySQL.append(" not exists (select fid from  T_SD_SaleOrderEntry where FBaseStatus = 7 and FQty-ABS(FTotalReversedQty) > FTotalIssueQty and fid in (");
                    querySQL.append(sourceCoreSOEntryID.toString()).append(") ) AND ");
                }
                querySQL.append(" ((sorder.FIsCentralBalance = 1 and sorder.FCompanyOrgUnitID='").append(arCompanyID).append("') or (sorder.FIsCentralBalance = 0 and sorderE.FCompanyOrgUnitID='").append(arCompanyID).append("')) AND ");
                querySQL.append("  isnull(sorder.fissysBill,0) = 0 AND sorderE.FID in (").append(coreSOEntryID.toString()).append(") ");
                needBackAmt = atAudit ? this.computeBackAmtForAudit(this.ctx, querySQL.toString()) : this.computeBackAmtForUnAudit(this.ctx, querySQL.toString());
                receivableAmountForSO = receivableAmountForSO.add(SCMUtils.effectualNumeric((BigDecimal)needBackAmt));
                if (entry != null && entry.getOrderCustomer() != null) {
                    Infos = (Object[])ocHashMap.get(entry.getOrderCustomer().getId().toString());
                    tmp2 = (BigDecimal)Infos[1];
                    tmp2 = tmp2.add(SCMUtils.effectualNumeric((BigDecimal)needBackAmt));
                    Infos[1] = tmp2;
                }
            }
            if (coreSREntryID.length() > 0) {
                coreSREntryID.setLength(coreSREntryID.length() - 1);
                querySQL.setLength(0);
                querySQL.append("select saleReturnsE.fid fid,saleReturnsE.FQty FQty,saleReturnsE.FInvoicedQty as totalARQty,saleReturnsE.FLocalTaxAmount as FAmount, 0 as FArClosedStatus,");
                querySQL.append(" case when saleReturnsE.FUnitID = otherBillE.FMeasureUnitID then otherBillE.FQuantity ");
                querySQL.append(" else Round(Decimal(otherBillE.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) end  FQuantity");
                querySQL.append(" from T_SD_SaleReturnsEntry saleReturnsE inner join ");
                querySQL.append(" (select arEntry.FCoreBillEntryID FCoreBillEntryID,arEntry.FMaterialID FMaterialID ,arEntry.FMeasureUnitID FMeasureUnitID,sum(arEntry.FQuantity) FQuantity,");
                querySQL.append(" sum(arEntry.FBaseQty) FBaseQty from T_AR_OtherBillEntry arEntry where arEntry.FParentID = '").append(receivable.getId().toString()).append("'");
                querySQL.append(" group by arEntry.FCoreBillEntryID,arEntry.FMaterialID,arEntry.FMeasureUnitID ) otherBillE on otherBillE.FCoreBillEntryID = saleReturnsE.FID ");
                querySQL.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON saleReturnsE.FMaterialID = mmu.FMaterialID AND saleReturnsE.FUnitID=mmu.FMeasureUnitID ");
                querySQL.append(" where saleReturnsE.FID in (").append(coreSREntryID.toString()).append(") ");
                needBackAmt = atAudit ? this.computeBackAmtForAudit(this.ctx, querySQL.toString()) : this.computeBackAmtForUnAudit(this.ctx, querySQL.toString());
                receivableAmountForSO = receivableAmountForSO.add(SCMUtils.effectualNumeric((BigDecimal)needBackAmt));
                if (entry != null && entry.getOrderCustomer() != null) {
                    Infos = (Object[])ocHashMap.get(entry.getOrderCustomer().getId().toString());
                    tmp2 = (BigDecimal)Infos[1];
                    tmp2 = tmp2.add(SCMUtils.effectualNumeric((BigDecimal)needBackAmt));
                    Infos[1] = tmp2;
                }
            }
            if (sourceSIEntryID.length() > 0) {
                sourceSIEntryID.setLength(sourceSIEntryID.length() - 1);
                querySQL.setLength(0);
                querySQL.append("Select saleIssueE.fid fid,saleIssueE.FQty FQty,saleIssueE.FDrewQty as totalARQty,saleIssueE.FLocalAmount as FAmount, 0 as FArClosedStatus,");
                querySQL.append(" case when saleIssueE.FUnitID = otherBillE.FMeasureUnitID then otherBillE.FQuantity ");
                querySQL.append(" else Round(Decimal(otherBillE.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) end  FQuantity");
                querySQL.append(" From T_IM_SaleIssueEntry saleIssueE inner join ");
                querySQL.append(" (select arEntry.FSourceBillEntryID FSourceBillEntryID,arEntry.FMaterialID FMaterialID ,arEntry.FMeasureUnitID FMeasureUnitID,sum(arEntry.FQuantity) FQuantity,");
                querySQL.append(" sum(arEntry.FBaseQty) FBaseQty from T_AR_OtherBillEntry arEntry where arEntry.FParentID = '").append(receivable.getId().toString()).append("'");
                querySQL.append(" group by arEntry.FSourceBillEntryID,arEntry.FMaterialID,arEntry.FMeasureUnitID ) otherBillE on otherBillE.FSourceBillEntryID = saleIssueE.FID ");
                querySQL.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON otherBillE.FMaterialID = mmu.FMaterialID AND saleIssueE.FUnitID=mmu.FMeasureUnitID ");
                querySQL.append(" LEFT OUTER JOIN T_BD_Customer cust on cust.fid=saleIssueE.FBalanceCustomerID ");
                querySQL.append(" where saleIssueE.FID in (").append(sourceSIEntryID.toString()).append(") ");
                querySQL.append(" and isnull(cust.FIsInternalCompany,0) = 0 ");
                needBackAmt = atAudit ? this.computeBackAmtForAudit(this.ctx, querySQL.toString()) : this.computeBackAmtForUnAudit(this.ctx, querySQL.toString());
                receivableAmountForSI = receivableAmountForSI.add(SCMUtils.effectualNumeric((BigDecimal)needBackAmt));
                if (entry != null && entry.getServiceCustomer() != null && entry.getServiceCustomer().getId() != null) {
                    Infos = (Object[])rcHashMap.get(entry.getServiceCustomer().getId().toString());
                    tmp2 = (BigDecimal)Infos[1];
                    tmp2 = tmp2.add(SCMUtils.effectualNumeric((BigDecimal)needBackAmt));
                    Infos[1] = tmp2;
                }
            }
            if (SysConstant.BIGZERO.compareTo(receivableAmountForSO) != 0) {
                if (atAudit) {
                    selector.pushBalance("FUnArBillOrderAmt", receivableAmountForSO.negate());
                    for (Object[] Infos2 : ocHashMap.values()) {
                        tmp = (BigDecimal)Infos2[1];
                        Infos2[1] = tmp.negate();
                    }
                } else {
                    selector.pushBalance("FUnArBillOrderAmt", receivableAmountForSO);
                }
            }
            if (SysConstant.BIGZERO.compareTo(receivableAmountForSI) != 0) {
                if (atAudit) {
                    selector.pushBalance("FUnArBillIssuedAmt", receivableAmountForSI.negate());
                    for (Object[] Infos2 : rcHashMap.values()) {
                        tmp = (BigDecimal)Infos2[1];
                        Infos2[1] = tmp.negate();
                    }
                } else {
                    selector.pushBalance("FUnArBillIssuedAmt", receivableAmountForSI);
                }
            }
        }
    }

    private BigDecimal computeBackAmtForAudit(Context ctx, String querySql) throws BOSException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql);
        BigDecimal needBackAmt = SysConstant.BIGZERO;
        Object totalIssueQty = null;
        StringBuffer paramStr = new StringBuffer();
        boolean isReturn = false;
        try {
            while (rs != null && rs.next()) {
                BigDecimal arQty = rs.getBigDecimal("FQuantity");
                BigDecimal qty = rs.getBigDecimal("FQty").abs();
                BigDecimal totalARQty = rs.getBigDecimal("totalARQty");
                BigDecimal taxAmount = rs.getBigDecimal("FAmount");
                int arClosedStatus = rs.getInt("FArClosedStatus");
                if (arClosedStatus == 1) {
                    String billID = rs.getString("fid");
                    paramStr.append("'").append(billID).append("',");
                    if (arQty.signum() != -1) continue;
                    isReturn = true;
                    continue;
                }
                int prec = this.visitCompany().getBaseCurrency().getPrecision();
                needBackAmt = needBackAmt.add(arQty.multiply(taxAmount.abs()).divide(qty, prec, 4));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (paramStr.length() > 0) {
            paramStr.setLength(paramStr.length() - 1);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)this.getSelectSqlAtCloseAr("(" + paramStr.toString() + ")"));
            try {
                while (rowSet.next()) {
                    needBackAmt = needBackAmt.add(isReturn ? rowSet.getBigDecimal("locAmt").negate() : rowSet.getBigDecimal("locAmt"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return needBackAmt;
    }

    private String getSelectSqlAtCloseAr(String paramString) {
        StringBuffer sqlSb = new StringBuffer();
        sqlSb.append("SELECT t0.FCompanyOrgUnitID,t0.FOrderCustomerID,");
        sqlSb.append(" t0.FID as FID, t0.FNumber as FNumber, t0.FBizDate as FBizDate, t0.FBilltypeID as FBilltypeID, ");
        sqlSb.append(" SUM(case when t1.fqty<=0 then 0 ");
        sqlSb.append(" when t1.FBaseStatus=7 and abs(t1.FTotalIssueQty)>=abs(t1.FTotalInvoicedQty) then ROUND(to_decimal((t1.FTotalIssueQty - t1.FTotalInvoicedQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,t4.FPrecision) ");
        sqlSb.append(" when t1.FBaseStatus=7 then 0 ");
        sqlSb.append(" when t1.FBaseStatus=4 and abs(t1.FTotalIssueQty)>=abs(t1.FQty) then  ROUND(to_decimal((t1.FTotalIssueQty - t1.FTotalInvoicedQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,t4.FPrecision) ");
        sqlSb.append(" when t1.FBaseStatus=4 and abs(t1.FTotalIssueQty)<abs(t1.FQty) then ROUND(to_decimal((t1.FQty - t1.FTotalInvoicedQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,t4.FPrecision) ");
        sqlSb.append(" else 0  end ) AS locAmt ");
        sqlSb.append(" FROM T_SD_SaleOrder t0 ");
        sqlSb.append("  INNER JOIN T_SD_SaleOrderEntry t1 ON  t0.FID = t1.FParentID ");
        sqlSb.append("  INNER JOIN T_BD_Customer t2 ON t0.FOrderCustomerID = t2.FID");
        sqlSb.append("  INNER JOIN T_ORG_Company t3 ON t3.FID = t0.FCompanyOrgUnitID");
        sqlSb.append("  INNER JOIN T_BD_Currency t4 ON t4.FID = t3.FBaseCurrencyID");
        sqlSb.append(" WHERE t1.FID in ").append(paramString);
        sqlSb.append(" AND t0.FPaymentTypeID = '91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5' ");
        sqlSb.append(" AND t2.FIsCredited = 1 ");
        sqlSb.append(" GROUP BY t0.FCompanyOrgUnitID,t0.FOrderCustomerID,t0.FID,t0.FNumber,t0.FBizDate,t0.FBilltypeID ");
        return sqlSb.toString();
    }

    private BigDecimal computeBackAmtForUnAudit(Context ctx, String querySql) throws BOSException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql);
        BigDecimal needBackAmt = SysConstant.BIGZERO;
        BigDecimal totalIssueQty = null;
        StringBuffer paramStr = new StringBuffer();
        try {
            while (rs != null && rs.next()) {
                BigDecimal arQty = rs.getBigDecimal("FQuantity");
                BigDecimal qty = rs.getBigDecimal("FQty").abs();
                BigDecimal totalARQty = rs.getBigDecimal("totalARQty");
                BigDecimal taxAmount = rs.getBigDecimal("FAmount");
                int arClosedStatus = rs.getInt("FArClosedStatus");
                if (arClosedStatus == 1) {
                    totalIssueQty = rs.getBigDecimal("FTotalIssueQty");
                    String billID = rs.getString("fid");
                    int prec = this.visitCompany().getBaseCurrency().getPrecision();
                    needBackAmt = needBackAmt.add(arQty.multiply(taxAmount.abs()).divide(qty, prec, 4));
                    paramStr.append("'").append(billID).append("',");
                    continue;
                }
                int prec = this.visitCompany().getBaseCurrency().getPrecision();
                needBackAmt = needBackAmt.add(arQty.multiply(taxAmount.abs()).divide(qty, prec, 4));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (paramStr.length() > 0) {
            paramStr.setLength(paramStr.length() - 1);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)this.getSelectSqlAtCloseAr("(" + paramStr.toString() + ")"));
            try {
                while (rowSet.next()) {
                    needBackAmt = needBackAmt.add(rowSet.getBigDecimal("locAmt"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return needBackAmt;
    }

    private CreditBalanceSeletor getSelector(IObjectValue billInfo) throws BOSException, EASBizException {
        this.billChanged();
        this.pushCommonBalance(billInfo);
        CreditBalanceSeletor selector = new CreditBalanceSeletor(this);
        selector.setCompany(this.visitCompany());
        return selector;
    }

    @Override
    public final boolean isNeedUpdateCreditBalanceForBill(CreditParamInfo param) throws BOSException, EASBizException {
        PaymentTypeInfo paymentType;
        String asstActId;
        boolean isNeed = false;
        IArApBillHeadInfo receivable = this.visitReceivableBillInfo();
        if (receivable != null && (asstActId = receivable.getAsstActID()) != null && asstActId.trim().length() != 0 && (isNeed = CustomerInfo.getBosType().equalsIgnoreCase(BOSUuid.read((String)asstActId).getType().toString())) && (paymentType = receivable.getPaymentType()) != null && paymentType.getId() != null) {
            isNeed = "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5".equalsIgnoreCase(paymentType.getId().toString());
        }
        return isNeed;
    }

    public static IArApBillHeadInfo visitReceivableBillInfo(IObjectValue billInfo) throws BOSException {
        if (billInfo != null && billInfo instanceof IArApBillHeadInfo) {
            return (IArApBillHeadInfo)billInfo;
        }
        throw new BOSException("this is'nt SaleInvoice or billInfo is Null!");
    }

    public final IArApBillHeadInfo visitReceivableBillInfo() {
        IArApBillHeadInfo receivable = null;
        IObjectValue o = super.visitBillInfo();
        if (o != null && o instanceof IArApBillHeadInfo) {
            receivable = (IArApBillHeadInfo)o;
        }
        return receivable;
    }

    public static IArApBillHeadInfo readFullReceivableBillInfo(Context ctx, IArApBillHeadInfo receivableBill) throws EASBizException, BOSException {
        IArApBillHeadInfo rb = receivableBill;
        if (!(receivableBill == null || receivableBill.getId() == null || receivableBill.containsKey("company") && receivableBill.containsKey("asstActID") && receivableBill.containsKey("paymentType") && receivableBill.containsKey("billStatus") && receivableBill.containsKey("sourceBillType") && receivableBill.containsKey("number") && receivableBill.containsKey("billDate") && receivableBill.containsKey("billType") && receivableBill.containsKey("entry"))) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("number"));
            selectors.add(new SelectorItemInfo("billDate"));
            selectors.add(new SelectorItemInfo("billType"));
            selectors.add(new SelectorItemInfo("company.id"));
            selectors.add(new SelectorItemInfo("asstActID"));
            selectors.add(new SelectorItemInfo("billStatus"));
            selectors.add(new SelectorItemInfo("sourceBillType"));
            selectors.add(new SelectorItemInfo("paymentType.id"));
            selectors.add(new SelectorItemInfo("entry.id"));
            selectors.add(new SelectorItemInfo("entry.sourceBillId"));
            selectors.add(new SelectorItemInfo("entry.sourceBillEntryId"));
            selectors.add(new SelectorItemInfo("entry.coreBillType.id"));
            selectors.add(new SelectorItemInfo("entry.coreBillEntryId"));
            selectors.add(new SelectorItemInfo("entry.quantity"));
            selectors.add(new SelectorItemInfo("entry.recievePayAmountLocal"));
            selectors.add(new SelectorItemInfo("entry.orderCustomer.id"));
            selectors.add(new SelectorItemInfo("entry.serviceCustomer.id"));
            rb = (IArApBillHeadInfo)BusinessProcessUtil.getValueByBosType(null, (IObjectPK)new ObjectUuidPK(receivableBill.getId().toString()), (SelectorItemCollection)selectors);
        }
        return rb;
    }

    @Override
    protected void updateRule(String operator, BigDecimal locTotalAmt) {
    }

    @Override
    protected CreditFormulaSceneEnum getBillSecene() {
        return CreditFormulaSceneEnum.ARBILL;
    }

    @Override
    protected void updateBalance() throws BOSException, SQLException, EASBizException {
        HashMap ocHashMap = (HashMap)this.creditBalance.get(CREDITBALANCE_KEY_ORDERCUSTOMERS);
        Iterator it = ocHashMap.values().iterator();
        this.creditBalance.remove("FUnArBillIssuedAmt");
        BigDecimal updateValue = SCMConstant.BIGDECIMAL_ZERO;
        while (it.hasNext()) {
            Object[] infos = (Object[])it.next();
            updateValue = (BigDecimal)infos[1];
            if (SCMConstant.BIGDECIMAL_ZERO.compareTo(updateValue) == 0) continue;
            this.creditBalance.put("CUSTOMER", infos[0]);
            this.creditBalance.put("FUnArBillOrderAmt", infos[1]);
            super.updateBalance();
        }
        HashMap rcHashMap = (HashMap)this.creditBalance.get(CREDITBALANCE_KEY_RECEIVECUSTOMERS);
        Iterator itr = rcHashMap.values().iterator();
        this.creditBalance.remove("FUnArBillOrderAmt");
        while (itr.hasNext()) {
            Object[] infos = (Object[])itr.next();
            updateValue = (BigDecimal)infos[1];
            if (SCMConstant.BIGDECIMAL_ZERO.compareTo(updateValue) == 0) continue;
            this.creditBalance.put("CUSTOMER", infos[0]);
            this.creditBalance.put("FUnArBillIssuedAmt", infos[1]);
            super.updateBalance();
        }
    }

    @Override
    public boolean isNeedCreditLog() {
        return true;
    }

    @Override
    public String getCreditAccount() {
        return "DawAAAAPiJDuN4KI";
    }

    public CreditBalanceUpdateStrategy pushCreditBalanceAtAlter(IObjectValue billInfo, BigDecimal amt) throws BOSException, EASBizException {
        return null;
    }
}

