/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.balance.CreditBalanceSeletor;
import com.kingdee.eas.scm.credit.app.balance.CreditBalanceUpdateStrategy;
import com.kingdee.eas.scm.credit.app.balance.IAuditPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IDeletePushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.ISubmitPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IUnAuditPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IUpdatePushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.PostbillUpdateProxy;
import com.kingdee.eas.scm.credit.app.balance.PushCreditBalanceFactory;
import com.kingdee.eas.scm.credit.app.balance.SaleOrderBalanceUpdateProxy;
import com.kingdee.eas.scm.credit.app.balance.SaleReturnsBalanceUpdateProxy;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SaleIssueBillBalanceStrategy
extends CreditBalanceUpdateStrategy
implements IAuditPushCreditBalance,
IUnAuditPushCreditBalance,
ISubmitPushCreditBalance,
IUpdatePushCreditBalance,
IDeletePushCreditBalance {
    private Map consignSaleMap = new HashMap();

    public SaleIssueBillBalanceStrategy(Context ctx) {
        super(ctx);
    }

    @Override
    public final boolean isNeedUpdateCreditBalanceForBill(CreditParamInfo param) throws BOSException, EASBizException {
        OrgUnitCollection orgColl;
        StorageOrgUnitInfo storageOrgUnitInfo;
        String bizTypeID;
        PaymentTypeInfo paymentType;
        boolean isNeed = false;
        if (param == null || !param.isCtrlIssuedAmount()) {
            return false;
        }
        SaleIssueBillInfo issueBill = this.visitSaleIssueBillInfo();
        if (issueBill != null && (paymentType = issueBill.getPaymentType()) != null && paymentType.getId() != null) {
            isNeed = "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5".equalsIgnoreCase(paymentType.getId().toString());
        }
        String string = bizTypeID = issueBill.getBizType() != null ? issueBill.getBizType().getId().toString() : null;
        if ("d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(bizTypeID) && isNeed && (storageOrgUnitInfo = issueBill.getStorageOrgUnit()) != null && (orgColl = SCMGroupServerUtils.getOrgsByRelation((Context)this.ctx, (OrgType)OrgType.Storage, (OrgType)OrgType.Company, (String)storageOrgUnitInfo.getId().toString())) != null && orgColl.size() > 0) {
            String consignSaleParams;
            OrgUnitInfo orgUnitInfo = orgColl.get(0);
            String orgUnitID = orgUnitInfo.getId().toString();
            boolean consignParams = true;
            if (!this.consignSaleMap.containsKey(orgUnitID) && (consignSaleParams = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamValue((IObjectPK)new ObjectUuidPK(orgUnitID), "CONSIGNSALES")) != null) {
                this.consignSaleMap.put(orgUnitID, Boolean.valueOf(consignSaleParams));
            }
            if (this.consignSaleMap.containsKey(orgUnitID) && !(consignParams = Boolean.valueOf(this.consignSaleMap.get(orgUnitID).toString()).booleanValue()) && issueBill.getTransactionType() != null) {
                TransactionTypeInfo transactionType = TransactionTypeFactory.getLocalInstance((Context)this.ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(issueBill.getTransactionType().getId().toString()));
                return RecIssueTypeConstant.CONSIGNOUT_RITYPEID.equals(transactionType.getRiType().getId().toString()) || RecIssueTypeConstant.CONSIGNRT_RITYPEID.equals(transactionType.getRiType().getId().toString());
            }
        }
        return isNeed;
    }

    private CreditBalanceSeletor getSelector(IObjectValue billInfo) throws BOSException, EASBizException {
        this.billChanged();
        this.pushCommonBalance(billInfo);
        CreditBalanceSeletor selector = new CreditBalanceSeletor(this);
        selector.setCompany(this.visitCompany());
        return selector;
    }

    private void pushCommonBalance(IObjectValue billInfo) throws EASBizException, BOSException {
        this.creditBalance.clear();
        SaleIssueBillInfo saleIssueBill = SaleIssueBillBalanceStrategy.readFullSaleIssueBillInfo(this.ctx, SaleIssueBillBalanceStrategy.visitSaleIssueBillInfo(billInfo));
        if (saleIssueBill != null) {
            CompanyOrgUnitInfo companyOrgUnit = CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(this.ctx, (OrgUnitInfo)saleIssueBill.getStorageOrgUnit());
            if (saleIssueBill.getEntry() != null && saleIssueBill.getEntry().size() > 0 && saleIssueBill.getEntry().get(0) != null) {
                String billTypeID;
                SaleIssueEntryInfo entryInfo = saleIssueBill.getEntry().get(0);
                boolean isCenterBalance = entryInfo.isIsCenterBalance();
                String string = billTypeID = entryInfo.getCoreBillType() != null ? entryInfo.getCoreBillType().getId().toString() : "";
                if (isCenterBalance && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(billTypeID) && entryInfo.getSaleOrder() != null && entryInfo.getSaleOrder().trim().length() > 0) {
                    SaleOrderInfo SaleOrderInfo2 = SaleOrderFactory.getLocalInstance((Context)this.ctx).getSaleOrderInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSaleOrder()));
                    companyOrgUnit = SaleOrderInfo2.getCompanyOrgUnit();
                }
            }
            this.creditBalance.put("BILLINFO", saleIssueBill);
            this.creditBalance.put("COMPANY", companyOrgUnit);
            this.creditBalance.put("CUSTOMER", CreditUtils.readFullCustomerInfo(this.ctx, saleIssueBill.getCustomer()));
            this.creditBalance.put("BILLDATE", saleIssueBill.getBizDate());
            this.creditBalance.put("BILLTYPE", "50957179-0105-1000-e000-015bc0a812fd463ED552");
            this.creditBalance.put("BILLID", saleIssueBill.getId().toString());
            this.creditBalance.put("BILLNUMBER", saleIssueBill.getNumber().toString());
            this.creditBalance.put("REMARK", "");
            this.creditBalance.put("REMARK_L1", "");
            this.creditBalance.put("REMARK_L2", "");
            this.creditBalance.put("REMARK_L3", "");
        }
    }

    public SaleIssueBillInfo visitSaleIssueBillInfo() {
        SaleIssueBillInfo issueBill = null;
        IObjectValue o = super.visitBillInfo();
        if (o != null && o instanceof SaleIssueBillInfo) {
            issueBill = (SaleIssueBillInfo)o;
        }
        return issueBill;
    }

    public static SaleIssueBillInfo visitSaleIssueBillInfo(IObjectValue billInfo) throws BOSException {
        if (billInfo != null && billInfo instanceof SaleIssueBillInfo) {
            return (SaleIssueBillInfo)billInfo;
        }
        throw new BOSException("this is'nt SaleIssueBillInfo or billInfo is Null!");
    }

    public static SaleIssueBillInfo readFullSaleIssueBillInfo(Context ctx, SaleIssueBillInfo saleIssueBill) throws EASBizException, BOSException {
        SaleIssueBillInfo sis = saleIssueBill;
        ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance((Context)ctx);
        if (!(saleIssueBill == null || saleIssueBill.getId() == null || saleIssueBill.containsKey("storageOrgUnit") && saleIssueBill.containsKey("customer") && saleIssueBill.containsKey("paymentType") && saleIssueBill.containsKey("sourceBillType") && saleIssueBill.containsKey("baseStatus") && saleIssueBill.containsKey("entry") && saleIssueBill.containsKey("number") && saleIssueBill.containsKey("bizDate") && saleIssueBill.containsKey("billType") && (saleIssueBill.getEntry().isEmpty() || saleIssueBill.getEntry().get(0).containsKey("coreBillType")))) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("number"));
            selectors.add(new SelectorItemInfo("bizDate"));
            selectors.add(new SelectorItemInfo("billType"));
            selectors.add(new SelectorItemInfo("totalLocalAmount"));
            selectors.add(new SelectorItemInfo("storageOrgUnit.id"));
            selectors.add(new SelectorItemInfo("customer.id"));
            selectors.add(new SelectorItemInfo("paymentType.id"));
            selectors.add(new SelectorItemInfo("sourceBillType.id"));
            selectors.add(new SelectorItemInfo("baseStatus"));
            selectors.add(new SelectorItemInfo("entry.id"));
            selectors.add(new SelectorItemInfo("entry.localAmount"));
            selectors.add(new SelectorItemInfo("entry.coreBillType.id"));
            selectors.add(new SelectorItemInfo("entry.saleOrderEntry"));
            selectors.add(new SelectorItemInfo("entry.sourceBillEntryId"));
            selectors.add(new SelectorItemInfo("entry.sourceBillType.id"));
            sis = iSaleIssueBill.getSaleIssueBillInfo((IObjectPK)new ObjectStringPK(saleIssueBill.getId().toString()), selectors);
        }
        return sis;
    }

    @Override
    public final CreditBalanceUpdateStrategy pushCreditBalanceAtAudit(IObjectValue billInfo) throws BOSException, EASBizException {
        BigDecimal ZERO;
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.AUDIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || !canUpdateCredit && !creditParamInfo.isCtrlSaleOrderAmount() && !creditParamInfo.isCtrlPostbillAmount()) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleIssueBillInfo issuedInfo = this.visitSaleIssueBillInfo();
        ArrayList<String> entryIdLst = new ArrayList<String>();
        ArrayList<String> saleMoreIssueList = new ArrayList<String>();
        ArrayList<String> saleReturnIssueList = new ArrayList<String>();
        ArrayList<String> saleReturnMoreIssueList = new ArrayList<String>();
        HashSet<String> saleOrderEntryIDs = new HashSet<String>();
        SaleIssueEntryInfo entry = null;
        boolean isCenterBalance = false;
        boolean updateSOAmt = false;
        TransactionTypeInfo transactionInfo = issuedInfo.getTransactionType();
        String bizTypeID = issuedInfo.getBizType() != null ? issuedInfo.getBizType().getId().toString() : "";
        int size = issuedInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            String coreBillTypeID;
            entry = issuedInfo.getEntry().get(i);
            isCenterBalance = entry.isIsCenterBalance();
            entryIdLst.add(entry.getId().toString());
            String string = coreBillTypeID = entry.getCoreBillType() != null ? entry.getCoreBillType().getId().toString() : "";
            if (transactionInfo != null) {
                if (entry.getCoreBillType() != null && ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeID) || "50957179-0105-1000-e008-8152c0a812fd463ED552".equals(coreBillTypeID))) {
                    updateSOAmt = true;
                }
                int bizDirection = transactionInfo.getRiType().getBizDirection().getValue();
                if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeID) && (bizDirection == 1 && "d8e80652-010e-1000-e000-04c5c0a812202407435C".equals(bizTypeID) || bizDirection == 1 && "d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(bizTypeID))) {
                    saleMoreIssueList.add(entry.getId().toString());
                }
                if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeID) && (bizDirection == 0 && "d8e80652-0110-1000-e000-04c5c0a812202407435C".equals(bizTypeID) || bizDirection == 0 && "d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(bizTypeID))) {
                    saleReturnIssueList.add(entry.getId().toString());
                }
                if (bizDirection == 0 && ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeID) || "50957179-0105-1000-e008-8152c0a812fd463ED552".equals(coreBillTypeID))) {
                    saleReturnMoreIssueList.add(entry.getId().toString());
                }
            }
            if (entry.getCoreBillType() == null || !"510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeID)) continue;
            saleOrderEntryIDs.add(entry.getSaleOrderEntry());
        }
        if (creditParamInfo.isCtrlPostbillAmount() && entryIdLst.size() > 0) {
            PostbillUpdateProxy postBillUpdate = new PostbillUpdateProxy(this.ctx);
            postBillUpdate.updateAtAudited_IssuedWB(entryIdLst);
        }
        BigDecimal amt = ZERO = new BigDecimal("0.00");
        BigDecimal tmp = SCMUtils.effectualNumeric((BigDecimal)issuedInfo.getTotalLocalAmount());
        if (this.checkWt(issuedInfo)) {
            if (isCenterBalance) {
                StringBuffer sqlStr = new StringBuffer();
                ArrayList params = new ArrayList();
                String paramStr = SCMUtils.toParamString(entryIdLst.iterator(), params);
                sqlStr.append(" select to_decimal(to_decimal(to_decimal(soe.FLocalTaxAmount,19,4) / to_decimal(soe.FQty,21,8),21,8)*to_decimal(sie.FQty,21,8),21,8) FAmt").append(" from t_im_saleissueentry sie inner join t_im_saleissuebill si on si.fid = sie.fparentid ").append(" inner join T_SD_SaleOrderEntry soe on soe.fid = sie.fsaleorderentryid where sie.fid in ").append(paramStr).append(" and sie.fiscenterbalance = 1");
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlStr.toString(), (Object[])params.toArray());
                try {
                    while (rs.next()) {
                        if (rs.getBigDecimal("FAmt") == null) continue;
                        amt = amt.add(rs.getBigDecimal("FAmt"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException(e.getMessage());
                }
            } else {
                amt = tmp;
            }
        }
        ISaleOrderEntry saleOrderEntry = SaleOrderEntryFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", saleOrderEntryIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.isSysBill", (Object)Boolean.FALSE, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SaleOrderEntryCollection orderEntryCollection = saleOrderEntry.getSaleOrderEntryCollection(viewInfo);
        if (creditParamInfo.isCtrlSaleOrderAmount() && creditParamInfo.isCompnayCredited() && orderEntryCollection.size() > 0 && updateSOAmt) {
            IRowSet result;
            BigDecimal orderAmt;
            BillTypeInfo sourceBillType;
            if (saleMoreIssueList.size() > 0) {
                this.oweSendAtIsuuedAudit(orderEntryCollection, issuedInfo);
                BigDecimal orderAmt2 = ZERO;
                IRowSet result2 = this.saleMoreIssue(saleMoreIssueList);
                try {
                    while (result2.next()) {
                        if (result2.getBigDecimal("FAmt") == null) continue;
                        orderAmt2 = orderAmt2.add(result2.getBigDecimal("FAmt"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException(e.getMessage());
                }
                if (ZERO.compareTo(orderAmt2) != 0) {
                    selector.pushBalance("FUnArBillOrderAmt", orderAmt2);
                    this.creditBalance.put("REMARK", this.getResourceStr("OVER_SALEISSUE"));
                    this.creditBalance.put("REMARK_L1", this.getResourceStr("OVER_SALEISSUE"));
                    this.creditBalance.put("REMARK_L2", this.getResourceStr("OVER_SALEISSUE"));
                    this.creditBalance.put("REMARK_L3", this.getResourceStr("OVER_SALEISSUE"));
                }
            }
            if ((sourceBillType = issuedInfo.getSourceBillType()) != null && sourceBillType.getId() != null && "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(sourceBillType.getId().toString()) && saleReturnIssueList.size() > 0) {
                orderAmt = ZERO;
                result = this.saleReturnIssue(saleReturnIssueList);
                try {
                    while (result.next()) {
                        if (result.getBigDecimal("FAmt") == null) continue;
                        orderAmt = orderAmt.add(result.getBigDecimal("FAmt"));
                    }
                }
                catch (SQLException e) {
                    Logger.error((Throwable)e);
                    throw new BOSException(e.getMessage());
                }
                if (ZERO.compareTo(orderAmt) != 0) {
                    selector.pushBalance("FUnArBillOrderAmt", orderAmt);
                }
            }
            if (sourceBillType != null && sourceBillType.getId() != null && "50957179-0105-1000-e008-8152c0a812fd463ED552".equals(sourceBillType.getId().toString()) && saleReturnMoreIssueList.size() > 0) {
                orderAmt = ZERO;
                result = this.saleReturnMoreIssue(saleReturnMoreIssueList);
                try {
                    while (result.next()) {
                        if (result.getBigDecimal("FAmt") == null) continue;
                        orderAmt = orderAmt.add(result.getBigDecimal("FAmt"));
                    }
                }
                catch (SQLException e) {
                    Logger.error((Throwable)e);
                    throw new BOSException(e.getMessage());
                }
                if (ZERO.compareTo(orderAmt) != 0) {
                    selector.pushBalance("FUnArBillOrderAmt", orderAmt);
                }
            }
        }
        if (canUpdateCredit) {
            if (creditParamInfo.getIssued_CtrlTime() == 1) {
                selector.pushBalance("FUnArBillIssuedAmt", amt);
                selector.pushBalance("FUnAuditIssuedAmt", amt.negate());
            } else if (creditParamInfo.getIssued_CtrlTime() == 2) {
                selector.pushBalance("FUnArBillIssuedAmt", amt);
            }
        }
        if (creditParamInfo.isCtrlPostbillAmount() && !creditParamInfo.isCtrlIssuedAmount() && updateSOAmt) {
            selector.pushBalance("FUnArBillIssuedAmt", amt);
        }
        return this;
    }

    private boolean checkWt(SaleIssueBillInfo siInfo) {
        SaleIssueEntryInfo siEntryInfo;
        BillTypeInfo sourceBillType;
        SaleIssueEntryCollection sieCollection;
        boolean isChecked = true;
        if (siInfo != null && siInfo.getId() != null && (sieCollection = siInfo.getEntry()) != null && !sieCollection.isEmpty() && (sourceBillType = (siEntryInfo = sieCollection.get(0)).getSourceBillType()) != null && sourceBillType.getId() != null && "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(sourceBillType.getId().toString()) && siEntryInfo.getSourceBillEntryId() != null) {
            BigDecimal localAmount = siInfo.getTotalLocalAmount();
            String sourceBillEntryId = siEntryInfo.getSourceBillEntryId();
            try {
                SaleIssueEntryInfo siEntryInfo2 = SaleIssueEntryFactory.getLocalInstance((Context)this.ctx).getSaleIssueEntryInfo((IObjectPK)new ObjectUuidPK(sourceBillEntryId));
                BigDecimal entryLocalAmount = siEntryInfo2.getLocalAmount();
                if (localAmount != null && entryLocalAmount != null && (localAmount.signum() >= 0 && entryLocalAmount.signum() >= 0 || localAmount.signum() <= 0 && entryLocalAmount.signum() <= 0)) {
                    isChecked = false;
                }
            }
            catch (EASBizException e) {
                isChecked = false;
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                isChecked = false;
                Logger.error((Throwable)e);
            }
        }
        return isChecked;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtUnAudit(IObjectValue billInfo) throws BOSException, EASBizException {
        BigDecimal ZERO;
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNAUDIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || !canUpdateCredit && !creditParamInfo.isCtrlSaleOrderAmount() && !creditParamInfo.isCtrlPostbillAmount()) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleIssueBillInfo issuedInfo = this.visitSaleIssueBillInfo();
        TransactionTypeInfo transactionInfo = issuedInfo.getTransactionType();
        String bizTypeID = issuedInfo.getBizType() != null ? issuedInfo.getBizType().getId().toString() : "";
        ArrayList<String> entryIdLst = new ArrayList<String>();
        ArrayList<String> saleMoreIssueList = new ArrayList<String>();
        ArrayList<String> saleReturnIssueList = new ArrayList<String>();
        ArrayList<String> saleReturnMoreIssueList = new ArrayList<String>();
        SaleIssueEntryInfo entry = null;
        boolean sourcebillIsSaleRetbill = false;
        ArrayList<String> srcEntryIdLst = new ArrayList<String>();
        if (issuedInfo.getSourceBillType() != null && issuedInfo.getSourceBillType().getId() != null && issuedInfo.getSourceBillType().getId().toString().equals("50957179-0105-1000-e008-8152c0a812fd463ED552")) {
            sourcebillIsSaleRetbill = true;
        }
        HashSet<String> saleOrderEntryIDs = new HashSet<String>();
        boolean isCenterBalance = false;
        boolean updateSOAmt = false;
        int size = issuedInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            String coreBillTypeID;
            entry = issuedInfo.getEntry().get(i);
            entryIdLst.add(entry.getId().toString());
            isCenterBalance = entry.isIsCenterBalance();
            String string = coreBillTypeID = entry.getCoreBillType() != null ? entry.getCoreBillType().getId().toString() : "";
            if (sourcebillIsSaleRetbill && entry.getSourceBillEntryId() != null && entry.getSourceBillEntryId().trim().length() > 0) {
                srcEntryIdLst.add(entry.getSourceBillEntryId());
            }
            if (entry.getCoreBillType() != null && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeID)) {
                saleOrderEntryIDs.add(entry.getSaleOrderEntry());
            }
            if (transactionInfo == null) continue;
            if (entry.getCoreBillType() != null && ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeID) || "50957179-0105-1000-e008-8152c0a812fd463ED552".equals(coreBillTypeID))) {
                updateSOAmt = true;
            }
            int bizDirection = transactionInfo.getRiType().getBizDirection().getValue();
            if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeID) && bizDirection == 1 && "d8e80652-010e-1000-e000-04c5c0a812202407435C".equals(bizTypeID) || bizDirection == 1 && "d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(bizTypeID)) {
                saleMoreIssueList.add(entry.getId().toString());
            }
            if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeID) && (bizDirection == 0 && "d8e80652-0110-1000-e000-04c5c0a812202407435C".equals(bizTypeID) || bizDirection == 0 && "d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(bizTypeID))) {
                saleReturnIssueList.add(entry.getId().toString());
            }
            if (bizDirection != 0 || !"510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeID) && !"50957179-0105-1000-e008-8152c0a812fd463ED552".equals(coreBillTypeID)) continue;
            saleReturnMoreIssueList.add(entry.getId().toString());
        }
        if (creditParamInfo.isCtrlPostbillAmount() && entryIdLst.size() > 0) {
            PostbillUpdateProxy postBillUpdate = new PostbillUpdateProxy(this.ctx);
            postBillUpdate.updateAtUnAudited_IssuedWB(entryIdLst);
        }
        if (sourcebillIsSaleRetbill) {
            SaleReturnsBalanceUpdateProxy updateProxy = new SaleReturnsBalanceUpdateProxy(this.ctx);
            updateProxy.updateAtUnClosed(srcEntryIdLst);
        }
        BigDecimal amt = ZERO = new BigDecimal("0.00");
        BigDecimal tmp = SCMUtils.effectualNumeric((BigDecimal)issuedInfo.getTotalLocalAmount());
        if (this.checkWt(issuedInfo)) {
            if (isCenterBalance) {
                StringBuffer sqlStr = new StringBuffer();
                ArrayList params = new ArrayList();
                String paramStr = SCMUtils.toParamString(entryIdLst.iterator(), params);
                sqlStr.append(" select to_decimal(to_decimal(to_decimal(soe.FLocalTaxAmount,19,4) / to_decimal(soe.FQty,21,8),21,8)*to_decimal(sie.FQty,21,8),21,8) FAmt").append(" from t_im_saleissueentry sie inner join t_im_saleissuebill si on si.fid = sie.fparentid ").append(" inner join T_SD_SaleOrderEntry soe on soe.fid = sie.fsaleorderentryid where sie.fid in ").append(paramStr).append(" and sie.fiscenterbalance = 1");
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlStr.toString(), (Object[])params.toArray());
                try {
                    while (rs.next()) {
                        if (rs.getBigDecimal("FAmt") == null) continue;
                        amt = amt.add(rs.getBigDecimal("FAmt"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException(e.getMessage());
                }
            } else {
                amt = tmp;
            }
        }
        ISaleOrderEntry saleOrderEntry = SaleOrderEntryFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", saleOrderEntryIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.isSysBill", (Object)Boolean.FALSE, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SaleOrderEntryCollection orderEntryCollection = saleOrderEntry.getSaleOrderEntryCollection(viewInfo);
        if (creditParamInfo.isCtrlSaleOrderAmount() && creditParamInfo.isCompnayCredited() && orderEntryCollection.size() > 0 && updateSOAmt) {
            BillTypeInfo sourceBillType;
            if (saleMoreIssueList.size() > 0) {
                this.oweSendAtIsuuedUnAudit(orderEntryCollection, issuedInfo);
                BigDecimal orderAmt = ZERO;
                IRowSet result = this.saleMoreIssue(saleMoreIssueList);
                try {
                    while (result.next()) {
                        if (result.getBigDecimal("FAmt") == null) continue;
                        orderAmt = orderAmt.add(result.getBigDecimal("FAmt"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException(e.getMessage());
                }
                if (ZERO.compareTo(orderAmt) != 0) {
                    selector.pushBalance("FUnArBillOrderAmt", orderAmt.negate());
                    this.creditBalance.put("REMARK", this.getResourceStr("OVER_SALEISSUE"));
                    this.creditBalance.put("REMARK_L1", this.getResourceStr("OVER_SALEISSUE"));
                    this.creditBalance.put("REMARK_L2", this.getResourceStr("OVER_SALEISSUE"));
                    this.creditBalance.put("REMARK_L3", this.getResourceStr("OVER_SALEISSUE"));
                }
            }
            if ((sourceBillType = issuedInfo.getSourceBillType()) != null && sourceBillType.getId() != null && "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(sourceBillType.getId().toString()) && saleReturnIssueList.size() > 0) {
                BigDecimal orderAmt = ZERO;
                IRowSet result = this.saleReturnIssue(saleReturnIssueList);
                try {
                    while (result.next()) {
                        if (result.getBigDecimal("FAmt") == null) continue;
                        orderAmt = orderAmt.add(result.getBigDecimal("FAmt"));
                    }
                }
                catch (SQLException e) {
                    Logger.error((Throwable)e);
                    throw new BOSException(e.getMessage());
                }
                if (ZERO.compareTo(orderAmt) != 0 && creditParamInfo.isCtrlSaleOrderAmount()) {
                    selector.pushBalance("FUnArBillOrderAmt", orderAmt.negate());
                }
            }
            if (sourceBillType != null && sourceBillType.getId() != null && "50957179-0105-1000-e008-8152c0a812fd463ED552".equals(sourceBillType.getId().toString())) {
                TransactionTypeInfo transactionTypeInfo = issuedInfo.getTransactionType();
                if (saleReturnMoreIssueList.size() > 0) {
                    BigDecimal orderAmt = ZERO;
                    IRowSet result = this.saleReturnMoreIssue(saleReturnMoreIssueList);
                    try {
                        while (result.next()) {
                            if (result.getBigDecimal("FAmt") == null) continue;
                            orderAmt = orderAmt.add(result.getBigDecimal("FAmt"));
                        }
                    }
                    catch (SQLException e) {
                        Logger.error((Throwable)e);
                        throw new BOSException(e.getMessage());
                    }
                    if (ZERO.compareTo(orderAmt) != 0) {
                        selector.pushBalance("FUnArBillOrderAmt", orderAmt.negate());
                    }
                }
            }
        }
        if (canUpdateCredit) {
            selector.pushBalance("FUnArBillIssuedAmt", amt.negate());
        }
        if (creditParamInfo.isCtrlPostbillAmount() && !creditParamInfo.isCtrlIssuedAmount() && updateSOAmt) {
            selector.pushBalance("FUnArBillIssuedAmt", amt.negate());
        }
        return this;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtSubmit(IObjectValue billInfo) throws BOSException, EASBizException {
        BigDecimal ZERO;
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.SUBMIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || creditParamInfo.getIssued_CtrlTime() != 1) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleIssueBillInfo issuedInfo = this.visitSaleIssueBillInfo();
        BigDecimal amt = ZERO = new BigDecimal("0.00");
        BigDecimal tmp = SCMUtils.effectualNumeric((BigDecimal)issuedInfo.getTotalLocalAmount());
        if (this.checkWt(issuedInfo)) {
            boolean isCenterBalance = false;
            if (issuedInfo != null && issuedInfo.getEntry() != null && issuedInfo.getEntry().get(0) != null) {
                isCenterBalance = issuedInfo.getEntry().get(0).isIsCenterBalance();
            }
            if (isCenterBalance) {
                HashMap priceMap = this.getSOPrice(issuedInfo);
                BigDecimal price = ZERO;
                for (int i = 0; i < issuedInfo.getEntry().size(); ++i) {
                    if (issuedInfo.getEntry().get(i) == null || issuedInfo.getEntry().get(i).getId() == null) continue;
                    price = priceMap.containsKey(issuedInfo.getEntry().get(i).getId().toString()) ? (BigDecimal)priceMap.get(issuedInfo.getEntry().get(i).getId().toString()) : ZERO;
                    amt = amt.add(issuedInfo.getEntry().get(i).getQty().multiply(price));
                }
            } else {
                amt = tmp;
            }
        }
        selector.pushBalance("FUnAuditIssuedAmt", amt);
        return this;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtUpdate(IObjectValue billInfo, IObjectValue oldBillInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.SUBMIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || creditParamInfo.getIssued_CtrlTime() != 1) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleIssueBillInfo issueBill = SaleIssueBillBalanceStrategy.visitSaleIssueBillInfo(billInfo);
        SaleIssueBillInfo oldIssueBill = SaleIssueBillBalanceStrategy.visitSaleIssueBillInfo(oldBillInfo);
        if (issueBill != null && oldIssueBill != null) {
            BigDecimal ZERO;
            BigDecimal diffAmt = ZERO = new BigDecimal("0.00");
            BigDecimal amtNew = ZERO;
            BigDecimal amtOld = ZERO;
            BigDecimal tmp = SCMUtils.effectualNumeric((BigDecimal)issueBill.getTotalLocalAmount()).subtract(SCMUtils.effectualNumeric((BigDecimal)oldIssueBill.getTotalLocalAmount()));
            if (this.checkWt(issueBill)) {
                boolean isCenterBalance = false;
                if (issueBill != null && issueBill.getEntry() != null && issueBill.getEntry().get(0) != null) {
                    isCenterBalance = issueBill.getEntry().get(0).isIsCenterBalance();
                }
                if (isCenterBalance) {
                    HashMap priceMap = this.getSOPrice(issueBill);
                    BigDecimal price = ZERO;
                    for (int i = 0; i < issueBill.getEntry().size(); ++i) {
                        if (issueBill.getEntry().get(i) == null || issueBill.getEntry().get(i).getId() == null) continue;
                        price = priceMap.containsKey(issueBill.getEntry().get(i).getId().toString()) ? (BigDecimal)priceMap.get(issueBill.getEntry().get(i).getId().toString()) : ZERO;
                        amtNew = amtNew.add(issueBill.getEntry().get(i).getQty().multiply(price));
                    }
                    for (int j = 0; j < oldIssueBill.getEntry().size(); ++j) {
                        if (oldIssueBill.getEntry().get(j) == null || oldIssueBill.getEntry().get(j).getId() == null) continue;
                        price = priceMap.containsKey(oldIssueBill.getEntry().get(j).getId().toString()) ? (BigDecimal)priceMap.get(oldIssueBill.getEntry().get(j).getId().toString()) : ZERO;
                        amtOld = amtOld.add(oldIssueBill.getEntry().get(j).getQty().multiply(price));
                    }
                    diffAmt = amtNew.subtract(amtOld);
                } else {
                    diffAmt = tmp;
                }
            }
            selector.pushBalance("FUnAuditIssuedAmt", diffAmt);
        }
        return this;
    }

    private HashMap getSOPrice(SaleIssueBillInfo issueBill) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" select sie.fid fid, to_decimal(to_decimal(to_decimal(soe.FLocalTaxAmount,19,4) / to_decimal(soe.FQty,21,8),21,8),21,8) FPrice ").append(" from t_im_saleissueentry sie inner join t_im_saleissuebill si on si.fid = sie.fparentid ").append(" inner join T_SD_SaleOrderEntry soe on soe.fid = sie.fsaleorderentryid where si.fid='").append(issueBill.getId().toString()).append("'").append(" and sie.fiscenterbalance = 1");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlStr.toString());
        HashMap<String, BigDecimal> priceMap = new HashMap<String, BigDecimal>();
        try {
            while (rs.next()) {
                if (rs.getBigDecimal("FPrice") == null) continue;
                priceMap.put(rs.getString("fid"), rs.getBigDecimal("FPrice"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return priceMap;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtDelete(IObjectValue billInfo) throws BOSException, EASBizException {
        BigDecimal ZERO;
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.DELETE);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || creditParamInfo.getIssued_CtrlTime() != 1) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleIssueBillInfo issuedInfo = this.visitSaleIssueBillInfo();
        BigDecimal amt = ZERO = new BigDecimal("0.00");
        BigDecimal tmp = SCMUtils.effectualNumeric((BigDecimal)issuedInfo.getTotalLocalAmount());
        if (this.checkWt(issuedInfo)) {
            boolean isCenterBalance = false;
            if (issuedInfo != null && issuedInfo.getEntry() != null && issuedInfo.getEntry().get(0) != null) {
                isCenterBalance = issuedInfo.getEntry().get(0).isIsCenterBalance();
            }
            if (isCenterBalance) {
                HashMap priceMap = this.getSOPrice(issuedInfo);
                BigDecimal price = ZERO;
                for (int i = 0; i < issuedInfo.getEntry().size(); ++i) {
                    if (issuedInfo.getEntry().get(i) == null || issuedInfo.getEntry().get(i).getId() == null) continue;
                    price = priceMap.containsKey(issuedInfo.getEntry().get(i).getId().toString()) ? (BigDecimal)priceMap.get(issuedInfo.getEntry().get(i).getId().toString()) : ZERO;
                    amt = amt.add(issuedInfo.getEntry().get(i).getQty().multiply(price));
                }
            } else {
                amt = tmp;
            }
        }
        selector.pushBalance("FUnAuditIssuedAmt", amt.negate());
        return this;
    }

    public CreditBalanceUpdateStrategy pushCreditBalanceAtAlter(IObjectValue billInfo, BigDecimal amt) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.ALTER);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        selector.pushBalance("FUnArBillIssuedAmt", amt);
        return this;
    }

    public void updateAtSubmit(IObjectValue billInfo, IObjectValue oldBillInfo) throws BOSException, EASBizException {
        if (oldBillInfo != null) {
            SaleIssueBillInfo newBill = SaleIssueBillBalanceStrategy.readFullSaleIssueBillInfo(this.ctx, SaleIssueBillBalanceStrategy.visitSaleIssueBillInfo(billInfo));
            SaleIssueBillInfo oldBill = SaleIssueBillBalanceStrategy.readFullSaleIssueBillInfo(this.ctx, SaleIssueBillBalanceStrategy.visitSaleIssueBillInfo(oldBillInfo));
            if (oldBill.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                String oldPayId;
                String newPayId = newBill.getPaymentType().getId().toString();
                if (newPayId.equals(oldPayId = oldBill.getPaymentType().getId().toString()) && newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                    String newCustId = newBill.getCustomer().getId().toString();
                    String oldCustId = oldBill.getCustomer().getId().toString();
                    String newCompId = newBill.getStorageOrgUnit().getId().toString();
                    String oldCompId = oldBill.getStorageOrgUnit().getId().toString();
                    if (newCustId.equals(oldCustId) && newCompId.equals(oldCompId)) {
                        this.pushCreditBalanceAtUpdate((IObjectValue)newBill, (IObjectValue)oldBill).updateCreditBalance();
                    } else {
                        this.pushCreditBalanceAtDelete((IObjectValue)oldBill).updateCreditBalance();
                        this.pushCreditBalanceAtSubmit((IObjectValue)newBill).updateCreditBalance();
                    }
                } else if (newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                    this.pushCreditBalanceAtSubmit(billInfo).updateCreditBalance();
                } else if (oldPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                    this.pushCreditBalanceAtDelete((IObjectValue)oldBill).updateCreditBalance();
                }
            } else {
                this.pushCreditBalanceAtSubmit(billInfo).updateCreditBalance();
            }
        } else {
            this.pushCreditBalanceAtSubmit(billInfo).updateCreditBalance();
        }
    }

    @Override
    protected void updateRule(String operator, BigDecimal locTotalAmt) {
    }

    @Override
    protected CreditFormulaSceneEnum getBillSecene() {
        return CreditFormulaSceneEnum.ISSUEDBILL;
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private IRowSet saleMoreIssue(List issuedEntryIdList) throws BOSException {
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(issuedEntryIdList.iterator(), params);
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" SELECT sum(sOrderE.FTotalIssueQty) as totalQty, ").append("to_decimal(SUM(case when sIssueBill.FIsReversed=1 and sOrderE.FTotalIssueQty<sOrderE.FQty and sOrderE.FTotalIssueQty+abs(sIssueE.FQty)>sOrderE.FQty and sOrderE.FLocalTaxAmount>0 ").append(" then to_decimal(to_decimal(to_decimal(sOrderE.FLocalTaxAmount,19,4)/ to_decimal(sOrderE.FQty,21,8),21,8)*to_decimal(sOrderE.FQty-(sOrderE.FTotalIssueQty+abs(sIssueE.FQty)),21,8),21,8)").append("when sIssueBill.FIsReversed=1 and sOrderE.FTotalIssueQty>=sOrderE.FQty and sOrderE.FTotalIssueQty+abs(sIssueE.FQty)>sOrderE.FQty and sOrderE.FLocalTaxAmount>0 ").append(" then to_decimal(to_decimal(to_decimal(sOrderE.FLocalTaxAmount,19,4)/ to_decimal(sOrderE.FQty,21,8),21,8)*to_decimal(sIssueE.FQty,21,8),21,8)").append(" when sIssueBill.FIsReversed=0 and sOrderE.FTotalIssueQty-sIssueE.FQty>=sOrderE.FQty and sOrderE.FLocalTaxAmount>0 ").append(" then to_decimal(to_decimal(to_decimal(sOrderE.FLocalTaxAmount,19,4) / to_decimal(sOrderE.FQty,21,8),21,8)*to_decimal(sIssueE.FQty,21,8),21,8)").append(" when sIssueBill.FIsReversed=0 and sOrderE.FTotalIssueQty>sOrderE.FQty and sOrderE.FTotalIssueQty-sIssueE.FQty<sOrderE.FQty and sOrderE.FLocalTaxAmount>0 ").append(" then to_decimal(to_decimal(to_decimal(sOrderE.FLocalTaxAmount,19,4) / to_decimal(sOrderE.FQty,21,8),21,8)* to_decimal(sOrderE.FTotalIssueQty-sOrderE.FQty,21,8),21,8) end ),19,4)  AS FAmt").append(" FROM T_IM_SaleIssueEntry sIssueE INNER JOIN T_IM_SaleIssueBill sIssueBill on sIssueBill.FID=sIssueE.FParentID").append("  INNER JOIN T_SD_SaleOrderEntry sOrderE ON  sIssueE.FSaleOrderEntryID = sOrderE.FID ").append(" WHERE sIssueE.FID in ").append(paramStr);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)strSQL.toString(), (Object[])params.toArray());
        return rs;
    }

    private IRowSet saleReturnIssue(List issuedEntryIdList) throws BOSException {
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(issuedEntryIdList.iterator(), params);
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" SELECT to_decimal(SUM(CASE WHEN sOrderE.FBaseQty = 0 ");
        strSQL.append(" THEN 0 ELSE to_decimal(to_decimal(to_decimal(sOrderE.FLocalTaxAmount,19,4) / to_decimal(sOrderE.FBaseQty,21,8),21,8)");
        strSQL.append("* to_decimal(sIssueE.FBaseQty,21,8),21,8) end ),19,4) AS FAmt");
        strSQL.append(" FROM T_IM_SaleIssueEntry sIssueE ").append("  INNER JOIN T_SD_SaleOrderEntry sOrderE ON  sIssueE.FSaleOrderEntryID = sOrderE.FID ").append(" WHERE sIssueE.FID in ").append(paramStr);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)strSQL.toString(), (Object[])params.toArray());
        return rs;
    }

    private IRowSet saleReturnMoreIssue(List issuedEntryIdList) throws BOSException {
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(issuedEntryIdList.iterator(), params);
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" select to_decimal(SUM(case when si.FIsReversed = 0 and sre.FQuantityUnctrl = 1  and sre.FQty < sre.FReturnsQty ").append(" then  to_decimal(to_decimal(to_decimal(sre.FLocalTaxAmount,19,4)/ to_decimal(sre.FQty,21,8),21,8)*to_decimal(sre.FQty-(sre.FReturnsQty),21,8),21,8) end  ),19,4) AS FAmt");
        strSQL.append(" from (select  sum(fqty) as FRQty,FSourceBillEntryId,FParentID from T_IM_SaleIssueEntry where FID in ").append(paramStr);
        strSQL.append(" group by FSourceBillEntryId,FParentID ) t");
        strSQL.append(" inner join T_IM_SaleIssueBill si on t.FParentID=si.FID ");
        strSQL.append(" inner join T_SD_SaleReturnsEntry sre ON  t.FSourceBillEntryId = sre.Fid");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)strSQL.toString(), (Object[])params.toArray());
        return rs;
    }

    @Override
    public boolean isNeedCreditLog() {
        return true;
    }

    @Override
    public String getCreditAccount() {
        return "DawAAAAPiJDuN4KI";
    }

    private void oweSendAtIsuuedAudit(SaleOrderEntryCollection orderEntryCollection, SaleIssueBillInfo issuedInfo) throws BOSException, EASBizException {
        ArrayList<String> sOrderEntryIDs = new ArrayList<String>();
        BigDecimal rate = null;
        BigDecimal qty = null;
        for (int i = 0; i < orderEntryCollection.size(); ++i) {
            rate = orderEntryCollection.get(i).getSendOwingRate();
            if (orderEntryCollection.get(i).isQuantityUnCtrl() || rate == null || SCMConstant.BIGDECIMAL_ZERO.compareTo(rate) == 0) continue;
            rate = SCMConstant.BIGDECIMAL_ONE.subtract(rate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 4, 4));
            qty = orderEntryCollection.get(i).getQty().multiply(rate);
            if (!EntryBaseStatusEnum.CLOSED.equals((Object)orderEntryCollection.get(i).getBaseStatus()) || qty.compareTo(orderEntryCollection.get(i).getTotalIssueQty()) != 0) continue;
            sOrderEntryIDs.add(orderEntryCollection.get(i).getId().toString());
        }
        if (sOrderEntryIDs.size() > 0) {
            SaleOrderBalanceUpdateProxy saleOrderProxy = (SaleOrderBalanceUpdateProxy)PushCreditBalanceFactory.getPushInstance(this.ctx, "com.kingdee.eas.scm.credit.app.balance.SaleOrderBalanceUpdateProxy");
            saleOrderProxy.pushBalance("BILLDATE", issuedInfo.getBizDate());
            saleOrderProxy.pushBalance("BILLTYPE", "50957179-0105-1000-e000-015bc0a812fd463ED552");
            saleOrderProxy.pushBalance("BILLID", issuedInfo.getId().toString());
            saleOrderProxy.pushBalance("BILLNUMBER", issuedInfo.getNumber());
            saleOrderProxy.pushBalance("REMARK", this.getResourceStr("SALEORDER_AUTOCLOSE_LESS"));
            saleOrderProxy.pushBalance("REMARK_L1", this.getResourceStr("SALEORDER_AUTOCLOSE_LESS"));
            saleOrderProxy.pushBalance("REMARK_L2", this.getResourceStr("SALEORDER_AUTOCLOSE_LESS"));
            saleOrderProxy.pushBalance("REMARK_L3", this.getResourceStr("SALEORDER_AUTOCLOSE_LESS"));
            saleOrderProxy.pushBalance("REDITOPERATION", (Object)CreditOperationEnum.AUDIT);
            saleOrderProxy.updateAtClosed(sOrderEntryIDs);
        }
    }

    private void oweSendAtIsuuedUnAudit(SaleOrderEntryCollection orderEntryCollection, SaleIssueBillInfo issuedInfo) throws BOSException, EASBizException {
        ArrayList<String> manulCloseIDS = new ArrayList<String>();
        ArrayList<String> autoCloseIDS = new ArrayList<String>();
        BigDecimal rate = null;
        BigDecimal qty = null;
        for (int i = 0; i < orderEntryCollection.size(); ++i) {
            if (!EntryBaseStatusEnum.CLOSED.equals((Object)orderEntryCollection.get(i).getBaseStatus())) continue;
            rate = orderEntryCollection.get(i).getSendOwingRate();
            qty = orderEntryCollection.get(i).getQty();
            if (!orderEntryCollection.get(i).isQuantityUnCtrl() && rate != null && SCMConstant.BIGDECIMAL_ZERO.compareTo(rate) != 0) {
                rate = SCMConstant.BIGDECIMAL_ONE.subtract(rate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 4, 4));
                if (qty.compareTo(orderEntryCollection.get(i).getTotalIssueQty()) > 0 && (qty = qty.multiply(rate)).compareTo(orderEntryCollection.get(i).getTotalIssueQty()) <= 0) {
                    autoCloseIDS.add(orderEntryCollection.get(i).getId().toString());
                }
            }
            if (qty.compareTo(orderEntryCollection.get(i).getTotalIssueQty()) <= 0) continue;
            manulCloseIDS.add(orderEntryCollection.get(i).getId().toString());
        }
        if (autoCloseIDS.size() > 0) {
            SaleOrderBalanceUpdateProxy saleOrderProxy = (SaleOrderBalanceUpdateProxy)PushCreditBalanceFactory.getPushInstance(this.ctx, "com.kingdee.eas.scm.credit.app.balance.SaleOrderBalanceUpdateProxy");
            saleOrderProxy.pushBalance("BILLDATE", issuedInfo.getBizDate());
            saleOrderProxy.pushBalance("BILLTYPE", "50957179-0105-1000-e000-015bc0a812fd463ED552");
            saleOrderProxy.pushBalance("BILLID", issuedInfo.getId().toString());
            saleOrderProxy.pushBalance("BILLNUMBER", issuedInfo.getNumber());
            saleOrderProxy.pushBalance("REMARK", this.getResourceStr("SALEORDER_AUTOCLOSE_LESS"));
            saleOrderProxy.pushBalance("REMARK_L1", this.getResourceStr("SALEORDER_AUTOCLOSE_LESS"));
            saleOrderProxy.pushBalance("REMARK_L2", this.getResourceStr("SALEORDER_AUTOCLOSE_LESS"));
            saleOrderProxy.pushBalance("REMARK_L3", this.getResourceStr("SALEORDER_AUTOCLOSE_LESS"));
            saleOrderProxy.pushBalance("REDITOPERATION", (Object)CreditOperationEnum.UNAUDIT);
            saleOrderProxy.updateAtUnClosed(autoCloseIDS);
        } else if (manulCloseIDS.size() > 0) {
            SaleOrderBalanceUpdateProxy saleOrderProxy = (SaleOrderBalanceUpdateProxy)PushCreditBalanceFactory.getPushInstance(this.ctx, "com.kingdee.eas.scm.credit.app.balance.SaleOrderBalanceUpdateProxy");
            saleOrderProxy.updateAtUnClosed(manulCloseIDS);
        }
    }
}

