/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.balance.CreditBalanceSeletor;
import com.kingdee.eas.scm.credit.app.balance.CreditBalanceUpdateStrategy;
import com.kingdee.eas.scm.credit.app.balance.IAlterPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IAuditPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IDeletePushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IHandClosedPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.ISubmitPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IUnAuditPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IUpdatePushCreditBalance;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SaleOrderBalanceUpdateProxy
extends CreditBalanceUpdateStrategy
implements IAuditPushCreditBalance,
IAlterPushCreditBalance,
IHandClosedPushCreditBalance,
IUnAuditPushCreditBalance,
ISubmitPushCreditBalance,
IUpdatePushCreditBalance,
IDeletePushCreditBalance {
    public SaleOrderBalanceUpdateProxy(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtSubmit(IObjectValue billInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.SUBMIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || creditParamInfo.getSO_CtrlTime() != 1) {
            this.isUpdateCredite = false;
            return this;
        }
        BigDecimal amt = SCMUtils.effectualNumeric((BigDecimal)this.visitSaleOrderInfo().getLocalTotalTaxAmount());
        selector.pushBalance("FUnAuditSOAmt", amt);
        return this;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtUpdate(IObjectValue billInfo, IObjectValue oldBillInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.SUBMIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || creditParamInfo.getSO_CtrlTime() != 1) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleOrderInfo order = SaleOrderBalanceUpdateProxy.visitSaleOrderInfo(billInfo);
        SaleOrderInfo oldOrder = SaleOrderBalanceUpdateProxy.visitSaleOrderInfo(oldBillInfo);
        if (order != null && oldOrder != null) {
            BigDecimal diffAmt = SCMUtils.effectualNumeric((BigDecimal)order.getLocalTotalTaxAmount()).subtract(SCMUtils.effectualNumeric((BigDecimal)oldOrder.getLocalTotalTaxAmount()));
            selector.pushBalance("FUnAuditSOAmt", diffAmt);
        }
        return this;
    }

    @Override
    public final CreditBalanceUpdateStrategy pushCreditBalanceAtAudit(IObjectValue billInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.AUDIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || !canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        BigDecimal amt = SCMUtils.effectualNumeric((BigDecimal)this.visitSaleOrderInfo().getLocalTotalTaxAmount());
        if (creditParamInfo.getSO_CtrlTime() == 2) {
            selector.pushBalance("FUnArBillOrderAmt", amt);
        } else if (creditParamInfo.getSO_CtrlTime() == 1) {
            selector.pushBalance("FUnArBillOrderAmt", amt);
            selector.pushBalance("FUnAuditSOAmt", amt.negate());
        }
        return this;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtUnAudit(IObjectValue billInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNAUDIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        BigDecimal amt = SCMUtils.effectualNumeric((BigDecimal)this.visitSaleOrderInfo().getLocalTotalTaxAmount());
        selector.pushBalance("FUnArBillOrderAmt", amt.negate());
        return this;
    }

    @Override
    public final CreditBalanceUpdateStrategy pushCreditBalanceAtAlter(IObjectValue billInfo, IObjectValue oldBillInfo) throws BOSException, EASBizException {
        String oldPayId;
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.ALTER);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleOrderInfo newBill = SaleOrderBalanceUpdateProxy.readFullSaleOrderInfo(this.ctx, SaleOrderBalanceUpdateProxy.visitSaleOrderInfo(billInfo));
        SaleOrderInfo oldBill = SaleOrderBalanceUpdateProxy.readFullSaleOrderInfo(this.ctx, SaleOrderBalanceUpdateProxy.visitSaleOrderInfo(oldBillInfo));
        String newPayId = newBill.getPaymentType().getId().toString();
        if (newPayId.equals(oldPayId = oldBill.getPaymentType().getId().toString()) && newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
            BigDecimal diffAmt = SCMUtils.effectualNumeric((BigDecimal)newBill.getLocalTotalTaxAmount()).subtract(SCMUtils.effectualNumeric((BigDecimal)oldBill.getLocalTotalTaxAmount()));
            selector.pushBalance("FUnArBillOrderAmt", diffAmt);
        } else if (newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
            selector.pushBalance("FUnArBillOrderAmt", SCMUtils.effectualNumeric((BigDecimal)newBill.getLocalTotalTaxAmount()));
        } else if (oldPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
            this.pushCreditBalanceAtUnAudit((IObjectValue)oldBill).updateCreditBalance();
        }
        return this;
    }

    public void updateAtClosed(List entryIdLst) throws BOSException, EASBizException {
        if (entryIdLst == null || entryIdLst.size() <= 0) {
            return;
        }
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(entryIdLst.iterator(), params);
        this.batchUpdate(this.getSelectBillSql_Close(paramStr), params, "CLOSE");
    }

    public void updateAtUnClosed(List entryIdLst) throws BOSException, EASBizException {
        if (entryIdLst == null || entryIdLst.size() <= 0) {
            return;
        }
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(entryIdLst.iterator(), params);
        this.batchUpdate(this.getSelectBillSql_Close(paramStr), params, "UNCLOSE");
    }

    private String getSelectBillSql_Close(String paramStr) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("SELECT t0.FCompanyOrgUnitID,t0.FOrderCustomerID,").append(" t0.FID as FID, t0.FNumber as FNumber, t0.FBizDate as FBizDate, t0.FBilltypeID as FBilltypeID, ").append(" SUM(case when t1.fqty<=0 then 0 ").append(" when abs(t1.FQty) - abs(t1.FTotalReversedQty) - abs(t1.FTotalIssueQty)<=0 then 0 ").append(" when abs(t1.FQty) - abs(t1.FTotalReversedQty) - abs(t1.FTotalInvoicedQty)<=0 then 0 ").append(" when abs(t1.FTotalIssueQty)>=abs(t1.FTotalInvoicedQty) ").append(" then ROUND(to_decimal((t1.FQty - abs(t1.FTotalReversedQty) - t1.FTotalIssueQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,t4.FPrecision) ").append(" else ROUND(to_decimal((t1.FQty - abs(t1.FTotalReversedQty) - t1.FTotalInvoicedQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,t4.FPrecision)  end ) AS locAmt ").append(" FROM T_SD_SaleOrder t0 ").append("  INNER JOIN T_SD_SaleOrderEntry t1 ON  t0.FID = t1.FParentID ").append("  INNER JOIN T_BD_Customer t2 ON t0.FOrderCustomerID = t2.FID").append("  INNER JOIN T_ORG_Company t3 ON t3.FID = t0.FCompanyOrgUnitID").append("  INNER JOIN T_BD_Currency t4 ON t4.FID = t3.FBaseCurrencyID").append(" WHERE t1.FID in ").append(paramStr).append(" AND t0.FPaymentTypeID = '91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5' ").append(" AND (t1.FArClosedStatus is null or t1.FArClosedStatus = 0) ").append(" AND t2.FIsCredited = 1 ").append(" GROUP BY t0.FCompanyOrgUnitID,t0.FOrderCustomerID,t0.FID,t0.FNumber,t0.FBizDate,t0.FBilltypeID ");
        return strSQL.toString();
    }

    public void updateAtCloseAr(List entryIDList) throws BOSException, EASBizException {
        if (entryIDList == null || entryIDList.isEmpty()) {
            return;
        }
        ArrayList paramList = new ArrayList();
        String paramString = SCMUtils.toParamString(entryIDList.iterator(), paramList);
        this.batchUpdate(this.getSelectSqlAtCloseAr(paramString), paramList, "CLOSEAR");
    }

    public void updateAtUnCloseAr(List entryIDList) throws BOSException, EASBizException {
        if (entryIDList == null || entryIDList.isEmpty()) {
            return;
        }
        ArrayList paramList = new ArrayList();
        String paramString = SCMUtils.toParamString(entryIDList.iterator(), paramList);
        this.batchUpdate(this.getSelectSqlAtCloseAr(paramString), paramList, "UNCLOSEAR");
    }

    private String getSelectSqlAtCloseAr(String paramString) {
        StringBuffer sqlSb = new StringBuffer();
        sqlSb.append("SELECT t0.FCompanyOrgUnitID,t0.FOrderCustomerID,");
        sqlSb.append(" t0.FID as FID, t0.FNumber as FNumber, t0.FBizDate as FBizDate, t0.FBilltypeID as FBilltypeID, ");
        sqlSb.append(" SUM(case when t1.fqty<=0 then 0 ");
        sqlSb.append(" when t1.FBaseStatus=7 and abs(t1.FTotalIssueQty)>=abs(t1.FTotalInvoicedQty) then ROUND(to_decimal((t1.FTotalIssueQty - t1.FTotalInvoicedQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,t4.FPrecision) ");
        sqlSb.append(" when t1.FBaseStatus=7 then 0 ");
        sqlSb.append(" when t1.FBaseStatus=4 and abs(t1.FTotalIssueQty)>=abs(t1.FQty) then  ROUND(to_decimal((t1.FTotalIssueQty - t1.FTotalInvoicedQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,t4.FPrecision) ");
        sqlSb.append(" when t1.FBaseStatus=4 and abs(t1.FTotalIssueQty)<abs(t1.FQty) then ROUND(to_decimal((t1.FQty - t1.FTotalInvoicedQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,t4.FPrecision) ");
        sqlSb.append(" else 0  end ) AS locAmt ");
        sqlSb.append(" FROM T_SD_SaleOrder t0 ");
        sqlSb.append("  INNER JOIN T_SD_SaleOrderEntry t1 ON  t0.FID = t1.FParentID ");
        sqlSb.append("  INNER JOIN T_BD_Customer t2 ON t0.FOrderCustomerID = t2.FID");
        sqlSb.append("  INNER JOIN T_ORG_Company t3 ON t3.FID = t0.FCompanyOrgUnitID");
        sqlSb.append("  INNER JOIN T_BD_Currency t4 ON t4.FID = t3.FBaseCurrencyID");
        sqlSb.append(" WHERE t1.FID in ").append(paramString);
        sqlSb.append(" AND t0.FPaymentTypeID = '91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5' ");
        sqlSb.append(" AND t2.FIsCredited = 1 ");
        sqlSb.append(" GROUP BY t0.FCompanyOrgUnitID,t0.FOrderCustomerID,t0.FID,t0.FNumber,t0.FBizDate,t0.FBilltypeID ");
        return sqlSb.toString();
    }

    @Override
    public final CreditBalanceUpdateStrategy pushCreditBalanceAtHandClosed(IObjectValue billInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.CLOSE);
        SaleOrderInfo order = this.visitSaleOrderInfo();
        if (order != null) {
            BigDecimal unInvoiceQty = SysConstant.BIGZERO;
            BigDecimal unExecuteAmount = SysConstant.BIGZERO;
            SaleOrderEntryInfo entry = null;
            int size = order.getEntries().size();
            for (int i = 0; i < size; ++i) {
                entry = order.getEntries().get(i);
                if (entry == null || entry.getBaseStatus().getValue() != 7 || (unInvoiceQty = SCMUtils.effectualNumeric((BigDecimal)entry.getQty()).subtract(SCMUtils.effectualNumeric((BigDecimal)entry.getTotalIssueQty()))).compareTo(SysConstant.BIGZERO) <= 0) continue;
                unExecuteAmount = unExecuteAmount.add(SCMUtils.effectualNumeric((BigDecimal)entry.getActualTaxPrice()).multiply(unInvoiceQty).setScale(10, 4));
            }
            if (SysConstant.BIGZERO.compareTo(unExecuteAmount) != 0) {
                unExecuteAmount = SCMUtils.convertAmountByCompany((Context)this.ctx, (BigDecimal)unExecuteAmount, (CompanyOrgUnitInfo)selector.getCompany(), (CurrencyInfo)order.getCurrency(), (BigDecimal)SCMUtils.effectualExchangeRate((BigDecimal)order.getExchangeRate()));
                selector.pushBalance("FUnArBillOrderAmt", unExecuteAmount.negate());
            }
        }
        return this;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtDelete(IObjectValue billInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.DELETE);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || creditParamInfo.getSO_CtrlTime() != 1) {
            this.isUpdateCredite = false;
            return this;
        }
        BigDecimal amt = SCMUtils.effectualNumeric((BigDecimal)this.visitSaleOrderInfo().getLocalTotalTaxAmount());
        selector.pushBalance("FUnAuditSOAmt", amt.negate());
        return this;
    }

    private CreditBalanceSeletor getSelector(IObjectValue billInfo) throws BOSException, EASBizException {
        this.billChanged();
        this.pushCommonBalance(billInfo);
        CreditBalanceSeletor selector = new CreditBalanceSeletor(this);
        selector.setCompany(this.visitCompany());
        return selector;
    }

    private void pushCommonBalance(IObjectValue billInfo) throws EASBizException, BOSException {
        this.creditBalance.clear();
        SaleOrderInfo saleOrder = SaleOrderBalanceUpdateProxy.readFullSaleOrderInfo(this.ctx, SaleOrderBalanceUpdateProxy.visitSaleOrderInfo(billInfo));
        if (saleOrder != null) {
            this.creditBalance.put("BILLINFO", saleOrder);
            this.creditBalance.put("COMPANY", CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(this.ctx, (OrgUnitInfo)saleOrder.getCompanyOrgUnit()));
            this.creditBalance.put("CUSTOMER", CreditUtils.readFullCustomerInfo(this.ctx, saleOrder.getOrderCustomer()));
            this.creditBalance.put("BILLDATE", saleOrder.getBizDate());
            this.creditBalance.put("BILLTYPE", "510b6503-0105-1000-e000-0113c0a812fd463ED552");
            this.creditBalance.put("BILLID", saleOrder.getId().toString());
            this.creditBalance.put("BILLNUMBER", saleOrder.getNumber().toString());
            this.creditBalance.put("REMARK", "");
            this.creditBalance.put("REMARK_L1", "");
            this.creditBalance.put("REMARK_L2", "");
            this.creditBalance.put("REMARK_L3", "");
        }
    }

    @Override
    public final boolean isNeedUpdateCreditBalanceForBill(CreditParamInfo param) throws BOSException, EASBizException {
        PaymentTypeInfo paymentType;
        if (param == null || !param.isCtrlSaleOrderAmount()) {
            return false;
        }
        boolean isNeed = false;
        SaleOrderInfo saleOrder = this.visitSaleOrderInfo();
        if (saleOrder != null && (paymentType = saleOrder.getPaymentType()) != null && paymentType.getId() != null) {
            isNeed = "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5".equalsIgnoreCase(paymentType.getId().toString());
        }
        return isNeed;
    }

    public static SaleOrderInfo visitSaleOrderInfo(IObjectValue billInfo) throws BOSException {
        if (billInfo != null && billInfo instanceof SaleOrderInfo) {
            return (SaleOrderInfo)billInfo;
        }
        throw new BOSException("this is'nt saleorder or billInfo is Null!");
    }

    public SaleOrderInfo visitSaleOrderInfo() {
        SaleOrderInfo order = null;
        IObjectValue o = super.visitBillInfo();
        if (o != null && o instanceof SaleOrderInfo) {
            order = (SaleOrderInfo)o;
        }
        return order;
    }

    public static SaleOrderInfo readFullSaleOrderInfo(Context ctx, SaleOrderInfo saleOrder) throws EASBizException, BOSException {
        SaleOrderInfo so = saleOrder;
        if (!(saleOrder == null || saleOrder.getId() == null || saleOrder.containsKey("saleOrgUnit") && saleOrder.containsKey("orderCustomer") && saleOrder.containsKey("companyOrgUnit") && saleOrder.containsKey("currency") && saleOrder.containsKey("exchangeRate") && saleOrder.containsKey("paymentType") && saleOrder.containsKey("localTotalTaxAmount") && saleOrder.containsKey("number") && saleOrder.containsKey("bizDate") && saleOrder.containsKey("billType") && saleOrder.containsKey("baseStatus"))) {
            so = SaleOrderFactory.getLocalInstance((Context)ctx).getSaleOrderInfo((IObjectPK)new ObjectStringPK(saleOrder.getId().toString()), SaleOrderBalanceUpdateProxy.getSelectors());
        }
        return so;
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("bizDate"));
        selectors.add(new SelectorItemInfo("billType"));
        selectors.add(new SelectorItemInfo("saleOrgUnit.id"));
        selectors.add(new SelectorItemInfo("orderCustomer.id"));
        selectors.add(new SelectorItemInfo("companyOrgUnit.id"));
        selectors.add(new SelectorItemInfo("currency.id"));
        selectors.add(new SelectorItemInfo("exchangeRate"));
        selectors.add(new SelectorItemInfo("paymentType.id"));
        selectors.add(new SelectorItemInfo("localTotalTaxAmount"));
        selectors.add(new SelectorItemInfo("baseStatus"));
        selectors.add(new SelectorItemInfo("entries.id"));
        selectors.add(new SelectorItemInfo("entries.actualTaxPrice"));
        selectors.add(new SelectorItemInfo("entries.totalIssueQty"));
        selectors.add(new SelectorItemInfo("entries.qty"));
        selectors.add(new SelectorItemInfo("entries.baseStatus"));
        return selectors;
    }

    public void updateAtSubmit(IObjectValue billInfo, IObjectValue oldBillInfo) throws BOSException, EASBizException {
        if (oldBillInfo == null) {
            this.pushCreditBalanceAtSubmit(billInfo).updateCreditBalance();
            return;
        }
        SaleOrderInfo newBill = SaleOrderBalanceUpdateProxy.readFullSaleOrderInfo(this.ctx, SaleOrderBalanceUpdateProxy.visitSaleOrderInfo(billInfo));
        SaleOrderInfo oldBill = SaleOrderBalanceUpdateProxy.readFullSaleOrderInfo(this.ctx, SaleOrderBalanceUpdateProxy.visitSaleOrderInfo(oldBillInfo));
        if (oldBill.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            this.pushCreditBalanceAtSubmit(billInfo).updateCreditBalance();
            return;
        }
        if (oldBill.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            String oldPayId;
            String newPayId = newBill.getPaymentType().getId().toString();
            if (newPayId.equals(oldPayId = oldBill.getPaymentType().getId().toString()) && newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                String newCustId = newBill.getOrderCustomer().getId().toString();
                String oldCustId = oldBill.getOrderCustomer().getId().toString();
                String newCompId = newBill.getSaleOrgUnit().getId().toString();
                String oldCompId = oldBill.getSaleOrgUnit().getId().toString();
                if (newCustId.equals(oldCustId) && newCompId.equals(oldCompId)) {
                    this.pushCreditBalanceAtUpdate((IObjectValue)newBill, (IObjectValue)oldBill).updateCreditBalance();
                } else {
                    this.pushCreditBalanceAtDelete((IObjectValue)oldBill).updateCreditBalance();
                    this.pushCreditBalanceAtSubmit((IObjectValue)newBill).updateCreditBalance();
                }
            } else if (newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                this.pushCreditBalanceAtSubmit(billInfo).updateCreditBalance();
            } else if (oldPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                this.pushCreditBalanceAtDelete((IObjectValue)oldBill).updateCreditBalance();
            }
        }
    }

    @Override
    protected void updateRule(String operator, BigDecimal locTotalAmt) {
        if (operator.equals("CLOSE")) {
            this.pushBalance("FUnArBillOrderAmt", locTotalAmt.negate());
            if (!this.creditBalance.containsKey("REDITOPERATION")) {
                this.creditBalance.put("REDITOPERATION", CreditOperationEnum.CLOSE);
            }
        } else if (operator.equals("UNCLOSE")) {
            this.pushBalance("FUnArBillOrderAmt", locTotalAmt);
            if (!this.creditBalance.containsKey("REDITOPERATION")) {
                this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNCLOSE);
            }
        } else if (operator.equals("DELETE")) {
            this.pushBalance("FUnAuditSOAmt", locTotalAmt.negate());
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.DELETE);
        } else if (operator.equals("AUDIT")) {
            this.pushBalance("FUnAuditSOAmt", locTotalAmt.negate());
            this.pushBalance("FUnArBillOrderAmt", locTotalAmt);
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.AUDIT);
        } else if (operator.equals("UNAUDIT")) {
            this.pushBalance("FUnArBillOrderAmt", locTotalAmt.negate());
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNAUDIT);
        } else if (operator.equals("AUDIT_WB")) {
            this.pushBalance("FUnArBillOrderAmt", locTotalAmt.negate());
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.AUDIT);
        } else if (operator.equals("UNAUDIT_WB")) {
            this.pushBalance("FUnArBillOrderAmt", locTotalAmt);
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNAUDIT);
        } else if (operator.equals("CLOSEAR")) {
            this.pushBalance("FUnArBillOrderAmt", locTotalAmt.negate());
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.CLOSEAR);
        } else if (operator.equals("UNCLOSEAR")) {
            this.pushBalance("FUnArBillOrderAmt", locTotalAmt);
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNCLOSEAR);
        }
    }

    @Override
    protected CreditFormulaSceneEnum getBillSecene() {
        return CreditFormulaSceneEnum.ORDER;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtHandUnClosed(IObjectValue billInfo) throws BOSException, EASBizException {
        return null;
    }

    public CreditBalanceUpdateStrategy pushCreditBalanceAtAlter(IObjectValue billInfo, BigDecimal amt) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public boolean isNeedCreditLog() {
        return true;
    }

    @Override
    public String getCreditAccount() {
        return "DawAAAAPiJDuN4KI";
    }
}

