/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.balance.CreditBalanceSeletor;
import com.kingdee.eas.scm.credit.app.balance.CreditBalanceUpdateStrategy;
import com.kingdee.eas.scm.credit.app.balance.IAuditPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IDeletePushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IHandClosedPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.ISubmitPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IUnAuditPushCreditBalance;
import com.kingdee.eas.scm.credit.app.balance.IUpdatePushCreditBalance;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.sd.sale.ReceiveDispatcherTypeEnum;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SaleReturnsBalanceUpdateProxy
extends CreditBalanceUpdateStrategy
implements IAuditPushCreditBalance,
IHandClosedPushCreditBalance,
IUnAuditPushCreditBalance,
ISubmitPushCreditBalance,
IUpdatePushCreditBalance,
IDeletePushCreditBalance {
    public SaleReturnsBalanceUpdateProxy(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    public final boolean isNeedUpdateCreditBalanceForBill(CreditParamInfo param) throws BOSException, EASBizException {
        PaymentTypeInfo paymentType;
        if (param == null || !param.isCtrlSaleOrderAmount()) {
            return false;
        }
        boolean isNeed = false;
        SaleReturnsInfo saleReturnsInfo = SaleReturnsBalanceUpdateProxy.readFullSaleReturnsInfo(this.ctx, this.visitSaleReturnsInfo());
        if (saleReturnsInfo != null && (paymentType = saleReturnsInfo.getPaymentType()) != null && paymentType.getId() != null) {
            isNeed = "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5".equalsIgnoreCase(paymentType.getId().toString());
        }
        return isNeed;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtSubmit(IObjectValue billInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.SUBMIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || creditParamInfo.getReturnBill_CtrlTime() == 2 || creditParamInfo.getReturnBill_CtrlTime() == -1 && creditParamInfo.getSO_CtrlTime() == 2) {
            this.isUpdateCredite = false;
            return this;
        }
        selector.pushBalance("FUnAuditSOAmt", this.getTotalLocalTaxAmount(this.visitSaleReturnsInfo()).negate());
        return this;
    }

    private BigDecimal getTotalLocalTaxAmount(SaleReturnsInfo srInfo) {
        BigDecimal totalLocalTaxAmount = new BigDecimal("0.0000");
        if (srInfo != null && srInfo.getEntries() != null) {
            SaleReturnsEntryCollection srEntryCollection = srInfo.getEntries();
            int n = srEntryCollection.size();
            for (int i = 0; i < n; ++i) {
                SaleReturnsEntryInfo srEntryInfo = srEntryCollection.get(i);
                ReceiveDispatcherTypeEnum receiveDispatcherType = srEntryInfo.getReceiveDispatcherType();
                BigDecimal localTaxAmount = SCMUtils.effectualNumeric((BigDecimal)srEntryInfo.getLocalTaxAmount());
                if (receiveDispatcherType != null && receiveDispatcherType.getValue() == 2) {
                    localTaxAmount = localTaxAmount.negate();
                }
                totalLocalTaxAmount = totalLocalTaxAmount.add(localTaxAmount);
            }
        }
        return totalLocalTaxAmount;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtUpdate(IObjectValue billInfo, IObjectValue oldBillInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.SUBMIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || creditParamInfo.getReturnBill_CtrlTime() == 2 || creditParamInfo.getReturnBill_CtrlTime() == -1 && creditParamInfo.getSO_CtrlTime() == 2) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleReturnsInfo saleReturns = SaleReturnsBalanceUpdateProxy.visitSaleReturnsInfo(billInfo);
        SaleReturnsInfo saleReturnsOld = SaleReturnsBalanceUpdateProxy.visitSaleReturnsInfo(oldBillInfo);
        if (saleReturns != null && saleReturnsOld != null) {
            BigDecimal diffAmt = this.getTotalLocalTaxAmount(saleReturns).subtract(this.getTotalLocalTaxAmount(saleReturnsOld));
            selector.pushBalance("FUnAuditSOAmt", diffAmt.negate());
        }
        return this;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtDelete(IObjectValue billInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.DELETE);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || creditParamInfo.getReturnBill_CtrlTime() == 2 || creditParamInfo.getReturnBill_CtrlTime() == -1 && creditParamInfo.getSO_CtrlTime() == 2) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleReturnsInfo returnInfo = null;
        String bizTypeID = null;
        if (billInfo instanceof SaleReturnsInfo) {
            returnInfo = (SaleReturnsInfo)billInfo;
            String string = bizTypeID = returnInfo.getBizType() == null ? null : returnInfo.getBizType().getId().toString();
        }
        if (!"wIZPS7oOQaOl1CeE/8cZOSQHQ1w=".equals(bizTypeID)) {
            selector.pushBalance("FUnAuditSOAmt", this.getTotalLocalTaxAmount(this.visitSaleReturnsInfo()));
        }
        return this;
    }

    @Override
    public final CreditBalanceUpdateStrategy pushCreditBalanceAtAudit(IObjectValue billInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.AUDIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        CreditParamInfo creditParamInfo = this.getCreditParam();
        if (creditParamInfo == null || !canUpdateCredit || creditParamInfo.getReturnBill_CtrlTime() == -1 && creditParamInfo.getSO_CtrlTime() != 2 && creditParamInfo.getSO_CtrlTime() != 1) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleReturnsInfo returnInfo = null;
        String bizTypeID = null;
        if (billInfo instanceof SaleReturnsInfo) {
            returnInfo = (SaleReturnsInfo)billInfo;
            String string = bizTypeID = returnInfo.getBizType() == null ? null : returnInfo.getBizType().getId().toString();
        }
        if ("wIZPS7oOQaOl1CeE/8cZOSQHQ1w=".equals(bizTypeID)) {
            this.isUpdateCredite = false;
            return this;
        }
        if (creditParamInfo.getReturnBill_CtrlTime() == 2 || creditParamInfo.getSO_CtrlTime() == 2) {
            selector.pushBalance("FUnArBillOrderAmt", this.getTotalLocalTaxAmount(this.visitSaleReturnsInfo()).negate());
        } else if (creditParamInfo.getReturnBill_CtrlTime() == 1 || creditParamInfo.getSO_CtrlTime() == 1) {
            selector.pushBalance("FUnArBillOrderAmt", this.getTotalLocalTaxAmount(this.visitSaleReturnsInfo()).negate());
            selector.pushBalance("FUnAuditSOAmt", this.getTotalLocalTaxAmount(this.visitSaleReturnsInfo()));
        }
        return this;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtUnAudit(IObjectValue billInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNAUDIT);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleReturnsInfo returnInfo = null;
        String bizTypeID = null;
        if (billInfo instanceof SaleReturnsInfo) {
            returnInfo = (SaleReturnsInfo)billInfo;
            String string = bizTypeID = returnInfo.getBizType() == null ? null : returnInfo.getBizType().getId().toString();
        }
        if ("wIZPS7oOQaOl1CeE/8cZOSQHQ1w=".equals(bizTypeID)) {
            this.isUpdateCredite = false;
            return this;
        }
        selector.pushBalance("FUnArBillOrderAmt", this.getTotalLocalTaxAmount(this.visitSaleReturnsInfo()));
        return this;
    }

    @Override
    public final CreditBalanceUpdateStrategy pushCreditBalanceAtHandClosed(IObjectValue billInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.CLOSE);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleReturnsInfo returnInfo = null;
        String bizTypeID = null;
        if (billInfo instanceof SaleReturnsInfo) {
            returnInfo = (SaleReturnsInfo)billInfo;
            String string = bizTypeID = returnInfo.getBizType() == null ? null : returnInfo.getBizType().getId().toString();
        }
        if ("wIZPS7oOQaOl1CeE/8cZOSQHQ1w=".equals(bizTypeID)) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleReturnsInfo saleReturns = this.visitSaleReturnsInfo();
        if (saleReturns != null) {
            BigDecimal unIssueQty = SysConstant.BIGZERO;
            BigDecimal unInvoiceQty = SysConstant.BIGZERO;
            BigDecimal unExecuteAmount = SysConstant.BIGZERO;
            SaleReturnsEntryInfo entry = null;
            int size = saleReturns.getEntries().size();
            for (int i = 0; i < size; ++i) {
                entry = saleReturns.getEntries().get(i);
                if (entry == null || entry.getBaseStatus().getValue() != 7) continue;
                unIssueQty = SCMUtils.effectualNumeric((BigDecimal)entry.getReturnsQty());
                if (unIssueQty.compareTo(unInvoiceQty = SCMUtils.effectualNumeric((BigDecimal)entry.getInvoicedQty())) > 0) {
                    unInvoiceQty = unIssueQty;
                }
                if ((unInvoiceQty = SCMUtils.effectualNumeric((BigDecimal)entry.getQty()).subtract(unInvoiceQty)).compareTo(SysConstant.BIGZERO) <= 0) continue;
                BigDecimal tmp = SCMUtils.effectualNumeric((BigDecimal)entry.getTaxPrice()).multiply(unInvoiceQty).setScale(10);
                if (entry.getReceiveDispatcherType() != null && entry.getReceiveDispatcherType().getValue() == 2) {
                    tmp = tmp.negate();
                }
                unExecuteAmount = unExecuteAmount.add(tmp);
            }
            if (SysConstant.BIGZERO.compareTo(unExecuteAmount) != 0) {
                unExecuteAmount = SCMUtils.convertAmountByCompany((Context)this.ctx, (BigDecimal)unExecuteAmount, (CompanyOrgUnitInfo)selector.getCompany(), (CurrencyInfo)saleReturns.getCurrency(), (BigDecimal)SCMUtils.effectualExchangeRate((BigDecimal)saleReturns.getExchangeRate()));
                selector.pushBalance("FUnArBillOrderAmt", unExecuteAmount);
            }
        }
        return this;
    }

    private CreditBalanceSeletor getSelector(IObjectValue billInfo) throws BOSException, EASBizException {
        this.billChanged();
        this.pushCommonBalance(billInfo);
        CreditBalanceSeletor selector = new CreditBalanceSeletor(this);
        selector.setCompany(this.visitCompany());
        return selector;
    }

    private void pushCommonBalance(IObjectValue billInfo) throws EASBizException, BOSException {
        this.creditBalance.clear();
        SaleReturnsInfo saleReturns = SaleReturnsBalanceUpdateProxy.readFullSaleReturnsInfo(this.ctx, SaleReturnsBalanceUpdateProxy.visitSaleReturnsInfo(billInfo));
        if (saleReturns != null) {
            this.creditBalance.put("BILLINFO", saleReturns);
            this.creditBalance.put("COMPANY", CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(this.ctx, (OrgUnitInfo)saleReturns.getSaleOrgUnit()));
            this.creditBalance.put("CUSTOMER", CreditUtils.readFullCustomerInfo(this.ctx, saleReturns.getReturnsCustomer()));
            this.creditBalance.put("BILLDATE", saleReturns.getBizDate());
            this.creditBalance.put("BILLTYPE", "50957179-0105-1000-e008-8152c0a812fd463ED552");
            this.creditBalance.put("BILLID", saleReturns.getId().toString());
            this.creditBalance.put("BILLNUMBER", saleReturns.getNumber().toString());
            this.creditBalance.put("REMARK", "");
            this.creditBalance.put("REMARK_L1", "");
            this.creditBalance.put("REMARK_L2", "");
            this.creditBalance.put("REMARK_L3", "");
        }
    }

    public static SaleReturnsInfo visitSaleReturnsInfo(IObjectValue billInfo) throws BOSException {
        if (billInfo != null && billInfo instanceof SaleReturnsInfo) {
            return (SaleReturnsInfo)billInfo;
        }
        throw new BOSException("this is'nt SaleReturnsInfo or billInfo is Null!");
    }

    public SaleReturnsInfo visitSaleReturnsInfo() {
        SaleReturnsInfo returns = null;
        IObjectValue o = super.visitBillInfo();
        if (o != null && o instanceof SaleReturnsInfo) {
            returns = (SaleReturnsInfo)o;
        }
        return returns;
    }

    public static SaleReturnsInfo readFullSaleReturnsInfo(Context ctx, SaleReturnsInfo saleReturns) throws EASBizException, BOSException {
        SaleReturnsInfo sr = saleReturns;
        if (!(saleReturns == null || saleReturns.getId() == null || saleReturns.containsKey("saleOrgUnit") && saleReturns.containsKey("returnsCustomer") && saleReturns.containsKey("currency") && saleReturns.containsKey("exchangeRate") && saleReturns.containsKey("localTotalTaxAmount") && saleReturns.containsKey("baseStatus") && saleReturns.containsKey("entries") && saleReturns.containsKey("paymentType"))) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("number"));
            selectors.add(new SelectorItemInfo("bizDate"));
            selectors.add(new SelectorItemInfo("billType"));
            selectors.add(new SelectorItemInfo("saleOrgUnit.id"));
            selectors.add(new SelectorItemInfo("returnsCustomer.id"));
            selectors.add(new SelectorItemInfo("currency.id"));
            selectors.add(new SelectorItemInfo("exchangeRate"));
            selectors.add(new SelectorItemInfo("localTotalTaxAmount"));
            selectors.add(new SelectorItemInfo("baseStatus"));
            selectors.add(new SelectorItemInfo("paymentType"));
            selectors.add(new SelectorItemInfo("entries.id"));
            selectors.add(new SelectorItemInfo("entries.receiveDispatcherType"));
            selectors.add(new SelectorItemInfo("entries.taxPrice"));
            selectors.add(new SelectorItemInfo("entries.qty"));
            selectors.add(new SelectorItemInfo("entries.returnsQty"));
            selectors.add(new SelectorItemInfo("entries.baseStatus"));
            selectors.add(new SelectorItemInfo("entries.localTaxAmount"));
            sr = SaleReturnsFactory.getLocalInstance((Context)ctx).getSaleReturnsInfo((IObjectPK)new ObjectStringPK(saleReturns.getId().toString()), selectors);
        }
        return sr;
    }

    public void updateAtClosed(List entryIdLst) throws BOSException, EASBizException {
        if (entryIdLst == null || entryIdLst.size() <= 0) {
            return;
        }
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(entryIdLst.iterator(), params);
        this.batchUpdate(this.getSelectBillSql_Close(paramStr), params, "CLOSE");
    }

    private String getSelectBillSql_Close(String paramStr) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("SELECT orgRe.FToUnitID  as FCompanyOrgUnitID,t0.FReturnsCustomerID as FOrderCustomerID,").append(" t0.FID as FID, t0.FNumber as FNumber, t0.FBizDate as FBizDate, t0.FBilltypeID as FBilltypeID, ").append("  SUM(CASE WHEN t0.FConvertMode = 0 THEN ").append(" ROUND((t1.FQty - (case when t1.FReturnsQty>t1.FInvoicedQty and t1.FReturnsQty<=t1.FQty then t1.FReturnsQty  when t1.FReturnsQty<=t1.FInvoicedQty and t1.FReturnsQty<=t1.FQty then t1.FInvoicedQty end)) * t1.FTaxPrice * t0.FExchangeRate,ISNULL(t4.FPrecision,4))*(case when t1.FReceiveDispatcherType=1 then 1 else -1 end) ").append(" ELSE ").append(" ROUND((t1.FQty - (case when t1.FReturnsQty>t1.FInvoicedQty and t1.FReturnsQty<=t1.FQty then t1.FReturnsQty  when t1.FReturnsQty<=t1.FInvoicedQty and t1.FReturnsQty<=t1.FQty then t1.FInvoicedQty end)) * t1.FTaxPrice / t0.FExchangeRate,ISNULL(t4.FPrecision,4))*(case when t1.FReceiveDispatcherType=1 then 1 else -1 end) END)  ").append("  AS locAmt  ").append(" FROM T_SD_SaleReturns t0 ").append("  INNER JOIN T_SD_SaleReturnsEntry t1 ON  t0.FID = t1.FParentID ").append("  INNER JOIN T_BD_Customer t2 ON t0.FReturnsCustomerID = t2.FID").append("  LEFT OUTER JOIN T_ORG_UnitRelation orgRe ON orgRe.FFromUnitID = t0.FSaleOrgUnitID AND ").append("      orgRe.FTypeRelationID = '00000000-0000-0000-0000-0000000000050FE9F8B5' ").append("  LEFT JOIN T_ORG_Company t3 ON t3.FID = orgRe.FToUnitID").append("  LEFT JOIN T_BD_Currency t4 ON t4.FID = t3.FBaseCurrencyID").append(" WHERE t1.FID in ").append(paramStr).append(" AND t2.FIsCredited = 1 AND t0.FBizTypeID != 'wIZPS7oOQaOl1CeE/8cZOSQHQ1w='").append(" AND t1.FBaseStatus = ").append(7).append(" GROUP BY orgRe.FToUnitID,t0.FReturnsCustomerID,t0.FID,t0.FNumber,t0.FBizDate,t0.FBilltypeID ");
        return strSQL.toString();
    }

    @Override
    protected void updateRule(String operator, BigDecimal locTotalAmt) {
        if (operator.equals("CLOSE")) {
            this.pushBalance("FUnArBillOrderAmt", locTotalAmt);
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.CLOSE);
        } else if (operator.equals("UNCLOSE")) {
            this.pushBalance("FUnArBillOrderAmt", locTotalAmt.negate());
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNCLOSE);
        } else if (operator.equals("DELETE")) {
            this.pushBalance("FUnAuditSOAmt", locTotalAmt);
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.DELETE);
        } else if (operator.equals("AUDIT")) {
            this.pushBalance("FUnAuditSOAmt", locTotalAmt);
            this.pushBalance("FUnArBillOrderAmt", locTotalAmt.negate());
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.AUDIT);
        } else if (operator.equals("UNAUDIT")) {
            this.pushBalance("FUnArBillOrderAmt", locTotalAmt);
            this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNAUDIT);
        }
    }

    public void updateAtUnClosed(List entryIdLst) throws BOSException, EASBizException {
        if (entryIdLst == null || entryIdLst.size() <= 0) {
            return;
        }
        ArrayList params = new ArrayList();
        String paramStr = SCMUtils.toParamString(entryIdLst.iterator(), params);
        this.batchUpdate(this.getSelectBillSql_Close(paramStr), params, "UNCLOSE");
    }

    public void updateAtSubmit(IObjectValue billInfo, IObjectValue oldBillInfo) throws BOSException, EASBizException {
        if (oldBillInfo != null) {
            String bizTypeID;
            SaleReturnsInfo newBill = SaleReturnsBalanceUpdateProxy.readFullSaleReturnsInfo(this.ctx, SaleReturnsBalanceUpdateProxy.visitSaleReturnsInfo(billInfo));
            SaleReturnsInfo oldBill = SaleReturnsBalanceUpdateProxy.readFullSaleReturnsInfo(this.ctx, SaleReturnsBalanceUpdateProxy.visitSaleReturnsInfo(oldBillInfo));
            String string = bizTypeID = oldBill.getBizType() == null ? null : oldBill.getBizType().getId().toString();
            if (oldBill.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) && !"wIZPS7oOQaOl1CeE/8cZOSQHQ1w=".equals(bizTypeID)) {
                String oldPayId;
                String newPayId = newBill.getPaymentType().getId().toString();
                if (newPayId.equals(oldPayId = oldBill.getPaymentType().getId().toString()) && newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                    String newCustId = newBill.getReturnsCustomer().getId().toString();
                    String oldCustId = oldBill.getReturnsCustomer().getId().toString();
                    String newCompId = newBill.getSaleOrgUnit().getId().toString();
                    String oldCompId = oldBill.getSaleOrgUnit().getId().toString();
                    if (newCustId.equals(oldCustId) && newCompId.equals(oldCompId)) {
                        this.pushCreditBalanceAtUpdate((IObjectValue)newBill, (IObjectValue)oldBill).updateCreditBalance();
                    } else {
                        this.pushCreditBalanceAtDelete((IObjectValue)oldBill).updateCreditBalance();
                        this.pushCreditBalanceAtSubmit((IObjectValue)newBill).updateCreditBalance();
                    }
                } else if (newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                    this.pushCreditBalanceAtSubmit(billInfo).updateCreditBalance();
                } else if (oldPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                    this.pushCreditBalanceAtDelete((IObjectValue)oldBill).updateCreditBalance();
                }
            } else if (!"wIZPS7oOQaOl1CeE/8cZOSQHQ1w=".equals(bizTypeID)) {
                this.pushCreditBalanceAtSubmit(billInfo).updateCreditBalance();
            }
        } else {
            String bizTypeID;
            SaleReturnsInfo newBill = SaleReturnsBalanceUpdateProxy.readFullSaleReturnsInfo(this.ctx, SaleReturnsBalanceUpdateProxy.visitSaleReturnsInfo(billInfo));
            String string = bizTypeID = newBill.getBizType() == null ? null : newBill.getBizType().getId().toString();
            if (!"wIZPS7oOQaOl1CeE/8cZOSQHQ1w=".equals(bizTypeID)) {
                this.pushCreditBalanceAtSubmit(billInfo).updateCreditBalance();
            }
        }
    }

    @Override
    protected CreditFormulaSceneEnum getBillSecene() {
        return CreditFormulaSceneEnum.ORDER;
    }

    @Override
    public CreditBalanceUpdateStrategy pushCreditBalanceAtHandUnClosed(IObjectValue billInfo) throws BOSException, EASBizException {
        CreditBalanceSeletor selector = this.getSelector(billInfo);
        this.creditBalance.put("REDITOPERATION", CreditOperationEnum.UNCLOSE);
        boolean canUpdateCredit = this.isNeedUpdateCreditBalance();
        if (!canUpdateCredit) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleReturnsInfo returnInfo = null;
        String bizTypeID = null;
        if (billInfo instanceof SaleReturnsInfo) {
            returnInfo = (SaleReturnsInfo)billInfo;
            String string = bizTypeID = returnInfo.getBizType() == null ? null : returnInfo.getBizType().getId().toString();
        }
        if ("wIZPS7oOQaOl1CeE/8cZOSQHQ1w=".equals(bizTypeID)) {
            this.isUpdateCredite = false;
            return this;
        }
        SaleReturnsInfo saleReturns = this.visitSaleReturnsInfo();
        if (saleReturns != null) {
            BigDecimal unIssueQty = SysConstant.BIGZERO;
            BigDecimal unInvoiceQty = SysConstant.BIGZERO;
            BigDecimal unExecuteAmount = SysConstant.BIGZERO;
            SaleReturnsEntryInfo entry = null;
            int size = saleReturns.getEntries().size();
            for (int i = 0; i < size; ++i) {
                entry = saleReturns.getEntries().get(i);
                if (entry == null || entry.getBaseStatus().getValue() != 4) continue;
                unIssueQty = SCMUtils.effectualNumeric((BigDecimal)entry.getReturnsQty());
                if (unIssueQty.compareTo(unInvoiceQty = SCMUtils.effectualNumeric((BigDecimal)entry.getInvoicedQty())) > 0) {
                    unInvoiceQty = unIssueQty;
                }
                if ((unInvoiceQty = SCMUtils.effectualNumeric((BigDecimal)entry.getQty()).subtract(unInvoiceQty)).compareTo(SysConstant.BIGZERO) <= 0) continue;
                BigDecimal tmp = SCMUtils.effectualNumeric((BigDecimal)entry.getTaxPrice()).multiply(unInvoiceQty).setScale(10);
                if (entry.getReceiveDispatcherType() != null && entry.getReceiveDispatcherType().getValue() == 2) {
                    tmp = tmp.negate();
                }
                unExecuteAmount = unExecuteAmount.add(tmp);
            }
            if (SysConstant.BIGZERO.compareTo(unExecuteAmount) != 0) {
                unExecuteAmount = SCMUtils.convertAmountByCompany((Context)this.ctx, (BigDecimal)unExecuteAmount, (CompanyOrgUnitInfo)selector.getCompany(), (CurrencyInfo)saleReturns.getCurrency(), (BigDecimal)SCMUtils.effectualExchangeRate((BigDecimal)saleReturns.getExchangeRate()));
                selector.pushBalance("FUnArBillOrderAmt", unExecuteAmount.negate());
            }
        }
        return this;
    }

    public CreditBalanceUpdateStrategy pushCreditBalanceAtAlter(IObjectValue billInfo, BigDecimal amt) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public boolean isNeedCreditLog() {
        return true;
    }

    @Override
    public String getCreditAccount() {
        return "DawAAAAPiJDuN4KI";
    }
}

