/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlBaseStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlHelper;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class ApSysBillCreditControlStrategy
extends CreditControlBaseStrategy {
    public static final String PAYMENTTYPEID_CREDITPUR = "2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5";
    private CreditFormulaSceneEnum billType;

    public ApSysBillCreditControlStrategy() {
    }

    public ApSysBillCreditControlStrategy(CreditFormulaSceneEnum billType) {
        this.billType = billType;
    }

    @Override
    protected boolean isControlCredit(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene, ContrlTimeEnum contrlTime) throws EASBizException, BOSException {
        BillBaseInfo apBill = (BillBaseInfo)billInfo;
        String newCustId = null;
        if (CreditFormulaSceneEnum.APBILL.equals((Object)CreditUtils.getBillTypeByBosType(apBill.getBOSType()))) {
            newCustId = apBill.getString("asstActID");
        } else if (CreditFormulaSceneEnum.PAYBILL.equals((Object)CreditUtils.getBillTypeByBosType(apBill.getBOSType()))) {
            newCustId = apBill.getString("payeeID");
        }
        if (newCustId == null || newCustId.trim().length() == 0) {
            return false;
        }
        boolean isCustomer = CustomerInfo.getBosType().equals(BOSUuid.read((String)newCustId).getType().toString());
        boolean isSupplier = SupplierInfo.getBosType().equals(BOSUuid.read((String)newCustId).getType().toString());
        if (!isCustomer && !isSupplier) {
            return false;
        }
        PaymentTypeInfo paymenttypeinfo = (PaymentTypeInfo)apBill.get("paymentType");
        if (paymenttypeinfo == null) {
            throw new CreditControlException(CreditControlException.NULL_PAYMENTTYPE);
        }
        String newPayId = paymenttypeinfo.getId().toString();
        if (!newPayId.equals(PAYMENTTYPEID_CREDITPUR)) {
            return false;
        }
        if (isCustomer) {
            CustomerInfo theCustInfo = new CustomerInfo();
            theCustInfo.setId(BOSUuid.read((String)newCustId));
            return CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, theCustInfo);
        }
        if (isSupplier) {
            SupplierInfo theSupplierInfo = new SupplierInfo();
            theSupplierInfo.setId(BOSUuid.read((String)newCustId));
            return CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, theSupplierInfo);
        }
        return false;
    }

    @Override
    protected CreditCondition getCreditCondition(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene) throws EASBizException, BOSException {
        BillBaseInfo apBill = (BillBaseInfo)billInfo;
        CreditCondition creditCondition = new CreditCondition();
        if (CreditFormulaSceneEnum.APBILL.equals((Object)CreditUtils.getBillTypeByBosType(apBill.getBOSType()))) {
            CustomerInfo customer = new CustomerInfo();
            customer.setId(BOSUuid.read((String)apBill.getString("asstActID")));
            creditCondition.setCustomer(customer);
        } else if (CreditFormulaSceneEnum.PAYBILL.equals((Object)CreditUtils.getBillTypeByBosType(apBill.getBOSType()))) {
            CustomerInfo customer = new CustomerInfo();
            customer.setId(BOSUuid.read((String)apBill.getString("payeeID")));
            creditCondition.setCustomer(customer);
        }
        creditCondition.setCompany(companyInfo);
        creditCondition.setPaymentType((PaymentTypeInfo)apBill.get("paymentType"));
        creditCondition.setCreditControlScene(scene.getValue());
        try {
            if (apBill.getId() != null && apBill.getNumber() == null) {
                apBill = (BillBaseInfo)this.readFullBillInfo(ctx, apBill.getId().toString());
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        creditCondition.setBillNumber(apBill.getNumber());
        creditCondition.setBillDate(apBill.getBizDate());
        return creditCondition;
    }

    @Override
    protected Map getBillNumericAtAudit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        BillBaseInfo apBill = (BillBaseInfo)billInfo;
        BigDecimal locTotalTaxAmt = SysConstant.BIGZERO;
        if (CreditFormulaSceneEnum.APBILL.equals((Object)CreditUtils.getBillTypeByBosType(apBill.getBOSType()))) {
            locTotalTaxAmt = apBill.getBigDecimal("amountLocal");
        } else if (CreditFormulaSceneEnum.PAYBILL.equals((Object)CreditUtils.getBillTypeByBosType(apBill.getBOSType()))) {
            locTotalTaxAmt = apBill.getBigDecimal("localAmt");
        }
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", locTotalTaxAmt);
        return billNumeric;
    }

    @Override
    protected Map getBillNumericAtSubmit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        BillBaseInfo apBill = (BillBaseInfo)billInfo;
        BigDecimal locTotalTaxAmt = SysConstant.BIGZERO;
        if (CreditFormulaSceneEnum.APBILL.equals((Object)CreditUtils.getBillTypeByBosType(apBill.getBOSType()))) {
            locTotalTaxAmt = apBill.getBigDecimal("amountLocal");
        } else if (CreditFormulaSceneEnum.PAYBILL.equals((Object)CreditUtils.getBillTypeByBosType(apBill.getBOSType()))) {
            locTotalTaxAmt = apBill.getBigDecimal("localAmt");
        }
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", locTotalTaxAmt);
        return billNumeric;
    }

    @Override
    protected Object readFullBillInfo(Context ctx, String billID) throws EASBizException, BOSException {
        return CreditControlHelper.readFullApBillInfo(ctx, billID);
    }

    @Override
    protected CompanyOrgUnitInfo getCompany(Context ctx, Object billInfo) throws EASBizException, BOSException {
        BillBaseInfo apBill = (BillBaseInfo)billInfo;
        return apBill.getCompany();
    }

    @Override
    public CreditFormulaSceneEnum getBillType() {
        return this.billType;
    }
}

