/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlBaseStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlHelper;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class ArSysBillCreditControlStrategy
extends CreditControlBaseStrategy {
    private CreditFormulaSceneEnum billType;

    public ArSysBillCreditControlStrategy() {
    }

    public ArSysBillCreditControlStrategy(CreditFormulaSceneEnum billType) {
        this.billType = billType;
    }

    @Override
    protected boolean isControlCredit(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene, ContrlTimeEnum contrlTime) throws EASBizException, BOSException {
        CoreBillBaseInfo arBill = (CoreBillBaseInfo)billInfo;
        String newCustId = null;
        PaymentTypeInfo paymenttypeinfo = null;
        if (CreditFormulaSceneEnum.ARBILL.equals((Object)CreditUtils.getBillTypeByBosType(arBill.getBOSType()))) {
            newCustId = arBill.getString("asstActID");
            paymenttypeinfo = (PaymentTypeInfo)arBill.get("paymentType");
        } else if (CreditFormulaSceneEnum.RECBILL.equals((Object)CreditUtils.getBillTypeByBosType(arBill.getBOSType()))) {
            newCustId = arBill.getString("payerID");
            paymenttypeinfo = (PaymentTypeInfo)arBill.get("paymentType");
        } else if (CreditFormulaSceneEnum.PROXYBILL.equals((Object)CreditUtils.getBillTypeByBosType(arBill.getBOSType()))) {
            newCustId = arBill.getString("RecAsstActId");
            paymenttypeinfo = new PaymentTypeInfo();
            paymenttypeinfo.setId(BOSUuid.read((String)"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
        }
        if (newCustId == null || newCustId.trim().length() == 0) {
            return false;
        }
        boolean isCustomer = CustomerInfo.getBosType().equals(BOSUuid.read((String)newCustId).getType().toString());
        boolean isSupplier = SupplierInfo.getBosType().equals(BOSUuid.read((String)newCustId).getType().toString());
        if (!isCustomer && !isSupplier) {
            return false;
        }
        if (paymenttypeinfo == null) {
            throw new CreditControlException(CreditControlException.NULL_PAYMENTTYPE);
        }
        String newPayId = paymenttypeinfo.getId().toString();
        if (!newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
            return false;
        }
        if (isCustomer) {
            CustomerInfo theCustInfo = new CustomerInfo();
            theCustInfo.setId(BOSUuid.read((String)newCustId));
            return CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, theCustInfo);
        }
        if (isSupplier) {
            SupplierInfo theSupplierInfo = new SupplierInfo();
            theSupplierInfo.setId(BOSUuid.read((String)newCustId));
            return CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, theSupplierInfo);
        }
        return false;
    }

    @Override
    protected CreditCondition getCreditCondition(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene) throws EASBizException, BOSException {
        CustomerInfo customer;
        CoreBillBaseInfo arBill = (CoreBillBaseInfo)billInfo;
        CreditCondition creditCondition = new CreditCondition();
        if (CreditFormulaSceneEnum.ARBILL.equals((Object)CreditUtils.getBillTypeByBosType(arBill.getBOSType()))) {
            customer = new CustomerInfo();
            customer.setId(BOSUuid.read((String)arBill.getString("asstActID")));
            creditCondition.setCustomer(customer);
            creditCondition.setPaymentType((PaymentTypeInfo)arBill.get("paymentType"));
        } else if (CreditFormulaSceneEnum.RECBILL.equals((Object)CreditUtils.getBillTypeByBosType(arBill.getBOSType()))) {
            customer = new CustomerInfo();
            customer.setId(BOSUuid.read((String)arBill.getString("payerID")));
            creditCondition.setCustomer(customer);
            creditCondition.setPaymentType((PaymentTypeInfo)arBill.get("paymentType"));
        } else if (CreditFormulaSceneEnum.PROXYBILL.equals((Object)CreditUtils.getBillTypeByBosType(arBill.getBOSType()))) {
            customer = new CustomerInfo();
            customer.setId(BOSUuid.read((String)arBill.getString("RecAsstActId")));
            creditCondition.setCustomer(customer);
            PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
            paymentTypeInfo.setId(BOSUuid.read((String)"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
            creditCondition.setPaymentType(paymentTypeInfo);
        }
        creditCondition.setCompany(companyInfo);
        creditCondition.setCreditControlScene(scene.getValue());
        try {
            CoreBillBaseInfo info;
            if (arBill.getId() != null && arBill.getNumber() == null && (info = (CoreBillBaseInfo)this.readFullBillInfo(ctx, arBill.getId().toString())) != null) {
                arBill = info;
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        creditCondition.setBillNumber(arBill.getNumber());
        creditCondition.setBillDate(arBill.getBizDate());
        return creditCondition;
    }

    @Override
    protected Map getBillNumericAtAudit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        CoreBillBaseInfo arBill = (CoreBillBaseInfo)billInfo;
        BigDecimal locTotalTaxAmt = SysConstant.BIGZERO;
        if (CreditFormulaSceneEnum.ARBILL.equals((Object)CreditUtils.getBillTypeByBosType(arBill.getBOSType()))) {
            locTotalTaxAmt = arBill.getBigDecimal("amountLocal");
        } else if (CreditFormulaSceneEnum.RECBILL.equals((Object)CreditUtils.getBillTypeByBosType(arBill.getBOSType()))) {
            locTotalTaxAmt = arBill.getBigDecimal("localAmt");
        } else if (CreditFormulaSceneEnum.PROXYBILL.equals((Object)CreditUtils.getBillTypeByBosType(arBill.getBOSType()))) {
            locTotalTaxAmt = arBill.getBigDecimal("RecAmountLocal");
        }
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", locTotalTaxAmt);
        return billNumeric;
    }

    @Override
    protected Map getBillNumericAtSubmit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        CoreBillBaseInfo arBill = (CoreBillBaseInfo)billInfo;
        BigDecimal locTotalTaxAmt = SysConstant.BIGZERO;
        if (CreditFormulaSceneEnum.ARBILL.equals((Object)CreditUtils.getBillTypeByBosType(arBill.getBOSType()))) {
            locTotalTaxAmt = arBill.getBigDecimal("amountLocal");
        } else if (CreditFormulaSceneEnum.RECBILL.equals((Object)CreditUtils.getBillTypeByBosType(arBill.getBOSType()))) {
            locTotalTaxAmt = arBill.getBigDecimal("localAmt");
        } else if (CreditFormulaSceneEnum.PROXYBILL.equals((Object)CreditUtils.getBillTypeByBosType(arBill.getBOSType()))) {
            locTotalTaxAmt = arBill.getBigDecimal("RecAmountLocal");
        }
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", locTotalTaxAmt);
        return billNumeric;
    }

    @Override
    protected Object readFullBillInfo(Context ctx, String billID) throws EASBizException, BOSException {
        return CreditControlHelper.readFullARBillInfo(ctx, billID);
    }

    @Override
    protected CompanyOrgUnitInfo getCompany(Context ctx, Object billInfo) throws EASBizException, BOSException {
        CoreBillBaseInfo coreInfo = (CoreBillBaseInfo)billInfo;
        if (CreditFormulaSceneEnum.PROXYBILL.equals((Object)CreditUtils.getBillTypeByBosType(coreInfo.getBOSType()))) {
            return (CompanyOrgUnitInfo)coreInfo.get("CompanyOrgUnit");
        }
        BillBaseInfo arBill = (BillBaseInfo)billInfo;
        return arBill.getCompany();
    }

    @Override
    public CreditFormulaSceneEnum getBillType() {
        return this.billType;
    }
}

