/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.BizDirectionEnum;
import com.kingdee.eas.basedata.scm.im.inv.RecIssueTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditDirectionEnum;
import com.kingdee.eas.scm.credit.CreditFileInfo;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.CreditQueryFacadeFactory;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlHelper;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import java.math.BigDecimal;
import java.util.Map;

public abstract class CreditControlBaseStrategy {
    public CreditCtrlResult verifyCredit(Context ctx, String billID, CreditFormulaSceneEnum scene, CreditOperationEnum operation, CreditDirectionEnum direction) throws EASBizException, BOSException {
        Object billInfo = this.readFullBillInfo(ctx, billID);
        return this.verifyCredit(ctx, billInfo, scene, operation, direction);
    }

    public CreditCtrlResult verifyCredit(Context ctx, Object billInfo, CreditFormulaSceneEnum scene, CreditOperationEnum operation, CreditDirectionEnum direction) throws EASBizException, BOSException {
        Boolean result = CreditControlBaseStrategy.unNeedCreditCheck((IObjectValue)billInfo, scene, operation);
        if (result.booleanValue()) {
            return new CreditCtrlResult();
        }
        ContrlTimeEnum creditControlTime = null;
        ctx.remove((Object)"creditaction");
        if (scene.getValue() == 8 || scene.getValue() == 7) {
            creditControlTime = ContrlTimeEnum.ONAUDIT;
        } else if (scene.getValue() == 2 && operation.getValue() == 3) {
            ctx.put((Object)"creditaction", (Object)3);
            creditControlTime = ContrlTimeEnum.ONAUDIT;
        } else if (scene.getValue() == 2 && operation.getValue() == 4) {
            creditControlTime = ContrlTimeEnum.ONSUBMIT;
            if (((BillBaseInfo)billInfo).getInt("billStatus") == 1) {
                return new CreditCtrlResult();
            }
        } else if (scene.getValue() == 13 && operation.getValue() == 7) {
            creditControlTime = ContrlTimeEnum.ONSUBMIT;
        } else if (scene.getValue() == 13 && operation.getValue() != 7) {
            creditControlTime = ContrlTimeEnum.ONAUDIT;
        } else if (scene.getValue() == 3 && operation.getValue() == 3) {
            ctx.put((Object)"creditaction", (Object)3);
            creditControlTime = ContrlTimeEnum.ONAUDIT;
        } else if (scene.getValue() == 3 && operation.getValue() == 4) {
            if (((CoreBillBaseInfo)billInfo).getInt("baseStatus") == 1) {
                return new CreditCtrlResult();
            }
            creditControlTime = ContrlTimeEnum.ONSUBMIT;
        } else if (scene.getValue() == 6 && operation.getValue() == 3) {
            ctx.put((Object)"creditaction", (Object)3);
            creditControlTime = ContrlTimeEnum.ONAUDIT;
        } else if (scene.getValue() == 6 && operation.getValue() == 4) {
            if (((CoreBillBaseInfo)billInfo).getInt("baseStatus") == 1) {
                return new CreditCtrlResult();
            }
            creditControlTime = ContrlTimeEnum.ONSUBMIT;
        } else {
            switch (operation.getValue()) {
                case 1: {
                    creditControlTime = ContrlTimeEnum.ONSUBMIT;
                    break;
                }
                case 2: {
                    creditControlTime = ContrlTimeEnum.ONAUDIT;
                    break;
                }
                default: {
                    return new CreditCtrlResult();
                }
            }
        }
        CompanyOrgUnitInfo companyInfo = this.getCompany(ctx, billInfo);
        if (!this.isControlCredit(ctx, billInfo, companyInfo, scene, creditControlTime)) {
            return CreditControlHelper.getPassResult();
        }
        CreditCondition creditCondition = this.getCreditCondition(ctx, billInfo, companyInfo, scene);
        creditCondition.setCompany(CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(ctx, (OrgUnitInfo)creditCondition.getCompany()));
        String customerID = null;
        boolean isSupplier = false;
        if (creditCondition.getCustomer() != null) {
            customerID = creditCondition.getCustomer().getId().toString();
            isSupplier = SupplierInfo.getBosType().equals(creditCondition.getCustomer().getId().getType().toString());
        }
        if (creditCondition.getBizCodeID() == null && !isSupplier) {
            creditCondition.setCustomer(CreditUtils.readFullCustomerInfo(ctx, creditCondition.getCustomer()));
        }
        creditCondition.setCreditControlTime(creditControlTime);
        creditCondition.setOperation(operation);
        creditCondition.setDirection(direction);
        creditCondition.setBillType(this.getBillType());
        Map billNumeric = this.getNumericValue(ctx, billInfo, companyInfo.getId().toString(), creditControlTime, operation.getValue() == 4);
        creditCondition.setBillNumeric(billNumeric);
        CreditCtrlResult creditCtrlResult = this.verifyCredit(ctx, creditCondition);
        creditCtrlResult.setRequiredCheck(true);
        if (scene.getValue() != 13) {
            creditCtrlResult.setBillInfo((CoreBillBaseInfo)billInfo);
            if (customerID != null) {
                creditCtrlResult.setCustomerId(customerID);
            }
        } else {
            creditCtrlResult.setCreditFile((CreditFileInfo)billInfo);
        }
        CreditParamInfo tempParamInfo = creditCondition.getCreditParam();
        boolean isChanged = tempParamInfo.isChanged();
        tempParamInfo.setParameter("operation", creditCondition.getOperation().getValue());
        tempParamInfo.setChanged(isChanged);
        creditCtrlResult.setCreditParam(tempParamInfo);
        return creditCtrlResult;
    }

    private static Boolean unNeedCreditCheck(IObjectValue billInfo, CreditFormulaSceneEnum billType, CreditOperationEnum operation) {
        if (billType == CreditFormulaSceneEnum.ARBILL) {
            BigDecimal amountLocal = billInfo.getBigDecimal("amountLocal");
            if (amountLocal == null || amountLocal.compareTo(BigDecimal.ZERO) == 0) {
                return true;
            }
            if (operation == CreditOperationEnum.UNAUDIT && amountLocal.compareTo(BigDecimal.ZERO) > 0 || operation == CreditOperationEnum.AUDIT && amountLocal.compareTo(BigDecimal.ZERO) < 0 || operation == CreditOperationEnum.DELETE && amountLocal.compareTo(BigDecimal.ZERO) > 0 || operation == CreditOperationEnum.SUBMIT && amountLocal.compareTo(BigDecimal.ZERO) < 0) {
                return true;
            }
        } else if (billType == CreditFormulaSceneEnum.ISSUEDBILL) {
            if (billInfo.getObjectValue("transactionType") == null) {
                return true;
            }
            RecIssueTypeInfo recIssueType = (RecIssueTypeInfo)billInfo.getObjectValue("transactionType").getObjectValue("riType");
            BizDirectionEnum bizDirection = recIssueType.getBizDirection();
            if (operation == CreditOperationEnum.UNAUDIT && bizDirection == BizDirectionEnum.normal || operation == CreditOperationEnum.AUDIT && bizDirection == BizDirectionEnum.back || operation == CreditOperationEnum.DELETE && bizDirection == BizDirectionEnum.normal || operation == CreditOperationEnum.SUBMIT && bizDirection == BizDirectionEnum.back) {
                return true;
            }
        }
        return false;
    }

    public CreditCtrlResult verifyCredit(Context ctx, CreditCondition creditCondition) throws BOSException, EASBizException {
        CreditCtrlResult result = null;
        if (creditCondition == null) {
            result = CreditControlHelper.getCancelResult();
        } else {
            creditCondition.initCreditParam(ctx);
            result = this.verifyCreditCondition(ctx, creditCondition);
            if (result == null) {
                result = CreditQueryFacadeFactory.getLocalInstance(ctx).checkCredit(creditCondition);
            }
            if (!result.isOverspend() && !result.isTimeout()) {
                return result;
            }
            if (creditCondition.getBillType() != null && creditCondition.getBillType().equals((Object)CreditFormulaSceneEnum.CREDITFILE)) {
                CreditControlHelper.buildMsg(ctx, result, creditCondition, true);
            } else {
                CreditControlHelper.buildMsg(ctx, result, creditCondition, false);
            }
        }
        return result;
    }

    private CreditCtrlResult verifyCreditCondition(Context ctx, CreditCondition creditCondition) throws EASBizException, BOSException {
        if (creditCondition.getCreditParam() == null || !creditCondition.isRootControl() && !creditCondition.getCreditParam().isCompnayCredited()) {
            return CreditControlHelper.getPassResult();
        }
        if (creditCondition.getCreditControlScene() == -1) {
            throw new CreditControlException(CreditControlException.NULL_CREDITSCENE);
        }
        if (creditCondition.getBizCodeID() != null) {
            return null;
        }
        if (creditCondition.getCustomer() == null) {
            throw new CreditControlException(CreditControlException.NULL_CUSTOMER);
        }
        boolean isSupplier = SupplierInfo.getBosType().equals(creditCondition.getCustomer().getId().getType().toString());
        if (!isSupplier) {
            if (!creditCondition.getCustomer().isIsCredited()) {
                return CreditControlHelper.getPassResult();
            }
        } else {
            SupplierInfo supplier = new SupplierInfo();
            supplier.setId(creditCondition.getCustomer().getId());
            supplier = CreditUtils.readFullSupplierInfo(ctx, supplier);
            if (supplier.getBizAnalysisCode() != null && supplier.getBizAnalysisCode().getId() != null) {
                creditCondition.setBizCodeID(supplier.getBizAnalysisCode().getId().toString());
            }
            creditCondition.setCustomer(null);
        }
        if (creditCondition.getPaymentType() == null || creditCondition.getPaymentType().getId() == null) {
            throw new CreditControlException(CreditControlException.NULL_PAYMENTTYPE);
        }
        if (creditCondition.getPaymentType().getId().toString().equalsIgnoreCase("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5")) {
            return CreditControlHelper.getPassResult();
        }
        if (creditCondition.getCompany() == null || creditCondition.getCompany().getId() == null) {
            throw new CreditControlException(CreditControlException.NULL_COMPANY);
        }
        if (creditCondition.getCompany().getBaseCurrency() == null || creditCondition.getCompany().getBaseExchangeTable() == null) {
            throw new CreditControlException(CreditControlException.NULL_BASECURRENCYANDRAT);
        }
        return null;
    }

    private Map getNumericValue(Context ctx, Object billInfo, String companyID, ContrlTimeEnum contrlTime, boolean isDelete) throws EASBizException, BOSException {
        if (contrlTime.getValue() == 1 && !isDelete) {
            return this.getBillNumericAtSubmit(ctx, billInfo, companyID);
        }
        if (contrlTime.getValue() == 2 || isDelete) {
            return this.getBillNumericAtAudit(ctx, billInfo, companyID);
        }
        return null;
    }

    public CreditFormulaSceneEnum getBillType() {
        return null;
    }

    protected abstract boolean isControlCredit(Context var1, Object var2, CompanyOrgUnitInfo var3, CreditFormulaSceneEnum var4, ContrlTimeEnum var5) throws EASBizException, BOSException;

    protected abstract CreditCondition getCreditCondition(Context var1, Object var2, CompanyOrgUnitInfo var3, CreditFormulaSceneEnum var4) throws EASBizException, BOSException;

    protected abstract Map getBillNumericAtAudit(Context var1, Object var2, String var3) throws BOSException, EASBizException;

    protected abstract Map getBillNumericAtSubmit(Context var1, Object var2, String var3) throws BOSException, EASBizException;

    protected abstract CompanyOrgUnitInfo getCompany(Context var1, Object var2) throws EASBizException, BOSException;

    protected abstract Object readFullBillInfo(Context var1, String var2) throws EASBizException, BOSException;
}

