/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.credit.ControlMethodEnum;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditLimit;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionFactory;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class CreditControlHelper {
    public static void buildMsg(Context ctx, CreditCtrlResult result, CreditCondition cc, boolean isBatch) throws BOSException, EASBizException {
        String billName;
        String billNum = cc != null ? cc.getBillNumber() : null;
        String string = billName = cc != null ? cc.getBillName(ctx) : null;
        if (cc.getBillType() != null) {
            billName = cc.getBillType().getAlias();
        }
        int prec = 4;
        if (cc.getCompany().getBaseCurrency() != null) {
            prec = cc.getCompany().getBaseCurrency().getPrecision();
        }
        if (cc != null && cc.getBillNumber() == null) {
            cc.setBillNumber("");
        }
        CreditControlHelper.buildMsg(ctx, result, billNum, billName, prec, isBatch);
    }

    public static void buildMsg(Context ctx, CreditCtrlResult result, String billNum, String billName, int precision, boolean isBatch) throws BOSException, EASBizException {
        String body;
        String header;
        if (billNum == null) {
            billNum = "";
        }
        StringBuffer msgHeader = new StringBuffer();
        StringBuffer msgBody = new StringBuffer();
        if (result.isOverspend()) {
            header = null;
            if (isBatch) {
                header = CreditControlHelper.getResourceStr(ctx, "OVER_SPEND_HEAD_BATCH");
                if (result.getCustomerName() != null) {
                    header = header.replaceAll("CLIENT_NAME", result.getCustomerName());
                }
                if (result.getCompanyName() != null) {
                    header = header.replaceAll("COMPANY_NAME", result.getCompanyName());
                }
            } else {
                header = CreditControlHelper.getResourceStr(ctx, "OVER_SPEND_HEAD");
                if (billNum != null) {
                    header = header.replaceAll("NUM", billNum);
                }
                if (billName != null) {
                    header = header.replaceAll("NAME", billName);
                }
            }
            body = "";
            if (result.isBalanceRate()) {
                body = CreditControlHelper.getResourceStr(ctx, "OVER_SPEND_RATE_BALANCE");
                body = body.replaceAll("CREDITAMT", CreditControlHelper.formatNumber(ctx, precision, result.getCreditAmount()));
                body = body.replaceAll("USEDAMT", result.getOtherUsedCreditAmount().setScale(4, 4).toString());
                body = body.replaceAll("BALANCE_RATE ", result.getBalanceRate().setScale(4, 4).toString());
                body = body.replaceAll("RATED_BALANCE", result.getRatedBalance().setScale(4, 4).toString());
                body = body.replaceAll("BILLATM", result.getCurAmount().setScale(4, 4).toString());
                body = body.replaceAll("BALAMT", CreditControlHelper.formatNumber(ctx, precision, result.getCreditBalance()));
            } else {
                body = CreditControlHelper.getResourceStr(ctx, "OVER_SPEND_BODY");
                body = body.replaceAll("CREDITAMT", CreditControlHelper.formatNumber(ctx, precision, result.getCreditAmount()));
                body = body.replaceAll("USEDAMT", result.getOtherUsedCreditAmount().setScale(4, 4).toString());
                body = body.replaceAll("BILLATM", result.getCurAmount().setScale(4, 4).toString());
                body = body.replaceAll("BALAMT", CreditControlHelper.formatNumber(ctx, precision, result.getCreditBalance()));
            }
            msgHeader.append(header).append("\r\n");
            msgBody.append(header).append("\r\n").append(body).append("\r\n");
        }
        if (result.isTimeout()) {
            header = CreditControlHelper.getResourceStr(ctx, "OVER_TIME_HEAD");
            body = CreditControlHelper.getResourceStr(ctx, "OVER_TIME_BODY");
            if (header != null) {
                if (billNum != null) {
                    header = header.replaceAll("NUM", billNum);
                }
                if (billName != null) {
                    header = header.replaceAll("NAME", billName);
                }
            }
            if (body != null) {
                body = body.replaceAll("NUM", result.getArBillNum());
                body = body.replaceAll("ARDATE", CreditControlHelper.formatDate(ctx, result.getFirstArDate()));
                body = body.replaceAll("OVERDAY", String.valueOf(result.getOverDays()));
            }
            msgHeader.append(header);
            msgBody.append(header).append("\r\n").append(body);
        }
        result.setMsgHeader(msgHeader.toString());
        result.setMsgBody(msgBody.toString());
    }

    public static String formatNumber(CreditCondition cc, CreditLimit creditLimit) throws BOSException, EASBizException {
        return CreditControlHelper.formatNumber(null, cc, creditLimit);
    }

    public static String formatNumberMultiLang(Context ctx, BigDecimal number) throws EASBizException, BOSException {
        HashMap nationmap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ctx.getCaller().toString(), null, ctx.getLocale().toString());
        NumberFormat dtformat = (NumberFormat)nationmap.get("numberFormat");
        return dtformat.format(number);
    }

    public static String formatNumber(Context ctx, CreditCondition cc, CreditLimit creditLimit) throws BOSException, EASBizException {
        int prec = 4;
        if (cc.getCompany().getBaseCurrency() != null) {
            prec = cc.getCompany().getBaseCurrency().getPrecision();
        }
        return CreditControlHelper.formatNumber(ctx, prec, creditLimit);
    }

    public static String formatNumber(Context ctx, int precision, CreditLimit creditLimit) throws BOSException, EASBizException {
        if (creditLimit.isInfinity()) {
            return creditLimit.toString();
        }
        BigDecimal val = creditLimit.bigDecimalValue();
        String result = val.setScale(precision, 4).toString();
        return result;
    }

    public static String formatDate(Date date) {
        StringBuffer strDate = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        strDate.append(cal.get(1)).append("-").append(cal.get(2) + 1).append("-").append(cal.get(5));
        return strDate.toString();
    }

    public static String formatDate(Context ctx, Date date) throws EASBizException, BOSException {
        HashMap nationmap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ctx.getCaller().toString(), null, ctx.getLocale().toString());
        DateFormat dtformat = (DateFormat)nationmap.get("dateFormat");
        return dtformat.format(date);
    }

    public static String getResourceStr(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditResource", (String)key, (Locale)ctx.getLocale());
    }

    public static boolean isUseBizAnalyseCode(CreditParamInfo creditParam, CustomerInfo customer) {
        boolean isBizCode = false;
        if (creditParam != null && customer != null) {
            isBizCode = creditParam.isBizCode() && customer.getBizAnalysisCode() != null;
        }
        return isBizCode;
    }

    public static CreditCtrlResult getPassResult() {
        CreditCtrlResult passResult = new CreditCtrlResult();
        passResult.setCreditAmount(CreditLimit.INFINITY);
        passResult.setUsedCreditAmount(CreditLimit.ZERO);
        passResult.setCreditBalance(CreditLimit.INFINITY);
        passResult.setOverspend(false);
        return passResult;
    }

    public static CreditCtrlResult getCancelResult() {
        CreditCtrlResult cancelResult = new CreditCtrlResult();
        cancelResult.setCreditAmount(CreditLimit.ZERO);
        cancelResult.setUsedCreditAmount(CreditLimit.INFINITY);
        cancelResult.setCreditBalance(CreditLimit.ZERO);
        cancelResult.setOverspend(true);
        cancelResult.setCreditCtrlMode(ControlMethodEnum.AUDITING);
        return cancelResult;
    }

    public static PostRequisitionInfo readFullPostRequisitionInfo(Context ctx, String postBillId) throws EASBizException, BOSException {
        PostRequisitionInfo postBill = new PostRequisitionInfo();
        postBill.setId(BOSUuid.read((String)postBillId));
        return CreditControlHelper.readFullPostRequisitionInfo(ctx, postBill);
    }

    public static PostRequisitionInfo readFullPostRequisitionInfo(Context ctx, PostRequisitionInfo postBill) throws EASBizException, BOSException {
        if (!(postBill == null || postBill.getId() == null || postBill.containsKey("saleOrgUnit") && postBill.containsKey("baseStatus") && postBill.containsKey("paymentType") && postBill.containsKey("number") && postBill.containsKey("bizDate") && postBill.containsKey("entries"))) {
            postBill = PostRequisitionFactory.getLocalInstance((Context)ctx).getPostRequisitionInfo((IObjectPK)new ObjectStringPK(postBill.getId().toString()), CreditControlHelper.getPostRequisitionSelectors());
        }
        return postBill;
    }

    public static SelectorItemCollection getPostRequisitionSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("saleOrgUnit.id"));
        selector.add(new SelectorItemInfo("companyOrgUnit.id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        selector.add(new SelectorItemInfo("paymentType"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("entries.localAmount"));
        selector.add(new SelectorItemInfo("entries.deliveryCustomer.id"));
        return selector;
    }

    public static SaleOrderInfo readFullSaleOrderInfo(Context ctx, String saleOrderID) throws EASBizException, BOSException {
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setId(BOSUuid.read((String)saleOrderID));
        return CreditControlHelper.readFullSaleOrderInfo(ctx, saleOrderInfo);
    }

    public static SaleOrderInfo readFullSaleOrderInfo(Context ctx, SaleOrderInfo saleOrderInfo) throws EASBizException, BOSException {
        if (!(saleOrderInfo == null || saleOrderInfo.getId() == null || saleOrderInfo.containsKey("saleOrgUnit") && saleOrderInfo.containsKey("companyOrgUnit") && saleOrderInfo.containsKey("orderCustomer") && saleOrderInfo.containsKey("paymentType") && saleOrderInfo.containsKey("baseStatus") && saleOrderInfo.containsKey("number") && saleOrderInfo.containsKey("bizDate") && saleOrderInfo.containsKey("localTotalTaxAmount"))) {
            saleOrderInfo = SaleOrderFactory.getLocalInstance((Context)ctx).getSaleOrderInfo((IObjectPK)new ObjectStringPK(saleOrderInfo.getId().toString()), CreditControlHelper.getSaleOrderSelectors());
        }
        return saleOrderInfo;
    }

    public static SelectorItemCollection getSaleOrderSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("companyOrgUnit.id"));
        selector.add(new SelectorItemInfo("saleOrgUnit.id"));
        selector.add(new SelectorItemInfo("orderCustomer.id"));
        selector.add(new SelectorItemInfo("paymentType.id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("localTotalTaxAmount"));
        return selector;
    }

    public static SaleReturnsInfo readFullSaleReturnsInfo(Context ctx, String billID) throws EASBizException, BOSException {
        SaleReturnsInfo saleReturns = new SaleReturnsInfo();
        saleReturns.setId(BOSUuid.read((String)billID));
        return CreditControlHelper.readFullSaleReturnsInfo(ctx, saleReturns);
    }

    public static SaleReturnsInfo readFullSaleReturnsInfo(Context ctx, SaleReturnsInfo saleReturns) throws EASBizException, BOSException {
        SaleReturnsInfo sr = saleReturns;
        if (!(saleReturns == null || saleReturns.getId() == null || saleReturns.containsKey("saleOrgUnit") && saleReturns.containsKey("returnsCustomer") && saleReturns.containsKey("currency") && saleReturns.containsKey("exchangeRate") && saleReturns.containsKey("localTotalTaxAmount") && saleReturns.containsKey("baseStatus") && saleReturns.containsKey("entries") && saleReturns.containsKey("paymentType"))) {
            sr = SaleReturnsFactory.getLocalInstance((Context)ctx).getSaleReturnsInfo((IObjectPK)new ObjectStringPK(saleReturns.getId().toString()), CreditControlHelper.getSaleReturnsSelectors());
        }
        return sr;
    }

    public static SelectorItemCollection getSaleReturnsSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("bizDate"));
        selectors.add(new SelectorItemInfo("billType"));
        selectors.add(new SelectorItemInfo("saleOrgUnit.id"));
        selectors.add(new SelectorItemInfo("returnsCustomer.id"));
        selectors.add(new SelectorItemInfo("currency.id"));
        selectors.add(new SelectorItemInfo("exchangeRate"));
        selectors.add(new SelectorItemInfo("localTotalTaxAmount"));
        selectors.add(new SelectorItemInfo("baseStatus"));
        selectors.add(new SelectorItemInfo("companyOrgUnit.id"));
        selectors.add(new SelectorItemInfo("returnsCustomer.id"));
        selectors.add(new SelectorItemInfo("paymentType"));
        selectors.add(new SelectorItemInfo("entries.id"));
        selectors.add(new SelectorItemInfo("entries.receiveDispatcherType"));
        selectors.add(new SelectorItemInfo("entries.taxPrice"));
        selectors.add(new SelectorItemInfo("entries.qty"));
        selectors.add(new SelectorItemInfo("entries.returnsQty"));
        selectors.add(new SelectorItemInfo("entries.baseStatus"));
        selectors.add(new SelectorItemInfo("entries.localTaxAmount"));
        return selectors;
    }

    public static SaleIssueBillInfo readFullSaleIssueBillInfo(Context ctx, String saleIssueID) throws EASBizException, BOSException {
        SaleIssueBillInfo saleIssueBillInfo = new SaleIssueBillInfo();
        saleIssueBillInfo.setId(BOSUuid.read((String)saleIssueID));
        return CreditControlHelper.readFullSaleIssueBillInfo(ctx, saleIssueBillInfo);
    }

    public static SaleIssueBillInfo readFullSaleIssueBillInfo(Context ctx, SaleIssueBillInfo saleIssueBillInfo) throws EASBizException, BOSException {
        if (!(saleIssueBillInfo == null || saleIssueBillInfo.getId() == null || saleIssueBillInfo.containsKey("storageOrgUnit") && saleIssueBillInfo.containsKey("customer") && saleIssueBillInfo.containsKey("baseStatus") && saleIssueBillInfo.containsKey("paymentType") && saleIssueBillInfo.containsKey("number") && saleIssueBillInfo.containsKey("bizDate") && saleIssueBillInfo.containsKey("totalLocalAmount"))) {
            saleIssueBillInfo = SaleIssueBillFactory.getLocalInstance((Context)ctx).getSaleIssueBillInfo((IObjectPK)new ObjectStringPK(saleIssueBillInfo.getId().toString()), CreditControlHelper.getSaleIssueSelectors());
        }
        return saleIssueBillInfo;
    }

    public static SelectorItemCollection getSaleIssueSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("storageOrgUnit.id"));
        selector.add(new SelectorItemInfo("customer.id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        selector.add(new SelectorItemInfo("paymentType.id"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("totalLocalAmount"));
        selector.add(new SelectorItemInfo("transactionType.id"));
        selector.add(new SelectorItemInfo("transactionType.riType.id"));
        selector.add(new SelectorItemInfo("transactionType.riType.bizDirection"));
        selector.add(new SelectorItemInfo("entry.saleOrder"));
        return selector;
    }

    public static CoreBillBaseInfo readFullARBillInfo(Context ctx, String billID) throws EASBizException, BOSException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        if (CreditFormulaSceneEnum.ARBILL.equals((Object)CreditUtils.getBillTypeByBosType(billID))) {
            selectors = CreditControlHelper.getARSelectors();
        } else if (CreditFormulaSceneEnum.RECBILL.equals((Object)CreditUtils.getBillTypeByBosType(billID))) {
            selectors = CreditControlHelper.getRecBillSelectors();
        } else if (CreditFormulaSceneEnum.PROXYBILL.equals((Object)CreditUtils.getBillTypeByBosType(billID))) {
            selectors = CreditControlHelper.getProxyBillSelectors();
            CoreBillBaseInfo arBillInfo = (CoreBillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(billID), (SelectorItemCollection)selectors);
            return arBillInfo;
        }
        BillBaseInfo arBillInfo = (BillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(billID), (SelectorItemCollection)selectors);
        return arBillInfo;
    }

    public static BillBaseInfo readFullARBillInfo(Context ctx, BillBaseInfo arBillInfo) throws EASBizException, BOSException {
        if (!(arBillInfo == null || arBillInfo.getId() == null || arBillInfo.containsKey("company") && arBillInfo.containsKey("asstActID") && arBillInfo.containsKey("billStatus") && arBillInfo.containsKey("paymentType") && arBillInfo.containsKey("number") && arBillInfo.containsKey("bizDate") && arBillInfo.containsKey("amountLocal"))) {
            arBillInfo = (BillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(arBillInfo.getId()), (SelectorItemCollection)CreditControlHelper.getARSelectors());
        }
        return arBillInfo;
    }

    public static SelectorItemCollection getARSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("asstActID"));
        selector.add(new SelectorItemInfo("billStatus"));
        selector.add(new SelectorItemInfo("paymentType.id"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("amountLocal"));
        selector.add(new SelectorItemInfo("isBizBill"));
        return selector;
    }

    public static SelectorItemCollection getRecBillSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("payerID"));
        selector.add(new SelectorItemInfo("billStatus"));
        selector.add(new SelectorItemInfo("paymentType.id"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("localAmt"));
        return selector;
    }

    public static SelectorItemCollection getProxyBillSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("CompanyOrgUnit.id"));
        selector.add(new SelectorItemInfo("RecAsstActId"));
        selector.add(new SelectorItemInfo("billStatus"));
        selector.add(new SelectorItemInfo("paymentType.id"));
        selector.add(new SelectorItemInfo("billDate"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("RecAmountLocal"));
        return selector;
    }

    public static BillBaseInfo readFullApBillInfo(Context ctx, String billID) throws EASBizException, BOSException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        if (CreditFormulaSceneEnum.APBILL.equals((Object)CreditUtils.getBillTypeByBosType(billID))) {
            selectors = CreditControlHelper.getApSelectors();
        } else if (CreditFormulaSceneEnum.PAYBILL.equals((Object)CreditUtils.getBillTypeByBosType(billID))) {
            selectors = CreditControlHelper.getPayBillSelectors();
        }
        BillBaseInfo billInfo = (BillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(billID), (SelectorItemCollection)selectors);
        return billInfo;
    }

    public static BillBaseInfo readFullApBillInfo(Context ctx, BillBaseInfo apBillInfo) throws EASBizException, BOSException {
        if (!(apBillInfo == null || apBillInfo.getId() == null || apBillInfo.containsKey("company") && apBillInfo.containsKey("asstActID") && apBillInfo.containsKey("billStatus") && apBillInfo.containsKey("paymentType") && apBillInfo.containsKey("number") && apBillInfo.containsKey("bizDate") && apBillInfo.containsKey("amountLocal"))) {
            apBillInfo = (BillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(apBillInfo.getId()), (SelectorItemCollection)CreditControlHelper.getApSelectors());
        }
        return apBillInfo;
    }

    public static SelectorItemCollection getApSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("asstActID"));
        selector.add(new SelectorItemInfo("billStatus"));
        selector.add(new SelectorItemInfo("paymentType.id"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("amountLocal"));
        return selector;
    }

    public static SelectorItemCollection getPayBillSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("payeeID"));
        selector.add(new SelectorItemInfo("billStatus"));
        selector.add(new SelectorItemInfo("paymentType.id"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("localAmt"));
        return selector;
    }
}

