/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditFileFactory;
import com.kingdee.eas.scm.credit.CreditFileInfo;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.ICreditFile;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlBaseStrategy;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CreditFileAlterCreditControlStrategy
extends CreditControlBaseStrategy {
    @Override
    protected boolean isControlCredit(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene, ContrlTimeEnum contrlTime) throws EASBizException, BOSException {
        CreditParamInfo paramInfo;
        CreditFileInfo creditInfo = (CreditFileInfo)billInfo;
        if (creditInfo.getCreditFileType().getValue() == 1) {
            CreditParamInfo paramInfo2 = CreditServerUtil.getCreditParamInfo(ctx, companyInfo.getId().toString());
            if (paramInfo2 != null) {
                if (!paramInfo2.isCtrlByGroup()) {
                    if (companyInfo.isIsBizUnit() && paramInfo2.isCompnayCredited() && creditInfo.getCustomer().isIsCredited()) {
                        if (creditInfo.getCustomer().getBizAnalysisCode() != null && paramInfo2.isCustFirst()) {
                            return true;
                        }
                        if (creditInfo.getCustomer().getBizAnalysisCode() == null) {
                            return true;
                        }
                    }
                } else if (creditInfo.getCustomer().getCU() != null && companyInfo.getId().toString().equals(creditInfo.getCustomer().getCU().getId().toString()) && creditInfo.getCustomer().isIsCredited()) {
                    if (creditInfo.getCustomer().getBizAnalysisCode() != null && paramInfo2.isCustFirst()) {
                        return true;
                    }
                    if (creditInfo.getCustomer().getBizAnalysisCode() == null) {
                        return true;
                    }
                }
            }
        } else if (creditInfo.getCreditFileType().getValue() == 6 && (paramInfo = CreditServerUtil.getCreditParamInfo(ctx, companyInfo.getId().toString())) != null && (!paramInfo.isCtrlByGroup() && paramInfo.isCompnayCredited() || paramInfo.isCtrlByGroup() && !companyInfo.isIsBizUnit()) && paramInfo.isBizCode()) {
            return true;
        }
        return false;
    }

    @Override
    protected CreditCondition getCreditCondition(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene) throws EASBizException, BOSException {
        CreditFileInfo creditInfo = (CreditFileInfo)billInfo;
        CreditCondition creditCondition = new CreditCondition();
        if (creditInfo.getCreditFileType().getValue() == 1) {
            creditCondition.setCustomer(creditInfo.getCustomer());
        } else if (creditInfo.getCreditFileType().getValue() == 6) {
            creditCondition.setBizCodeID(creditInfo.getBizAnsCode().getId().toString());
        }
        creditCondition.setCompany(companyInfo);
        PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
        paymentTypeInfo.setId(BOSUuid.read((String)"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
        creditCondition.setPaymentType(paymentTypeInfo);
        creditCondition.setCreditControlScene(scene.getValue());
        creditCondition.setBillNumber(creditInfo.getNumber());
        creditCondition.setBillDate(new Date());
        return creditCondition;
    }

    @Override
    protected Map getBillNumericAtAudit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        CreditFileInfo creditInfo = (CreditFileInfo)billInfo;
        BigDecimal locTotalTaxAmt = creditInfo.getAmount();
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", locTotalTaxAmt);
        return billNumeric;
    }

    @Override
    protected Map getBillNumericAtSubmit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        CreditFileInfo creditInfo = (CreditFileInfo)billInfo;
        BigDecimal locTotalTaxAmt = creditInfo.getAmount();
        if (creditInfo.getId() != null && creditInfo.getId().toString().trim().length() != 0) {
            ObjectUuidPK billPK = new ObjectUuidPK(creditInfo.getId());
            ICreditFile iCreditFile = CreditFileFactory.getLocalInstance(ctx);
            if (iCreditFile.exists((IObjectPK)billPK)) {
                CreditFileInfo oldVersionBill = iCreditFile.getCreditFileInfo("select amount where id='" + billPK.toString() + "'");
                locTotalTaxAmt = creditInfo.getAmount().subtract(oldVersionBill.getAmount());
            }
        }
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", locTotalTaxAmt);
        return billNumeric;
    }

    @Override
    protected Object readFullBillInfo(Context ctx, String billID) throws EASBizException, BOSException {
        return CreditFileFactory.getLocalInstance(ctx).getCreditFileInfo("select *,customer.isCredited,customer.bizAnalysisCode,customer.cu,companyOrgUnit.isBizUnit where id='" + billID + "'");
    }

    @Override
    protected CompanyOrgUnitInfo getCompany(Context ctx, Object billInfo) throws EASBizException, BOSException {
        CreditFileInfo creditInfo = (CreditFileInfo)billInfo;
        return creditInfo.getCompanyOrgUnit();
    }

    @Override
    public CreditFormulaSceneEnum getBillType() {
        return CreditFormulaSceneEnum.CREDITFILE;
    }
}

