/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlBaseStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlHelper;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.sd.sale.IPostRequisition;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionFactory;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class PostRequisitionCreditControlStrategy
extends CreditControlBaseStrategy {
    @Override
    protected boolean isControlCredit(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene, ContrlTimeEnum contrlTime) throws EASBizException, BOSException {
        PostRequisitionInfo postBill = (PostRequisitionInfo)billInfo;
        if (postBill.getPaymentType() == null) {
            throw new CreditControlException(CreditControlException.NULL_PAYMENTTYPE);
        }
        String newPayId = postBill.getPaymentType().getId().toString();
        if (!newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
            return false;
        }
        String custId = null;
        PostRequisitionEntryInfo entry = null;
        CustomerInfo theCustInfo = new CustomerInfo();
        int size = postBill.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entry = postBill.getEntries().get(i);
            if (entry.getDeliveryCustomer() == null || entry.getDeliveryCustomer().getId() == null) {
                throw new CreditControlException(CreditControlException.DELIVERY_CUSTOMER_NULL);
            }
            if (custId != null && !custId.equals(entry.getDeliveryCustomer().getId().toString())) {
                theCustInfo.setId(BOSUuid.read((String)custId));
                if (!CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, theCustInfo, scene.getValue(), contrlTime.getValue()) && !CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, entry.getDeliveryCustomer(), scene.getValue(), contrlTime.getValue())) continue;
                throw new CreditControlException(CreditControlException.CANTSUBMIT_POSTBILL_CTRLBYCREDIT);
            }
            custId = entry.getDeliveryCustomer().getId().toString();
        }
        if (custId == null) {
            return false;
        }
        theCustInfo.setId(BOSUuid.read(custId));
        return CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, theCustInfo, scene.getValue(), contrlTime.getValue());
    }

    @Override
    protected CreditCondition getCreditCondition(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene) throws EASBizException, BOSException {
        PostRequisitionInfo postBill = (PostRequisitionInfo)billInfo;
        CreditCondition creditCondition = new CreditCondition();
        creditCondition.setCustomer(postBill.getEntries().get(0).getDeliveryCustomer());
        creditCondition.setCompany(companyInfo);
        creditCondition.setPaymentType(postBill.getPaymentType());
        creditCondition.setCreditControlScene(scene.getValue());
        creditCondition.setBillNumber(postBill.getNumber());
        creditCondition.setBillDate(postBill.getBizDate());
        return creditCondition;
    }

    @Override
    protected Map getBillNumericAtAudit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        BigDecimal locTotalAmt = CreditUtils.sumPostbillLocalAmount((PostRequisitionInfo)billInfo);
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", locTotalAmt);
        return billNumeric;
    }

    @Override
    protected Map getBillNumericAtSubmit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        BigDecimal locTotalAmt;
        PostRequisitionInfo postBill = (PostRequisitionInfo)billInfo;
        BigDecimal bizTotalAmt = locTotalAmt = CreditUtils.sumPostbillLocalAmount(postBill);
        if (postBill.getId() != null && postBill.getId().toString().trim().length() != 0) {
            PostRequisitionInfo oldVersionBill;
            ObjectUuidPK billPK = new ObjectUuidPK(postBill.getId());
            IPostRequisition iPostRequisition = PostRequisitionFactory.getLocalInstance((Context)ctx);
            if (iPostRequisition.exists((IObjectPK)billPK) && (oldVersionBill = iPostRequisition.getPostRequisitionInfo((IObjectPK)billPK, CreditControlHelper.getPostRequisitionSelectors())).getBaseStatus().getValue() != 0 && oldVersionBill.getBaseStatus().getValue() != 1) {
                String newCompanyId = postBill.getSaleOrgUnit().getId().toString();
                String oldCompanyId = oldVersionBill.getSaleOrgUnit().getId().toString();
                String oldCustId = oldVersionBill.getEntries().get(0).getDeliveryCustomer().getId().toString();
                String custId = postBill.getEntries().get(0).getDeliveryCustomer().getId().toString();
                if (custId.equalsIgnoreCase(oldCustId) && newCompanyId.equalsIgnoreCase(oldCompanyId)) {
                    BigDecimal oldLocTotalAmt = CreditUtils.sumPostbillLocalAmount(oldVersionBill);
                    bizTotalAmt = locTotalAmt = locTotalAmt.subtract(oldLocTotalAmt);
                } else {
                    String sql = "select fbizanalysiscodeid from t_bd_customer where fid in(?,?) group by fbizanalysiscodeid";
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{oldCustId, custId});
                    if (rowSet.size() < 2) {
                        BigDecimal oldLocTotalAmt = CreditUtils.sumPostbillLocalAmount(oldVersionBill);
                        bizTotalAmt = locTotalAmt.subtract(oldLocTotalAmt);
                    }
                }
            }
        }
        if (ctx.get((Object)"isServerCreditCheck") != null) {
            bizTotalAmt = locTotalAmt = postBill.getBigDecimal("postBillAmount");
        }
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", bizTotalAmt);
        return billNumeric;
    }

    @Override
    protected CompanyOrgUnitInfo getCompany(Context ctx, Object billInfo) throws EASBizException, BOSException {
        PostRequisitionInfo postBill = (PostRequisitionInfo)billInfo;
        return CreditOrgUnitUtils.readCompanyOrgUnitInfo(ctx, (OrgUnitInfo)postBill.getSaleOrgUnit());
    }

    @Override
    protected Object readFullBillInfo(Context ctx, String billID) throws EASBizException, BOSException {
        return CreditControlHelper.readFullPostRequisitionInfo(ctx, billID);
    }
}

