/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlBaseStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlHelper;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class ReceivableCreditControlStrategy
extends CreditControlBaseStrategy {
    @Override
    protected boolean isControlCredit(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene, ContrlTimeEnum contrlTime) throws EASBizException, BOSException {
        BillBaseInfo arBill = (BillBaseInfo)billInfo;
        String newCustId = arBill.getString("asstActID");
        if (newCustId == null || newCustId.trim().length() == 0) {
            return false;
        }
        boolean isCustomer = CustomerInfo.getBosType().equals(BOSUuid.read((String)newCustId).getType().toString());
        boolean isSupplier = SupplierInfo.getBosType().equals(BOSUuid.read((String)newCustId).getType().toString());
        if (!isCustomer && !isSupplier) {
            return false;
        }
        PaymentTypeInfo paymenttypeinfo = (PaymentTypeInfo)arBill.get("paymentType");
        if (paymenttypeinfo == null) {
            throw new CreditControlException(CreditControlException.NULL_PAYMENTTYPE);
        }
        String newPayId = paymenttypeinfo.getId().toString();
        if (!newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
            return false;
        }
        if (isCustomer) {
            CustomerInfo theCustInfo = new CustomerInfo();
            theCustInfo.setId(BOSUuid.read((String)newCustId));
            if (ctx.get((Object)"creditaction") != null && ctx.get((Object)"creditaction").equals(3)) {
                ctx.put((Object)"creditaction", null);
                return CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, theCustInfo, scene.getValue(), 3);
            }
            return CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, theCustInfo, scene.getValue(), contrlTime.getValue());
        }
        if (isSupplier) {
            SupplierInfo theSupplierInfo = new SupplierInfo();
            theSupplierInfo.setId(BOSUuid.read((String)newCustId));
            return CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, theSupplierInfo);
        }
        return false;
    }

    @Override
    protected CreditCondition getCreditCondition(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene) throws EASBizException, BOSException {
        BillBaseInfo arBill = (BillBaseInfo)billInfo;
        CreditCondition creditCondition = new CreditCondition();
        CustomerInfo customer = new CustomerInfo();
        customer.setId(BOSUuid.read((String)arBill.getString("asstActID")));
        creditCondition.setCustomer(customer);
        creditCondition.setCompany(companyInfo);
        creditCondition.setPaymentType((PaymentTypeInfo)arBill.get("paymentType"));
        creditCondition.setCreditControlScene(scene.getValue());
        creditCondition.setBillNumber(arBill.getNumber());
        creditCondition.setBillDate(arBill.getBizDate());
        return creditCondition;
    }

    @Override
    protected Map getBillNumericAtAudit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        BillBaseInfo arBill = (BillBaseInfo)billInfo;
        BigDecimal locTotalTaxAmt = arBill.getBigDecimal("amountLocal");
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", locTotalTaxAmt);
        return billNumeric;
    }

    @Override
    protected Map getBillNumericAtSubmit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        BigDecimal locTotalTaxAmt;
        BillBaseInfo arBill = (BillBaseInfo)billInfo;
        BigDecimal bizTotalAmt = locTotalTaxAmt = arBill.getBigDecimal("amountLocal");
        if (arBill.getId() != null && arBill.getId().toString().trim().length() != 0) {
            BillBaseInfo oldVersionBill;
            Method methodDelete;
            ObjectUuidPK billPK = new ObjectUuidPK(arBill.getId());
            IBizCtrl iBiz = BusinessProcessUtil.getLocBizInteface((Context)ctx, (BOSObjectType)new BOSObjectType("FC910EF3"));
            boolean exist = (Boolean)BusinessProcessUtil.invokeBizMethod((IBizCtrl)iBiz, (Method)(methodDelete = BusinessProcessUtil.getLocBizMethod((IBizCtrl)iBiz, (String)"exists", (Class[])new Class[]{IObjectPK.class})), (Object[])new Object[]{billPK});
            if (exist && (oldVersionBill = (BillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)billPK, (SelectorItemCollection)CreditControlHelper.getARSelectors())).getInt("billStatus") != 1) {
                PaymentTypeInfo oldpaymenttypeinfo = (PaymentTypeInfo)oldVersionBill.get("paymentType");
                String oldPayId = oldpaymenttypeinfo.getId().toString();
                String newPayId = ((PaymentTypeInfo)arBill.get("paymentType")).getId().toString();
                if (newPayId.equals(oldPayId) && newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                    String oldCompanyId = oldVersionBill.getCompany().getId().toString();
                    String oldCustId = oldVersionBill.getString("asstActID");
                    if (arBill.getString("asstActID").equalsIgnoreCase(oldCustId) && companyID.equalsIgnoreCase(oldCompanyId)) {
                        if (oldVersionBill instanceof OtherBillInfo) {
                            bizTotalAmt = ((OtherBillInfo)oldVersionBill).isIsBizBill() ? locTotalTaxAmt : (locTotalTaxAmt = locTotalTaxAmt.subtract(oldVersionBill.getBigDecimal("amountLocal")));
                        }
                    } else {
                        String sql = "select fbizanalysiscodeid from t_bd_customer where fid in(?,?) group by fbizanalysiscodeid";
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{oldCustId, arBill.getString("asstActID")});
                        if (rowSet.size() < 2 && oldVersionBill instanceof OtherBillInfo) {
                            bizTotalAmt = ((OtherBillInfo)oldVersionBill).isIsBizBill() ? locTotalTaxAmt : locTotalTaxAmt.subtract(oldVersionBill.getBigDecimal("amountLocal"));
                        }
                    }
                }
            }
        }
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", bizTotalAmt);
        return billNumeric;
    }

    @Override
    protected Object readFullBillInfo(Context ctx, String billID) throws EASBizException, BOSException {
        return CreditControlHelper.readFullARBillInfo(ctx, billID);
    }

    @Override
    protected CompanyOrgUnitInfo getCompany(Context ctx, Object billInfo) throws EASBizException, BOSException {
        BillBaseInfo arBill = (BillBaseInfo)billInfo;
        return arBill.getCompany();
    }
}

