/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlBaseStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlHelper;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SaleIssueCreditControlStrategy
extends CreditControlBaseStrategy {
    @Override
    protected boolean isControlCredit(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene, ContrlTimeEnum contrlTime) throws EASBizException, BOSException {
        SaleIssueBillInfo issueBillInfo = (SaleIssueBillInfo)billInfo;
        PaymentTypeInfo newPay = issueBillInfo.getPaymentType();
        if (newPay == null || !newPay.getId().toString().equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
            return false;
        }
        if (ctx.get((Object)"creditaction") != null && ctx.get((Object)"creditaction").equals(3)) {
            ctx.put((Object)"creditaction", null);
            return CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, issueBillInfo.getCustomer(), scene.getValue(), 3);
        }
        return CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, issueBillInfo.getCustomer(), scene.getValue(), contrlTime.getValue());
    }

    @Override
    protected CreditCondition getCreditCondition(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene) throws EASBizException, BOSException {
        SaleIssueBillInfo issueBillInfo = (SaleIssueBillInfo)billInfo;
        CreditCondition creditCondition = new CreditCondition();
        creditCondition.setCustomer(issueBillInfo.getCustomer());
        creditCondition.setCompany(companyInfo);
        creditCondition.setPaymentType(issueBillInfo.getPaymentType());
        creditCondition.setCreditControlScene(scene.getValue());
        creditCondition.setBillNumber(issueBillInfo.getNumber());
        creditCondition.setBillDate(issueBillInfo.getBizDate());
        return creditCondition;
    }

    @Override
    protected Map getBillNumericAtAudit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        SaleIssueBillInfo issueBillInfo = (SaleIssueBillInfo)billInfo;
        BigDecimal locTotalTaxAmt = issueBillInfo.getTotalLocalAmount();
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", locTotalTaxAmt);
        return billNumeric;
    }

    @Override
    protected Map getBillNumericAtSubmit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        BigDecimal locTotalTaxAmt;
        SaleIssueBillInfo issueBillInfo = (SaleIssueBillInfo)billInfo;
        BigDecimal bizTotalAmt = locTotalTaxAmt = issueBillInfo.getTotalLocalAmount();
        if (issueBillInfo.getId() != null && issueBillInfo.getId().toString().trim().length() != 0) {
            SaleIssueBillInfo oldVersionBill;
            ObjectUuidPK billPK = new ObjectUuidPK(issueBillInfo.getId());
            ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance((Context)ctx);
            if (iSaleIssueBill.exists((IObjectPK)billPK) && (oldVersionBill = iSaleIssueBill.getSaleIssueBillInfo((IObjectPK)billPK, CreditControlHelper.getSaleIssueSelectors())).getBaseStatus().getValue() != 0 && oldVersionBill.getBaseStatus().getValue() != 1) {
                String oldPayId = oldVersionBill.getPaymentType().getId().toString();
                String newPayId = issueBillInfo.getPaymentType().getId().toString();
                if (newPayId.equals(oldPayId) && newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                    String oldOrgID;
                    String oldCustID = oldVersionBill.getCustomer() != null ? oldVersionBill.getCustomer().getId().toString() : "";
                    String string = oldOrgID = oldVersionBill.getStorageOrgUnit() != null ? oldVersionBill.getStorageOrgUnit().getId().toString() : "";
                    if (issueBillInfo.getCustomer().getId().toString().equalsIgnoreCase(oldCustID) && issueBillInfo.getStorageOrgUnit().getId().toString().equalsIgnoreCase(oldOrgID)) {
                        bizTotalAmt = locTotalTaxAmt = issueBillInfo.getTotalLocalAmount().subtract(oldVersionBill.getTotalLocalAmount());
                    } else {
                        String sql = "select fbizanalysiscodeid from t_bd_customer where fid in(?,?) group by fbizanalysiscodeid";
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{oldCustID, issueBillInfo.getCustomer().getId().toString()});
                        if (rowSet.size() < 2) {
                            bizTotalAmt = issueBillInfo.getTotalLocalAmount().subtract(oldVersionBill.getTotalLocalAmount());
                        }
                    }
                }
            }
        }
        if (ctx.get((Object)"isServerCreditCheck") != null) {
            bizTotalAmt = locTotalTaxAmt = issueBillInfo.getBigDecimal("issueBillAmount");
        }
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", bizTotalAmt);
        return billNumeric;
    }

    @Override
    protected CompanyOrgUnitInfo getCompany(Context ctx, Object billInfo) throws EASBizException, BOSException {
        ICompanyOrgUnit iCompanyOrgUnit;
        String companyID;
        IRowSet rowSet;
        SaleIssueBillInfo issueBillInfo = (SaleIssueBillInfo)billInfo;
        StringBuffer sql = new StringBuffer();
        SaleIssueEntryCollection issueBillEntryColl = issueBillInfo.getEntry();
        SaleIssueEntryInfo info = issueBillEntryColl.get(0);
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (info != null) {
            sql.append("select fcompanyorgunitid from t_sd_saleorder  where fid='").append(info.getSaleOrder()).append("' and FIsCentralBalance=1");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rowSet.next()) {
                    companyID = rowSet.getString("fcompanyorgunitid");
                    iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    companyOrgUnitInfo = (CompanyOrgUnitInfo)iCompanyOrgUnit.getValue((IObjectPK)new ObjectUuidPK(companyID));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        sql.setLength(0);
        if (info != null) {
            sql.append("select fcompanyorgunitid from T_SD_SaleReturns  where fid='").append(info.getSaleOrder()).append("' and FIsCentralBalance=1");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rowSet.next()) {
                    companyID = rowSet.getString("fcompanyorgunitid");
                    iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    companyOrgUnitInfo = (CompanyOrgUnitInfo)iCompanyOrgUnit.getValue((IObjectPK)new ObjectUuidPK(companyID));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        if (companyOrgUnitInfo != null) {
            return companyOrgUnitInfo;
        }
        return CreditOrgUnitUtils.readCompanyOrgUnitInfo(ctx, (OrgUnitInfo)issueBillInfo.getStorageOrgUnit());
    }

    @Override
    protected Object readFullBillInfo(Context ctx, String billID) throws EASBizException, BOSException {
        return CreditControlHelper.readFullSaleIssueBillInfo(ctx, billID);
    }
}

