/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlBaseStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlHelper;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SaleOrderCreditControlStrategy
extends CreditControlBaseStrategy {
    @Override
    protected boolean isControlCredit(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene, ContrlTimeEnum contrlTime) throws EASBizException, BOSException {
        SaleOrderInfo saleOrderInfo = (SaleOrderInfo)billInfo;
        if (saleOrderInfo.getPaymentType() == null) {
            throw new CreditControlException(CreditControlException.NULL_PAYMENTTYPE);
        }
        String newPayId = saleOrderInfo.getPaymentType().getId().toString();
        if (!newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
            return false;
        }
        return CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, saleOrderInfo.getOrderCustomer(), scene.getValue(), contrlTime.getValue());
    }

    @Override
    protected CreditCondition getCreditCondition(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene) throws EASBizException, BOSException {
        SaleOrderInfo saleOrderInfo = (SaleOrderInfo)billInfo;
        CreditCondition creditCondition = new CreditCondition();
        creditCondition.setCustomer(saleOrderInfo.getOrderCustomer());
        creditCondition.setCompany(companyInfo);
        creditCondition.setPaymentType(saleOrderInfo.getPaymentType());
        creditCondition.setCreditControlScene(scene.getValue());
        creditCondition.setBillNumber(saleOrderInfo.getNumber());
        creditCondition.setBillDate(saleOrderInfo.getBizDate());
        return creditCondition;
    }

    @Override
    protected Map getBillNumericAtAudit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        BigDecimal locTotalTaxAmt;
        SaleOrderInfo saleOrderInfo = (SaleOrderInfo)billInfo;
        ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK billPK = new ObjectUuidPK(saleOrderInfo.getId());
        saleOrderInfo = iSaleOrder.getSaleOrderInfo((IObjectPK)billPK);
        BigDecimal bizTotalAmt = locTotalTaxAmt = saleOrderInfo.getLocalTotalTaxAmount();
        if (saleOrderInfo.getId() != null && saleOrderInfo.getId().toString().trim().length() != 0) {
            IRowSet checkSet;
            block6: {
                int version = 1;
                version = saleOrderInfo.getVersion();
                checkSet = null;
                try {
                    String checkSql = "select FID from T_SD_SaleOrder where FOldID='" + saleOrderInfo.getId().toString() + "' and FVersion=" + Integer.toString(version - 1);
                    checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                    if (!checkSet.next() || checkSet.getString(1) == null) break block6;
                    SaleOrderInfo oldVersionBill = iSaleOrder.getSaleOrderInfo((IObjectPK)new ObjectUuidPK(checkSet.getString(1)));
                    String oldPayId = oldVersionBill.getPaymentType().getId().toString();
                    String newPayId = saleOrderInfo.getPaymentType().getId().toString();
                    if (!newPayId.equals(oldPayId) || !newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) break block6;
                    if (saleOrderInfo.getOrderCustomer().getId().toString().equalsIgnoreCase(oldVersionBill.getOrderCustomer().getId().toString()) && companyID.equalsIgnoreCase(oldVersionBill.getCompanyOrgUnit().getId().toString())) {
                        bizTotalAmt = locTotalTaxAmt = saleOrderInfo.getLocalTotalTaxAmount().subtract(oldVersionBill.getLocalTotalTaxAmount());
                        break block6;
                    }
                    String sql = "select fbizanalysiscodeid from t_bd_customer where fid in(?,?) group by fbizanalysiscodeid";
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{saleOrderInfo.getOrderCustomer().getId().toString(), oldVersionBill.getOrderCustomer().getId().toString()});
                    if (rowSet.size() >= 2) break block6;
                    bizTotalAmt = saleOrderInfo.getLocalTotalTaxAmount().subtract(oldVersionBill.getLocalTotalTaxAmount());
                }
                catch (SQLException er) {
                    try {
                        throw new BOSException("sql Execute Error :", (Throwable)er);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(checkSet);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)checkSet);
        }
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", bizTotalAmt);
        return billNumeric;
    }

    @Override
    protected Map getBillNumericAtSubmit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        BigDecimal locTotalTaxAmt;
        SaleOrderInfo saleOrderInfo = (SaleOrderInfo)billInfo;
        BigDecimal bizTotalAmt = locTotalTaxAmt = saleOrderInfo.getLocalTotalTaxAmount();
        if (saleOrderInfo.getId() != null && saleOrderInfo.getId().toString().trim().length() != 0) {
            SaleOrderInfo oldVersionBill;
            ObjectUuidPK billPK = new ObjectUuidPK(saleOrderInfo.getId());
            ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)ctx);
            if (iSaleOrder.exists((IObjectPK)billPK) && (oldVersionBill = iSaleOrder.getSaleOrderInfo((IObjectPK)billPK, CreditControlHelper.getSaleOrderSelectors())).getBaseStatus().getValue() != 0 && oldVersionBill.getBaseStatus().getValue() != 1) {
                String oldPayId = oldVersionBill.getPaymentType().getId().toString();
                String newPayId = saleOrderInfo.getPaymentType().getId().toString();
                if (newPayId.equals(oldPayId) && newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                    if (saleOrderInfo.getOrderCustomer().getId().toString().equalsIgnoreCase(oldVersionBill.getOrderCustomer().getId().toString()) && companyID.equalsIgnoreCase(oldVersionBill.getCompanyOrgUnit().getId().toString())) {
                        bizTotalAmt = locTotalTaxAmt = saleOrderInfo.getLocalTotalTaxAmount().subtract(oldVersionBill.getLocalTotalTaxAmount());
                    } else {
                        String sql = "select fbizanalysiscodeid from t_bd_customer where fid in(?,?) group by fbizanalysiscodeid";
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{saleOrderInfo.getOrderCustomer().getId().toString(), oldVersionBill.getOrderCustomer().getId().toString()});
                        if (rowSet.size() < 2) {
                            bizTotalAmt = saleOrderInfo.getLocalTotalTaxAmount().subtract(oldVersionBill.getLocalTotalTaxAmount());
                        }
                    }
                }
            }
        }
        if (ctx.get((Object)"isServerCreditCheck") != null) {
            bizTotalAmt = locTotalTaxAmt = saleOrderInfo.getBigDecimal("soBillAmount");
        }
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", bizTotalAmt);
        return billNumeric;
    }

    @Override
    protected CompanyOrgUnitInfo getCompany(Context ctx, Object billInfo) throws EASBizException, BOSException {
        SaleOrderInfo saleOrderInfo = (SaleOrderInfo)billInfo;
        return saleOrderInfo.getCompanyOrgUnit();
    }

    @Override
    protected Object readFullBillInfo(Context ctx, String billID) throws EASBizException, BOSException {
        return CreditControlHelper.readFullSaleOrderInfo(ctx, billID);
    }
}

