/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlBaseStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlHelper;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.sd.sale.ISaleReturns;
import com.kingdee.eas.scm.sd.sale.ReceiveDispatcherTypeEnum;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class SaleReturnsCreditControlStrategy
extends CreditControlBaseStrategy {
    @Override
    protected boolean isControlCredit(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene, ContrlTimeEnum contrlTime) throws EASBizException, BOSException {
        SaleReturnsInfo saleReturnsInfo = (SaleReturnsInfo)billInfo;
        if (saleReturnsInfo.getPaymentType() == null) {
            throw new CreditControlException(CreditControlException.NULL_PAYMENTTYPE);
        }
        String newPayId = saleReturnsInfo.getPaymentType().getId().toString();
        if (!newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
            return false;
        }
        if (ctx.get((Object)"creditaction") != null && ctx.get((Object)"creditaction").equals(3)) {
            ctx.put((Object)"creditaction", null);
            return CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, saleReturnsInfo.getOrderCustomer() == null ? saleReturnsInfo.getReturnsCustomer() : saleReturnsInfo.getOrderCustomer(), scene.getValue(), 3);
        }
        return CreditUtils.isRequireVerifyCredit(ctx, (OrgUnitInfo)companyInfo, saleReturnsInfo.getOrderCustomer() == null ? saleReturnsInfo.getReturnsCustomer() : saleReturnsInfo.getOrderCustomer(), scene.getValue(), contrlTime.getValue());
    }

    @Override
    protected CreditCondition getCreditCondition(Context ctx, Object billInfo, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum scene) throws EASBizException, BOSException {
        SaleReturnsInfo saleReturnsInfo = (SaleReturnsInfo)billInfo;
        CreditCondition creditCondition = new CreditCondition();
        creditCondition.setCustomer(saleReturnsInfo.getOrderCustomer() == null ? saleReturnsInfo.getReturnsCustomer() : saleReturnsInfo.getOrderCustomer());
        creditCondition.setCompany(companyInfo);
        creditCondition.setPaymentType(saleReturnsInfo.getPaymentType());
        creditCondition.setCreditControlScene(scene.getValue());
        creditCondition.setBillNumber(saleReturnsInfo.getNumber());
        creditCondition.setBillDate(saleReturnsInfo.getBizDate());
        return creditCondition;
    }

    @Override
    protected Map getBillNumericAtAudit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        SaleReturnsInfo saleReturnsInfo = (SaleReturnsInfo)billInfo;
        BigDecimal locTotalTaxAmt = this.getTotalLocalTaxAmount(saleReturnsInfo);
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", locTotalTaxAmt);
        return billNumeric;
    }

    @Override
    protected Map getBillNumericAtSubmit(Context ctx, Object billInfo, String companyID) throws BOSException, EASBizException {
        BigDecimal locTotalTaxAmt;
        SaleReturnsInfo saleReturnsInfo = (SaleReturnsInfo)billInfo;
        BigDecimal bizTotalAmt = locTotalTaxAmt = this.getTotalLocalTaxAmount(saleReturnsInfo);
        if (saleReturnsInfo.getId() != null && saleReturnsInfo.getId().toString().trim().length() != 0) {
            SaleReturnsInfo oldVersionBill;
            ObjectUuidPK billPK = new ObjectUuidPK(saleReturnsInfo.getId());
            ISaleReturns iSaleReturns = SaleReturnsFactory.getLocalInstance((Context)ctx);
            if (iSaleReturns.exists((IObjectPK)billPK) && (oldVersionBill = iSaleReturns.getSaleReturnsInfo((IObjectPK)billPK, CreditControlHelper.getSaleReturnsSelectors())).getBaseStatus().getValue() != 0 && oldVersionBill.getBaseStatus().getValue() != 1) {
                String oldPayId = oldVersionBill.getPaymentType().getId().toString();
                String newPayId = saleReturnsInfo.getPaymentType().getId().toString();
                if (newPayId.equals(oldPayId) && newPayId.equals("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5")) {
                    if (saleReturnsInfo.getReturnsCustomer().getId().toString().equalsIgnoreCase(oldVersionBill.getReturnsCustomer().getId().toString()) && companyID.equalsIgnoreCase(oldVersionBill.getCompanyOrgUnit().getId().toString())) {
                        bizTotalAmt = locTotalTaxAmt = locTotalTaxAmt.subtract(this.getTotalLocalTaxAmount(oldVersionBill));
                    } else {
                        String sql = "select fbizanalysiscodeid from t_bd_customer where fid in(?,?) group by fbizanalysiscodeid";
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{saleReturnsInfo.getOrderCustomer().getId().toString(), oldVersionBill.getOrderCustomer().getId().toString()});
                        if (rowSet.size() < 2) {
                            bizTotalAmt = locTotalTaxAmt.subtract(this.getTotalLocalTaxAmount(oldVersionBill));
                        }
                    }
                }
            }
        }
        if (ctx.get((Object)"isServerCreditCheck") != null) {
            bizTotalAmt = locTotalTaxAmt = saleReturnsInfo.getBigDecimal("srBillAmount");
        }
        HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
        billNumeric.put("BILL_NUMERIC_AMOUNT", locTotalTaxAmt);
        billNumeric.put("BILL_NUMERIC_AMOUNT_BIZCODE", bizTotalAmt);
        return billNumeric;
    }

    private BigDecimal getTotalLocalTaxAmount(SaleReturnsInfo srInfo) {
        BigDecimal totalLocalTaxAmount = SysConstant.BIGZERO;
        if (srInfo != null && srInfo.getEntries() != null) {
            SaleReturnsEntryCollection srEntryCollection = srInfo.getEntries();
            int n = srEntryCollection.size();
            for (int i = 0; i < n; ++i) {
                SaleReturnsEntryInfo srEntryInfo = srEntryCollection.get(i);
                ReceiveDispatcherTypeEnum receiveDispatcherType = srEntryInfo.getReceiveDispatcherType();
                BigDecimal localTaxAmount = SCMUtils.effectualNumeric((BigDecimal)srEntryInfo.getLocalTaxAmount());
                if (receiveDispatcherType != null && receiveDispatcherType.getValue() != 2) {
                    localTaxAmount = localTaxAmount.negate();
                }
                totalLocalTaxAmount = totalLocalTaxAmount.add(localTaxAmount);
            }
        }
        return totalLocalTaxAmount;
    }

    @Override
    protected CompanyOrgUnitInfo getCompany(Context ctx, Object billInfo) throws EASBizException, BOSException {
        SaleReturnsInfo saleReturnsInfo = (SaleReturnsInfo)billInfo;
        return saleReturnsInfo.getCompanyOrgUnit();
    }

    @Override
    protected Object readFullBillInfo(Context ctx, String billID) throws EASBizException, BOSException {
        return CreditControlHelper.readFullSaleReturnsInfo(ctx, billID);
    }
}

