/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.app.balance.sql.CreateCreditBalanceSQLStringForNetOrder;
import com.kingdee.eas.scm.credit.app.balance.sql.CreateCreditBalanceSQLStringForPostReq;
import com.kingdee.eas.scm.credit.app.balance.sql.CreateCreditBalanceSQLStringForSaleIssue;
import com.kingdee.eas.scm.credit.app.balance.sql.CreateCreditBalanceSQLStringForSaleOrder;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class CreateCreditBalanceSQLString {
    private Context ctx;
    private final String sp = " \r\n";
    public static final String CREDITBALANCE_BOSTYPE = "12D4D072";
    private String tempTable = null;
    private static Logger logger = Logger.getLogger(CreateCreditBalanceSQLString.class);

    public CreateCreditBalanceSQLString(Context ctx) {
        this.ctx = ctx;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createCredit(String companyIdString, String customerIdString, List params) throws BOSException, EASBizException {
        Connection conn;
        block7: {
            this.createTempTable();
            if (this.tempTable == null) {
                return;
            }
            conn = null;
            try {
                this.insertTempTableData(companyIdString, customerIdString, params);
                conn = EJBFactory.getConnection((Context)this.ctx);
                StringBuffer initSQL = new StringBuffer();
                initSQL.append("Insert Into T_SD_CreditBalance(FID,FCompanyID,FCustomerID,FUnOutSaleOrderBillAmt,");
                initSQL.append("FUnAuditIssuedAmt,FUnArBillIssuedAmt,FUnAuditSOAmt,");
                initSQL.append("FUnArBillOrderAmt,FUnAuditPostBillAmt,FUnOutPostBillAmt,FCreditAccountID) ");
                initSQL.append(" \r\n");
                initSQL.append("Select NEWBOSID('").append(CREDITBALANCE_BOSTYPE).append("'),FCompanyID,FCustomerID,sum(FUnOutSaleOrderBillAmt),");
                initSQL.append("Sum(FUnAuditIssuedAmt),Sum(FUnArBillIssuedAmt),Sum(FUnAuditSOAmt),");
                initSQL.append("Sum(FUnArBillOrderAmt),Sum(FUnAuditPostBillAmt),Sum(FUnOutPostBillAmt),'DawAAAAPiJDuN4KI' ");
                initSQL.append(" From ").append(this.tempTable);
                initSQL.append(" GROUP BY FCompanyID,FCustomerID");
                DbUtil.execute((Context)this.ctx, (String)initSQL.toString());
                if (this.tempTable == null || this.tempTable.length() == 0) break block7;
            }
            catch (BOSException bosExp) {
                try {
                    logger.error((Object)bosExp.getMessage());
                    throw new CreditControlException(CreditControlException.INIT_ERROR);
                    catch (SQLException e) {
                        logger.error((Object)e.getMessage());
                        throw new CreditControlException(CreditControlException.INIT_ERROR);
                    }
                }
                catch (Throwable throwable) {
                    if (this.tempTable != null && this.tempTable.length() != 0) {
                        TempTablePool.getInstance((Context)this.ctx).releaseTable(this.tempTable);
                    }
                    SQLUtils.cleanup(conn);
                    throw throwable;
                }
            }
            TempTablePool.getInstance((Context)this.ctx).releaseTable(this.tempTable);
        }
        SQLUtils.cleanup((Connection)conn);
    }

    private void createTempTable() throws CreditControlException {
        StringBuffer createTableSQL = new StringBuffer();
        createTableSQL.append("Create Table credit_temp_").append(System.currentTimeMillis());
        createTableSQL.append(" \r\n");
        createTableSQL.append(" (FCompanyID VARCHAR(44),FCustomerID VARCHAR(44),FUnOutSaleOrderBillAmt DECIMAL(19,4),");
        createTableSQL.append(" \r\n");
        createTableSQL.append("FUnAuditIssuedAmt DECIMAL(19,4),FUnArBillIssuedAmt DECIMAL(19,4),FUnAuditSOAmt DECIMAL(19,4),");
        createTableSQL.append(" \r\n");
        createTableSQL.append("FUnArBillOrderAmt DECIMAL(19,4),FUnAuditPostBillAmt DECIMAL(19,4),FUnOutPostBillAmt DECIMAL(19,4)) ");
        try {
            this.tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(createTableSQL.toString());
            TempTablePool.getInstance((Context)this.ctx).createIndex(this.tempTable, "FCompanyID, FCustomerID", false, false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new CreditControlException(CreditControlException.INIT_ERROR);
        }
    }

    private void insertTempTableData(String companyIdString, String customerIdString, List params) throws EASBizException, BOSException {
        CreditParamInfo paramInfo = CreditServerUtil.getCreditParamInfo(this.ctx, companyIdString);
        if (paramInfo == null) {
            return;
        }
        if (!(paramInfo.isCtrlSaleOrderAmount() || paramInfo.isCtrlIssuedAmount() || paramInfo.isCtrlPostbillAmount())) {
            return;
        }
        if (paramInfo.isCtrlSaleOrderAmount()) {
            CreateCreditBalanceSQLStringForSaleOrder orderSqlCreater = new CreateCreditBalanceSQLStringForSaleOrder(this.ctx);
            orderSqlCreater.insertDetailData(this.tempTable, companyIdString, customerIdString, paramInfo, params);
            if (paramInfo.getSO_CtrlTime() == 1) {
                CreateCreditBalanceSQLStringForNetOrder netOrderSqlCreater = new CreateCreditBalanceSQLStringForNetOrder(this.ctx);
                netOrderSqlCreater.insertDetailData(this.tempTable, companyIdString, customerIdString, paramInfo, params);
            }
        }
        if (paramInfo.isCtrlIssuedAmount() || paramInfo.isCtrlPostbillAmount()) {
            CreateCreditBalanceSQLStringForSaleIssue issueSqlCreater = new CreateCreditBalanceSQLStringForSaleIssue(this.ctx);
            issueSqlCreater.insertDetailData(this.tempTable, companyIdString, customerIdString, paramInfo, params);
        }
        if (paramInfo.isCtrlPostbillAmount()) {
            CreateCreditBalanceSQLStringForPostReq postReqSqlCreater = new CreateCreditBalanceSQLStringForPostReq(this.ctx);
            postReqSqlCreater.insertDetailData(this.tempTable, companyIdString, customerIdString, paramInfo, params);
        }
    }
}

