/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditDirectionEnum;
import com.kingdee.eas.scm.credit.CreditExceptionRptFacadeFactory;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.CreditQueryFacadeFactory;
import com.kingdee.eas.scm.credit.ICreditQueryFacade;
import com.kingdee.eas.scm.credit.app.CreditCheck;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlHelper;
import com.kingdee.eas.scm.credit.util.BillControlStrategy;
import com.kingdee.eas.scm.credit.util.ControlStategyFacotry;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionFactory;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public abstract class CreditUpdateBaseStrategy {
    protected Context _ctx = null;
    protected Map _param = null;
    protected String sp = " \r\n";
    protected String dataTempTable = null;
    protected String balanceTempTable = null;
    protected CreditOperationEnum operation = CreditOperationEnum.NULL;
    protected String bosType = null;
    protected boolean arBillCtrl = false;

    public CreditUpdateBaseStrategy(Context ctx, Map param) {
        this._ctx = ctx;
        this._param = param;
        this.operation = (CreditOperationEnum)((Object)this._param.get("bizAction"));
        this.dataTempTable = this._param.get("tableName").toString();
        this.arBillCtrl = this._param.get("arBillCtrl") != null ? (Boolean)this._param.get("arBillCtrl") : false;
        this.bosType = this._param.get("bosType").toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateBalance() throws BOSException, EASBizException {
        IRowSet rs = null;
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement psUpdate = null;
        PreparedStatement psInsert = null;
        int preUpdate = 0;
        int preInsert = 0;
        try {
            conn = EJBFactory.getConnection((Context)this._ctx);
            stmt = conn.createStatement();
            String update_sql = this.getUpdateCreditBalanceSql();
            psUpdate = conn.prepareStatement(update_sql);
            String insert_sql = this.getInsertCreditBalanceSql();
            psInsert = conn.prepareStatement(insert_sql);
            this.deleteUnNeedUpdateData();
            String sqlStr = this.getSelectCreditBalanceSql();
            rs = DbUtil.executeQuery((Context)this._ctx, (String)sqlStr);
            while (rs.next()) {
                if (rs.getString("FID") != null) {
                    psUpdate.setBigDecimal(1, rs.getBigDecimal("FUnOutSaleOrderBillAmt"));
                    psUpdate.setBigDecimal(2, rs.getBigDecimal("FUnAuditIssuedAmt"));
                    psUpdate.setBigDecimal(3, rs.getBigDecimal("FUnArBillIssuedAmt"));
                    psUpdate.setBigDecimal(4, rs.getBigDecimal("FUnAuditSOAmt"));
                    psUpdate.setBigDecimal(5, rs.getBigDecimal("FUnArBillOrderAmt"));
                    psUpdate.setBigDecimal(6, rs.getBigDecimal("FUnAuditPostBillAmt"));
                    psUpdate.setBigDecimal(7, rs.getBigDecimal("FUnOutPostBillAmt"));
                    psUpdate.setString(8, rs.getString("FID"));
                    psUpdate.addBatch();
                    ++preUpdate;
                    continue;
                }
                psInsert.setString(1, rs.getString("NewFID"));
                psInsert.setString(2, rs.getString("FCompanyID"));
                psInsert.setString(3, rs.getString("FCustomerID"));
                psInsert.setString(4, rs.getString("FCreditAccountID"));
                psInsert.setBigDecimal(5, rs.getBigDecimal("FUnOutSaleOrderBillAmt"));
                psInsert.setBigDecimal(6, rs.getBigDecimal("FUnAuditIssuedAmt"));
                psInsert.setBigDecimal(7, rs.getBigDecimal("FUnArBillIssuedAmt"));
                psInsert.setBigDecimal(8, rs.getBigDecimal("FUnAuditSOAmt"));
                psInsert.setBigDecimal(9, rs.getBigDecimal("FUnArBillOrderAmt"));
                psInsert.setBigDecimal(10, rs.getBigDecimal("FUnAuditPostBillAmt"));
                psInsert.setBigDecimal(11, rs.getBigDecimal("FUnOutPostBillAmt"));
                psInsert.addBatch();
                ++preInsert;
            }
            if (preUpdate > 0) {
                psUpdate.executeBatch();
            }
            if (preInsert > 0) {
                psInsert.executeBatch();
            }
            this.checkCreditBalance();
            if (this.isStartCreditLog()) {
                DbUtil.execute((Context)this._ctx, (String)this.getInsertCreditLogSql());
            }
        }
        catch (SQLException e) {
            try {
                if (!(e instanceof BatchUpdateException)) throw new BOSException((Throwable)e);
                throw new CreditControlException(CreditControlException.CREDITE_SQL_EXCEPTION);
                catch (BOSException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                SQLUtils.cleanup(psInsert);
                SQLUtils.cleanup(psUpdate);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)psInsert);
        SQLUtils.cleanup((Statement)psUpdate);
    }

    private void checkCreditBalance() throws EASBizException, BOSException {
        String usedCreditAmountFormual = "";
        String postIssueUsedCreditAmountFormual = "";
        String soIssueUsedCreditAmountFormual = "";
        String queryStr = "";
        switch (this.getBillSecene().getValue()) {
            case 6: {
                usedCreditAmountFormual = ",SUM(ISNULL(t03.FUnAuditSOAmt,0)+ISNULL(t03.FUnArBillOrderAmt,0)) AS FusedCreditAmount ";
                postIssueUsedCreditAmountFormual = ",0 AS FPostUsedCreditAmount ";
                soIssueUsedCreditAmountFormual = ",0 AS FSoUsedCreditAmount ";
                queryStr = ",t01.FusedCreditAmount AS FusedCreditAmount,t01.FPostUsedCreditAmount AS FPostUsedCreditAmount,t01.FSoUsedCreditAmount AS FSoUsedCreditAmount ";
                break;
            }
            case 1: {
                usedCreditAmountFormual = ",SUM(ISNULL(t03.FUnAuditSOAmt,0)+ISNULL(t03.FUnArBillOrderAmt,0)) AS FusedCreditAmount ";
                postIssueUsedCreditAmountFormual = ",0 AS FPostUsedCreditAmount ";
                soIssueUsedCreditAmountFormual = ",0 AS FSoUsedCreditAmount ";
                queryStr = ",t01.FusedCreditAmount AS FusedCreditAmount,t01.FPostUsedCreditAmount AS FPostUsedCreditAmount,t01.FSoUsedCreditAmount AS FSoUsedCreditAmount ";
                break;
            }
            case 4: {
                usedCreditAmountFormual = ",SUM(ISNULL(t03.FUnAuditPostBillAmt,0)+ISNULL(t03.FUnOutPostBillAmt,0)+ISNULL(t03.FUnArBillIssuedAmt,0)) AS FusedCreditAmount ";
                postIssueUsedCreditAmountFormual = ",0 AS FPostUsedCreditAmount ";
                soIssueUsedCreditAmountFormual = ",0 AS FSoUsedCreditAmount ";
                queryStr = ",t01.FusedCreditAmount AS FusedCreditAmount,t01.FPostUsedCreditAmount AS FPostUsedCreditAmount,t01.FSoUsedCreditAmount AS FSoUsedCreditAmount ";
                break;
            }
            case 5: {
                usedCreditAmountFormual = ",SUM(ISNULL(t03.FUnOutSaleOrderBillAmt,0)+ISNULL(t03.FUnAuditSOAmt,0)+ISNULL(t03.FUnArBillOrderAmt,0)) AS FusedCreditAmount ";
                postIssueUsedCreditAmountFormual = ",0 AS FPostUsedCreditAmount ";
                soIssueUsedCreditAmountFormual = ",0 AS FSoUsedCreditAmount ";
                queryStr = ",t01.FusedCreditAmount AS FusedCreditAmount,t01.FPostUsedCreditAmount AS FPostUsedCreditAmount,t01.FSoUsedCreditAmount AS FSoUsedCreditAmount ";
                break;
            }
            case 3: {
                usedCreditAmountFormual = ",SUM(ISNULL(t03.FUnAuditIssuedAmt,0)+ISNULL(t03.FUnArBillIssuedAmt,0)) AS FusedCreditAmount ";
                postIssueUsedCreditAmountFormual = ",SUM(ISNULL(t03.FUnAuditPostBillAmt,0)+ISNULL(t03.FUnOutPostBillAmt,0)+ISNULL(t03.FUnArBillIssuedAmt,0)) AS FPostUsedCreditAmount ";
                soIssueUsedCreditAmountFormual = ",SUM(ISNULL(t03.FUnAuditSOAmt,0)+ISNULL(t03.FUnArBillOrderAmt,0)) AS FSoUsedCreditAmount ";
                queryStr = ",t01.FusedCreditAmount AS FusedCreditAmount,t01.FPostUsedCreditAmount AS FPostUsedCreditAmount,t01.FSoUsedCreditAmount AS FSoUsedCreditAmount ";
                break;
            }
            default: {
                usedCreditAmountFormual = ",0 AS FusedCreditAmount ";
                postIssueUsedCreditAmountFormual = ",0 AS FPostUsedCreditAmount ";
                soIssueUsedCreditAmountFormual = ",0 AS FSoUsedCreditAmount ";
                queryStr = ",t01.FusedCreditAmount AS FusedCreditAmount,t01.FPostUsedCreditAmount AS FPostUsedCreditAmount,t01.FSoUsedCreditAmount AS FSoUsedCreditAmount ";
            }
        }
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select t01.FCompanyID AS FCompanyID,t01.FCustomerID AS FCustomerID,t01.FCreditAccountID AS FCreditAccountID");
        sqlStr.append(queryStr).append(", t02.FControlMethod ");
        sqlStr.append(" FROM (");
        sqlStr.append("select t03.FCompanyID AS FCompanyID,t03.FCustomerID AS FCustomerID,t03.FCreditAccountID AS FCreditAccountID");
        sqlStr.append(usedCreditAmountFormual).append(postIssueUsedCreditAmountFormual).append(soIssueUsedCreditAmountFormual);
        sqlStr.append(" from ").append(this.balanceTempTable).append(" AS t03");
        sqlStr.append(" GROUP BY t03.FCompanyID,t03.FCustomerID,t03.FCreditAccountID");
        sqlStr.append(") AS t01");
        sqlStr.append(" INNER JOIN (SELECT t04.FCompanyID as FCompanyID, t04.FCustomerID as FCustomerID, t04.FCreditAccountID as FCreditAccountID, t04.FControlMethod as FControlMethod FROM ");
        sqlStr.append(this.dataTempTable).append(" AS t04 ");
        sqlStr.append(" GROUP BY t04.FCompanyID,t04.FCustomerID,t04.FCreditAccountID,t04.FControlMethod) AS t02");
        sqlStr.append(" ON t01.FCompanyID = t02.FCompanyID ");
        sqlStr.append(" AND t01.FCustomerID = t02.FCustomerID ");
        sqlStr.append(" AND t01.FCreditAccountID = t02.FCreditAccountID ");
        IRowSet rowSet = DbUtil.executeQuery((Context)this._ctx, (String)sqlStr.toString());
        CreditCondition creditCondition = null;
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        CustomerInfo customer = new CustomerInfo();
        try {
            while (rowSet.next()) {
                if (!(rowSet.getBigDecimal("FusedCreditAmount") != null && SCMConstant.BIGDECIMAL_ZERO.compareTo(rowSet.getBigDecimal("FusedCreditAmount")) != 0 || rowSet.getBigDecimal("FPostUsedCreditAmount") != null && SCMConstant.BIGDECIMAL_ZERO.compareTo(rowSet.getBigDecimal("FPostUsedCreditAmount")) != 0 || rowSet.getBigDecimal("FSoUsedCreditAmount") != null && SCMConstant.BIGDECIMAL_ZERO.compareTo(rowSet.getBigDecimal("FSoUsedCreditAmount")) != 0)) continue;
                creditCondition = new CreditCondition();
                company.setId(BOSUuid.read((String)rowSet.getString("FCompanyID")));
                creditCondition.setCompany(CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(this._ctx, (OrgUnitInfo)company));
                customer.setId(BOSUuid.read((String)rowSet.getString("FCustomerID")));
                creditCondition.setCustomer(CreditUtils.readFullCustomerInfo(this._ctx, customer));
                HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
                billNumeric.put("BILL_NUMERIC_AMOUNT", rowSet.getBigDecimal("FusedCreditAmount"));
                creditCondition.setBillNumeric(billNumeric);
                if (3 == this.getBillSecene().getValue()) {
                    billNumeric.put("FPostUsedCreditAmount", rowSet.getBigDecimal("FPostUsedCreditAmount"));
                    billNumeric.put("FSoUsedCreditAmount", rowSet.getBigDecimal("FSoUsedCreditAmount"));
                }
                this.checkCreditBalance(creditCondition);
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
    }

    private void checkCreditBalance(CreditCondition creditCondition) throws EASBizException, BOSException {
        switch (this.getBillSecene().getValue()) {
            case 6: {
                creditCondition.setCreditControlScene(1);
                this.doCheck(creditCondition);
                break;
            }
            case 1: {
                creditCondition.setCreditControlScene(1);
                this.doCheck(creditCondition);
                break;
            }
            case 4: {
                creditCondition.setCreditControlScene(4);
                this.doCheck(creditCondition);
                break;
            }
            case 5: {
                creditCondition.setCreditControlScene(1);
                this.doCheck(creditCondition);
                break;
            }
            case 3: {
                Map billNumeric = creditCondition.getBillNumeric();
                creditCondition.setCreditControlScene(3);
                this.doCheck(creditCondition);
                if (creditCondition.getCreditParam() != null && creditCondition.getCreditParam().isCtrlPostbillAmount() && SCMConstant.BIGDECIMAL_ZERO.compareTo((BigDecimal)billNumeric.get("FPostUsedCreditAmount")) != 0) {
                    billNumeric.put("BILL_NUMERIC_AMOUNT", (BigDecimal)billNumeric.get("FPostUsedCreditAmount"));
                    creditCondition.setBillNumeric(billNumeric);
                    creditCondition.setCreditControlScene(4);
                    this.doCheck(creditCondition);
                }
                if (creditCondition.getCreditParam() == null || !creditCondition.getCreditParam().isCtrlSaleOrderAmount() || SCMConstant.BIGDECIMAL_ZERO.compareTo((BigDecimal)billNumeric.get("FSoUsedCreditAmount")) == 0) break;
                billNumeric.put("BILL_NUMERIC_AMOUNT", (BigDecimal)billNumeric.get("FSoUsedCreditAmount"));
                creditCondition.setBillNumeric(billNumeric);
                creditCondition.setCreditControlScene(1);
                this.doCheck(creditCondition);
            }
        }
    }

    private void doCheck(CreditCondition creditCondition) throws BOSException, EASBizException {
        String companyID;
        Map billNumeric = creditCondition.getBillNumeric();
        CreditCtrlResult checkResult = null;
        ICreditQueryFacade iCreditQueryFacade = CreditQueryFacadeFactory.getLocalInstance(this._ctx);
        BigDecimal curAmount = creditCondition.readBillAmount();
        creditCondition.setBillNumeric(new HashMap());
        checkResult = iCreditQueryFacade.checkCreditBalance(creditCondition);
        if (checkResult != null && checkResult.isOverspend() && (companyID = checkResult.getCompanyId()) != null && companyID.length() > 0 && !creditCondition.getCompany().getId().toString().equals(companyID)) {
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyID));
            company = CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(this._ctx, (OrgUnitInfo)company);
            ObjectUuidPK srcCurrencyPk = new ObjectUuidPK(creditCondition.getCompany().getBaseCurrency().getId().toString());
            ObjectUuidPK exchangeTablePk = new ObjectUuidPK(company.getBaseExchangeTable().getId().toString());
            ObjectUuidPK destCurrencyPk = new ObjectUuidPK(company.getBaseCurrency().getId().toString());
            BigDecimal rate = CreditUtils.getExchangeRate(this._ctx, (IObjectPK)exchangeTablePk, (IObjectPK)srcCurrencyPk, (IObjectPK)destCurrencyPk);
            curAmount = curAmount.multiply(rate);
            curAmount = curAmount.setScale(company.getBaseCurrency().getPrecision(), 4);
        }
        if (checkResult != null && checkResult.isOverspend() && 1 == checkResult.getCreditCtrlMode().getValue()) {
            checkResult.setCurAmount(curAmount);
            checkResult.setOtherUsedCreditAmount(checkResult.getOtherUsedCreditAmount().subtract(curAmount));
            CreditControlHelper.buildMsg(this._ctx, checkResult, creditCondition, true);
            if (checkResult.getMsgBody() != null) {
                Object[] resultparams = new String[]{checkResult.getMsgBody() + "\r\n" + ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditResource", (String)"CANCEL_OPT", (Locale)this._ctx.getLocale())};
                throw new CreditControlException(CreditControlException.OVER_SPEND, resultparams);
            }
        } else {
            BigDecimal creditBalanceAfter = checkResult.getCreditBalanceAfter();
            checkResult.setCreditBalanceBefore(creditBalanceAfter.add(curAmount));
            checkResult.setCustomerId(creditCondition.getCustomer() != null ? creditCondition.getCustomer().getId().toString() : null);
            if (checkResult != null && checkResult.isOverspend()) {
                String querySql = "select FBillID,FBillNumber,FSourceBillID,FCoreBillID from " + this.dataTempTable + " where FIsHistory = 0 and FCompanyID = '" + creditCondition.getCompany().getId().toString() + "' and FCustomerID = '" + creditCondition.getCustomer().getId().toString() + "'";
                if (billNumeric.containsKey("FPostUsedCreditAmount") && creditCondition.getCreditControlScene() == 4) {
                    querySql = "select tmp.FSourceBillID,postreq.fnumber from " + this.dataTempTable + " tmp left outer join T_SD_PostRequisition postreq on postreq.fid = tmp.FSourceBillID where tmp.FSourceBillTypeID = '" + "510b6503-0105-1000-e000-011bc0a812fd463ED552" + "' and tmp.FIsHistory = 0 and tmp.FCompanyID = '" + creditCondition.getCompany().getId().toString() + "' and tmp.FCustomerID = '" + creditCondition.getCustomer().getId().toString() + "'";
                } else if (billNumeric.containsKey("FSoUsedCreditAmount") && creditCondition.getCreditControlScene() == 1) {
                    querySql = "select tmp.FCoreBillID,so.fnumber from " + this.dataTempTable + " tmp left outer join T_SD_SaleOrder so on so.fid = tmp.FCoreBillID where tmp.FCoreBillTypeID = '" + "510b6503-0105-1000-e000-0113c0a812fd463ED552" + "' and tmp.FIsHistory = 0 and tmp.FCompanyID = '" + creditCondition.getCompany().getId().toString() + "' and tmp.FCustomerID = '" + creditCondition.getCustomer().getId().toString() + "'";
                }
                IRowSet rs = DbUtil.executeQuery((Context)this._ctx, (String)querySql);
                HashMap<String, String> billMap = new HashMap<String, String>();
                try {
                    String billID = null;
                    while (rs != null && rs.next()) {
                        billID = rs.getString(1);
                        if (billID == null || billID.length() <= 0) continue;
                        billMap.put(billID, rs.getString(2));
                    }
                    if (billMap.size() == 0) {
                        return;
                    }
                    CreditFormulaSceneEnum billType = CreditFormulaSceneEnum.getEnum(creditCondition.getCreditControlScene());
                    if ("546F192F".equals(BOSUuid.read((String)billID).getType().toString())) {
                        billType = CreditFormulaSceneEnum.SALERETURN;
                    } else if ("CC3E933B".equals(BOSUuid.read((String)billID).getType().toString())) {
                        billType = CreditFormulaSceneEnum.ISSUEDBILL;
                    } else if ("C2D6BA77".equals(BOSUuid.read((String)billID).getType().toString())) {
                        billType = CreditFormulaSceneEnum.NETORDERBILL;
                    }
                    CreditExceptionRptFacadeFactory.getLocalInstance(this._ctx).addExceptionRecord(billMap, billType, checkResult, this.operation);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    public String getInsertCreditLogSql() {
        StringBuffer strSQL = new StringBuffer();
        Date currentDate = new Date(System.currentTimeMillis());
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        strSQL.append("Insert Into T_SD_CreditLog (FID,FCreditAccountID,FCompanyID,FCustomerID,FCreditOperation,FOperateTime,FBillTypeID,FBillID,FBillNumber,FBizDate,FRemark,FRemark_l1,FRemark_l2, FRemark_l3,").append(" FUnOutSaleOrderBillAmt,FUnAuditIssuedAmt,FUnArBillIssuedAmt,FUnAuditSOAmt,FUnArBillOrderAmt,FUnAuditPostBillAmt,FUnOutPostBillAmt)").append(" SELECT newbosid('CFCE011F'), FCreditAccountID, FCompanyID, FCustomerID, ").append(this.operation.getValue()).append(", {ts'" + formater.format(currentDate) + "'}, FBillTypeID,FBillID,FBillNumber,FBizDate,FRemark,FRemark_l1,FRemark_l2, FRemark_l3,").append(" SUM(ISNULL(FUnOutSaleOrderBillAmt,0)) AS FUnOutSaleOrderBillAmt,SUM(ISNULL(FUnAuditIssuedAmt,0)) AS FUnAuditIssuedAmt,").append(" SUM(ISNULL(FUnArBillIssuedAmt,0)) AS FUnArBillIssuedAmt, SUM(ISNULL(FUnAuditSOAmt,0)) AS FUnAuditSOAmt,").append(" SUM(ISNULL(FUnArBillOrderAmt,0)) AS FUnArBillOrderAmt,SUM(ISNULL(FUnAuditPostBillAmt,0)) AS FUnAuditPostBillAmt,").append(" SUM(ISNULL(FUnOutPostBillAmt,0)) AS FUnOutPostBillAmt ").append(" FROM ").append(this.balanceTempTable).append(" GROUP BY FCompanyID, FCustomerID, FCreditAccountID,FBillTypeID,FBillID,FBillNumber,FBizDate,FRemark,FRemark_l1,FRemark_l2, FRemark_l3");
        return strSQL.toString();
    }

    public void preCheck() throws BOSException, EASBizException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select FEntryID from ").append(this.dataTempTable).append(" where FCompanyID is null or FCompanyID=''");
        IRowSet rowSet = DbUtil.executeQuery((Context)this._ctx, (String)sqlStr.toString());
        try {
            if (rowSet.next()) {
                throw new CreditControlException(CreditControlException.NULL_CONSIGN_COMPANY);
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        sqlStr.setLength(0);
        sqlStr.append("select FEntryID from ").append(this.dataTempTable).append(" where FCustomerID is null or FCustomerID=''");
        rowSet = DbUtil.executeQuery((Context)this._ctx, (String)sqlStr.toString());
        try {
            if (rowSet.next()) {
                throw new CreditControlException(CreditControlException.NULL_PUSH_CUSTOMER);
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        sqlStr.setLength(0);
        sqlStr.append("SELECT FCompanyID,FCustomerID FROM ").append(this.dataTempTable).append(" GROUP BY FCompanyID,FCustomerID");
        rowSet = DbUtil.executeQuery((Context)this._ctx, (String)sqlStr.toString());
        CreditParamInfo creditParam = null;
        BillControlStrategy billCtrlStrategy = null;
        sqlStr.setLength(0);
        sqlStr.append(" delete from ").append(this.dataTempTable).append(" where FCompanyID=?");
        String updateSql = "update " + this.dataTempTable + " set FControlTime=?, FControlMethod=?, FIsCtrlSaleOrderAmount=?, FIsCtrlPostBillAmount=?, FIsCtrlSaleIssueAmount=?, FIsCtrlARAmount=? where FCompanyID=? ";
        try {
            while (rowSet.next()) {
                creditParam = CreditServerUtil.getCreditParamInfo(this._ctx, rowSet.getString("FCompanyID"));
                if (creditParam == null || !creditParam.isCompnayCredited()) {
                    DbUtil.execute((Context)this._ctx, (String)sqlStr.toString(), (Object[])new Object[]{rowSet.getString("FCompanyID")});
                    continue;
                }
                billCtrlStrategy = ControlStategyFacotry.getStragy(this.getBillSecene(), creditParam);
                DbUtil.execute((Context)this._ctx, (String)updateSql, (Object[])new Object[]{String.valueOf(billCtrlStrategy.getControlTime().getValue()), String.valueOf(billCtrlStrategy.getControlMethod().getValue()), creditParam.isCtrlSaleOrderAmount() ? "1" : "0", creditParam.isCtrlPostbillAmount() ? "1" : "0", creditParam.isCtrlIssuedAmount() ? "1" : "0", creditParam.isCtrlARAmount() ? "1" : "0", rowSet.getString("FCompanyID")});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        this.deleteUnCtrlData();
    }

    public void preProcess() throws BOSException, EASBizException {
        if (this.dataTempTable == null) {
            throw new BOSException("Credit balance data temp table is null!");
        }
        this.createTempTable4Balance();
    }

    public void releaseTable() {
        TempTablePool.getInstance((Context)this._ctx).releaseTable(this.balanceTempTable);
        TempTablePool.getInstance((Context)this._ctx).releaseTable(this.dataTempTable);
    }

    public void createTempTable4Balance() throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("CREATE TABLE T_TMP_CREDITBALANCE ( ");
        strSQL.append("FBillID varchar(44) NULL,");
        strSQL.append("FBillNumber nvarchar(80) NULL,");
        strSQL.append("FBillTypeID varchar(44) NULL,");
        strSQL.append("FBizDate DateTime,");
        strSQL.append("FRemark nvarchar(255) NULL,");
        strSQL.append("FRemark_l1 nvarchar(255) NULL,");
        strSQL.append("FRemark_l2 nvarchar(255) NULL,");
        strSQL.append("FRemark_l3 nvarchar(255) NULL,");
        strSQL.append("FCompanyID varchar(44) NULL,");
        strSQL.append("FCustomerID varchar(44) NULL,");
        strSQL.append("FCreditAccountID varchar(44) NULL,");
        strSQL.append("FUnOutSaleOrderBillAmt NUMERIC(28,10) DEFAULT 0,");
        strSQL.append("FUnAuditIssuedAmt NUMERIC(28,10) DEFAULT 0,");
        strSQL.append("FUnArBillIssuedAmt NUMERIC(28,10) DEFAULT 0,");
        strSQL.append("FUnAuditSOAmt NUMERIC(28,10) DEFAULT 0,");
        strSQL.append("FUnArBillOrderAmt NUMERIC(28,10) DEFAULT 0,");
        strSQL.append("FUnAuditPostBillAmt NUMERIC(28,10) DEFAULT 0,");
        strSQL.append("FUnOutPostBillAmt NUMERIC(28,10) DEFAULT 0)");
        try {
            this.balanceTempTable = TempTablePool.getInstance((Context)this._ctx).createTempTable(strSQL.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String getSelectCreditBalanceSql() {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("SELECT TB.FID AS FID,newbosid('12D4D072') AS NewFID, TA.FCompanyID AS FCompanyID, TA.FCustomerID AS FCustomerID, TA.FCreditAccountID,").append("ISNULL(TB.FUnOutSaleOrderBillAmt,0)+ISNULL(TA.FUnOutSaleOrderBillAmt,0) AS FUnOutSaleOrderBillAmt,").append("ISNULL(TB.FUnAuditIssuedAmt,0)+ISNULL(TA.FUnAuditIssuedAmt,0) AS FUnAuditIssuedAmt,").append("ISNULL(TB.FUnArBillIssuedAmt,0)+ISNULL(TA.FUnArBillIssuedAmt,0) AS FUnArBillIssuedAmt,").append("ISNULL(TB.FUnAuditSOAmt,0)+ISNULL(TA.FUnAuditSOAmt,0) AS FUnAuditSOAmt,").append("ISNULL(TB.FUnArBillOrderAmt,0)+ISNULL(TA.FUnArBillOrderAmt,0) AS FUnArBillOrderAmt,").append("ISNULL(TB.FUnAuditPostBillAmt,0)+ISNULL(TA.FUnAuditPostBillAmt,0) AS FUnAuditPostBillAmt,").append("ISNULL(TB.FUnOutPostBillAmt,0)+ISNULL(TA.FUnOutPostBillAmt,0) AS FUnOutPostBillAmt ").append("FROM (SELECT FCompanyID, FCustomerID, FCreditAccountID,").append(" SUM(ISNULL(FUnOutSaleOrderBillAmt,0)) AS FUnOutSaleOrderBillAmt,SUM(ISNULL(FUnAuditIssuedAmt,0)) AS FUnAuditIssuedAmt,").append(" SUM(ISNULL(FUnArBillIssuedAmt,0)) AS FUnArBillIssuedAmt, SUM(ISNULL(FUnAuditSOAmt,0)) AS FUnAuditSOAmt,").append(" SUM(ISNULL(FUnArBillOrderAmt,0)) AS FUnArBillOrderAmt,SUM(ISNULL(FUnAuditPostBillAmt,0)) AS FUnAuditPostBillAmt,").append(" SUM(ISNULL(FUnOutPostBillAmt,0)) AS FUnOutPostBillAmt ").append(" FROM ").append(this.balanceTempTable).append(" GROUP BY FCompanyID, FCustomerID, FCreditAccountID) TA ").append(" LEFT JOIN T_SD_CREDITBALANCE TB ON ").append(" ISNULL(TA.FCompanyID,'X') = ISNULL(TB.FCompanyID,'X')").append(" AND ISNULL(TA.FCustomerID,'X') = ISNULL(TB.FCustomerID,'X')").append(" AND ISNULL(TA.FCreditAccountID,'X') = ISNULL(TB.FCreditAccountID,'X')");
        return strSQL.toString();
    }

    public String getSelectBalanceTempTableSql() {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" SELECT  SUM(ISNULL(FUnArBillOrderAmt,0)) AS FUnArBillOrderAmt,SUM(ISNULL(FUnArBillIssuedAmt,0)) AS FUnArBillIssuedAmt");
        strSQL.append(" FROM ").append(this.balanceTempTable).append(" GROUP BY FCompanyID, FCustomerID, FCreditAccountID ");
        return strSQL.toString();
    }

    public void endProcess() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if ("FC910EF3".equals(this.bosType)) {
            sql.append("update T_SD_CREDITBALANCE set FID = FID where FID in ").append("(select TB.FID from ").append(this.dataTempTable).append(" TA INNER JOIN T_SD_CREDITBALANCE TB ON ").append(" TA.FCompanyID = TB.FCompanyID AND TA.FCreditAccountID = TB.FCreditAccountID").append(" AND (TA.FCustomerID = TB.FCustomerID OR TB.FCustomerID in (select cust.FID from t_bd_customer cust where cust.fbizanalysiscodeid in (select c.fbizanalysiscodeid from t_bd_customer c inner join ").append(this.dataTempTable).append(" b on b.FCustomerID = c.FID))))");
        } else {
            sql.append("update T_SD_CREDITBALANCE set FID = FID where FID in ").append("(select TB.FID from ").append(this.balanceTempTable).append(" TA INNER JOIN T_SD_CREDITBALANCE TB ON ").append(" TA.FCompanyID = TB.FCompanyID AND TA.FCreditAccountID = TB.FCreditAccountID").append(" AND (TA.FCustomerID = TB.FCustomerID OR TB.FCustomerID in (select cust.FID from t_bd_customer cust where cust.fbizanalysiscodeid in (select c.fbizanalysiscodeid from t_bd_customer c inner join ").append(this.balanceTempTable).append(" b on b.FCustomerID = c.FID))))");
        }
        DbUtil.execute((Context)this._ctx, (String)sql.toString());
        if (Boolean.TRUE.equals(this._ctx.get((Object)"CONTEXT_KEY_ISCHECKCREDIT_SERVER"))) {
            this.checkCredit();
        }
        this.updateBalance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCredit() throws BOSException, EASBizException {
        CreditCtrlResult result = null;
        if ("FC910EF3".equals(this.bosType)) {
            StringBuffer sql = new StringBuffer();
            sql.append("select FBillID from ").append(this.dataTempTable);
            IRowSet rs = DbUtil.executeQuery((Context)this._ctx, (String)sql.toString());
            String id = null;
            try {
                if (rs.next()) {
                    id = rs.getString("FBillID");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
            if (id == null) {
                return;
            }
            OtherBillInfo otherBillInfo = OtherBillFactory.getLocalInstance((Context)this._ctx).getOtherBillInfo((IObjectPK)new ObjectUuidPK(id), CreditControlHelper.getARSelectors());
            CreditOperationEnum opEnum = CreditOperationEnum.AUDIT;
            CreditDirectionEnum directionEnum = CreditDirectionEnum.ADD;
            if (CreditOperationEnum.AUDIT.equals((Object)this.operation)) {
                opEnum = CreditOperationEnum.AUDIT;
                directionEnum = CreditDirectionEnum.ADD;
                result = CreditCheck.checkArSysBillAtOperation(this._ctx, (IObjectValue[])new CoreBillBaseInfo[]{otherBillInfo}, CreditFormulaSceneEnum.ARBILL, opEnum, directionEnum);
            } else if (CreditOperationEnum.UNAUDIT.equals((Object)this.operation)) {
                opEnum = CreditOperationEnum.UNAUDIT;
                directionEnum = CreditDirectionEnum.LESS;
                result = CreditCheck.checkArSysBillAtOperation(this._ctx, (IObjectValue[])new CoreBillBaseInfo[]{otherBillInfo}, CreditFormulaSceneEnum.ARBILL, opEnum, directionEnum);
            } else if (CreditOperationEnum.DELETE.equals((Object)this.operation)) {
                opEnum = CreditOperationEnum.DELETE;
                directionEnum = CreditDirectionEnum.LESS;
                result = CreditCheck.checkArSysBillAtOperation(this._ctx, (IObjectValue[])new CoreBillBaseInfo[]{otherBillInfo}, CreditFormulaSceneEnum.ARBILL, opEnum, directionEnum);
            }
            if (result != null && (result.isOverspend() || result.isTimeout())) {
                throw new CreditControlException(CreditControlException.CREDIT_ISOVER);
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("select FBillID,FCompanyID,FCustomerID from ").append(this.balanceTempTable);
            IRowSet rs = DbUtil.executeQuery((Context)this._ctx, (String)sql.toString());
            String id = null;
            String couId = null;
            String custId = null;
            try {
                HashSet<String> ids = new HashSet<String>();
                while (rs.next()) {
                    id = rs.getString("FBillID");
                    ids.add(id);
                }
                SaleOrderInfo saleOrderInfoNew = null;
                SaleOrderInfo saleOrderInfoTemp = null;
                if (ids != null && ids.size() > 0) {
                    EntityViewInfo entityViewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                    entityViewInfo.setFilter(filter);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("id");
                    selector.add("version");
                    selector.add("companyOrgUnit.id");
                    selector.add("orderCustomer.id");
                    entityViewInfo.setSelector(selector);
                    SaleOrderCollection saleOrderCollection = SaleOrderFactory.getLocalInstance((Context)this._ctx).getSaleOrderCollection(entityViewInfo);
                    if (saleOrderCollection != null && saleOrderCollection.size() > 0) {
                        for (int i = 0; i < saleOrderCollection.size(); ++i) {
                            saleOrderInfoTemp = saleOrderCollection.get(i);
                            if (saleOrderInfoNew != null && saleOrderInfoNew.getVersion() >= saleOrderInfoTemp.getVersion()) continue;
                            saleOrderInfoNew = saleOrderInfoTemp;
                        }
                    }
                }
                if (saleOrderInfoNew != null) {
                    id = saleOrderInfoNew.getId().toString();
                    if (saleOrderInfoNew.getCompanyOrgUnit() != null) {
                        couId = saleOrderInfoNew.getCompanyOrgUnit().getId().toString();
                    }
                    if (saleOrderInfoNew.getOrderCustomer() != null) {
                        custId = saleOrderInfoNew.getOrderCustomer().getId().toString();
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
            if (id == null) {
                return;
            }
            BigDecimal oldAmount = this.getOldAmount(couId, custId);
            try {
                this._ctx.put((Object)"isServerCreditCheck", (Object)true);
                if ("C48A423A".equals(this.bosType)) {
                    SaleOrderInfo so = SaleOrderFactory.getLocalInstance((Context)this._ctx).getSaleOrderInfo((IObjectPK)new ObjectUuidPK(id), CreditControlHelper.getSaleOrderSelectors());
                    if (CreditOperationEnum.SUBMIT.equals((Object)this.operation)) {
                        so.put("soBillAmount", (Object)so.getLocalTotalTaxAmount().subtract(oldAmount));
                        result = CreditCheck.checkSOAtSubmit(this._ctx, so);
                    } else if (CreditOperationEnum.AUDIT.equals((Object)this.operation)) {
                        result = CreditCheck.checkSOAtAudit(this._ctx, so);
                    } else if (!CreditOperationEnum.UNAUDIT.equals((Object)this.operation) && CreditOperationEnum.ALTER.equals((Object)this.operation)) {
                        result = CreditCheck.checkSOAtAudit(this._ctx, so);
                    }
                } else if ("9CA9D08F".equals(this.bosType)) {
                    PostRequisitionInfo prInfo = PostRequisitionFactory.getLocalInstance((Context)this._ctx).getPostRequisitionInfo((IObjectPK)new ObjectUuidPK(id), CreditControlHelper.getPostRequisitionSelectors());
                    if (CreditOperationEnum.SUBMIT.equals((Object)this.operation)) {
                        prInfo.put("postBillAmount", (Object)CreditUtils.sumPostbillLocalAmount(prInfo).subtract(oldAmount));
                        result = CreditCheck.checkPostbillAtSubmit(this._ctx, prInfo);
                    } else if (CreditOperationEnum.AUDIT.equals((Object)this.operation)) {
                        result = CreditCheck.checkPostbillAtAudit(this._ctx, prInfo);
                    }
                } else if ("CC3E933B".equals(this.bosType)) {
                    SaleIssueBillInfo issueInfo = SaleIssueBillFactory.getLocalInstance((Context)this._ctx).getSaleIssueBillInfo((IObjectPK)new ObjectUuidPK(id), CreditControlHelper.getSaleIssueSelectors());
                    if (CreditOperationEnum.SUBMIT.equals((Object)this.operation)) {
                        issueInfo.put("issueBillAmount", (Object)issueInfo.getTotalLocalAmount().subtract(oldAmount));
                        result = CreditCheck.checkIssuedBillAtSubmit(this._ctx, issueInfo);
                    } else if (CreditOperationEnum.AUDIT.equals((Object)this.operation)) {
                        result = CreditCheck.checkIssuedBillAtAudit(this._ctx, issueInfo);
                    } else if (CreditOperationEnum.UNAUDIT.equals((Object)this.operation)) {
                        result = CreditCheck.checkIssuedBillAtUnAudit(this._ctx, issueInfo);
                    } else if (CreditOperationEnum.DELETE.equals((Object)this.operation)) {
                        result = CreditCheck.checkIssuedBillAtDelete(this._ctx, issueInfo);
                    }
                } else if ("546F192F".equals(this.bosType)) {
                    SaleReturnsInfo srInfo = SaleReturnsFactory.getLocalInstance((Context)this._ctx).getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(id), CreditControlHelper.getSaleReturnsSelectors());
                    if (CreditOperationEnum.SUBMIT.equals((Object)this.operation)) {
                        srInfo.put("srBillAmount", (Object)srInfo.getLocalTotalTaxAmount().subtract(oldAmount));
                    } else if (CreditOperationEnum.AUDIT.equals((Object)this.operation)) {
                        result = CreditCheck.checkSRAtAudit(this._ctx, srInfo);
                    } else if (CreditOperationEnum.UNAUDIT.equals((Object)this.operation)) {
                        result = CreditCheck.checkSRAtUnAudit(this._ctx, srInfo);
                    } else if (CreditOperationEnum.DELETE.equals((Object)this.operation)) {
                        result = CreditCheck.checkSRAtDelete(this._ctx, srInfo);
                    }
                }
                if (result != null && result.isRequiredCheck() && (result.isOverspend() || result.isTimeout())) {
                    throw new CreditControlException(CreditControlException.CREDIT_ISOVER);
                }
            }
            finally {
                this._ctx.remove((Object)"isServerCreditCheck");
            }
        }
    }

    protected String getUpdateCreditBalanceSql() {
        return "UPDATE T_SD_CREDITBALANCE SET FUnOutSaleOrderBillAmt = ?,FUnAuditIssuedAmt = ?,FUnArBillIssuedAmt = ?,FUnAuditSOAmt=?, FUnArBillOrderAmt=?, FUnAuditPostBillAmt = ?,FUnOutPostBillAmt = ? WHERE FID = ?";
    }

    protected void deleteUnNeedUpdateData() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ").append(this.balanceTempTable).append(" where (ISNULL(FUnOutSaleOrderBillAmt, 0))=0 and (ISNULL(FUnAuditIssuedAmt, 0))=0 ").append(this.sp).append(" and (ISNULL(FUnArBillIssuedAmt, 0))=0 and (ISNULL(FUnAuditSOAmt, 0))=0 and (ISNULL(FUnArBillOrderAmt, 0))=0 and (ISNULL(FUnAuditPostBillAmt, 0))=0 and (ISNULL(FUnOutPostBillAmt, 0))=0");
        DbUtil.execute((Context)this._ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("Delete from ").append(this.balanceTempTable).append(" WHERE EXISTS (select TA.FCompanyID,TA.FCustomerID,TA.FCreditAccountID FROM (SELECT FCompanyID, FCustomerID, FCreditAccountID ").append(this.sp).append(" FROM ").append(this.balanceTempTable).append(" GROUP BY FCompanyID, FCustomerID, FCreditAccountID ").append(this.sp).append(" having SUM(ISNULL(FUnOutSaleOrderBillAmt, 0)) = 0 and SUM(ISNULL(FUnAuditIssuedAmt, 0)) = 0 and SUM(ISNULL(FUnArBillIssuedAmt, 0)) = 0 ").append(this.sp).append(" and SUM(ISNULL(FUnAuditSOAmt, 0)) = 0 and SUM(ISNULL(FUnArBillOrderAmt, 0)) = 0 and SUM(ISNULL(FUnAuditPostBillAmt, 0)) = 0 ").append(this.sp).append(" and SUM(ISNULL(FUnOutPostBillAmt, 0)) = 0) as TA ").append(this.sp).append(" WHERE TA.FCompanyID = ").append(this.balanceTempTable).append(".FCompanyID").append(this.sp).append(" AND TA.FCustomerID = ").append(this.balanceTempTable).append(".FCustomerID").append(this.sp).append(" AND TA.FCreditAccountID = ").append(this.balanceTempTable).append(".FCreditAccountID)");
        DbUtil.execute((Context)this._ctx, (String)sql.toString());
    }

    protected String getInsertCreditBalanceSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_SD_CREDITBALANCE(FID,FCompanyID,FCustomerID,FCreditAccountID,FUnOutSaleOrderBillAmt,FUnAuditIssuedAmt,");
        sql.append("FUnArBillIssuedAmt,FUnAuditSOAmt,FUnArBillOrderAmt,FUnAuditPostBillAmt,FUnOutPostBillAmt) ");
        sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?)");
        return sql.toString();
    }

    public boolean isStartCreditLog() {
        return true;
    }

    protected String getResourceStr(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.credit.CreditResource", (String)key);
    }

    protected String getResourceStr(String key, Context ctx) {
        return this.getResourceStr(key, ctx.getLocale());
    }

    protected String getResourceStr(String key, Locale locale) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditResource", (String)key, (Locale)locale);
    }

    protected BigDecimal getOldAmount(String couId, String custId) throws BOSException {
        if (couId == null || custId == null) {
            return BigDecimal.ZERO;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(FLocalAmount) as FAmount,FBaseStatus,FCompanyID,FCustomerID from ").append(this.dataTempTable).append(" where FIsHistory = 1 group by FBillID,FBaseStatus,FCompanyID,FCustomerID");
        IRowSet rowSet = DbUtil.executeQuery((Context)this._ctx, (String)sql.toString());
        String baseStatus = null;
        BigDecimal oldAmount = BigDecimal.ZERO;
        String oldCouId = null;
        String oldCustId = null;
        try {
            if (rowSet.next()) {
                baseStatus = rowSet.getString("FBaseStatus");
                oldCouId = rowSet.getString("FCompanyID");
                oldCustId = rowSet.getString("FCustomerID");
                if (baseStatus.equals(String.valueOf(2)) && couId.equals(oldCouId) && custId.equals(oldCustId)) {
                    oldAmount = rowSet.getBigDecimal("FAmount");
                }
                if (baseStatus.equals(String.valueOf(2)) && couId.equals(oldCouId) && !custId.equals(oldCustId)) {
                    sql.setLength(0);
                    sql.append("select fbizanalysiscodeid from t_bd_customer where fid in(?,?) and fbizanalysiscodeid is not null group by fbizanalysiscodeid");
                    IRowSet rs = DbUtil.executeQuery((Context)this._ctx, (String)sql.toString(), (Object[])new Object[]{custId, oldCustId});
                    if (rs.size() == 1) {
                        oldAmount = rowSet.getBigDecimal("FAmount");
                    }
                    SQLUtils.cleanup((ResultSet)rs);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowSet);
        }
        return oldAmount;
    }

    protected abstract CreditFormulaSceneEnum getBillSecene();

    public abstract String getCreditAccount();

    public abstract void deleteUnCtrlData() throws BOSException, EASBizException;
}

