/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.app.balance.strategy.CreditUpdateBaseStrategy;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Map;

public class NetOrderUpdateStrategy
extends CreditUpdateBaseStrategy {
    public NetOrderUpdateStrategy(Context ctx, Map param) {
        super(ctx, param);
    }

    public void processCreditBalanceAtSubmit() throws BOSException, EASBizException {
        this.calcUnOutSaleOrderBillAmt4NO(" and FIsHistory=1 ", CreditOperationEnum.DELETE);
        this.calcUnOutSaleOrderBillAmt4NO(" and FIsHistory=0 ", CreditOperationEnum.SUBMIT);
    }

    public void processCreditBalanceAtDelete() throws BOSException, EASBizException {
        this.calcUnOutSaleOrderBillAmt4NO(" and FBaseStatus=2 ", CreditOperationEnum.DELETE);
    }

    public void processCreditBalanceAtUnAudit() throws BOSException, EASBizException {
        this.calcUnOutSaleOrderBillAmt4NO(" and FBaseStatus=4 ", CreditOperationEnum.UNAUDIT);
    }

    public void processCreditBalanceAtClose() throws BOSException, EASBizException {
        this.calcUnOutSaleOrderBillAmt4NO(" and (FBaseStatus=4 or FBaseStatus=8)", CreditOperationEnum.CLOSE);
    }

    public void processCreditBalanceAtAlter() throws BOSException, EASBizException {
        this.processCreditBalanceAtSubmit();
    }

    private void calcUnOutSaleOrderBillAmt4NO(String condition, CreditOperationEnum bizAction) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        String multiplier = "-1";
        switch (bizAction.getValue()) {
            case 1: {
                multiplier = "1";
                break;
            }
            case 7: {
                multiplier = "1";
                break;
            }
            case 10: {
                multiplier = "1";
                break;
            }
            default: {
                multiplier = "-1";
            }
        }
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnOutSaleOrderBillAmt)").append(this.sp).append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0))*").append(multiplier).append(" from ").append(this.dataTempTable).append(" where FControlTime=").append(1).append(condition).append(" group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    @Override
    public void deleteUnCtrlData() throws BOSException, EASBizException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("delete from ").append(this.dataTempTable).append(" where FIsCtrlSaleOrderAmount=0 or FControlTime=").append(2);
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    @Override
    protected CreditFormulaSceneEnum getBillSecene() {
        return CreditFormulaSceneEnum.NETORDERBILL;
    }

    @Override
    public String getCreditAccount() {
        return "DawAAAAPiJDuN4KI";
    }
}

