/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.app.balance.strategy.CreditUpdateBaseStrategy;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Map;

public class PostRequisitionUpdateStrategy
extends CreditUpdateBaseStrategy {
    public PostRequisitionUpdateStrategy(Context ctx, Map param) {
        super(ctx, param);
    }

    public void processCreditBalanceAtSubmit() throws BOSException, EASBizException {
        this.calcUnAuditPostBillAmt4PR(" and FIsHistory=1 and FBaseStatus=2 ");
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnAuditPostBillAmt)").append(this.sp).append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0)) from ").append(this.dataTempTable).append(" where FControlTime=").append(1).append(" and FIsHistory=0 group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    public void processCreditBalanceAtDelete() throws BOSException, EASBizException {
        this.calcUnAuditPostBillAmt4PR(" and FBaseStatus=2 ");
    }

    public void processCreditBalanceAtDiscard() throws BOSException, EASBizException {
        this.calcUnAuditPostBillAmt4PR(" and FBaseStatus=2 ");
    }

    private void calcUnAuditPostBillAmt4PR(String condition) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnAuditPostBillAmt)").append(this.sp).append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0))*(-1) from ").append(this.dataTempTable).append(" where FControlTime=").append(1).append(condition).append(" group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    public void processCreditBalanceAtAudit() throws BOSException, EASBizException {
        this.calcUnAuditPostBillAmt4PR("");
        this.calcUnAuditPostBillAmt4PR(CreditOperationEnum.AUDIT);
    }

    public void processCreditBalanceAtUnAudit() throws BOSException, EASBizException {
        this.calcUnAuditPostBillAmt4PR(CreditOperationEnum.UNAUDIT);
    }

    private void calcUnAuditPostBillAmt4PR(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnOutPostBillAmt)").append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0))*").append(2 == bizAction.getValue() ? "1" : "(-1)").append(" from ").append(this.dataTempTable).append(" group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    public void processCreditBalanceAtClose() throws BOSException, EASBizException {
        this.calcUnAuditPostBillAmt4PRClose(CreditOperationEnum.CLOSE);
    }

    public void processCreditBalanceAtUnClose() throws BOSException, EASBizException {
        this.calcUnAuditPostBillAmt4PRClose(CreditOperationEnum.UNCLOSE);
    }

    private void calcUnAuditPostBillAmt4PRClose(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" insert into ").append(this.balanceTempTable).append("(FCompanyID,FCustomerID,FBillID,FBillNumber,FBizDate,FBillTypeID,FCreditAccountID,FUnOutPostBillAmt)");
        strSQL.append("SELECT t0.FCompanyID,t0.FCustomerID,t0.FBillID, t0.FBillNumber, t0.FBizDate, t0.FBillTypeID, '").append(this.getCreditAccount()).append("',").append(" SUM(case when abs(t1.FQty) - abs(t1.FShippedQty)<=0 then 0 ").append(" when t1.fqty > 0  ").append("  then to_decimal(to_decimal((t1.FQty - t1.FShippedQty) / t1.FQty,21,10) * t1.flocalAmount,19,4)  ").append(" when t1.fqty < 0  ").append("  then to_decimal(to_decimal((abs(t1.FQty) - abs(t1.FShippedQty)) / t1.FQty,21,10) * abs(t1.flocalAmount),19,4)  ").append("   else 0 end )*").append(5 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ").append(" FROM T_SD_PostRequisitionEntry t1 ").append("  INNER JOIN ").append(this.dataTempTable).append(" t0 on t0.FEntryID=t1.FID ").append(" GROUP BY t0.FCompanyID,t0.FCustomerID,t0.FBillID, t0.FBillNumber, t0.FBizDate, t0.FBillTypeID ");
        DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
    }

    @Override
    public void deleteUnCtrlData() throws BOSException, EASBizException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("delete from ").append(this.dataTempTable).append(" where FIsCtrlPostBillAmount=0");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    @Override
    protected CreditFormulaSceneEnum getBillSecene() {
        return CreditFormulaSceneEnum.POSTBILL;
    }

    @Override
    public String getCreditAccount() {
        return "DawAAAAPiJDuN4KI";
    }
}

