/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.app.balance.strategy.CreditUpdateBaseStrategy;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Map;

public class ReceivableUpdateStrategy
extends CreditUpdateBaseStrategy {
    public ReceivableUpdateStrategy(Context ctx, Map param) {
        super(ctx, param);
    }

    public void processCreditBalanceAtManualWriteOff() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4ManualWriteOff(CreditOperationEnum.ManualWriteOff);
        this.calcUnArBillReturnsAmt4ManualWriteOff(CreditOperationEnum.ManualWriteOff);
        this.calcUnArBillIssuedAmt4ManualWriteOff(CreditOperationEnum.ManualWriteOff);
    }

    public void processCreditBalanceAtManualUnWriteOff() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4ManualWriteOff(CreditOperationEnum.ManualUnWriteOff);
        this.calcUnArBillReturnsAmt4ManualWriteOff(CreditOperationEnum.ManualUnWriteOff);
        this.calcUnArBillIssuedAmt4ManualWriteOff(CreditOperationEnum.ManualUnWriteOff);
    }

    public void processCreditBalanceAtAudit() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4SOCore(CreditOperationEnum.AUDIT);
        this.calcUnArBillOrderAmt4SRCore(CreditOperationEnum.AUDIT);
        this.calcUnArBillIssuedAmt4SISource(CreditOperationEnum.AUDIT);
    }

    public void processCreditBalanceAtAuditCheck() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4SOCore(CreditOperationEnum.AUDIT);
        this.calcUnArBillOrderAmt4SRCore(CreditOperationEnum.AUDIT);
        this.calcUnArBillIssuedAmt4SISourceCheck(CreditOperationEnum.AUDIT);
    }

    private void calcUnArBillIssuedAmt4SISourceCheck(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillIssuedAmt)");
        sqlStr.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FServiceCustomerID,tmp.FCreditAccountID,");
        sqlStr.append(" SUM(ROUND(to_decimal(sie.famount/sie.FQty,21,10)*( ");
        sqlStr.append(" Round(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision)),tmp.FPrecision))*");
        sqlStr.append(2 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
        sqlStr.append(" From T_IM_SaleIssueEntry sie ");
        sqlStr.append(" INNER JOIN ").append(this.dataTempTable).append(" as tmp on tmp.FSourceBillEntryID=sie.FID ");
        sqlStr.append(" INNER JOIN T_BD_Customer t2 ON tmp.FServiceCustomerID = t2.FID");
        sqlStr.append(" left join T_bas_paramitem param on tmp.fcompanyid = param.FORGUNITID and param.FKEYID = 'zH2fpdJXSEqT1xVOujGsyaiB8+c='");
        sqlStr.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON sie.FMaterialID = mmu.FMaterialID AND sie.FUnitID=mmu.FMeasureUnitID   left outer join T_IM_SaleIssueEntry sie1 on sie1.fid = sie.FSourceBillEntryID");
        sqlStr.append(" INNER JOIN T_BD_Customer cust on cust.fid=sie.FBalanceCustomerID ");
        sqlStr.append(" where t2.FIsCredited = 1");
        sqlStr.append(" GROUP BY tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FServiceCustomerID,tmp.FCreditAccountID ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    public void processCreditBalanceAtSubmit() throws BOSException, EASBizException {
        this.calcUnAuditSOAmt4SO(" and FIsHistory=1 and FBaseStatus=2 ");
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnAuditSOAmt)").append(this.sp).append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0)) from ").append(this.dataTempTable).append(" where FControlTime=").append(1).append(" and FIsHistory=0 group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    public void processCreditBalanceAtDelete() throws BOSException, EASBizException {
    }

    private void calcUnAuditSOAmt4SO(String condition) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnAuditSOAmt)").append(this.sp).append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0))*(-1) from ").append(this.dataTempTable).append(" where FControlTime=").append(1).append(condition).append(" group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    public void processCreditBalanceAtUnAudit() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4SOCore(CreditOperationEnum.UNAUDIT);
        this.calcUnArBillOrderAmt4SRCore(CreditOperationEnum.UNAUDIT);
        this.calcUnArBillIssuedAmt4SISource(CreditOperationEnum.UNAUDIT);
    }

    private void calcUnArBillIssuedAmt4SISource(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillIssuedAmt)");
        sqlStr.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FServiceCustomerID,tmp.FCreditAccountID,");
        sqlStr.append(" SUM(ROUND((case when tmp.fbiztypeid = 'd8e80652-0113-1000-e000-04c5c0a812202407435C' and param.FVALUE_L1 = 'false'  then to_decimal(sie.flocalamount/sie.FQty,21,10) else to_decimal(sie.flocalamount/sie.FQty,21,10) end)*( ");
        sqlStr.append(" Round(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision)),tmp.FPrecision))*");
        sqlStr.append(2 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
        sqlStr.append(" From T_IM_SaleIssueEntry sie ");
        sqlStr.append(" INNER JOIN (SELECT dt.FSourceBillEntryID,dt.FEntryID,dt.FUnitID,sum(wor1.fcurrwrittenoffqty) FBaseQty,");
        sqlStr.append(" dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FServiceCustomerID,dt.FPrecision,dt.FCreditAccountID,dt.fbiztypeid from ").append(this.dataTempTable);
        sqlStr.append(" as dt left join t_cl_writeoffrecord wor on wor.fbillentryid = dt.FEntryID");
        sqlStr.append(" inner join t_cl_writeoffrecord wor1 on wor1.fparentid = wor.fparentid and wor1.fbillentryid=dt.FSourceBillEntryID");
        sqlStr.append(" where dt.FIsCtrlSaleIssueAmount=1 or dt.FIsCtrlPostBillAmount=1 and wor1.FBillTypeNumber='102' ");
        sqlStr.append(" group by dt.FSourceBillEntryID,dt.FEntryID,dt.FUnitID,dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FServiceCustomerID,dt.FPrecision,dt.FCreditAccountID,dt.fbiztypeid) tmp on tmp.FSourceBillEntryID=sie.FID ");
        sqlStr.append(" INNER JOIN T_BD_Customer t2 ON tmp.FServiceCustomerID = t2.FID");
        sqlStr.append(" left join T_bas_paramitem param on tmp.fcompanyid = param.FORGUNITID and param.FKEYID = 'zH2fpdJXSEqT1xVOujGsyaiB8+c='");
        sqlStr.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON sie.FMaterialID = mmu.FMaterialID AND sie.FUnitID=mmu.FMeasureUnitID   left outer join T_IM_SaleIssueEntry sie1 on sie1.fid = sie.FSourceBillEntryID");
        sqlStr.append(" INNER JOIN T_BD_Customer cust on cust.fid=sie.FBalanceCustomerID ");
        sqlStr.append(" where  t2.FIsCredited = 1");
        sqlStr.append(" GROUP BY tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FServiceCustomerID,tmp.FCreditAccountID ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    private void calcUnArBillOrderAmt4SRCore(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)");
        sqlStr.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID,");
        sqlStr.append(" SUM(ROUND(to_decimal(sre.FLocalTaxAmount/sre.FQty,21,10)*(");
        sqlStr.append(" Round(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision)),tmp.FPrecision))*");
        sqlStr.append(2 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
        sqlStr.append(" from T_SD_SaleReturnsEntry sre ");
        sqlStr.append(" INNER JOIN (SELECT dt.FCoreBillEntryID,dt.FEntryID,dt.FUnitID,sum(dt.FBaseQty+isnull(wor1.fcurrwrittenoffqty,0)-isnull(wor.fcurrwrittenoffqty,0)) FBaseQty,");
        sqlStr.append(" dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FOrderCustomerID,dt.FPrecision,dt.FCreditAccountID from ").append(this.dataTempTable);
        sqlStr.append(" as dt left join t_cl_writeoffrecord wor on wor.fbillentryid = dt.FEntryID");
        sqlStr.append(" inner join t_cl_writeoffrecord wor1 on wor1.fparentid = wor.fparentid and wor1.fbillentryid=dt.FSourceBillEntryID");
        sqlStr.append(" where dt.FIsCtrlSaleOrderAmount=1 and wor1.FBillTypeNumber='102' ");
        sqlStr.append(" group by dt.FCoreBillEntryID,dt.FEntryID,dt.FUnitID,dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FOrderCustomerID,dt.FPrecision,dt.FCreditAccountID) tmp on tmp.FCoreBillEntryID=sre.FID");
        sqlStr.append(" INNER JOIN T_BD_Customer t2 ON tmp.FOrderCustomerID = t2.FID");
        sqlStr.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON sre.FMaterialID = mmu.FMaterialID AND sre.FUnitID=mmu.FMeasureUnitID ");
        sqlStr.append(" where t2.FIsCredited = 1");
        sqlStr.append(" GROUP BY tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcUnArBillOrderAmt4SOCore(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" delete from ").append(this.dataTempTable).append(" where exists (select fid from T_SD_SaleOrderEntry ta ").append(" where ta.FBaseStatus = 7 and ta.FQty-ABS(ta.FTotalReversedQty) > ta.FTotalIssueQty and ").append(this.dataTempTable).append(".FCoreBillEntryID = ta.fid and ").append(this.dataTempTable).append(".FSourceBillEntryID=ta.fid)");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append(" create table temp(fparentid varchar(44),");
        sqlStr.append(" fcurrwrittenoffqty NUMERIC(28,10))");
        String writeTemp = KsqlUtil.createTempTableWithNewTx((Context)this._ctx, (String)sqlStr.toString());
        KsqlUtil.createTempTableIndex((Context)this._ctx, (String)writeTemp, (String)"fparentid", (boolean)false);
        sqlStr.setLength(0);
        sqlStr.append(" insert into ").append(writeTemp);
        sqlStr.append(" (fparentid,fcurrwrittenoffqty)");
        sqlStr.append(" select fparentid,sum(fcurrwrittenoffqty) as fcurrwrittenoffqty from t_cl_writeoffrecord where FBillTypeNumber='102'");
        sqlStr.append("  and fparentid in( select fparentid from t_cl_writeoffrecord where fbillentryid in(select FEntryID from ").append(this.dataTempTable).append("))");
        sqlStr.append(" group by fparentid ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        try {
            sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)");
            sqlStr.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID,");
            sqlStr.append(" SUM(ROUND(to_decimal(soe.FLocalTaxAmount/soe.FQty,21,10)*( ");
            sqlStr.append(" Round(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision)),tmp.FPrecision))*");
            sqlStr.append(2 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
            sqlStr.append(" From T_SD_SaleOrderEntry soe inner join T_SD_SaleOrder so on so.fid=soe.fparentid ");
            sqlStr.append(" INNER JOIN (SELECT dt.FSourceBillEntryID,dt.FCoreBillEntryID,dt.FUnitID,sum(dt.FQty) FQty,sum(dt.FBaseQty+isnull(wor1.fcurrwrittenoffqty,0)-isnull(wor.fcurrwrittenoffqty,0)) FBaseQty,");
            sqlStr.append(" dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FOrderCustomerID,dt.FPrecision,dt.FCreditAccountID from ").append(this.dataTempTable);
            sqlStr.append(" as dt left join t_cl_writeoffrecord wor on wor.fbillentryid = dt.FEntryID ");
            sqlStr.append(" left join ").append(writeTemp).append(" wor1 on wor1.fparentid = wor.fparentid  ");
            sqlStr.append(" where dt.FIsCtrlSaleOrderAmount=1 ");
            sqlStr.append(" group by dt.FSourceBillEntryID,dt.FCoreBillEntryID,dt.FUnitID,dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FOrderCustomerID,dt.FPrecision,dt.FCreditAccountID) tmp on tmp.FCoreBillEntryID=soe.FID ");
            sqlStr.append(" INNER JOIN T_BD_Customer t2 ON tmp.FOrderCustomerID = t2.FID");
            sqlStr.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON soe.FMaterialID = mmu.FMaterialID AND soe.FUnitID=mmu.FMeasureUnitID ");
            sqlStr.append(" WHERE  t2.FIsCredited = 1 AND isnull(so.fissysBill,0) = 0 ");
            sqlStr.append(" and ((so.FIsCentralBalance = 1 and so.FCompanyOrgUnitID=tmp.FCompanyID) or (so.FIsCentralBalance = 0 and soe.FCompanyOrgUnitID=tmp.FCompanyID)) ");
            sqlStr.append(" GROUP BY tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID ");
            DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        }
        finally {
            KsqlUtil.releaseTempTable((Context)this._ctx, (String)writeTemp);
        }
    }

    private void calcUnArBillOrderAmt4ManualWriteOff(CreditOperationEnum bizAction) throws BOSException {
        String ArBillEntryID = (String)this._ctx.get((Object)"ArBillEntryID");
        String writeOffID = (String)this._ctx.get((Object)"writeOffID");
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)");
        sqlStr.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID,");
        sqlStr.append(" SUM(ROUND(to_decimal(soe.FLocalTaxAmount/soe.FQty,21,10)*( ");
        sqlStr.append(" Round(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision)),tmp.FPrecision))*");
        sqlStr.append(51 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
        sqlStr.append(" From T_SD_SaleOrderEntry soe inner join T_SD_SaleOrder so on so.fid=soe.fparentid ");
        sqlStr.append(" INNER JOIN (SELECT soe1.fid as soeID,dt.FUnitID,sum(wor1.fcurrwrittenoffqty) FBaseQty,");
        sqlStr.append(" dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FOrderCustomerID,dt.FPrecision,dt.FCreditAccountID from ").append(this.dataTempTable);
        sqlStr.append(" as dt inner join t_cl_writeoffrecord wor on wor.fbillentryid = dt.FEntryID");
        sqlStr.append(" inner join t_cl_writeoffrecord wor1 on wor1.fparentid = wor.fparentid");
        sqlStr.append(" inner join T_IM_SaleIssueEntry sie on wor1.fbillentryid=sie.fid");
        sqlStr.append(" inner join T_SD_SaleOrderEntry soe1 on sie.FSaleOrderEntryID=soe1.fid");
        sqlStr.append(" where wor1.FBillTypeNumber='102' and dt.FEntryID = '").append(ArBillEntryID).append("'");
        sqlStr.append(" and wor1.fparentid  = '").append(writeOffID).append("'");
        sqlStr.append(" and (wor.forderbillnumber is null or wor.forderbillnumber <> wor1.forderbillnumber)");
        sqlStr.append(" group by soe1.fid,dt.FUnitID,dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FOrderCustomerID,dt.FPrecision,dt.FCreditAccountID) tmp on tmp.soeID=soe.FID");
        sqlStr.append(" INNER JOIN T_BD_Customer t2 ON tmp.FOrderCustomerID = t2.FID");
        sqlStr.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON soe.FMaterialID = mmu.FMaterialID AND soe.FUnitID=mmu.FMeasureUnitID ");
        sqlStr.append(" WHERE  t2.FIsCredited = 1 AND isnull(so.fissysBill,0) = 0 ");
        sqlStr.append(" and ((so.FIsCentralBalance = 1 and so.FCompanyOrgUnitID=tmp.FCompanyID) or (so.FIsCentralBalance = 0 and soe.FCompanyOrgUnitID=tmp.FCompanyID)) ");
        sqlStr.append(" GROUP BY tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)");
        sqlStr.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID,");
        sqlStr.append(" SUM(ROUND(to_decimal(soe.FLocalTaxAmount/soe.FQty,21,10)*( ");
        sqlStr.append(" Round(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision)),tmp.FPrecision))*");
        sqlStr.append(51 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
        sqlStr.append(" From T_SD_SaleOrderEntry soe inner join T_SD_SaleOrder so on so.fid=soe.fparentid ");
        sqlStr.append(" INNER JOIN (SELECT dt.FCoreBillEntryID,dt.FUnitID,(wor1.fcurrwrittenoffqty-wor2.fcurrwrittenoffqty) FBaseQty,wor1.forderbillnumber,wor1.forderbillentryseq,");
        sqlStr.append(" dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FOrderCustomerID,dt.FPrecision,dt.FCreditAccountID from ").append(this.dataTempTable);
        sqlStr.append(" as dt inner join t_cl_writeoffrecord wor on wor.fbillentryid = dt.FEntryID");
        sqlStr.append(" inner join (select fparentid,sum(fcurrwrittenoffqty) as fcurrwrittenoffqty,forderbillnumber,forderbillentryseq from t_cl_writeoffrecord where FBillTypeNumber='102' group by FParentid,forderbillnumber,forderbillentryseq) wor1 on wor1.fparentid = wor.fparentid");
        sqlStr.append(" inner join (select fparentid,sum(fcurrwrittenoffqty) as fcurrwrittenoffqty,forderbillnumber,forderbillentryseq from t_cl_writeoffrecord where FBillTypeNumber='330' group by FParentid,forderbillnumber,forderbillentryseq) wor2 on wor2.fparentid = wor.fparentid");
        sqlStr.append(" where dt.FEntryID = '").append(ArBillEntryID).append("'");
        sqlStr.append(" and wor1.fparentid  = '").append(writeOffID).append("'");
        sqlStr.append(" and wor1.forderbillnumber=wor2.forderbillnumber and wor1.forderbillentryseq=wor2.forderbillentryseq");
        sqlStr.append(" ) tmp on tmp.forderbillnumber=so.fnumber and tmp.forderbillentryseq=soe.fseq");
        sqlStr.append(" INNER JOIN T_BD_Customer t2 ON tmp.FOrderCustomerID = t2.FID");
        sqlStr.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON soe.FMaterialID = mmu.FMaterialID AND soe.FUnitID=mmu.FMeasureUnitID ");
        sqlStr.append(" WHERE  t2.FIsCredited = 1 AND isnull(so.fissysBill,0) = 0 ");
        sqlStr.append(" and ((so.FIsCentralBalance = 1 and so.FCompanyOrgUnitID=tmp.FCompanyID) or (so.FIsCentralBalance = 0 and soe.FCompanyOrgUnitID=tmp.FCompanyID)) ");
        sqlStr.append(" GROUP BY tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    private void calcUnArBillReturnsAmt4ManualWriteOff(CreditOperationEnum bizAction) throws BOSException {
        String ArBillEntryID = (String)this._ctx.get((Object)"ArBillEntryID");
        String writeOffID = (String)this._ctx.get((Object)"writeOffID");
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)");
        sqlStr.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID,");
        sqlStr.append(" SUM(ROUND(to_decimal(soe.FLocalTaxAmount/soe.FQty,21,10)*( ");
        sqlStr.append(" Round(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision)),tmp.FPrecision))*");
        sqlStr.append(51 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
        sqlStr.append(" From T_SD_SaleReturnsEntry soe inner join T_SD_SaleReturns so on so.fid=soe.fparentid ");
        sqlStr.append(" INNER JOIN (SELECT soe1.fid as soeID,dt.FUnitID,sum(wor1.fcurrwrittenoffqty) FBaseQty,");
        sqlStr.append(" dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FOrderCustomerID,dt.FPrecision,dt.FCreditAccountID from ").append(this.dataTempTable);
        sqlStr.append(" as dt left join t_cl_writeoffrecord wor on wor.fbillentryid = dt.FEntryID");
        sqlStr.append(" inner join t_cl_writeoffrecord wor1 on wor1.fparentid = wor.fparentid");
        sqlStr.append(" inner join T_IM_SaleIssueEntry sie on wor1.fbillentryid=sie.fid");
        sqlStr.append(" inner join T_SD_SaleReturnsEntry soe1 on sie.FSaleOrderEntryID=soe1.fid");
        sqlStr.append(" where wor1.FBillTypeNumber='102' and dt.FEntryID = '").append(ArBillEntryID).append("'");
        sqlStr.append(" and wor1.fparentid  = '").append(writeOffID).append("'");
        sqlStr.append(" and (wor.forderbillnumber is null or wor.forderbillnumber <> wor1.forderbillnumber)");
        sqlStr.append(" group by soe1.fid,dt.FUnitID,dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FOrderCustomerID,dt.FPrecision,dt.FCreditAccountID) tmp on tmp.soeID=soe.FID");
        sqlStr.append(" INNER JOIN T_BD_Customer t2 ON tmp.FOrderCustomerID = t2.FID");
        sqlStr.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON soe.FMaterialID = mmu.FMaterialID AND soe.FUnitID=mmu.FMeasureUnitID ");
        sqlStr.append(" WHERE  t2.FIsCredited = 1 ");
        sqlStr.append(" and ((so.FIsCentralBalance = 1 and so.FCompanyOrgUnitID=tmp.FCompanyID) or (so.FIsCentralBalance = 0 and soe.FCompanyOrgUnitID=tmp.FCompanyID)) ");
        sqlStr.append(" GROUP BY tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)");
        sqlStr.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID,");
        sqlStr.append(" SUM(ROUND(to_decimal(soe.FLocalTaxAmount/soe.FQty,21,10)*( ");
        sqlStr.append(" Round(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision)),tmp.FPrecision))*");
        sqlStr.append(51 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
        sqlStr.append(" From T_SD_SaleReturnsEntry soe inner join T_SD_SaleReturns so on so.fid=soe.fparentid ");
        sqlStr.append(" INNER JOIN (SELECT dt.FCoreBillEntryID,dt.FUnitID,(wor1.fcurrwrittenoffqty-wor2.fcurrwrittenoffqty) FBaseQty,wor1.forderbillnumber,wor1.forderbillentryseq,");
        sqlStr.append(" dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FOrderCustomerID,dt.FPrecision,dt.FCreditAccountID from ").append(this.dataTempTable);
        sqlStr.append(" as dt inner join t_cl_writeoffrecord wor on wor.fbillentryid = dt.FEntryID");
        sqlStr.append(" inner join (select fparentid,sum(fcurrwrittenoffqty) as fcurrwrittenoffqty,forderbillnumber,forderbillentryseq from t_cl_writeoffrecord where FBillTypeNumber='102' group by FParentid,forderbillnumber,forderbillentryseq) wor1 on wor1.fparentid = wor.fparentid");
        sqlStr.append(" inner join (select fparentid,sum(fcurrwrittenoffqty) as fcurrwrittenoffqty,forderbillnumber,forderbillentryseq from t_cl_writeoffrecord where FBillTypeNumber='330' group by FParentid,forderbillnumber,forderbillentryseq) wor2 on wor2.fparentid = wor.fparentid");
        sqlStr.append(" where dt.FEntryID = '").append(ArBillEntryID).append("'");
        sqlStr.append(" and wor1.fparentid  = '").append(writeOffID).append("'");
        sqlStr.append(" and wor1.forderbillnumber=wor2.forderbillnumber and wor1.forderbillentryseq=wor2.forderbillentryseq");
        sqlStr.append(" ) tmp on tmp.forderbillnumber=so.fnumber and tmp.forderbillentryseq=soe.fseq");
        sqlStr.append(" INNER JOIN T_BD_Customer t2 ON tmp.FOrderCustomerID = t2.FID");
        sqlStr.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON soe.FMaterialID = mmu.FMaterialID AND soe.FUnitID=mmu.FMeasureUnitID ");
        sqlStr.append(" WHERE  t2.FIsCredited = 1  ");
        sqlStr.append(" and ((so.FIsCentralBalance = 1 and so.FCompanyOrgUnitID=tmp.FCompanyID) or (so.FIsCentralBalance = 0 and soe.FCompanyOrgUnitID=tmp.FCompanyID)) ");
        sqlStr.append(" GROUP BY tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    private void calcUnArBillIssuedAmt4ManualWriteOff(CreditOperationEnum bizAction) throws BOSException {
        String ArBillEntryID = (String)this._ctx.get((Object)"ArBillEntryID");
        String writeOffID = (String)this._ctx.get((Object)"writeOffID");
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillIssuedAmt)");
        sqlStr.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FServiceCustomerID,tmp.FCreditAccountID,");
        sqlStr.append(" SUM(ROUND(to_decimal(sie.FLocalAmount/sie.FQty,21,10)*( ");
        sqlStr.append(" Round(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision)),tmp.FPrecision))*");
        sqlStr.append(51 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
        sqlStr.append(" From T_IM_SaleIssueEntry sie ");
        sqlStr.append(" INNER JOIN (SELECT wor1.fbillentryid as sieID,dt.FSourceBillEntryID,dt.FEntryID,dt.FUnitID,wor1.fcurrwrittenoffqty FBaseQty,");
        sqlStr.append(" dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FServiceCustomerID,dt.FPrecision,dt.FCreditAccountID from ").append(this.dataTempTable);
        sqlStr.append(" as dt left join t_cl_writeoffrecord wor on wor.fbillentryid = dt.FEntryID");
        sqlStr.append(" inner join t_cl_writeoffrecord wor1 on wor1.fparentid = wor.fparentid ");
        sqlStr.append(" where wor1.FBillTypeNumber='102' and dt.FEntryID = '").append(ArBillEntryID).append("'");
        sqlStr.append(" and wor1.fparentid  = '").append(writeOffID).append("'");
        sqlStr.append(" and (wor.forderbillnumber is null or wor.forderbillnumber <> wor1.forderbillnumber)");
        sqlStr.append(" ) tmp on tmp.sieID=sie.FID ");
        sqlStr.append(" INNER JOIN T_BD_Customer t2 ON tmp.FServiceCustomerID = t2.FID");
        sqlStr.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON sie.FMaterialID = mmu.FMaterialID AND sie.FUnitID=mmu.FMeasureUnitID ");
        sqlStr.append(" INNER JOIN T_BD_Customer cust on cust.fid=sie.FBalanceCustomerID ");
        sqlStr.append(" where  t2.FIsCredited = 1");
        sqlStr.append(" GROUP BY tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FServiceCustomerID,tmp.FCreditAccountID ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillIssuedAmt)");
        sqlStr.append(" SELECT TOP 1 tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID,");
        sqlStr.append(" SUM(ROUND(to_decimal(sie.FLocalAmount/sie.FQty,21,10)*( ");
        sqlStr.append(" Round(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision)),tmp.FPrecision))*");
        sqlStr.append(51 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
        sqlStr.append(" From T_IM_SaleIssueEntry sie  ");
        sqlStr.append(" inner join T_SD_SaleOrderEntry soe on soe.fid=sie.FSaleOrderEntryID inner join T_SD_SaleOrder so on so.fid=soe.fparentid");
        sqlStr.append(" INNER JOIN (SELECT dt.FCoreBillEntryID,dt.FUnitID,(wor1.fcurrwrittenoffqty-wor2.fcurrwrittenoffqty) FBaseQty,wor1.forderbillnumber,wor1.forderbillentryseq,");
        sqlStr.append(" dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FOrderCustomerID,dt.FPrecision,dt.FCreditAccountID from ").append(this.dataTempTable);
        sqlStr.append(" as dt inner join t_cl_writeoffrecord wor on wor.fbillentryid = dt.FEntryID");
        sqlStr.append(" inner join (select fparentid,sum(fcurrwrittenoffqty) as fcurrwrittenoffqty,forderbillnumber,forderbillentryseq from t_cl_writeoffrecord where FBillTypeNumber='102' group by FParentid,forderbillnumber,forderbillentryseq) wor1 on wor1.fparentid = wor.fparentid");
        sqlStr.append(" inner join (select fparentid,sum(fcurrwrittenoffqty) as fcurrwrittenoffqty,forderbillnumber,forderbillentryseq from t_cl_writeoffrecord where FBillTypeNumber='330' group by FParentid,forderbillnumber,forderbillentryseq) wor2 on wor2.fparentid = wor.fparentid");
        sqlStr.append(" where dt.FEntryID = '").append(ArBillEntryID).append("'");
        sqlStr.append(" and wor1.fparentid  = '").append(writeOffID).append("'");
        sqlStr.append(" and wor1.forderbillnumber=wor2.forderbillnumber and wor1.forderbillentryseq=wor2.forderbillentryseq");
        sqlStr.append(" ) tmp on tmp.forderbillnumber=so.fnumber and tmp.forderbillentryseq=soe.fseq");
        sqlStr.append(" INNER JOIN T_BD_Customer t2 ON tmp.FOrderCustomerID = t2.FID");
        sqlStr.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON soe.FMaterialID = mmu.FMaterialID AND soe.FUnitID=mmu.FMeasureUnitID ");
        sqlStr.append(" WHERE  t2.FIsCredited = 1  ");
        sqlStr.append(" and ((so.FIsCentralBalance = 1 and so.FCompanyOrgUnitID=tmp.FCompanyID) or (so.FIsCentralBalance = 0 and soe.FCompanyOrgUnitID=tmp.FCompanyID)) ");
        sqlStr.append(" GROUP BY tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillIssuedAmt)");
        sqlStr.append(" SELECT TOP 1 tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID,");
        sqlStr.append(" SUM(ROUND(to_decimal(sie.FLocalAmount/sie.FQty,21,10)*( ");
        sqlStr.append(" Round(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision)),tmp.FPrecision))*");
        sqlStr.append(51 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
        sqlStr.append(" From T_IM_SaleIssueEntry sie  ");
        sqlStr.append(" inner join T_SD_SaleReturnsEntry soe on soe.fid=sie.FSaleOrderEntryID inner join T_SD_SaleReturns so on so.fid=soe.fparentid");
        sqlStr.append(" INNER JOIN (SELECT dt.FCoreBillEntryID,dt.FUnitID,(wor1.fcurrwrittenoffqty-wor2.fcurrwrittenoffqty) FBaseQty,wor1.forderbillnumber,wor1.forderbillentryseq,");
        sqlStr.append(" dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FOrderCustomerID,dt.FPrecision,dt.FCreditAccountID from ").append(this.dataTempTable);
        sqlStr.append(" as dt inner join t_cl_writeoffrecord wor on wor.fbillentryid = dt.FEntryID");
        sqlStr.append(" inner join (select fparentid,sum(fcurrwrittenoffqty) as fcurrwrittenoffqty,forderbillnumber,forderbillentryseq from t_cl_writeoffrecord where FBillTypeNumber='102' group by FParentid,forderbillnumber,forderbillentryseq) wor1 on wor1.fparentid = wor.fparentid");
        sqlStr.append(" inner join (select fparentid,sum(fcurrwrittenoffqty) as fcurrwrittenoffqty,forderbillnumber,forderbillentryseq from t_cl_writeoffrecord where FBillTypeNumber='330' group by FParentid,forderbillnumber,forderbillentryseq) wor2 on wor2.fparentid = wor.fparentid");
        sqlStr.append(" where dt.FEntryID = '").append(ArBillEntryID).append("'");
        sqlStr.append(" and wor1.fparentid  = '").append(writeOffID).append("'");
        sqlStr.append(" and wor1.forderbillnumber=wor2.forderbillnumber and wor1.forderbillentryseq=wor2.forderbillentryseq");
        sqlStr.append(" ) tmp on tmp.forderbillnumber=so.fnumber and tmp.forderbillentryseq=soe.fseq");
        sqlStr.append(" INNER JOIN T_BD_Customer t2 ON tmp.FOrderCustomerID = t2.FID");
        sqlStr.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON soe.FMaterialID = mmu.FMaterialID AND soe.FUnitID=mmu.FMeasureUnitID ");
        sqlStr.append(" WHERE  t2.FIsCredited = 1  ");
        sqlStr.append(" and ((so.FIsCentralBalance = 1 and so.FCompanyOrgUnitID=tmp.FCompanyID) or (so.FIsCentralBalance = 0 and soe.FCompanyOrgUnitID=tmp.FCompanyID)) ");
        sqlStr.append(" GROUP BY tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FOrderCustomerID,tmp.FCreditAccountID ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    @Override
    public String getCreditAccount() {
        return "DawAAAAPiJDuN4KI";
    }

    @Override
    public void deleteUnCtrlData() throws BOSException, EASBizException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("delete from ").append(this.dataTempTable).append(" where FIsCtrlSaleIssueAmount=0 and FIsCtrlPostBillAmount=0 and FIsCtrlSaleOrderAmount=0 ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append("delete from ").append(this.dataTempTable).append(" where (FCoreBillTypeID='").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("' or FCoreBillTypeID='").append("50957179-0105-1000-e008-8152c0a812fd463ED552").append("') and (FOrderCustomerID is null or FOrderCustomerID='') ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    @Override
    protected CreditFormulaSceneEnum getBillSecene() {
        if (!this.arBillCtrl) {
            return CreditFormulaSceneEnum.ARBILL;
        }
        return CreditFormulaSceneEnum.ARSYSBILL;
    }
}

