/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.app.balance.strategy.CreditUpdateBaseStrategy;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.Map;

public class SaleIssueUpdateStrategy
extends CreditUpdateBaseStrategy {
    public SaleIssueUpdateStrategy(Context ctx, Map param) {
        super(ctx, param);
    }

    @Override
    public void preProcess() throws BOSException, EASBizException {
        super.preProcess();
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("update ").append(this.dataTempTable).append(" as tmp set FCompanyID = ").append(" (select so.fcompanyorgunitid from t_sd_saleorder so where so.fid=tmp.FCoreBillID) where tmp.FIsCenterBalance=1 and tmp.FCoreBillTypeID='").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("'");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append("update ").append(this.dataTempTable).append(" as tmp set FPrice = ").append(" (select to_decimal(to_decimal(to_decimal(soe.FLocalTaxAmount,19,4) / to_decimal(soe.FQty,21,8),21,8),21,8) FPrice ").append(" from T_SD_SaleOrderEntry soe where soe.fid = tmp.FCoreBillEntryID) where tmp.FIsCenterBalance=1 and tmp.FCoreBillTypeID='").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("'");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append("update ").append(this.dataTempTable).append(" as tmp set FCompanyID = (select orgRe.FToUnitID from T_SD_SaleReturns sr ").append(" INNER JOIN T_ORG_UnitRelation orgRe ON orgRe.FFromUnitID = sr.fsaleorgunitid").append(this.sp).append("                                    AND orgRe.FTypeRelationID ='").append("00000000-0000-0000-0000-0000000000050FE9F8B5").append("'").append(this.sp).append(" INNER JOIN T_ORG_Company t3 ON t3.FID = orgRe.FToUnitID WHERE sr.fid=tmp.FCoreBillID) where tmp.FIsCenterBalance=1 and tmp.FCoreBillTypeID='").append("50957179-0105-1000-e008-8152c0a812fd463ED552").append("'");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append("update ").append(this.dataTempTable).append(" as tmp set FPrice = ").append(" (select to_decimal(to_decimal(to_decimal(sre.flocalamount,19,4) / to_decimal(sre.FQty,21,8),21,8),21,8) FPrice ").append(" from T_SD_SaleReturnsEntry sre where sre.fid = tmp.FCoreBillEntryID) where tmp.FIsCenterBalance=1 and tmp.FCoreBillTypeID='").append("50957179-0105-1000-e008-8152c0a812fd463ED552").append("'");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    @Override
    public void deleteUnCtrlData() throws BOSException, EASBizException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select FCompanyID from ").append(this.dataTempTable).append(" where FBizTypeID='").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' group by FCompanyID");
        IRowSet rowSet = DbUtil.executeQuery((Context)this._ctx, (String)sqlStr.toString());
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)this._ctx);
        sqlStr.setLength(0);
        sqlStr.append("delete from ").append(this.dataTempTable).append(" where FCompanyID=? and FBizTypeID=? and FRITypeID not in('").append(RecIssueTypeConstant.CONSIGNOUT_RITYPEID).append("','").append(RecIssueTypeConstant.CONSIGNRT_RITYPEID).append("')");
        try {
            while (rowSet.next()) {
                String consignSales = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(rowSet.getString("FCompanyID")), "CONSIGNSALES");
                if (Boolean.valueOf(consignSales).booleanValue()) continue;
                DbUtil.execute((Context)this._ctx, (String)sqlStr.toString(), (Object[])new Object[]{rowSet.getString("FCompanyID"), "d8e80652-0113-1000-e000-04c5c0a812202407435C"});
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        sqlStr.setLength(0);
        sqlStr.append("delete from ").append(this.dataTempTable).append(" where exists (select t2.fid from t_im_saleissueentry t2 where t2.fid = ").append(this.dataTempTable).append(".fsourcebillentryid and t2.flocalamount>=0) and flocalamount>=0");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append("delete from ").append(this.dataTempTable).append(" where exists (select t2.fid from t_im_saleissueentry t2 where t2.fid = ").append(this.dataTempTable).append(".fsourcebillentryid and t2.flocalamount<0) and flocalamount<0");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    public void processCreditBalanceAtDelete() throws BOSException, EASBizException {
        this.calcUnAuditIssuedAmt4SI(" and FBaseStatus=2 ", CreditOperationEnum.DELETE);
    }

    public void processCreditBalanceAtDiscard() throws BOSException, EASBizException {
        this.calcUnAuditIssuedAmt4SI(" and FBaseStatus=3 ", CreditOperationEnum.DISCARD);
    }

    public void processCreditBalanceAtSubmit() throws BOSException, EASBizException {
        this.calcUnAuditIssuedAmt4SI(" and FIsHistory=1 and FBaseStatus=2 ", CreditOperationEnum.DELETE);
        this.calcUnAuditIssuedAmt4SI(" and FIsHistory=0 ", CreditOperationEnum.SUBMIT);
    }

    private void calcUnAuditIssuedAmt4SI(String condition, CreditOperationEnum bizAction) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnAuditIssuedAmt)").append(this.sp).append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0))*").append(1 == bizAction.getValue() ? "1" : "(-1)").append(" from ").append(this.dataTempTable).append(" where FIsCtrlSaleIssueAmount=1 and FControlTime=").append(1).append(condition).append(" group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    public void processCreditBalanceAtUnClose() throws BOSException, EASBizException {
        this.operation = CreditOperationEnum.AUDIT;
        this.calcUnArBillOrderAmt4SIReturnUnClose(CreditOperationEnum.AUDIT);
        String whereSql = " and tmp.FIsReversed=1 and t1.FQty>t1.FTotalIssueQty and (1-isnull(t1.FSendOwingRate,0)/100)*t1.FQty>t1.FTotalIssueQty";
        this.calcUnArBillOrderAmt4SILess(CreditOperationEnum.UNAUDIT, "", whereSql);
        whereSql = "and tmp.FIsReversed=1 and t1.FQuantityUnCtrl=0 and isnull(t1.FSendOwingRate,0)<>0 and t1.FQty>t1.FTotalIssueQty and (1-isnull(t1.FSendOwingRate,0)/100)*t1.FQty<=t1.FTotalIssueQty";
        this.calcUnArBillOrderAmt4SILess(CreditOperationEnum.UNAUDIT, "SALEORDER_AUTOCLOSE_LESS", whereSql);
        this.calcUnAuditPostBillAmt4PRClose(CreditOperationEnum.UNCLOSE);
    }

    private void calcUnAuditPostBillAmt4PRClose(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" insert into ").append(this.balanceTempTable).append("(FCompanyID,FCustomerID,FBillID,FBillNumber,FBizDate,FBillTypeID,FCreditAccountID,FUnOutPostBillAmt)");
        strSQL.append("SELECT t0.FCompanyID,t0.FCustomerID,t0.FBillID, t0.FBillNumber, t0.FBizDate, t0.FBillTypeID, '").append(this.getCreditAccount()).append("',").append(" SUM(case when abs(t1.FQty) - abs(t1.FShippedQty)<=0 then 0 ").append(" when t1.fqty > 0  ").append("  then to_decimal(to_decimal((t1.FQty - t1.FShippedQty) / t1.FQty,21,10) * t1.flocalAmount,19,4)  ").append(" when t1.fqty < 0  ").append("  then to_decimal(to_decimal((abs(t1.FQty) - abs(t1.FShippedQty)) / t1.FQty,21,10) * abs(t1.flocalAmount),19,4)  ").append("   else 0 end )*").append(5 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ").append(" FROM T_SD_PostRequisitionEntry t1 ").append(" INNER JOIN t_im_saleissueentry sie ON t1.FID=sie.FSourceBillEntryID").append(" INNER JOIN ").append(this.dataTempTable).append(" t0 ON sie.FID = t0.FSourceBillEntryID and t0.FIsReversed=1").append(" INNER JOIN T_BD_Customer t2 ON t1.FDeliveryCustomerID = t2.FID ").append(" WHERE t2.FIsCredited = 1 and t0.FIsCtrlPostBillAmount=1 AND t1.FBaseStatus = ").append(7).append(this.sp).append(" GROUP BY t0.FCompanyID,t0.FCustomerID,t0.FBillID, t0.FBillNumber, t0.FBizDate, t0.FBillTypeID ");
        DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
    }

    private void calcUnArBillOrderAmt4SIReturnUnClose(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)");
        strSQL.append("SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,t0.FReturnsCustomerID,tmp.FCreditAccountID,").append("  SUM(CASE WHEN t0.FConvertMode = 0 THEN ").append(" ROUND((t1.FQty - (case when t1.FReturnsQty>t1.FInvoicedQty and t1.FReturnsQty<=t1.FQty then t1.FReturnsQty  when t1.FReturnsQty<=t1.FInvoicedQty and t1.FReturnsQty<=t1.FQty then t1.FInvoicedQty end)) * t1.FTaxPrice * t0.FExchangeRate,ISNULL(tmp.FPrecision,4))*(case when t1.FReceiveDispatcherType=1 then 1 else -1 end) ").append(" ELSE ").append(" ROUND((t1.FQty - (case when t1.FReturnsQty>t1.FInvoicedQty and t1.FReturnsQty<=t1.FQty then t1.FReturnsQty  when t1.FReturnsQty<=t1.FInvoicedQty and t1.FReturnsQty<=t1.FQty then t1.FInvoicedQty end)) * t1.FTaxPrice / t0.FExchangeRate,ISNULL(tmp.FPrecision,4))*(case when t1.FReceiveDispatcherType=1 then 1 else -1 end) END)*(-1) AS locAmt ").append(" FROM T_SD_SaleReturns t0 ").append("  INNER JOIN T_SD_SaleReturnsEntry t1 ON  t0.FID = t1.FParentID ").append("  inner join ").append(this.dataTempTable).append(" tmp on tmp.").append(2 == bizAction.getValue() ? "FCoreBillEntryID" : "FSourceBillEntryID").append("=t1.FID ").append("  INNER JOIN T_BD_Customer t2 ON t0.FReturnsCustomerID = t2.FID").append(" WHERE t2.FIsCredited = 1 and tmp.FIsCtrlSaleOrderAmount=1 AND t0.FBizTypeID <> 'wIZPS7oOQaOl1CeE/8cZOSQHQ1w='").append(" AND t1.FBaseStatus = ").append(7).append(this.sp).append(2 == bizAction.getValue() ? " and tmp.FIsReversed=1 " : "").append(this.sp).append(" GROUP BY tmp.FCompanyID,t0.FReturnsCustomerID,tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
    }

    public void processCreditBalanceAtAudit() throws BOSException, EASBizException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("delete from ").append(this.dataTempTable).append(" where FIsCtrlSaleIssueAmount=0 and FIsCtrlPostBillAmount=0 and FIsCtrlSaleOrderAmount=0 ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        this.calcUnOutPostBillAmt(CreditOperationEnum.AUDIT, false);
        this.calcUnOutPostBillAmt(CreditOperationEnum.UNAUDIT, true);
        this.calcUnAuditIssuedAmt4SI("", CreditOperationEnum.AUDIT);
        this.calcUnArBillIssuedAmt4SI(CreditOperationEnum.AUDIT, "");
        this.calcUnArBillOrderAmt4SILess(CreditOperationEnum.AUDIT, "SALEORDER_AUTOCLOSE_LESS", this.getUnCtrlQtyWhereSql4SO());
        this.calcUnArBillOrderAmt4SIMore(CreditOperationEnum.AUDIT);
        this.calUnArBillOrderAmt4WriteOffSaleissue(CreditOperationEnum.AUDIT);
        this.calcUnArBillOrderAmt4SIReturn(CreditOperationEnum.AUDIT);
        this.calcUnArBillOrderAmt4SIReturnMore(CreditOperationEnum.AUDIT);
        this.calcUnArBillOrderAmt4SIReplenishReturn(CreditOperationEnum.AUDIT);
    }

    public void processCreditBalanceAtUnAudit() throws BOSException, EASBizException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("delete from ").append(this.dataTempTable).append(" where FIsCtrlSaleIssueAmount=0 and FIsCtrlPostBillAmount=0 and FIsCtrlSaleOrderAmount=0 ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        this.calcUnOutPostBillAmt(CreditOperationEnum.UNAUDIT, false);
        this.calcUnArBillOrderAmt4SIReturnUnClose(CreditOperationEnum.UNAUDIT);
        this.calcUnArBillIssuedAmt4SI(CreditOperationEnum.UNAUDIT, "");
        this.calcUnArBillOrderAmt4SILess(CreditOperationEnum.UNAUDIT, "SALEORDER_AUTOCLOSE_LESS", this.getUnCtrlQtyWhereSql4SO());
        this.calcUnArBillOrderAmt4SILess(CreditOperationEnum.UNAUDIT, "", this.getManulCloseWhereSql4SO());
        this.calcUnArBillOrderAmt4SIMore(CreditOperationEnum.UNAUDIT);
        this.calUnArBillOrderAmt4WriteOffSaleissue(CreditOperationEnum.UNAUDIT);
        this.calcUnArBillOrderAmt4SIReturn(CreditOperationEnum.UNAUDIT);
        this.calcUnArBillOrderAmt4SIReturnMore(CreditOperationEnum.UNAUDIT);
        this.calcUnArBillOrderAmt4SIReplenishReturn(CreditOperationEnum.UNAUDIT);
    }

    private void calUnArBillOrderAmt4NewSaleissue(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" update ").append(this.balanceTempTable).append(" set FUnArBillorderAmt = ").append(" SELECT ").append("sum(sOrderE.ftaxamount)*").append(2 == bizAction.getValue() ? "1" : "(-1)").append(" AS FAmt ").append(" from ").append(this.dataTempTable).append(" tmp ").append("INNER JOIN T_SD_SaleOrderEntry sOrderE ON  tmp.FCoreBillEntryID = sOrderE.FID  inner join T_SD_SaleOrder so on so.fid = sOrderE.FParentID ").append("Left join T_IM_RecIssueType riType on tmp.fritypeid = ritype.fid  ").append("where so.FIsSysBill=1  and riType.FBizDirection = 1 and funarbillissuedamt <>0");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    private void calcUnArBillIssuedAmt4SI(CreditOperationEnum bizAction, String condition) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillIssuedAmt)").append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0))*").append(2 == bizAction.getValue() ? "1" : "(-1)").append(" from ").append(this.dataTempTable).append(" where FIsCtrlSaleIssueAmount=1 ").append(condition).append(this.sp).append(" group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillIssuedAmt)").append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0))*").append(2 == bizAction.getValue() ? "1" : "(-1)").append(" from ").append(this.dataTempTable).append(" where FIsCtrlPostBillAmount=1 and FIsCtrlSaleIssueAmount=0 ").append(condition).append(this.sp).append(" group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    private void calcUnArBillOrderAmt4SIMore(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" insert into ").append(this.balanceTempTable);
        strSQL.append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FRemark,FRemark_l1,FRemark_l2,FRemark_l3,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)");
        strSQL.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,");
        strSQL.append("'").append(this.getResourceStr("OVER_SALEISSUE", this._ctx)).append("',");
        strSQL.append("'").append(this.getResourceStr("OVER_SALEISSUE", LocaleUtils.locale_en_US)).append("',");
        strSQL.append("'").append(this.getResourceStr("OVER_SALEISSUE", LocaleUtils.locale_zh_CN)).append("',");
        strSQL.append("'").append(this.getResourceStr("OVER_SALEISSUE", LocaleUtils.locale_zh_TW)).append("',");
        strSQL.append(" tmp.FCompanyID,tmp.FCustomerID,tmp.FCreditAccountID, ");
        strSQL.append("to_decimal(SUM(case when tmp.FIsReversed=1 and sOrderE.FTotalIssueQty<sOrderE.FQty and sOrderE.FTotalIssueQty+abs(tmp.FQty)>sOrderE.FQty and sOrderE.FLocalTaxAmount>0 ");
        strSQL.append(" then to_decimal(to_decimal(to_decimal(sOrderE.FLocalTaxAmount,19,4)/ to_decimal(sOrderE.FQty,21,8),21,8)*to_decimal(sOrderE.FQty-(sOrderE.FTotalIssueQty+abs(tmp.FQty)),21,8),21,8)");
        strSQL.append("when tmp.FIsReversed=1 and sOrderE.FTotalIssueQty>=sOrderE.FQty and sOrderE.FTotalIssueQty+abs(tmp.FQty)>sOrderE.FQty and sOrderE.FLocalTaxAmount>0 ");
        strSQL.append(" then to_decimal(to_decimal(to_decimal(sOrderE.FLocalTaxAmount,19,4)/ to_decimal(sOrderE.FQty,21,8),21,8)*to_decimal(tmp.FQty,21,8),21,8)");
        strSQL.append(" when tmp.FIsReversed=0 and sOrderE.FTotalIssueQty-tmp.FQty-sOrderE.FTotalCancellingStockQty>=sOrderE.FQty and sOrderE.FLocalTaxAmount>0 ");
        strSQL.append(" then to_decimal(to_decimal(to_decimal(sOrderE.FLocalTaxAmount,19,4) / to_decimal(sOrderE.FQty,21,8),21,8)*to_decimal(tmp.FQty,21,8),21,8)");
        strSQL.append(" when tmp.FIsReversed=0 and sOrderE.FTotalIssueQty-sOrderE.FTotalCancellingStockQty>sOrderE.FQty and sOrderE.FTotalIssueQty-tmp.FQty-sOrderE.FTotalCancellingStockQty<sOrderE.FQty and sOrderE.FLocalTaxAmount>0 ");
        strSQL.append(" then to_decimal(to_decimal(to_decimal(sOrderE.FLocalTaxAmount,19,4) / to_decimal(sOrderE.FQty,21,8),21,8)* to_decimal(sOrderE.FTotalIssueQty-sOrderE.FTotalCancellingStockQty-sOrderE.FQty,21,8),21,8) end ),19,4)*");
        strSQL.append(2 == bizAction.getValue() ? "1" : "(-1)").append("  AS FAmt");
        strSQL.append(" from ").append(this.dataTempTable).append(" tmp ");
        strSQL.append("  INNER JOIN T_SD_SaleOrderEntry sOrderE ON  tmp.FCoreBillEntryID = sOrderE.FID ");
        strSQL.append(" inner join T_SD_SaleOrder so on so.fid = sOrderE.FParentID").append(this.sp);
        strSQL.append(" Left join T_IM_RecIssueType riType on tmp.fritypeid = ritype.fid ").append(this.sp);
        strSQL.append(" where so.FIsSysBill=0 and tmp.FIsCtrlSaleOrderAmount=1 and riType.FBizDirection = 1 ");
        strSQL.append(" group by tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FCustomerID,tmp.FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
    }

    private void calcUnArBillOrderAmt4SIReturn(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)");
        strSQL.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FCustomerID,tmp.FCreditAccountID, to_decimal(SUM(CASE WHEN sOrderE.FQty = 0 ");
        strSQL.append(" THEN 0 ELSE to_decimal(to_decimal(to_decimal(sOrderE.FLocalTaxAmount,19,4) / to_decimal(sOrderE.FBaseQty,21,8),21,8)");
        strSQL.append("* to_decimal(tmp.FBaseQty,21,8),21,8) end ),19,4)*").append(2 == bizAction.getValue() ? "1" : "(-1)").append(" AS FAmt");
        strSQL.append(" from ").append(this.dataTempTable).append(" tmp ").append("  INNER JOIN T_SD_SaleOrderEntry sOrderE ON  tmp.fcorebillentryid = sOrderE.FID ").append(" inner join T_SD_SaleOrder so on so.fid = sOrderE.FParentID").append(this.sp).append(" left join T_IM_RecIssueType riType on tmp.fritypeid = ritype.fid ").append(this.sp).append(" where so.FIsSysBill=0 and tmp.FIsCtrlSaleOrderAmount=1 and riType.FBizDirection = -1").append(this.sp).append(" and tmp.FSourceBillTypeID='").append("50957179-0105-1000-e000-015bc0a812fd463ED552").append("'").append(this.sp).append(" and tmp.FBizTypeID <>'").append("wIZPS7oOQaOl1CeE/8cZOSQHQ1w=").append("'").append(this.sp).append(" group by tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FCustomerID,tmp.FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
    }

    private void calcUnArBillOrderAmt4SIReturnMore(CreditOperationEnum bizAction) throws BOSException {
        String tempTable = null;
        String tmpTable = null;
        try {
            StringBuffer createTempSql = new StringBuffer();
            createTempSql.append("CREATE TABLE T_TMP_TABLE ( ");
            createTempSql.append("FBillID varchar(44) NULL, FBillNumber nvarchar(80) NULL, ");
            createTempSql.append("FBillTypeID varchar(44) NULL, FBizDate DateTime,");
            createTempSql.append("FCompanyID varchar(44) NULL,");
            createTempSql.append("FCustomerID varchar(44) NULL,");
            createTempSql.append("FCreditAccountID varchar(44) NULL,");
            createTempSql.append("FAmt NUMERIC(28,10) DEFAULT 0)");
            tempTable = KsqlUtil.createTempTableWithNewTx((Context)this._ctx, (String)createTempSql.toString());
            createTempSql.setLength(0);
            createTempSql.append("CREATE TABLE T_TMP_TABLE ( ");
            createTempSql.append("FRQty NUMERIC(28,10) DEFAULT 0, FBillEntryID varchar(44) NULL, ");
            createTempSql.append("FIsReversed int, FBillID varchar(44) NULL,");
            createTempSql.append("FBillTypeID varchar(44) NULL,");
            createTempSql.append("FBillNumber nvarchar(80) NULL,");
            createTempSql.append("FBizDate DateTime,");
            createTempSql.append("FCompanyID varchar(44) NULL,");
            createTempSql.append("FCustomerID varchar(44) NULL,");
            createTempSql.append("FCreditAccountID varchar(44) NULL)");
            tmpTable = KsqlUtil.createTempTableWithNewTx((Context)this._ctx, (String)createTempSql.toString());
            StringBuffer strSQL = new StringBuffer();
            strSQL.append("insert into ").append(tmpTable).append(" (FRQty,FBillEntryID,FIsReversed,FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID)");
            strSQL.append(" select  sum(fqty) as FRQty,(case when FSourceBillTypeID='").append("50957179-0105-1000-e008-8152c0a812fd463ED552").append("' then FSourceBillEntryID else FCoreBillEntryID end) FBillEntryID,FIsReversed, ");
            strSQL.append(" FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID from ").append(this.dataTempTable).append(" where FIsCtrlSaleOrderAmount=1 and FBizTypeID <> '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' and ( FCoreBillTypeID='").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("' or FCoreBillTypeID='").append("50957179-0105-1000-e008-8152c0a812fd463ED552").append("')").append(this.sp);
            strSQL.append(" group by FSourceBillTypeID,FSourceBillEntryID,FCoreBillEntryID,FIsReversed,FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID ");
            DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
            strSQL.setLength(0);
            strSQL.append("insert into ").append(tempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FAmt) ");
            strSQL.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FCustomerID,tmp.FCreditAccountID, to_decimal(SUM(case ").append(this.sp).append(" when tmp.FIsReversed = 0 and sre.FQuantityUnctrl = 1  and sre.FQty < abs(sre.FReturnsQty) ").append(" then to_decimal(to_decimal(to_decimal(sre.FLocalTaxAmount,19,4)/ to_decimal(sre.FQty,21,8),21,8)*to_decimal(sre.FQty-abs(sre.FReturnsQty),21,8),21,8) ").append(this.sp).append(" when tmp.FIsReversed = 1 and sre.FQuantityUnctrl = 1  and sre.FQty < abs(tmp.FRQty) ").append(" then to_decimal(to_decimal(to_decimal(sre.FLocalTaxAmount,19,4)/ to_decimal(sre.FQty,21,8),21,8)*to_decimal(abs(tmp.FRQty)-(sre.FQty),21,8),21,8) ").append(this.sp).append(" end ),19,4)*(case when sre.FReceiveDispatcherType=1 then 1 else -1 end)*").append(2 == bizAction.getValue() ? "1" : "(-1)").append(" AS FAmt");
            strSQL.append(" from ").append(tmpTable).append(" as tmp").append(this.sp);
            strSQL.append(" inner join T_SD_SaleReturnsEntry sre ON  tmp.FBillEntryID = sre.Fid ").append(" group by tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FCustomerID,tmp.FCreditAccountID,sre.FReceiveDispatcherType");
            DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
            strSQL.setLength(0);
            strSQL.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)");
            strSQL.append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FAmt from ").append(tempTable);
            DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                TempTablePool.getInstance((Context)this._ctx).releaseTable(tempTable);
                TempTablePool.getInstance((Context)this._ctx).releaseTable(tmpTable);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)this._ctx).releaseTable(tempTable);
        TempTablePool.getInstance((Context)this._ctx).releaseTable(tmpTable);
    }

    private void calUnArBillOrderAmt4WriteOffSaleissue(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)");
        sqlStr.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FCustomerID,tmp.FCreditAccountID,");
        sqlStr.append(" SUM(ROUND(to_decimal(soe.FLocalTaxAmount/soe.FQty,21,10)*(");
        sqlStr.append(" Round(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision)),tmp.FPrecision))*");
        sqlStr.append(2 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
        sqlStr.append(" From T_SD_SaleOrderEntry soe inner join T_SD_SaleOrder so on so.fid=soe.fparentid ");
        sqlStr.append(" inner JOIN (SELECT dt.FCoreBillEntryID,dt.FUnitID,sum(wor.fcurrwrittenoffqty-wor1.fcurrwrittenoffqty) FBaseQty,");
        sqlStr.append(" dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FCustomerID,dt.FPrecision,dt.FCreditAccountID from ").append(this.dataTempTable);
        sqlStr.append(" as dt inner join t_cl_writeoffrecord wor on wor.fbillentryid = dt.FEntryID ");
        sqlStr.append(" inner join (select fparentid,sum(fcurrwrittenoffqty) as fcurrwrittenoffqty from t_cl_writeoffrecord where FBillTypeNumber='330' group by fparentid) wor1 on wor1.fparentid = wor.fparentid ");
        sqlStr.append(" group by dt.FCoreBillEntryID,dt.FUnitID,dt.FBillID,dt.FBillTypeID,dt.FBillNumber,dt.FBizDate,dt.FCompanyID,dt.FCustomerID,dt.FPrecision,dt.FCreditAccountID) tmp on tmp.FCoreBillEntryID=soe.FID");
        sqlStr.append(" INNER JOIN T_BD_Customer t2 ON tmp.FCustomerID = t2.FID");
        sqlStr.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON soe.FMaterialID = mmu.FMaterialID AND soe.FUnitID=mmu.FMeasureUnitID ");
        sqlStr.append(" WHERE  t2.FIsCredited = 1 AND isnull(so.fissysBill,0) = 0 ");
        sqlStr.append(" and ((so.FIsCentralBalance = 1 and so.FCompanyOrgUnitID=tmp.FCompanyID) or (so.FIsCentralBalance = 0 and soe.FCompanyOrgUnitID=tmp.FCompanyID)) ");
        sqlStr.append(" GROUP BY tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FCustomerID,tmp.FCreditAccountID ");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    private String getUnCtrlQtyWhereSql4SO() {
        String whereSql = " and t1.FQuantityUnCtrl=0 and isnull(t1.FSendOwingRate,0)<>0 and t1.FQty>t1.FTotalIssueQty and (1-isnull(t1.FSendOwingRate,0)/100)*t1.FQty<=t1.FTotalIssueQty";
        return whereSql;
    }

    private String getManulCloseWhereSql4SO() {
        String whereSql = " and tmp.FIsReversed=0 and t1.FQty>t1.FTotalIssueQty and (1-isnull(t1.FSendOwingRate,0)/100)*t1.FQty>t1.FTotalIssueQty";
        return whereSql;
    }

    private void calcUnArBillOrderAmt4SILess(CreditOperationEnum bizAction, String remarkKey, String whereSql) throws BOSException {
        String remark = "";
        String remark_l1 = "";
        String remark_l2 = "";
        String remark_l3 = "";
        if (remarkKey != null && !"".equals(remarkKey)) {
            remark_l1 = this.getResourceStr(remarkKey, LocaleUtils.locale_en_US);
            remark_l2 = this.getResourceStr(remarkKey, LocaleUtils.locale_zh_CN);
            remark_l3 = this.getResourceStr(remarkKey, LocaleUtils.locale_zh_TW);
            remark = this.getResourceStr(remarkKey, this._ctx.getLocale());
        }
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" insert into ").append(this.balanceTempTable);
        strSQL.append("(FBillID,FRemark,FRemark_l1,FRemark_l2,FRemark_l3,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)");
        strSQL.append(" SELECT tmp.FBillID,");
        strSQL.append("'").append(remark).append("',");
        strSQL.append("'").append(remark_l1).append("',");
        strSQL.append("'").append(remark_l2).append("',");
        strSQL.append("'").append(remark_l3).append("',");
        strSQL.append(" tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,t0.FCompanyOrgUnitID,t0.FOrderCustomerID,tmp.FCreditAccountID,");
        strSQL.append(" SUM(case when t1.fqty<=0 then 0 ").append(" when abs(t1.FQty) - abs(t1.FTotalReversedQty) - abs(t1.FTotalIssueQty)<=0 then 0 ");
        strSQL.append(" when abs(t1.FQty) - abs(t1.FTotalReversedQty) - abs(t1.FTotalInvoicedQty)<=0 then 0 ").append(" when abs(t1.FTotalIssueQty)>=abs(t1.FTotalInvoicedQty) ");
        strSQL.append(" then ROUND(to_decimal((t1.FQty - abs(t1.FTotalReversedQty) - t1.FTotalIssueQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,tmp.FPrecision) ");
        strSQL.append(" else ROUND(to_decimal((t1.FQty - abs(t1.FTotalReversedQty) - t1.FTotalInvoicedQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,tmp.FPrecision)  end )*");
        strSQL.append(2 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
        strSQL.append(" FROM T_SD_SaleOrder t0 ").append("  INNER JOIN T_SD_SaleOrderEntry t1 ON  t0.FID = t1.FParentID ");
        strSQL.append("  INNER JOIN T_BD_Customer t2 ON t0.FOrderCustomerID = t2.FID");
        strSQL.append("  inner join (SELECT distinct(FCoreBillEntryID) FCoreBillEntryID,FBillID,FBillTypeID,FBillNumber,FBizDate,FCreditAccountID,FPrecision,FIsCtrlSaleOrderAmount,FISREVERSED from  ").append(this.dataTempTable).append("  ) tmp on tmp.FCoreBillEntryID=t1.FID ");
        strSQL.append(" WHERE t0.FIsSysBill=0 and t1.FBaseStatus=").append(7).append(this.sp);
        strSQL.append(whereSql).append(this.sp);
        strSQL.append(" AND t0.FPaymentTypeID = '91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5' ").append(" AND (t1.FArClosedStatus is null or t1.FArClosedStatus = 0) ");
        strSQL.append(" AND t2.FIsCredited = 1 and tmp.FIsCtrlSaleOrderAmount=1 ");
        strSQL.append(" GROUP BY t0.FCompanyOrgUnitID,t0.FOrderCustomerID,tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCreditAccountID ");
        DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
    }

    private void calcUnOutPostBillAmt(CreditOperationEnum bizAction, boolean isReverse) throws BOSException, EASBizException {
        String sql = 2 == bizAction.getValue() ? "*(case when t0.FSourceBillTypeID='510b6503-0105-1000-e000-011bc0a812fd463ED552' then -1 else 1 end)" : "";
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnOutPostBillAmt)").append(" SELECT t3.FBillID,t3.FBillTypeID,t3.FBillNumber,t3.FBizDate, t3.FCompanyID, t1.FDeliveryCustomerID, ").append("t3.FCreditAccountID as FCreditAccountID, SUM(case when t1.FQty = 0 then 0 ").append(" when t3.FIsReversed=0 and abs(t1.FShippedQty)-abs(CASE WHEN t3.FUnitID=t1.FUnitID THEN t3.FQty ELSE t3.FQty*mmu2.FBaseConvsRate/mmu.FBaseConvsRate END)>=abs(t1.FQty) ").append("\tthen 0 ");
        if (2 == bizAction.getValue()) {
            strSQL.append(" when t3.FIsReversed=0 and abs(t1.FShippedQty)<=abs(t1.FQty) and t1.FBaseStatus <> 7");
        } else if (3 == bizAction.getValue()) {
            strSQL.append(" when t3.FIsReversed=0 and abs(t1.FShippedQty)<=abs(t1.FQty) and t1.FBaseStatus <> 7 ");
        }
        strSQL.append(" then ROUND(to_decimal(abs(CASE WHEN t3.FUnitID=t1.FUnitID THEN t3.FQty ELSE t3.FQty*mmu2.FBaseConvsRate/mmu.FBaseConvsRate END)*t1.FLocalAmount,19,4)/t1.FQty,t5.FPrecision)").append(sql).append(" when t3.FIsReversed=0 then ROUND(to_decimal((abs(t1.FQty)-(abs(t1.FShippedQty)-abs(CASE WHEN t3.FUnitID=t1.FUnitID THEN t3.FQty ELSE t3.FQty*mmu2.FBaseConvsRate/mmu.FBaseConvsRate END)))*t1.FLocalAmount,19,4)/t1.FQty,t5.FPrecision)").append(sql).append(" when t3.FIsReversed=1 and abs(t1.FShippedQty)>=abs(t1.FQty) then 0 ").append(" when t3.FIsReversed=1 and abs(t1.FShippedQty)+abs(CASE WHEN t3.FUnitID=t1.FUnitID THEN t3.FQty ELSE t3.FQty*mmu2.FBaseConvsRate/mmu.FBaseConvsRate END)<=abs(t1.FQty) ").append(" then ROUND(to_decimal(abs(CASE WHEN t3.FUnitID=t1.FUnitID THEN t3.FQty ELSE t3.FQty*mmu2.FBaseConvsRate/mmu.FBaseConvsRate END)*t1.FLocalAmount,19,4)/t1.FQty,t5.FPrecision)").append(sql).append(" when t3.FIsReversed=1 then ROUND(to_decimal((abs(t1.FQty)-abs(t1.FShippedQty))*t1.FLocalAmount,19,4)/t1.FQty,t5.FPrecision)").append(sql);
        strSQL.append(" end)*").append(2 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ").append(" FROM T_SD_PostRequisition t0 ").append(" INNER JOIN T_SD_PostRequisitionEntry t1 ON t0.FID = t1.FParentID ");
        if (isReverse) {
            strSQL.append(" INNER JOIN t_im_saleissueentry sie ON t1.FID=sie.FSourceBillEntryID").append(" INNER JOIN ").append(this.dataTempTable).append(" t3 ON sie.FID = t3.FSourceBillEntryID and t3.FIsReversed=1");
        } else {
            strSQL.append(" INNER JOIN ").append(this.dataTempTable).append(" T3 ON t1.FID = t3.FSourceBillEntryID ");
        }
        strSQL.append(" INNER JOIN T_BD_Customer t2 ON t1.FDeliveryCustomerID = t2.FID ").append("  INNER JOIN T_ORG_Company t4 ON t4.FID = t0.FcompanyOrgUnitId").append("  INNER JOIN T_BD_Currency t5 ON t5.FID = t4.FBaseCurrencyID").append(" LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=t1.FMaterialID AND mmu.FMeasureUnitID=t1.FUnitID ").append(" LEFT JOIN T_BD_MultiMeasureUnit mmu2 ON mmu2.FMaterialID=t1.FMaterialID AND mmu2.FMeasureUnitID=t3.FUnitID ").append(" WHERE t2.FIsCredited = 1 and t3.FIsCtrlPostBillAmount=1 GROUP BY t3.FCompanyID, t1.FDeliveryCustomerID,t3.FBillID,t3.FBillTypeID,t3.FBillNumber,t3.FBizDate,t3.FCreditAccountID ");
        DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
    }

    @Override
    public String getCreditAccount() {
        return "DawAAAAPiJDuN4KI";
    }

    @Override
    protected CreditFormulaSceneEnum getBillSecene() {
        return CreditFormulaSceneEnum.ISSUEDBILL;
    }

    public void processCreditBalanceAtAlter() throws BOSException, EASBizException {
        this.calcUnArBillIssuedAmt4SI(CreditOperationEnum.UNAUDIT, " AND FIsHistory=1 ");
        this.calcUnArBillIssuedAmt4SI(CreditOperationEnum.AUDIT, " and FIsHistory=0 ");
    }

    private void calcUnArBillOrderAmt4SIReplenishReturn(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)");
        strSQL.append(" SELECT tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FCustomerID,tmp.FCreditAccountID, to_decimal(SUM(CASE WHEN sOrderE.FQty = 0 ");
        strSQL.append(" THEN 0 ELSE to_decimal(to_decimal(to_decimal(sOrderE.FLocalTaxAmount,19,4) / to_decimal(sOrderE.FQty,21,8),21,8)");
        strSQL.append("* to_decimal(");
        strSQL.append("case when sOrderE.FTotalIssueQty - (sOrderE.FTotalCancellingStockQty - abs(tmp.FQty)) > sOrderE.FQty and sOrderE.FTotalIssueQty - sOrderE.FTotalCancellingStockQty > sOrderE.FQty then abs(tmp.FQty) ");
        strSQL.append(" when sOrderE.FTotalIssueQty - (sOrderE.FTotalCancellingStockQty - abs(tmp.FQty)) > sOrderE.FQty and sOrderE.FTotalIssueQty - sOrderE.FTotalCancellingStockQty <= sOrderE.FQty then ");
        strSQL.append(" sOrderE.FTotalIssueQty - (sOrderE.FTotalCancellingStockQty - abs(tmp.FQty)) - sOrderE.FQty ");
        strSQL.append(" when sOrderE.FTotalIssueQty - (sOrderE.FTotalCancellingStockQty - abs(tmp.FQty)) <= sOrderE.FQty then 0 else 0 end");
        strSQL.append(",21,8),21,8) end ),19,4)*").append(2 == bizAction.getValue() ? "(-1)" : "1").append(" AS FAmt");
        strSQL.append(" from ").append(this.dataTempTable).append(" tmp ").append("  INNER JOIN T_SD_SaleOrderEntry sOrderE ON  tmp.fcorebillentryid = sOrderE.FID ").append(" inner join T_SD_SaleOrder so on so.fid = sOrderE.FParentID").append(this.sp).append(" left join T_IM_RecIssueType riType on tmp.fritypeid = ritype.fid ").append(this.sp).append(" where so.FIsSysBill=0 and tmp.FIsCtrlSaleOrderAmount=1 and riType.FBizDirection = -1").append(this.sp).append(" and tmp.FSourceBillTypeID='").append("50957179-0105-1000-e000-015bc0a812fd463ED552").append("'").append(this.sp).append(" and tmp.FBizTypeID ='").append("wIZPS7oOQaOl1CeE/8cZOSQHQ1w=").append("'").append(this.sp).append(" group by tmp.FBillID,tmp.FBillTypeID,tmp.FBillNumber,tmp.FBizDate,tmp.FCompanyID,tmp.FCustomerID,tmp.FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
    }
}

