/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.app.balance.strategy.CreditUpdateBaseStrategy;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Map;

public class SaleOrderUpdateStrategy
extends CreditUpdateBaseStrategy {
    public SaleOrderUpdateStrategy(Context ctx, Map param) {
        super(ctx, param);
    }

    public void processCreditBalanceAtSubmit() throws BOSException, EASBizException {
        this.calcUnAuditSOAmt4SO(" and FIsHistory=1 and FBaseStatus=2 ");
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnAuditSOAmt)").append(this.sp).append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0)) from ").append(this.dataTempTable).append(" where FControlTime=").append(1).append(" and FIsHistory=0 group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    public void processCreditBalanceAtDelete() throws BOSException, EASBizException {
        this.calcUnAuditSOAmt4SO(" AND FBaseStatus=2 ");
    }

    public void processCreditBalanceAtDiscard() throws BOSException, EASBizException {
        this.calcUnAuditSOAmt4SO(" AND FBaseStatus=2 ");
    }

    private void calcUnAuditSOAmt4SO(String condition) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnAuditSOAmt)").append(this.sp).append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0))*(-1) from ").append(this.dataTempTable).append(" where FControlTime=").append(1).append(condition).append(" group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    public void processCreditBalanceAtAudit() throws BOSException, EASBizException {
        this.calcUnAuditSOAmt4SO("");
        this.calcUnArBillOrderAmt4SO(CreditOperationEnum.AUDIT, "");
    }

    public void processCreditBalanceAtUnAudit() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4SO(CreditOperationEnum.UNAUDIT, "");
    }

    public void processCreditBalanceAtAlter() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4SO(CreditOperationEnum.UNAUDIT, " where FIsHistory=1 ");
        this.calcUnArBillOrderAmt4SO(CreditOperationEnum.AUDIT, " where FIsHistory=0 ");
    }

    public void processCreditBalanceAtClose() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4SOClose(CreditOperationEnum.CLOSE);
    }

    public void processCreditBalanceAtUnClose() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4SOClose(CreditOperationEnum.UNCLOSE);
    }

    public void processCreditBalanceAtCloseAR() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4SOCloseAR(CreditOperationEnum.CLOSEAR);
    }

    public void processCreditBalanceAtUnCloseAR() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4SOCloseAR(CreditOperationEnum.UNCLOSEAR);
    }

    private void calcUnArBillOrderAmt4SO(CreditOperationEnum bizAction, String condition) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)").append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0))*").append(2 == bizAction.getValue() ? "1" : "(-1)").append(" from ").append(this.dataTempTable).append(this.sp).append(condition).append(this.sp).append(" group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    private void calcUnArBillOrderAmt4SOClose(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" insert into ").append(this.balanceTempTable).append("(FCompanyID,FCustomerID,FBillID,FBillNumber,FBizDate,FBillTypeID,FCreditAccountID,FUnArBillOrderAmt)");
        strSQL.append("SELECT t0.FCompanyID,t0.FCustomerID,t0.FBillID, t0.FBillNumber, t0.FBizDate, t0.FBillTypeID, '").append(this.getCreditAccount()).append("',").append(" SUM(case when t1.fqty<=0 then 0 ").append(" when abs(t1.FQty) - abs(t1.FTotalReversedQty) - abs(t1.FTotalIssueQty)<=0 then 0 ").append(" when abs(t1.FQty) - abs(t1.FTotalReversedQty) - abs(t1.FTotalInvoicedQty)<=0 then 0 ").append(" when abs(t1.FTotalIssueQty)>=abs(t1.FTotalInvoicedQty) ").append(" then ROUND(to_decimal((t1.FQty - abs(t1.FTotalReversedQty) - t1.FTotalIssueQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,t0.FPrecision) ").append(" else ROUND(to_decimal((t1.FQty - abs(t1.FTotalReversedQty) - t1.FTotalInvoicedQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,t0.FPrecision)  end )*").append(5 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ").append(" FROM T_SD_SaleOrderEntry t1 ").append("  INNER JOIN ").append(this.dataTempTable).append(" t0 on t0.FEntryID=t1.FID ").append(" WHERE (t1.FArClosedStatus is null or t1.FArClosedStatus = 0) ").append(" GROUP BY t0.FCompanyID,t0.FCustomerID,t0.FBillID, t0.FBillNumber, t0.FBizDate, t0.FBillTypeID ");
        DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
    }

    private void calcUnArBillOrderAmt4SOCloseAR(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" insert into ").append(this.balanceTempTable).append("(FCompanyID,FCustomerID,FBillID,FBillNumber,FBizDate,FBillTypeID,FCreditAccountID,FUnArBillOrderAmt)");
        strSQL.append("SELECT t0.FCompanyID,t0.FCustomerID,t0.FBillID, t0.FBillNumber, t0.FBizDate, t0.FBillTypeID, '").append(this.getCreditAccount()).append("',");
        strSQL.append(" SUM(case when t1.fqty<=0 then 0 ");
        strSQL.append(" when t1.FBaseStatus=7 and abs(t1.FTotalIssueQty)>=abs(t1.FTotalInvoicedQty) then ROUND(to_decimal((t1.FTotalIssueQty - t1.FTotalInvoicedQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,t0.FPrecision) ");
        strSQL.append(" when t1.FBaseStatus=7 then 0 ");
        strSQL.append(" when t1.FBaseStatus=4 and abs(t1.FTotalIssueQty)>=abs(t1.FQty) then  ROUND(to_decimal((t1.FTotalIssueQty - t1.FTotalInvoicedQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,t0.FPrecision) ");
        strSQL.append(" when t1.FBaseStatus=4 and abs(t1.FTotalIssueQty)<abs(t1.FQty) then ROUND(to_decimal((t1.FQty - t1.FTotalInvoicedQty) / t1.FQty,21,10) * t1.FLocalTaxAmount,t0.FPrecision) ");
        strSQL.append(" else 0  end )*").append(9 == bizAction.getValue() ? "(-1)" : "1").append(" AS locAmt ");
        strSQL.append(" FROM T_SD_SaleOrderEntry t1 ");
        strSQL.append("  INNER JOIN ").append(this.dataTempTable).append(" t0 on t0.FEntryID=t1.FID ");
        strSQL.append(" GROUP BY t0.FCompanyID,t0.FCustomerID,t0.FBillID, t0.FBillNumber, t0.FBizDate, t0.FBillTypeID ");
        DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
    }

    @Override
    public void deleteUnCtrlData() throws BOSException, EASBizException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("delete from ").append(this.dataTempTable).append(" where FIsCtrlSaleOrderAmount=0");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    @Override
    protected CreditFormulaSceneEnum getBillSecene() {
        return CreditFormulaSceneEnum.ORDER;
    }

    @Override
    public String getCreditAccount() {
        return "DawAAAAPiJDuN4KI";
    }
}

