/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.app.balance.strategy.CreditUpdateBaseStrategy;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Map;

public class SaleReturnsUpdateStrategy
extends CreditUpdateBaseStrategy {
    public SaleReturnsUpdateStrategy(Context ctx, Map param) {
        super(ctx, param);
    }

    public void processCreditBalanceAtSubmit() throws BOSException, EASBizException {
        this.calcUnAuditSOAmt4SR(" and FIsHistory=1 and FBaseStatus=2 ", CreditOperationEnum.DELETE);
        this.calcUnAuditSOAmt4SR(" and FIsHistory=0 ", CreditOperationEnum.SUBMIT);
    }

    public void processCreditBalanceAtDelete() throws BOSException, EASBizException {
        this.calcUnAuditSOAmt4SR(" and FBaseStatus=2 ", CreditOperationEnum.DELETE);
    }

    public void processCreditBalanceAtDiscard() throws BOSException, EASBizException {
        this.calcUnAuditSOAmt4SR(" and FBaseStatus=2 ", CreditOperationEnum.DELETE);
    }

    public void processCreditBalanceAtAudit() throws BOSException, EASBizException {
        this.calcUnAuditSOAmt4SR("", CreditOperationEnum.AUDIT);
        this.calcUnArBillOrderAmt4SR(CreditOperationEnum.AUDIT);
    }

    public void processCreditBalanceAtUnAudit() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4SR(CreditOperationEnum.UNAUDIT);
    }

    private void calcUnAuditSOAmt4SR(String condition, CreditOperationEnum bizAction) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnAuditSOAmt)").append(this.sp).append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0))*").append(1 == bizAction.getValue() ? "(-1)" : "1").append(" from ").append(this.dataTempTable).append(this.sp).append(" where FControlTime=").append(1).append(condition).append(this.sp).append(" group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    private void calcUnArBillOrderAmt4SR(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" insert into ").append(this.balanceTempTable).append("(FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,FUnArBillOrderAmt)").append(" select FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID,sum(isnull(FLocalAmount,0))*").append(2 == bizAction.getValue() ? "(-1)" : "1").append(" from ").append(this.dataTempTable).append(" group by FBillID,FBillTypeID,FBillNumber,FBizDate,FCompanyID,FCustomerID,FCreditAccountID");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    public void processCreditBalanceAtClose() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4SRClose(CreditOperationEnum.CLOSE);
    }

    public void processCreditBalanceAtUnClose() throws BOSException, EASBizException {
        this.calcUnArBillOrderAmt4SRClose(CreditOperationEnum.UNCLOSE);
    }

    private void calcUnArBillOrderAmt4SRClose(CreditOperationEnum bizAction) throws BOSException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" insert into ").append(this.balanceTempTable).append("(FCompanyID,FCustomerID,FBillID,FBillNumber,FBizDate,FBillTypeID,FCreditAccountID,FUnArBillOrderAmt)");
        strSQL.append("SELECT t0.FCompanyID,t0.FCustomerID,t0.FBillID, t0.FBillNumber, t0.FBizDate, t0.FBillTypeID, '").append(this.getCreditAccount()).append("',").append("  SUM(CASE WHEN t0.FConvertMode = 0 THEN ").append(" ROUND((t1.FQty - (case when t1.FReturnsQty>t1.FInvoicedQty and t1.FReturnsQty<=t1.FQty then t1.FReturnsQty  when t1.FReturnsQty<=t1.FInvoicedQty and t1.FReturnsQty<=t1.FQty then t1.FInvoicedQty end)) * t1.FTaxPrice * t0.FExchangeRate,ISNULL(t0.FPrecision,4))*(case when t1.FReceiveDispatcherType=1 then 1 else -1 end) ").append(" ELSE ").append(" ROUND((t1.FQty - (case when t1.FReturnsQty>t1.FInvoicedQty and t1.FReturnsQty<=t1.FQty then t1.FReturnsQty  when t1.FReturnsQty<=t1.FInvoicedQty and t1.FReturnsQty<=t1.FQty then t1.FInvoicedQty end)) * t1.FTaxPrice / t0.FExchangeRate,ISNULL(t0.FPrecision,4))*(case when t1.FReceiveDispatcherType=1 then 1 else -1 end) END)*").append(5 == bizAction.getValue() ? "1" : "(-1)").append(" AS locAmt  ").append(" FROM T_SD_SaleReturnsEntry t1 ").append("  INNER JOIN ").append(this.dataTempTable).append(" t0 on t0.FEntryID=t1.FID ").append(" where t1.FBaseStatus = ").append(7).append(" GROUP BY t0.FCompanyID,t0.FCustomerID,t0.FBillID, t0.FBillNumber, t0.FBizDate, t0.FBillTypeID ");
        DbUtil.execute((Context)this._ctx, (String)strSQL.toString());
    }

    @Override
    public void deleteUnCtrlData() throws BOSException, EASBizException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("delete from ").append(this.dataTempTable).append(" where FIsCtrlSaleOrderAmount=0 or FBizTypeID='").append("wIZPS7oOQaOl1CeE/8cZOSQHQ1w=").append("'");
        DbUtil.execute((Context)this._ctx, (String)sqlStr.toString());
    }

    @Override
    protected CreditFormulaSceneEnum getBillSecene() {
        return CreditFormulaSceneEnum.SALERETURN;
    }

    @Override
    public String getCreditAccount() {
        return "DawAAAAPiJDuN4KI";
    }
}

