/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CreditExProcessor {
    protected Context _ctx = null;
    private String _companyID;
    private String _customerID;
    private String _updateField;
    private BigDecimal _amount;

    public CreditExProcessor(Context ctx) {
        this._ctx = ctx;
    }

    public String getCreditAccount() {
        return "DawAAAAPiJDuN4KI";
    }

    public boolean isStartCreditLog() {
        return true;
    }

    public void udpateBalance(String companyID, String customerID, String updateField, BigDecimal amount) throws BOSException, EASBizException {
        if (!this.isNeedUpdateCreditBalance()) {
            return;
        }
        this._companyID = companyID;
        this._customerID = customerID;
        this._updateField = updateField;
        this._amount = amount;
        try {
            String strSQL = null;
            ArrayList params = new ArrayList();
            if (this.isExistsBalanceRecord()) {
                String lockSql = "update T_SD_CreditBalance set FID = FID Where FCompanyID = ? And FCustomerID =? and FCreditAccountID = ?";
                DbUtil.execute((Context)this._ctx, (String)lockSql, (Object[])new Object[]{this._companyID, this._customerID, this.getCreditAccount()});
                strSQL = this.getUpdateBalanceSQLString(params);
            } else {
                strSQL = this.getInsertBalanceSQLString(params);
            }
            DbUtil.execute((Context)this._ctx, (String)strSQL, (Object[])params.toArray());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private boolean isExistsBalanceRecord() throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)this._ctx, (String)"Select FID From T_SD_CreditBalance Where FCompanyID = ? And FCustomerID = ? and FCreditAccountID = ? ", (Object[])new Object[]{this._companyID, this._customerID, this.getCreditAccount()});
        return rs != null && rs.next();
    }

    protected String getUpdateBalanceSQLString(List params) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Update T_SD_CreditBalance Set ").append(this._updateField).append(" = ").append(this._updateField).append(" + ? ").append(" Where FCompanyID = ? And FCustomerID = ? And FCreditAccountID = ? ");
        params.add(this._amount);
        params.add(this._companyID);
        params.add(this._customerID);
        params.add(this.getCreditAccount());
        return strSQL.toString();
    }

    protected String getInsertBalanceSQLString(List params) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Insert Into T_SD_CreditBalance(FID,FCreditAccountID,FCompanyID,FCustomerID,").append(this._updateField).append(") ").append(" Values(?,?,?,?) ");
        params.add(BOSUuid.create((String)"12D4D072").toString());
        params.add(this.getCreditAccount());
        params.add(this._companyID);
        params.add(this._customerID);
        params.add(this._amount);
        return strSQL.toString();
    }

    private boolean isNeedUpdateCreditBalance() throws BOSException, EASBizException {
        boolean isNeed = false;
        CustomerInfo customer = new CustomerInfo();
        customer.setId(BOSUuid.read((String)this._customerID));
        customer = CreditUtils.readFullCustomerInfo(this._ctx, customer);
        CreditParamInfo param = CreditServerUtil.getCreditParamInfo(this._ctx, this._companyID);
        if (param != null && param.isCompnayCredited()) {
            isNeed = customer.isIsCredited();
        }
        return isNeed;
    }
}

