/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.app.balance.command.CreditBaseCommand;
import com.kingdee.eas.scm.credit.app.balance.strategy.CreditUpdateBaseStrategy;
import com.kingdee.eas.scm.credit.app.processor.CreditUpdateHelper;
import com.kingdee.eas.scm.credit.app.processor.CreditUpdateInvoker;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class CreditGeneralProcessor {
    public static void process(Context ctx, Object[] pks, IRowSet rs, CreditOperationEnum bizAction) throws BOSException, EASBizException {
        if (pks[0] == null || pks[0].toString().equals(null)) {
            return;
        }
        BOSObjectType objType = BOSUuid.getBOSObjectType((String)pks[0].toString(), (boolean)true);
        if (objType == null || bizAction == null) {
            return;
        }
        String bosType = CreditUpdateHelper.getBosType(objType);
        String prefix = "billEntry";
        if (objType.toString().equals(bosType)) {
            prefix = "bill";
        }
        String tableName = CreditUpdateHelper.init(ctx, pks, prefix, bosType);
        if (rs != null && rs.size() > 0) {
            if (tableName == null || tableName.trim().length() < 1) {
                tableName = CreditUpdateHelper.createTempTable4Data(ctx);
            }
            CreditGeneralProcessor.insertPreData(ctx, rs, tableName);
        }
        if (tableName == null || tableName.trim().length() < 1) {
            return;
        }
        String className = CreditUpdateHelper.getStrategy(bosType);
        String commandName = CreditUpdateHelper.getCommand(bizAction.getValue());
        if (className == null || className.trim().length() < 1 || commandName == null || commandName.trim().length() < 1) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bizAction", (Object)bizAction);
        paramMap.put("bosType", bosType);
        paramMap.put("tableName", tableName);
        CreditUpdateBaseStrategy strategy = null;
        try {
            Class<?> classObj = Class.forName(className);
            Constructor<?> constructor = classObj.getConstructor(Context.class, Map.class);
            strategy = (CreditUpdateBaseStrategy)constructor.newInstance(ctx, paramMap);
            strategy.preProcess();
            strategy.preCheck();
            classObj = Class.forName(commandName);
            constructor = classObj.getConstructor(CreditUpdateBaseStrategy.class);
            CreditBaseCommand command = (CreditBaseCommand)constructor.newInstance(strategy);
            CreditUpdateInvoker invoker = new CreditUpdateInvoker(command);
            invoker.executeCreditBalanceUpdate();
            strategy.endProcess();
        }
        catch (IllegalArgumentException e) {
            Logger.error((Throwable)e);
            throw new BOSException("class name : " + className + " command name:" + commandName);
        }
        catch (IllegalAccessException e) {
            Logger.error((Throwable)e);
            throw new BOSException("class name : " + className + " command name:" + commandName);
        }
        catch (NoSuchMethodException e) {
            Logger.error((Throwable)e);
            throw new BOSException("class name : " + className + " command name:" + commandName);
        }
        catch (InstantiationException e) {
            Logger.error((Throwable)e);
            throw new BOSException("class name : " + className + " command name:" + commandName);
        }
        catch (ClassNotFoundException e) {
            Logger.error((Throwable)e);
            throw new BOSException("class name : " + className + " command name:" + commandName);
        }
        catch (SecurityException e) {
            Logger.error((Throwable)e);
            throw new BOSException("class name : " + className + " command name:" + commandName);
        }
        catch (InvocationTargetException e) {
            Logger.error((Throwable)e);
            throw new BOSException("class name : " + className + " command name:" + commandName);
        }
        finally {
            if (strategy != null) {
                strategy.releaseTable();
            }
        }
    }

    private static void insertPreData(Context ctx, IRowSet rs, String tableName) throws BOSException, EASBizException {
        if (rs == null || rs.size() < 1) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement psInsert = null;
        int preInsert = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            psInsert = conn.prepareStatement(CreditUpdateHelper.getInsertSqlStr(tableName).append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ").toString());
            while (rs.next()) {
                psInsert.setInt(1, 1);
                psInsert.setString(2, rs.getString("FBillID"));
                psInsert.setString(3, rs.getString("FEntryID"));
                psInsert.setString(4, rs.getString("FBillNumber"));
                psInsert.setString(5, rs.getString("FBillTypeID"));
                psInsert.setDate(6, rs.getDate("FBizDate"));
                psInsert.setString(7, rs.getString("FBizTypeID"));
                psInsert.setString(8, rs.getString("FCompanyID"));
                psInsert.setString(9, rs.getString("FCustomerID"));
                psInsert.setString(10, rs.getString("FOrderCustomerID"));
                psInsert.setString(11, rs.getString("FServiceCustomerID"));
                psInsert.setString(12, rs.getString("FPaymentTypeID"));
                psInsert.setString(13, rs.getString("FTransactionTypeID"));
                psInsert.setString(14, rs.getString("FRITypeID"));
                psInsert.setInt(15, rs.getInt("FIsCenterBalance"));
                psInsert.setInt(16, rs.getInt("FBaseStatus"));
                psInsert.setInt(17, rs.getInt("FConvertMode"));
                psInsert.setBigDecimal(18, rs.getBigDecimal("FExchangeRate"));
                psInsert.setBigDecimal(19, rs.getBigDecimal("FLocalAmount"));
                psInsert.setBigDecimal(20, rs.getBigDecimal("FQty"));
                psInsert.setBigDecimal(21, rs.getBigDecimal("FBaseQty"));
                psInsert.setBigDecimal(22, rs.getBigDecimal("FPrice"));
                psInsert.setString(23, rs.getString("FSourceBillTypeID"));
                psInsert.setString(24, rs.getString("FSourceBillEntryID"));
                psInsert.setString(25, rs.getString("FSourceBillID"));
                psInsert.setString(26, rs.getString("FCoreBillTypeID"));
                psInsert.setString(27, rs.getString("FCoreBillEntryID"));
                psInsert.setString(28, rs.getString("FCoreBillID"));
                psInsert.setInt(29, rs.getInt("FIsReversed"));
                psInsert.setString(30, rs.getString("FUnitID"));
                psInsert.setInt(31, rs.getInt("FPrecision"));
                psInsert.setString(32, rs.getString("FCreditAccountID"));
                psInsert.addBatch();
                ++preInsert;
            }
            if (preInsert > 0) {
                psInsert.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(psInsert);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)psInsert);
    }
}

