/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.app.balance.command.CreditAlterCommand;
import com.kingdee.eas.scm.credit.app.balance.command.CreditAuditCommand;
import com.kingdee.eas.scm.credit.app.balance.command.CreditCloseARCommand;
import com.kingdee.eas.scm.credit.app.balance.command.CreditCloseCommand;
import com.kingdee.eas.scm.credit.app.balance.command.CreditDeleteCommand;
import com.kingdee.eas.scm.credit.app.balance.command.CreditDiscardCommand;
import com.kingdee.eas.scm.credit.app.balance.command.CreditManualUnWriteOffCommand;
import com.kingdee.eas.scm.credit.app.balance.command.CreditManualWriteOffCommand;
import com.kingdee.eas.scm.credit.app.balance.command.CreditSubmitCommand;
import com.kingdee.eas.scm.credit.app.balance.command.CreditUnAuditCommand;
import com.kingdee.eas.scm.credit.app.balance.command.CreditUnCloseARCommand;
import com.kingdee.eas.scm.credit.app.balance.command.CreditUnCloseCommand;
import com.kingdee.eas.scm.credit.app.balance.strategy.NetOrderUpdateStrategy;
import com.kingdee.eas.scm.credit.app.balance.strategy.PostRequisitionUpdateStrategy;
import com.kingdee.eas.scm.credit.app.balance.strategy.ReceivableUpdateStrategy;
import com.kingdee.eas.scm.credit.app.balance.strategy.SaleIssueUpdateStrategy;
import com.kingdee.eas.scm.credit.app.balance.strategy.SaleOrderUpdateStrategy;
import com.kingdee.eas.scm.credit.app.balance.strategy.SaleReturnsUpdateStrategy;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class CreditUpdateHelper {
    public static final String NORMAL_CREDITACCOUNT_ID = "DawAAAAPiJDuN4KI";
    public static final String NETORDER_BILLTYPENO = "271";
    public static final String CREDITBALANCE_BOSTYPE = "12D4D072";
    public static final String CREDITLOG_BOSTYPE = "CFCE011F";
    public static final String KEY_BOSTYPE = "bosType";
    public static final String KEY_BIZACTION = "bizAction";
    public static final String KEY_TABLE_NAME = "tableName";
    public static final String sp = " \r\n";
    public static final String PREFIX_HEAD = "bill";
    public static final String PREFIX_ENTRY = "billEntry";
    public static final String ARBILLCTRL = "arBillCtrl";
    private static final Map strategyMap = new HashMap();
    private static final Map commandMap = new HashMap();
    private static final Map selectSqlMap = new HashMap();

    public static String getStrategy(String bosType) {
        return strategyMap.get(bosType) != null ? strategyMap.get(bosType).toString() : null;
    }

    public static String getCommand(int bizAction) {
        return commandMap.get(String.valueOf(bizAction)) != null ? commandMap.get(String.valueOf(bizAction)).toString() : null;
    }

    public static String getContiditon(Object[] ids, String prefix) {
        if (CreditUpdateHelper.isEmpty(ids)) {
            return "";
        }
        StringBuffer idStr = new StringBuffer();
        idStr.append(" AND ").append(prefix).append(".FID in(").append(CreditUpdateHelper.getStringFromArr(ids, ",", true)).append(")");
        return idStr.toString();
    }

    public static String getStringFromArr(Object[] ids, String delim, boolean hasQuotationMask) {
        if (CreditUpdateHelper.isEmpty(ids) || CreditUpdateHelper.isEmpty(delim)) {
            return "";
        }
        StringBuffer sb = new StringBuffer(30);
        int len = ids.length;
        for (int i = 0; i < len; ++i) {
            sb.append(CreditUpdateHelper.connectString(ids[i].toString(), delim, hasQuotationMask));
        }
        if (sb.length() > 0) {
            sb.delete(0, delim.length());
        }
        return sb.toString();
    }

    public static boolean isEmpty(Object[] arr) {
        return null == arr || arr.length == 0;
    }

    public static boolean isEmpty(String str) {
        return null == str || str.trim().length() == 0;
    }

    public static String connectString(String id, String delim, boolean hasQuotationMask) {
        return delim + (hasQuotationMask ? "'" + id + "'" : id);
    }

    public static String init(Context ctx, Object[] ids, String prefix, String bosType) throws BOSException, EASBizException {
        if (CreditUpdateHelper.isEmpty(ids)) {
            return null;
        }
        StringBuffer sqlStr = new StringBuffer();
        String condition = CreditUpdateHelper.getContiditon(ids, prefix);
        sqlStr.append(selectSqlMap.get(bosType)).append(condition);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        try {
            if (rowSet.next()) {
                String tableName = CreditUpdateHelper.createTempTable4Data(ctx);
                DbUtil.execute((Context)ctx, (String)CreditUpdateHelper.getInsertSqlStr(tableName).append(sqlStr).toString());
                return tableName;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    public static IRowSet getPreUpdateData(Context ctx, Object[] ids) throws BOSException, EASBizException {
        if (CreditUpdateHelper.isEmpty(ids)) {
            return null;
        }
        BOSObjectType obj = BOSUuid.getBOSObjectType((String)ids[0].toString(), (boolean)true);
        if (obj == null) {
            return null;
        }
        String bosType = CreditUpdateHelper.getBosType(obj);
        String prefix = PREFIX_ENTRY;
        if (obj.toString().equals(bosType)) {
            prefix = PREFIX_HEAD;
        }
        StringBuffer sqlStr = new StringBuffer();
        String condition = CreditUpdateHelper.getContiditon(ids, prefix);
        sqlStr.append(selectSqlMap.get(bosType)).append(condition);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        return rowSet;
    }

    public static String getBosType(BOSObjectType obj) {
        String bosType = obj.toString();
        if ("88882A58".equals(bosType)) {
            bosType = "C48A423A";
        } else if ("CCFD4923".equals(bosType)) {
            bosType = "9CA9D08F";
        } else if ("164C6483".equals(bosType)) {
            bosType = "546F192F";
        } else if ("BBC07FBE".equals(bosType)) {
            bosType = "CC3E933B";
        } else if ("BC91693F".equals(bosType)) {
            bosType = "FC910EF3";
        } else if ("C75E503B".equals(bosType)) {
            bosType = "C2D6BA77";
        }
        return bosType;
    }

    public static String createTempTable4Data(Context ctx) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("CREATE TABLE T_TMP_CREDITBALANCEDATA ( ");
        strSQL.append("FIsHistory INT, FControlTime INT, FControlMethod INT, ");
        strSQL.append("FIsCtrlSaleOrderAmount INT, FIsCtrlPostBillAmount INT, FIsCtrlSaleIssueAmount INT,FIsCtrlARAmount INT,");
        strSQL.append("FBillID varchar(44) NULL, FEntryID varchar(44) NULL, FBillNumber nvarchar(80) NULL, ");
        strSQL.append("FBillTypeID varchar(44) NULL, FBizDate DateTime, FBizTypeID varchar(44) NULL,");
        strSQL.append("FCompanyID varchar(44) NULL,");
        strSQL.append("FCustomerID varchar(44) NULL,");
        strSQL.append("FOrderCustomerID varchar(44) NULL,");
        strSQL.append("FServiceCustomerID varchar(44) NULL,");
        strSQL.append("FPaymentTypeID varchar(44) NULL, FTransactionTypeID varchar(44) NULL, FRITypeID varchar(44) NULL,");
        strSQL.append("FIsCenterBalance INT, FBaseStatus INT, FIsReversed INT,");
        strSQL.append("FLocalAmount NUMERIC(28,10) DEFAULT 0, FQty NUMERIC(28,10) DEFAULT 0, FBaseQty NUMERIC(28,10) DEFAULT 0,");
        strSQL.append("FUnitID varchar(44) NULL, FConvertMode INT, FExchangeRate NUMERIC(28,10) DEFAULT 0, FPrecision INT,");
        strSQL.append("FPrice NUMERIC(28,10) DEFAULT 0,");
        strSQL.append("FSourceBillTypeID varchar(44) NULL, FSourceBillEntryID varchar(44) NULL, FSourceBillID varchar(44) NULL,");
        strSQL.append("FCoreBillTypeID varchar(44) NULL, FCoreBillEntryID varchar(44) NULL, FCoreBillID varchar(44) NULL,");
        strSQL.append("FCreditAccountID varchar(44) NULL, FCreditOperation INT, FOperateTime DateTime, FRemark nvarchar(80) NULL)");
        try {
            return KsqlUtil.createTempTableWithNewTx((Context)ctx, (String)strSQL.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String getSelectSql4SaleOrder() {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select 0,bill.fid         FBillID,").append(sp).append("       billEntry.fid        FEntryID,").append(sp).append("       bill.fnumber     FBillNumber,").append(sp).append("       bill.fbilltypeid FBillTypeID,").append(sp).append("       bill.fbizdate    FBizDate,").append(sp).append("       bill.fbiztypeid          FBizTypeID,").append(sp).append("       bill.fcompanyorgunitid   FCompanyID,").append(sp).append("       bill.fordercustomerid    FCustomerID,").append(sp).append("       null as FOrderCustomerID, null as FServiceCustomerID, ").append(sp).append("       bill.fpaymenttypeid      FPaymentTypeID,").append(sp).append("       null as FTransactionTypeID, null as FRITypeID, 0 as FIsCenterBalance,").append(sp).append("       billEntry.fbasestatus         FBaseStatus,").append(sp).append("       0 as FConvertMode, 0 as FExchangeRate,").append(sp).append(" \t\tbillEntry.flocaltaxamount    FLocalAmount,").append(sp).append("       billEntry.fqty               FQty,").append(sp).append("       billEntry.FBaseQty           FBaseQty,").append(sp).append("       to_decimal(to_decimal(to_decimal(billEntry.FLocalTaxAmount,19,4) / to_decimal(billEntry.FQty,21,8),21,8),21,8) FPrice,").append(sp).append("       billEntry.fsourcebilltypeid  FSourceBillTypeID,").append(sp).append("       billEntry.fsourcebillentryid FSourceBillEntryID,").append(sp).append("       billEntry.fsourcebillid      FSourceBillID,").append(sp).append("       null as FCoreBillTypeID, null as FCoreBillEntryID, null as FCoreBillID,").append(sp).append("       bill.fisreverse FIsReversed,").append(sp).append("       billEntry.funitid FUnitID,").append(sp).append("       t4.FPrecision FPrecision,  ").append(sp).append("'").append(NORMAL_CREDITACCOUNT_ID).append("' as FCreditAccountID").append(sp).append("       from t_sd_saleorder bill").append(sp).append("       inner join t_sd_saleorderentry billEntry on billEntry.fparentid = bill.fid").append(sp).append("       inner JOIN T_BD_Customer cust on cust.fid = bill.fordercustomerid ").append(sp).append("       INNER JOIN T_ORG_Company t3 ON t3.FID = bill.fcompanyorgunitid").append(sp).append("       INNER JOIN T_BD_Currency t4 ON t4.FID = t3.FBaseCurrencyID").append(sp).append(" WHERE bill.FPaymentTypeID='").append("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5").append("' AND cust.FIsCredited=1 and ISNULL(billEntry.FQty,0)<>0 ");
        return sqlStr.toString();
    }

    private static String getSelectSql4NetOrder() {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select 0,bill.fid       FBillID,").append(sp).append("       billEntry.fid          FEntryID,").append(sp).append("       bill.fnumber           FBillNumber,").append(sp).append("       bill.fbilltypeid       FBillTypeID,").append(sp).append("       bill.fbizdate          FBizDate,").append(sp).append("       bill.fbiztypeid        FBizTypeID,").append(sp).append("       bill.fcompanyorgunitid FCompanyID,").append(sp).append("       bill.fcustomerid       FCustomerID,").append(sp).append("       null as FOrderCustomerID, null as FServiceCustomerID, ").append(sp).append("'").append("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5").append("' as FPaymentTypeID,").append(sp).append("       null as FTransactionTypeID, null as FRITypeID, 0 as FIsCenterBalance,").append(sp).append("       billEntry.FEntryStatus FBaseStatus,").append(sp).append("       0 as FConvertMode, 0 as FExchangeRate,").append(sp).append("       CASE WHEN billEntry.FEntryStatus = 8 THEN billEntry.FApproveAmount ELSE billEntry.FAmount END FLocalAmount,").append(sp).append("       CASE WHEN billEntry.FEntryStatus = 8 THEN billEntry.fapproveqty  ELSE billEntry.FQty END FQty,").append(sp).append("       0 as FBaseQty,").append(sp).append("       CASE WHEN billEntry.FEntryStatus = 8 THEN billEntry.fapproveprice ELSE billEntry.FPrice END FPrice,").append(sp).append("       null as  FSourceBillTypeID,").append(sp).append("       null as  FSourceBillEntryID,").append(sp).append("       null as  FSourceBillID,").append(sp).append("       null as FCoreBillTypeID, null as FCoreBillEntryID, null as FCoreBillID,").append(sp).append("       0 as FIsReversed,").append(sp).append("       null as  FUnitID,").append(sp).append("       0 as FPrecision,  ").append(sp).append("'").append(NORMAL_CREDITACCOUNT_ID).append("' as FCreditAccountID").append(sp).append("  from t_cha_netorderbill bill").append(sp).append(" inner join t_cha_netorderbillentry billEntry on billEntry.fparentid = bill.fid").append(sp).append(" inner JOIN T_BD_Customer cust on cust.fid = bill.fcustomerid").append(sp).append(" WHERE cust.FIsCredited=1 ");
        return sqlStr.toString();
    }

    private static String getSelectSql4PostRequisition() {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select 0,bill.fid         FBillID,").append(sp).append("       billEntry.fid            FEntryID,").append(sp).append("       bill.fnumber             FBillNumber,").append(sp).append("       bill.fbilltypeid         FBillTypeID,").append(sp).append("       bill.fbizdate            FBizDate,").append(sp).append("       bill.fbiztypeid          FBizTypeID,").append(sp).append("       orgRe.FToUnitID        FCompanyID,").append(sp).append("       cust.fid               FCustomerID,").append(sp).append("       null as FOrderCustomerID, null as FServiceCustomerID, ").append(sp).append("       bill.fpaymenttypeid      FPaymentTypeID,").append(sp).append("       null as FTransactionTypeID, null as FRITypeID, 0 as FIsCenterBalance,").append(sp).append("       billEntry.fbasestatus         FBaseStatus,").append(sp).append("       0 as FConvertMode, 0 as FExchangeRate,").append(sp).append("       billEntry.flocalamount       FLocalAmount,").append(sp).append("       billEntry.fqty               FQty,").append(sp).append("       billEntry.FBaseQty           FBaseQty,").append(sp).append("       to_decimal(to_decimal(to_decimal(billEntry.flocalamount,19,4) / to_decimal(billEntry.FQty,21,8),21,8),21,8) FPrice,").append(sp).append("       billEntry.fsourcebilltypeid  FSourceBillTypeID,").append(sp).append("       billEntry.fsourcebillentryid FSourceBillEntryID,").append(sp).append("       billEntry.fsourcebillid      FSourceBillID,").append(sp).append("       null as FCoreBillTypeID, null as FCoreBillEntryID, null as FCoreBillID,").append(sp).append("       bill.fisreverse          FIsReversed,").append(sp).append("       billEntry.funitid            FUnitID,").append(sp).append("       0 as FPrecision,  ").append(sp).append("'").append(NORMAL_CREDITACCOUNT_ID).append("' as FCreditAccountID").append(sp).append("  from T_SD_PostRequisition bill").append(sp).append(" inner join T_SD_PostRequisitionEntry billEntry on billEntry.fparentid = bill.fid").append(sp).append(" inner JOIN T_BD_Customer cust on cust.fid = billEntry.fdeliverycustomerid").append(sp).append(" INNER JOIN T_ORG_UnitRelation orgRe ON orgRe.FFromUnitID = bill.FSaleOrgUnitID").append(sp).append("                                    AND orgRe.FTypeRelationID ='").append("00000000-0000-0000-0000-0000000000050FE9F8B5").append("'").append(sp).append(" WHERE bill.FPaymentTypeID='").append("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5").append("' AND cust.FIsCredited=1 and ISNULL(billEntry.FQty,0)<>0 ");
        return sqlStr.toString();
    }

    private static String getSelectSql4SaleIssue() {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select 0,bill.fid         FBillID,").append(sp).append("       billEntry.fid        FEntryID,").append(sp).append("       bill.fnumber     FBillNumber,").append(sp).append("       bill.fbilltypeid FBillTypeID,").append(sp).append("       bill.fbizdate    FBizDate,").append(sp).append("       bill.fbiztypeid         FBizTypeID,").append(sp).append("       orgRe.FToUnitID       FCompanyID,").append(sp).append("       bill.fcustomerid        FCustomerID,").append(sp).append("       null as FOrderCustomerID, null as FServiceCustomerID, ").append(sp).append("       bill.fpaymenttypeid     FPaymentTypeID,").append(sp).append("       bill.ftransactiontypeid FTransactionTypeID,").append(sp).append("       tt.fritypeid            FRITypeID,").append(sp).append("       billEntry.fiscenterbalance  FIsCenterBalance,").append(sp).append("       bill.fbasestatus        FBaseStatus,").append(sp).append("       0 as FConvertMode, 0 as FExchangeRate,").append(sp).append("       billEntry.flocalamount FLocalAmount,").append(sp).append("       billEntry.fqty         FQty,").append(sp).append("       billEntry.fbaseqty     FBaseQty,").append(sp).append("       to_decimal(to_decimal(to_decimal(billEntry.flocalamount,19,4) / to_decimal(billEntry.FQty,21,8),21,8),21,8) FPrice,").append(sp).append("       billEntry.fsourcebilltypeid  FSourceBillTypeID,").append(sp).append("       billEntry.fsourcebillentryid FSourceBillEntryID,").append(sp).append("       billEntry.fsourcebillid      FSourceBillID,").append(sp).append("       billEntry.fcorebilltypeid   FCoreBillTypeID,").append(sp).append("       billEntry.fsaleorderentryid FCoreBillEntryID,").append(sp).append("       billEntry.fsaleorderid      FCoreBillID,").append(sp).append("\t\tbill.fisreversed    FIsReversed,").append(sp).append("       billEntry.funitid   FUnitID,").append(sp).append("       t4.fprecision          FPrecision,").append(sp).append("'").append(NORMAL_CREDITACCOUNT_ID).append("' as FCreditAccountID").append(sp).append("  from t_im_saleissuebill bill").append(sp).append(" inner join t_im_saleissueentry billEntry on billEntry.fparentid = bill.fid").append(sp).append(" inner JOIN T_BD_Customer cust on cust.fid = bill.fcustomerid ").append(sp).append(" inner JOIN T_ORG_UnitRelation orgRe ON orgRe.FFromUnitID =bill.FStorageOrgUnitID AND orgRe.FTypeRelationID = '").append("00000000-0000-0000-0000-0000000000070FE9F8B5").append("'").append(sp).append(" INNER JOIN T_ORG_Company t3 ON t3.FID = orgRe.FToUnitID").append(sp).append(" INNER JOIN T_BD_Currency t4 ON t4.FID = t3.FBaseCurrencyID").append(sp).append("  LEFT OUTER JOIN T_SCM_TransactionType tt ON bill.FTransactionTypeID = tt.FID ").append(" WHERE bill.FPaymentTypeID='").append("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5").append("' AND cust.FIsCredited=1 and ISNULL(billEntry.FQty,0)<>0 ");
        return sqlStr.toString();
    }

    private static String getSelectSql4SaleReturns() {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select 0,bill.fid                 FBillID,").append(sp).append("       billEntry.fid                FEntryID,").append(sp).append("       bill.fnumber             FBillNumber,").append(sp).append("       bill.fbilltypeid         FBillTypeID,").append(sp).append("       bill.fbizdate            FBizDate,").append(sp).append("       bill.fbiztypeid          FBizTypeID,").append(sp).append("       orgRe.FToUnitID        FCompanyID,").append(sp).append("       cust.fid               FCustomerID,").append(sp).append("       null as FOrderCustomerID, null as FServiceCustomerID, ").append(sp).append("       bill.fpaymenttypeid      FPaymentTypeID,").append(sp).append("       null as FTransactionTypeID, null as FRITypeID, 0 as FIsCenterBalance,").append(sp).append("       billEntry.fbasestatus         FBaseStatus,").append(sp).append("       bill.FConvertMode        FConvertMode,").append(sp).append("       bill.FExchangeRate       FExchangeRate,").append(sp).append("       billEntry.flocaltaxamount*(case when billEntry.FReceiveDispatcherType=1 then 1 else -1 end) FLocalAmount,").append(sp).append("       billEntry.fqty               FQty,").append(sp).append("       0 as FBaseQty,").append(sp).append("       to_decimal(to_decimal(to_decimal(billEntry.flocalamount,19,4) / to_decimal(billEntry.FQty,21,8),21,8),21,8) FPrice,").append(sp).append("       billEntry.fsourcebilltypeid  FSourceBillTypeID,").append(sp).append("       billEntry.fsourcebillentryid FSourceBillEntryID,").append(sp).append("       billEntry.fsourcebillid      FSourceBillID,").append(sp).append("       null as FCoreBillTypeID, null as FCoreBillEntryID, null as FCoreBillID,").append(sp).append("       0 as FIsReversed,").append(sp).append("       billEntry.funitid            FUnitID,").append(sp).append("       t4.fprecision          FPrecision,").append(sp).append("'").append(NORMAL_CREDITACCOUNT_ID).append("' as FCreditAccountID").append(sp).append("  from T_SD_SaleReturns bill").append(sp).append(" inner join T_SD_SaleReturnsEntry billEntry on billEntry.fparentid = bill.fid").append(sp).append(" inner JOIN T_BD_Customer cust on cust.fid = bill.freturnscustomerid").append(sp).append(" INNER JOIN T_ORG_UnitRelation orgRe ON orgRe.FFromUnitID = bill.fsaleorgunitid").append(sp).append("                                    AND orgRe.FTypeRelationID ='").append("00000000-0000-0000-0000-0000000000050FE9F8B5").append("'").append(sp).append(" INNER JOIN T_ORG_Company t3 ON t3.FID = orgRe.FToUnitID").append(sp).append(" INNER JOIN T_BD_Currency t4 ON t4.FID = t3.FBaseCurrencyID").append(sp).append(" WHERE bill.FPaymentTypeID='").append("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5").append("' AND cust.FIsCredited=1 and ISNULL(billEntry.FQty,0)<>0 ");
        return sqlStr.toString();
    }

    private static String getSelectSql4AR() {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select 0,bill.fid         FBillID,").append(sp).append("       billEntry.fid            FEntryID,").append(sp).append("       bill.fnumber             FBillNumber,").append(sp).append("       '").append("510b6503-0105-1000-e000-0117c0a812fd463ED552").append("' FBillTypeID,").append(sp).append("       bill.fbilldate           FBizDate,").append(sp).append("       bill.fbiztypeid          FBizTypeID,").append(sp).append("       bill.fcompanyid          FCompanyID,").append(sp).append("       bill.fasstactid          FCustomerID,").append(sp).append("       billEntry.fordercustomerid   FOrderCustomerID,").append(sp).append("       billEntry.fservicecustomerid FServiceCustomerID,").append(sp).append("       bill.fpaymenttypeid      FPaymentTypeID,").append(sp).append("       null as FTransactionTypeID, null as FRITypeID, 0 as FIsCenterBalance,").append(sp).append("       bill.fbillstatus         FBaseStatus,").append(sp).append("       0 as FConvertMode, 0 as FExchangeRate,").append(sp).append("       billEntry.famountlocal       FLocalAmount,").append(sp).append("       billEntry.fquantity          FQty,").append(sp).append("       billEntry.fbaseqty           FBaseQty,").append(sp).append("       0 as FPrice,").append(sp).append("       null as  FSourceBillTypeID,").append(sp).append("       billEntry.fsourcebillentryid FSourceBillEntryID,").append(sp).append("       billEntry.fsourcebillid      FSourceBillID,").append(sp).append("       billEntry.fcorebilltypeid    FCoreBillTypeID,").append(sp).append("       billEntry.fcorebillentryid   FCoreBillEntryID,").append(sp).append("       billEntry.fcorebillid        FCoreBillID,").append(sp).append("       0 as FIsReversed,").append(sp).append("       billEntry.fmeasureunitid     FUnitID,").append(sp).append("       t4.fprecision          FPrecision,").append(sp).append("'").append(NORMAL_CREDITACCOUNT_ID).append("' as FCreditAccountID").append(sp).append("  from T_AR_OtherBill bill").append(sp).append(" inner join T_AR_OtherBillentry billEntry on billEntry.fparentid = bill.fid").append(sp).append(" inner JOIN T_BD_Customer cust on cust.fid = bill.fasstactid").append(sp).append(" INNER JOIN T_ORG_Company t3 ON t3.FID = bill.fcompanyid").append(sp).append(" INNER JOIN T_BD_Currency t4 ON t4.FID = t3.FBaseCurrencyID").append(sp).append(" WHERE bill.FPaymentTypeID='").append("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5").append("' AND cust.FIsCredited=1 ");
        return sqlStr.toString();
    }

    public static StringBuffer getInsertSqlStr(String tableName) {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("INSERT INTO ").append(tableName).append(sp).append(" (FIsHistory,FBillID,FEntryID,FBillNumber,FBillTypeID,FBizDate,FBizTypeID,FCompanyID,FCustomerID,").append(sp).append("FOrderCustomerID,FServiceCustomerID,FPaymentTypeID,FTransactionTypeID,FRITypeID,FIsCenterBalance,FBaseStatus,").append(sp).append("FConvertMode,FExchangeRate,FLocalAmount,FQty,FBaseQty,FPrice,FSourceBillTypeID,FSourceBillEntryID,FSourceBillID,").append(sp).append("FCoreBillTypeID,FCoreBillEntryID,FCoreBillID,FIsReversed,FUnitID,FPrecision,FCreditAccountID) ").append(sp);
        return sqlStr;
    }

    static {
        strategyMap.put("C48A423A", SaleOrderUpdateStrategy.class.getName());
        strategyMap.put("9CA9D08F", PostRequisitionUpdateStrategy.class.getName());
        strategyMap.put("546F192F", SaleReturnsUpdateStrategy.class.getName());
        strategyMap.put("CC3E933B", SaleIssueUpdateStrategy.class.getName());
        strategyMap.put("FC910EF3", ReceivableUpdateStrategy.class.getName());
        strategyMap.put("C2D6BA77", NetOrderUpdateStrategy.class.getName());
        commandMap.put(String.valueOf(1), CreditSubmitCommand.class.getName());
        commandMap.put(String.valueOf(4), CreditDeleteCommand.class.getName());
        commandMap.put(String.valueOf(2), CreditAuditCommand.class.getName());
        commandMap.put(String.valueOf(3), CreditUnAuditCommand.class.getName());
        commandMap.put(String.valueOf(7), CreditAlterCommand.class.getName());
        commandMap.put(String.valueOf(5), CreditCloseCommand.class.getName());
        commandMap.put(String.valueOf(6), CreditUnCloseCommand.class.getName());
        commandMap.put(String.valueOf(9), CreditCloseARCommand.class.getName());
        commandMap.put(String.valueOf(10), CreditUnCloseARCommand.class.getName());
        commandMap.put(String.valueOf(50), CreditDiscardCommand.class.getName());
        commandMap.put(String.valueOf(51), CreditManualWriteOffCommand.class.getName());
        commandMap.put(String.valueOf(52), CreditManualUnWriteOffCommand.class.getName());
        selectSqlMap.put("C48A423A", CreditUpdateHelper.getSelectSql4SaleOrder());
        selectSqlMap.put("9CA9D08F", CreditUpdateHelper.getSelectSql4PostRequisition());
        selectSqlMap.put("546F192F", CreditUpdateHelper.getSelectSql4SaleReturns());
        selectSqlMap.put("CC3E933B", CreditUpdateHelper.getSelectSql4SaleIssue());
        selectSqlMap.put("FC910EF3", CreditUpdateHelper.getSelectSql4AR());
        selectSqlMap.put("C2D6BA77", CreditUpdateHelper.getSelectSql4NetOrder());
    }
}

