/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.ControlMethodEnum;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFormulaConstant;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.util.BillControlStrategy;

public class ARBillControlStrategy
extends BillControlStrategy {
    public ARBillControlStrategy(CreditParamInfo paramInfo) {
        super(paramInfo);
    }

    @Override
    public ContrlTimeEnum getControlTime() throws CreditControlException {
        this.checkParam();
        return ContrlTimeEnum.getEnum(this.paramInfo.getAR_CtrlTime());
    }

    @Override
    public boolean isCtrlAmount(ContrlTimeEnum controlTime) throws CreditControlException {
        this.checkParam();
        return this.paramInfo.isCtrlARAmount() && controlTime.getValue() == this.paramInfo.getAR_CtrlTime();
    }

    @Override
    public boolean isCtrlTimelimit(ContrlTimeEnum controlTime) throws CreditControlException {
        this.checkParam();
        return this.paramInfo.isCtrlARTimeLimit() && controlTime.getValue() == this.paramInfo.getAR_CtrlTime();
    }

    @Override
    public String getFormulaForSave() {
        String formula = "FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5";
        if (this.paramInfo != null) {
            formula = this.paramInfo.getAR_CtrlTime() == 2 ? "FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5" : "FUnAuditARAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5";
        }
        return formula;
    }

    @Override
    public String getFormulaForDisplay() {
        String formula = CreditFormulaConstant.AR_Amount_Formula_ATAUDIT_ForDisplay;
        if (this.paramInfo != null) {
            formula = this.paramInfo.getAR_CtrlTime() == 2 ? CreditFormulaConstant.AR_Amount_Formula_ATAUDIT_ForDisplay : CreditFormulaConstant.AR_Amount_Formula_ATSUBMIT_ForDisplay;
        }
        return formula;
    }

    @Override
    public String getPassword() throws CreditControlException {
        this.checkParam();
        return this.paramInfo.getARCtrlPassword();
    }

    @Override
    public ControlMethodEnum getControlMethod() throws CreditControlException {
        this.checkParam();
        return ControlMethodEnum.getEnum(this.paramInfo.getAR_CreditCtrlMode());
    }

    @Override
    public String getBillName() {
        return this.getResource("ARBILL_NAME");
    }

    @Override
    public String getBillName(Context ctx) {
        return this.getResource("ARBILL_NAME", ctx);
    }

    @Override
    public boolean isCtrlAmount() throws CreditControlException {
        this.checkParam();
        return this.paramInfo.isCtrlARAmount();
    }

    @Override
    public boolean isCtrlTimelimit() throws CreditControlException {
        this.checkParam();
        return this.paramInfo.isCtrlARTimeLimit();
    }
}

