/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.ControlMethodEnum;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.util.Locale;

public abstract class BillControlStrategy {
    protected CreditParamInfo paramInfo;

    public BillControlStrategy(CreditParamInfo paramInfo) {
        this.paramInfo = paramInfo;
    }

    public abstract ContrlTimeEnum getControlTime() throws CreditControlException;

    public abstract boolean isCtrlAmount(ContrlTimeEnum var1) throws CreditControlException;

    public abstract boolean isCtrlAmount() throws CreditControlException;

    public abstract boolean isCtrlTimelimit(ContrlTimeEnum var1) throws CreditControlException;

    public abstract boolean isCtrlTimelimit() throws CreditControlException;

    public abstract String getFormulaForSave();

    public abstract String getFormulaForDisplay();

    public abstract String getPassword() throws CreditControlException;

    public abstract ControlMethodEnum getControlMethod() throws CreditControlException;

    public boolean isControledCredit(ContrlTimeEnum controlTime) throws CreditControlException {
        return this.isCtrlAmount(controlTime) || this.isCtrlTimelimit(controlTime);
    }

    public abstract String getBillName();

    public abstract String getBillName(Context var1);

    protected String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.credit.CreditResource", (String)key);
    }

    protected String getResource(String key, Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditResource", (String)key, (Locale)ctx.getLocale());
    }

    protected void checkParam() throws CreditControlException {
        if (this.paramInfo == null) {
            throw new CreditControlException(CreditControlException.NULL_CREDITPARAM);
        }
    }
}

