/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.util;

import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.util.ARBillControlStrategy;
import com.kingdee.eas.scm.credit.util.ARSysBillControlStrategy;
import com.kingdee.eas.scm.credit.util.ApSysBillControlStrategy;
import com.kingdee.eas.scm.credit.util.BillControlStrategy;
import com.kingdee.eas.scm.credit.util.CreditFileAlterControlStrategy;
import com.kingdee.eas.scm.credit.util.IssueBillControlStrtegy;
import com.kingdee.eas.scm.credit.util.NetOrderControlStrategy;
import com.kingdee.eas.scm.credit.util.PostBillControlStrategy;
import com.kingdee.eas.scm.credit.util.SaleOrderControlStrategy;
import com.kingdee.eas.scm.credit.util.SaleReturnsControlStrategy;

public class ControlStategyFacotry {
    public static BillControlStrategy getStragy(CreditFormulaSceneEnum scene, CreditParamInfo paramInfo) {
        if (scene == null) {
            throw new IllegalArgumentException();
        }
        BillControlStrategy strategy = null;
        if (scene.equals((Object)CreditFormulaSceneEnum.ORDER)) {
            strategy = new SaleOrderControlStrategy(paramInfo);
        } else if (scene.equals((Object)CreditFormulaSceneEnum.ISSUEDBILL)) {
            strategy = new IssueBillControlStrtegy(paramInfo);
        } else if (scene.equals((Object)CreditFormulaSceneEnum.ARBILL)) {
            strategy = new ARBillControlStrategy(paramInfo);
        } else if (scene.equals((Object)CreditFormulaSceneEnum.POSTBILL)) {
            strategy = new PostBillControlStrategy(paramInfo);
        } else if (scene.equals((Object)CreditFormulaSceneEnum.NETORDERBILL)) {
            strategy = new NetOrderControlStrategy(paramInfo);
        } else if (scene.equals((Object)CreditFormulaSceneEnum.SALERETURN)) {
            strategy = new SaleReturnsControlStrategy(paramInfo);
        } else if (scene.equals((Object)CreditFormulaSceneEnum.ARSYSBILL)) {
            strategy = new ARSysBillControlStrategy(paramInfo);
        } else if (scene.equals((Object)CreditFormulaSceneEnum.APSYSBILL)) {
            strategy = new ApSysBillControlStrategy(paramInfo);
        } else if (scene.equals((Object)CreditFormulaSceneEnum.CREDITFILE)) {
            strategy = new CreditFileAlterControlStrategy(paramInfo);
        }
        return strategy;
    }
}

