/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.ControlMethodEnum;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFormulaConstant;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.util.BillControlStrategy;

public class CreditFileAlterControlStrategy
extends BillControlStrategy {
    public CreditFileAlterControlStrategy(CreditParamInfo paramInfo) {
        super(paramInfo);
    }

    @Override
    public ContrlTimeEnum getControlTime() throws CreditControlException {
        this.checkParam();
        int ctrlMode = 2;
        if (this.paramInfo != null) {
            if (this.paramInfo.isCtrlSaleOrderAmount()) {
                ctrlMode = this.paramInfo.getSO_CtrlTime();
            } else if (this.paramInfo.isCtrlPostbillAmount()) {
                ctrlMode = this.paramInfo.getPostbill_CtrlTime();
            } else if (this.paramInfo.isCtrlIssuedAmount()) {
                ctrlMode = this.paramInfo.getIssued_CtrlTime();
            } else if (this.paramInfo.isCtrlARAmount()) {
                ctrlMode = this.paramInfo.getAR_CtrlTime();
            }
        }
        return ContrlTimeEnum.getEnum(ctrlMode);
    }

    @Override
    public boolean isCtrlAmount(ContrlTimeEnum controlTime) throws CreditControlException {
        this.checkParam();
        boolean ctrlAmount = false;
        if (this.paramInfo != null) {
            if (this.paramInfo.isCtrlSaleOrderAmount()) {
                ctrlAmount = true;
            } else if (this.paramInfo.isCtrlPostbillAmount()) {
                ctrlAmount = true;
            } else if (this.paramInfo.isCtrlIssuedAmount()) {
                ctrlAmount = true;
            } else if (this.paramInfo.isCtrlARAmount()) {
                ctrlAmount = true;
            }
        }
        return ctrlAmount;
    }

    @Override
    public boolean isCtrlTimelimit(ContrlTimeEnum controlTime) throws CreditControlException {
        this.checkParam();
        boolean ctrlTimeLimit = false;
        return ctrlTimeLimit;
    }

    @Override
    public String getFormulaForSave() {
        String formula = "FUnArBillOrderAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5";
        if (this.paramInfo != null) {
            if (this.paramInfo.isCtrlSaleOrderAmount()) {
                formula = this.paramInfo.getSO_CreditCtrlMode() == 2 ? "FUnArBillOrderAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5" : "FUnAuditSOAmt+FUnArBillOrderAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5";
            } else if (this.paramInfo.isCtrlPostbillAmount()) {
                formula = this.paramInfo.getPostbill_CreditCtrlMode() == 2 ? "FUnOutPostBillAmt+FUnArBillIssuedAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5" : "FUnAuditPostBillAmt+FUnOutPostBillAmt+FUnArBillIssuedAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5";
            } else if (this.paramInfo.isCtrlIssuedAmount()) {
                formula = this.paramInfo.getIssued_CreditCtrlMode() == 2 ? "FUnArBillIssuedAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5" : "FUnAuditIssuedAmt+FUnArBillIssuedAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5";
            } else if (this.paramInfo.isCtrlARAmount()) {
                formula = this.paramInfo.getAR_CreditCtrlMode() == 2 ? "FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5" : "FUnAuditARAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5";
            }
        }
        return formula;
    }

    @Override
    public String getFormulaForDisplay() {
        String formula = CreditFormulaConstant.SO_Amount_Formula_ATAUDIT_ForDisplay;
        if (this.paramInfo != null) {
            if (this.paramInfo.isCtrlSaleOrderAmount()) {
                formula = this.paramInfo.getSO_CreditCtrlMode() == 2 ? CreditFormulaConstant.SO_Amount_Formula_ATAUDIT_ForDisplay : CreditFormulaConstant.SO_Amount_Formula_ATSUBMIT_ForDisplay;
            } else if (this.paramInfo.isCtrlPostbillAmount()) {
                formula = this.paramInfo.getPostbill_CreditCtrlMode() == 2 ? CreditFormulaConstant.PostBill_Amount_Formula_ATAUDIT_ForDisplay : CreditFormulaConstant.PostBill_Amount_Formula_ATSUBMIT_ForDisplay;
            } else if (this.paramInfo.isCtrlIssuedAmount()) {
                formula = this.paramInfo.getIssued_CreditCtrlMode() == 2 ? CreditFormulaConstant.Issued_Amount_Formula_ATAUDIT_ForDisplay : CreditFormulaConstant.Issued_Amount_Formula_ATSUBMIT_ForDisplay;
            } else if (this.paramInfo.isCtrlARAmount()) {
                formula = this.paramInfo.getAR_CreditCtrlMode() == 2 ? CreditFormulaConstant.AR_Amount_Formula_ATAUDIT_ForDisplay : CreditFormulaConstant.AR_Amount_Formula_ATSUBMIT_ForDisplay;
            }
        }
        return formula;
    }

    @Override
    public String getPassword() throws CreditControlException {
        this.checkParam();
        if (this.paramInfo != null) {
            if (this.paramInfo.isCtrlSaleOrderAmount()) {
                return this.paramInfo.getSOCtrlPassword();
            }
            if (this.paramInfo.isCtrlPostbillAmount()) {
                return this.paramInfo.getPostbillCtrlPassword();
            }
            if (this.paramInfo.isCtrlIssuedAmount()) {
                return this.paramInfo.getIssuedCtrlPassword();
            }
            if (this.paramInfo.isCtrlARAmount()) {
                return this.paramInfo.getARCtrlPassword();
            }
        }
        return "";
    }

    @Override
    public ControlMethodEnum getControlMethod() throws CreditControlException {
        this.checkParam();
        int mode = 2;
        if (this.paramInfo != null) {
            if (this.paramInfo.isCtrlSaleOrderAmount()) {
                mode = this.paramInfo.getSO_CreditCtrlMode();
            } else if (this.paramInfo.isCtrlPostbillAmount()) {
                mode = this.paramInfo.getPostbill_CreditCtrlMode();
            } else if (this.paramInfo.isCtrlIssuedAmount()) {
                mode = this.paramInfo.getIssued_CreditCtrlMode();
            } else if (this.paramInfo.isCtrlARAmount()) {
                mode = this.paramInfo.getAR_CreditCtrlMode();
            }
        }
        return ControlMethodEnum.getEnum(mode);
    }

    @Override
    public String getBillName() {
        return this.getResource("CREDITFILEALTER");
    }

    @Override
    public String getBillName(Context ctx) {
        return this.getResource("CREDITFILEALTER", ctx);
    }

    @Override
    public boolean isCtrlAmount() throws CreditControlException {
        this.checkParam();
        boolean ctrlAmount = false;
        if (this.paramInfo != null) {
            if (this.paramInfo.isCtrlSaleOrderAmount()) {
                ctrlAmount = true;
            } else if (this.paramInfo.isCtrlPostbillAmount()) {
                ctrlAmount = true;
            } else if (this.paramInfo.isCtrlIssuedAmount()) {
                ctrlAmount = true;
            } else if (this.paramInfo.isCtrlARAmount()) {
                ctrlAmount = true;
            }
        }
        return ctrlAmount;
    }

    @Override
    public boolean isCtrlTimelimit() throws CreditControlException {
        this.checkParam();
        boolean ctrlTimeLimit = false;
        return ctrlTimeLimit;
    }
}

