/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.Locale;

public abstract class CreditOrgUnitUtils {
    public static final String ORG_DELEGATE_SALE_FI = "00000000-0000-0000-0000-0000000000050FE9F8B5";
    public static final String ORG_DELEGATE_PURCHARSE_FI = "00000000-0000-0000-0000-0000000000030FE9F8B5";
    public static final String ORG_DELEGATE_STORAGE_FI = "00000000-0000-0000-0000-0000000000070FE9F8B5";
    public static final String ORG_DELEGATE_ADMIN_FI = "00000000-0000-0000-0000-0000000000010FE9F8B5";
    public static final String ORG_DELEGATE_HR_FI = "00000000-0000-0000-0000-0000000000130FE9F8B5";
    public static final int ORG_OU_BIZUNIT = 1;
    public static final int ORG_OU_VIRTUAL = 2;
    public static final int ORG_OU_ALL = 3;
    public static final int ORG_OU_UP = 1;
    public static final int ORG_OU_DOWN = 2;

    public static final CompanyOrgUnitInfo readCompanyOrgUnitInfo(Context ctx, OrgUnitInfo orgUnit) throws EASBizException, BOSException {
        return CreditOrgUnitUtils.readCompanyOrgUnitInfo(ctx, orgUnit, false);
    }

    public static final CompanyOrgUnitInfo readFullCompanyOrgUnitInfo(Context ctx, OrgUnitInfo orgUnit) throws EASBizException, BOSException {
        return CreditOrgUnitUtils.readCompanyOrgUnitInfo(ctx, orgUnit, true);
    }

    public static CompanyOrgUnitInfo readCompanyOrgUnitInfo(Context ctx, OrgUnitInfo orgUnit, boolean isFull) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        if (orgUnit != null) {
            if (orgUnit instanceof CompanyOrgUnitInfo && orgUnit.getId() != null) {
                company = (CompanyOrgUnitInfo)orgUnit;
                if (isFull && (company.getBaseCurrency() == null || company.getBaseCurrency().getName() == null || !company.getBaseCurrency().containsKey("precision") || company.getBaseExchangeTable() == null)) {
                    company = CreditOrgUnitUtils.fullCompanyOrgUnitInfo(ctx, company.getId().toString());
                }
            } else {
                OrgUnitInfo ou = null;
                ou = ctx != null ? OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUint(CreditOrgUnitUtils.getOrgRelationTypeByOU(orgUnit), orgUnit) : OrgUnitRelationFactory.getRemoteInstance().getToUint(CreditOrgUnitUtils.getOrgRelationTypeByOU(orgUnit), orgUnit);
                if (ou != null && ou.getId() != null) {
                    if (isFull) {
                        company = CreditOrgUnitUtils.fullCompanyOrgUnitInfo(ctx, ou.getId().toString());
                    } else {
                        company = new CompanyOrgUnitInfo();
                        company.setId(ou.getId());
                    }
                }
            }
        }
        return company;
    }

    public static CompanyOrgUnitInfo fullCompanyOrgUnitInfo(Context ctx, String Id) throws EASBizException, BOSException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("longNumber"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("baseCurrency.id"));
        selectors.add(new SelectorItemInfo("baseCurrency.name"));
        selectors.add(new SelectorItemInfo("baseCurrency.precision"));
        selectors.add(new SelectorItemInfo("baseExchangeTable.id"));
        selectors.add(new SelectorItemInfo("isOnlyUnion"));
        ICompanyOrgUnit ie = null;
        ie = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return ie.getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(Id), selectors);
    }

    public static CompanyOrgUnitInfo getCurrentCompanyOrgUnitInfo(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        String id = (String)ctx.get((Object)"CurCompanyId");
        if (id != null && id.trim().length() != 0) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(id));
        }
        return company;
    }

    public static CompanyOrgUnitCollection getSuperiorCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf, SortType sortType) throws EASBizException, BOSException {
        return CreditOrgUnitUtils.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, sortType, 1);
    }

    public static CompanyOrgUnitCollection getSuperiorCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf) throws EASBizException, BOSException {
        return CreditOrgUnitUtils.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, SortType.ASCEND, 1);
    }

    public static CompanyOrgUnitCollection getChildrenCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf, SortType sortType) throws EASBizException, BOSException {
        return CreditOrgUnitUtils.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, sortType, 2);
    }

    public static CompanyOrgUnitCollection getChildrenCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf) throws EASBizException, BOSException {
        return CreditOrgUnitUtils.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, SortType.ASCEND, 2);
    }

    public static CompanyOrgUnitCollection getThreadCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf, SortType sortType, int upOrDown) throws EASBizException, BOSException {
        if (ctx == null || companyId == null || companyId.trim().length() == 0) {
            return null;
        }
        String sp = " \r\n";
        String locale = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("SELECT b.FID, b.FNumber, b.FName").append(locale).append(" As FCompanyName, b.FLongNumber, b.FBaseExgTableID, ").append(sp);
        strSQL.append("  b.FBaseCurrencyID, c.FName").append(locale).append(" As FCurrencyName, c.FPrecision").append(sp);
        strSQL.append("FROM T_ORG_Company a, T_ORG_Company b, T_BD_Currency c").append(sp);
        strSQL.append("WHERE a.FID = ? And b.FBaseCurrencyID = c.FID ").append(sp);
        if (isContainSelf) {
            if (2 == upOrDown) {
                strSQL.append("  And ( (SUBSTRING(b.FLongNumber, 0,LENGTH(a.FLongNumber) + 1) = a.FLongNumber || '!' AND b.FLevel > a.FLevel) OR ").append(sp);
                strSQL.append("  (b.FLongNumber = a.FLongNumber) ) ").append(sp);
            } else if (1 == upOrDown) {
                strSQL.append("  And ( (SUBSTRING(a.FLongNumber, 0,LENGTH(b.FLongNumber) + 1) = b.FLongNumber || '!' AND b.FLevel < a.FLevel) OR ").append(sp);
                strSQL.append("  (b.FLongNumber = a.FLongNumber) ) ").append(sp);
            }
        } else if (2 == upOrDown) {
            strSQL.append("  And (SUBSTRING(b.FLongNumber, 0,LENGTH(a.FLongNumber) + 1) = a.FLongNumber || '!' AND b.FLevel > a.FLevel) ").append(sp);
        } else if (1 == upOrDown) {
            strSQL.append("  And (SUBSTRING(a.FLongNumber, 0,LENGTH(b.FLongNumber) + 1) = b.FLongNumber || '!' AND b.FLevel < a.FLevel) ").append(sp);
        }
        if (isBizUnit == 1) {
            strSQL.append("  And b.FIsBizUnit = 1").append(sp);
        } else if (isBizUnit == 2) {
            strSQL.append("  And b.FIsBizUnit = 0").append(sp);
        }
        if (sortType == null || sortType != null && SortType.ASCEND.getName().equalsIgnoreCase(sortType.getName())) {
            strSQL.append("Order By b.FLongNumber ASC");
        } else {
            strSQL.append("Order By b.FLongNumber DESC");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{companyId});
        CompanyOrgUnitCollection companys = new CompanyOrgUnitCollection();
        if (rs != null) {
            try {
                CompanyOrgUnitInfo company = null;
                while (rs.next()) {
                    company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)rs.getString("FID")));
                    company.setNumber(rs.getString("FNumber"));
                    company.setName(rs.getString("FCompanyName"));
                    company.setLongNumber(rs.getString("FLongNumber"));
                    if (rs.getString("FBaseExgTableID") != null) {
                        ExchangeTableInfo exchangeTable = new ExchangeTableInfo();
                        exchangeTable.setId(BOSUuid.read((String)rs.getString("FBaseExgTableID")));
                        company.setBaseExchangeTable(exchangeTable);
                    }
                    CurrencyInfo baseCurrency = new CurrencyInfo();
                    baseCurrency.setId(BOSUuid.read((String)rs.getString("FBaseCurrencyID")));
                    baseCurrency.setName(rs.getString("FCurrencyName"));
                    baseCurrency.setPrecision(rs.getInt("FPrecision"));
                    company.setBaseCurrency(baseCurrency);
                    companys.add(company);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return companys;
    }

    private static OrgTypeRelationInfo getOrgRelationTypeByOU(OrgUnitInfo orgUnit) {
        OrgTypeRelationInfo ri = null;
        if (orgUnit != null) {
            ri = new OrgTypeRelationInfo();
            if (orgUnit != null) {
                if (orgUnit instanceof PurchaseOrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_PURCHARSE_FI));
                } else if (orgUnit instanceof SaleOrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_SALE_FI));
                } else if (orgUnit instanceof StorageOrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_STORAGE_FI));
                } else if (orgUnit instanceof AdminOrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_ADMIN_FI));
                } else if (orgUnit instanceof HROrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_HR_FI));
                }
            }
        }
        return ri;
    }
}

