/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeFactory;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeInfo;
import com.kingdee.eas.basedata.master.cssp.IBizAnalysisCode;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;

public class CreditUIUtils {
    public static final String strDateFormat = CtrlFormatUtilities.getDateFormatString();

    public static FilterInfo getF7FilterInfoByAuthorizedCompanyOrg(String orgFieldName, String permItem) {
        NewCompanyF7 fiF7 = new NewCompanyF7();
        fiF7.setIsCUFilter(false);
        fiF7.setNeedConsiderFaultTree(true);
        fiF7.setNeedAddSealUp(false);
        NewOrgUnitFilterInfoProducer filterInfoProducer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)fiF7, permItem);
        boolean isRootControl = CreditUIUtils.isRootControl();
        FilterInfo filterInfo = filterInfoProducer.getFilterInfo();
        if (!isRootControl && filterInfo != null && filterInfo.getFilterItems().size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isOnlyUnion", (Object)new Integer(0)));
            try {
                filterInfo.mergeFilter(filter, "and");
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return filterInfo;
    }

    public static CompanyOrgUnitInfo getDefaultMainBizOrg(OrgType orgType, String permItem) throws EASBizException, BOSException {
        FilterInfo filterInfo = CreditUIUtils.getF7FilterInfoByAuthorizedCompanyOrg("id", permItem);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SorterItemInfo sorterInfo = new SorterItemInfo("number");
        sorterInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(sorterInfo);
        CompanyOrgUnitCollection companyOrgColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        if (companyOrgColl != null && companyOrgColl.size() > 0) {
            boolean isRootControl = CreditUIUtils.isRootControl();
            OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(orgType);
            if (isRootControl) {
                if (currentMainOrg != null) {
                    for (int i = 0; i < companyOrgColl.size(); ++i) {
                        if (!currentMainOrg.getId().toString().equals(companyOrgColl.get(i).getId().toString())) continue;
                        return companyOrgColl.get(i);
                    }
                }
            } else if (currentMainOrg instanceof CompanyOrgUnitInfo) {
                if (currentMainOrg != null && currentMainOrg.isIsCompanyOrgUnit() && ((CompanyOrgUnitInfo)currentMainOrg).isIsBizUnit()) {
                    for (int i = 0; i < companyOrgColl.size(); ++i) {
                        if (!currentMainOrg.getId().toString().equals(companyOrgColl.get(i).getId().toString())) continue;
                        return companyOrgColl.get(i);
                    }
                } else {
                    return companyOrgColl.get(0);
                }
            }
            return companyOrgColl.get(0);
        }
        return null;
    }

    public static boolean isRootControl() {
        boolean isRootControl = false;
        try {
            IParamControl ipc = ParamControlFactory.getRemoteInstance();
            String strParamG00X = ipc.getParamValue(null, "G005");
            if (strParamG00X != null && strParamG00X.trim().length() != 0 && strParamG00X.trim().equalsIgnoreCase("true")) {
                isRootControl = true;
            }
        }
        catch (BOSException e) {
            isRootControl = false;
        }
        catch (EASBizException e) {
            isRootControl = false;
        }
        return isRootControl;
    }

    public static void setCompanyOrgF7(KDBizPromptBox f7, String permItem) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(CreditUIUtils.getF7FilterInfoByAuthorizedCompanyOrg("id", permItem));
        f7.setEntityViewInfo(viewInfo);
    }

    public static CompanyOrgUnitInfo getCompanyByNum(String num) throws BOSException {
        CompanyOrgUnitInfo company = null;
        ICompanyOrgUnit companyCtrl = CompanyOrgUnitFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)num));
        view.setFilter(filter);
        CoreBaseCollection companyCol = companyCtrl.getCollection(view);
        if (companyCol.size() > 0) {
            company = (CompanyOrgUnitInfo)companyCol.get(0);
        }
        return company;
    }

    public static CurrencyInfo getCurrencyByNum(String num) throws BOSException {
        CurrencyInfo currency = null;
        ICurrency currencyCtrl = CurrencyFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)num));
        view.setFilter(filter);
        CoreBaseCollection currencyCol = currencyCtrl.getCollection(view);
        if (currencyCol.size() > 0) {
            currency = (CurrencyInfo)currencyCol.get(0);
        }
        return currency;
    }

    public static BizAnalysisCodeInfo getBizCodeById(String id) throws BOSException, EASBizException {
        IBizAnalysisCode bizCodeCtrl = BizAnalysisCodeFactory.getRemoteInstance();
        BizAnalysisCodeInfo bizCode = (BizAnalysisCodeInfo)bizCodeCtrl.getValue((IObjectPK)new ObjectUuidPK(id));
        return bizCode;
    }

    public static String getDateFormatString() {
        String pattern = CtrlFormatUtilities.getDateFormatString();
        if (pattern == null) {
            pattern = strDateFormat;
        }
        return pattern;
    }
}

