/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditLogFactory;
import com.kingdee.eas.scm.credit.CreditLogInfo;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.util.BillControlStrategy;
import com.kingdee.eas.scm.credit.util.ControlStategyFacotry;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CreditUtils {
    public static CustomerInfo readFullCustomerInfo(Context ctx, CustomerInfo customer) throws EASBizException, BOSException {
        CustomerInfo ct = customer;
        if (!(customer == null || customer.getId() == null || customer.containsKey("isCredited") && customer.containsKey("bizAnalysisCode.id") && customer.containsKey("browseGroup.id"))) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("name"));
            selectors.add(new SelectorItemInfo("number"));
            selectors.add(new SelectorItemInfo("isCredited"));
            selectors.add(new SelectorItemInfo("bizAnalysisCode.id"));
            selectors.add(new SelectorItemInfo("browseGroup.id"));
            ICustomer ie = null;
            ie = ctx == null ? CustomerFactory.getRemoteInstance() : CustomerFactory.getLocalInstance((Context)ctx);
            ct = ie.getCustomerInfo((IObjectPK)new ObjectStringPK(customer.getId().toString()), selectors);
        }
        return ct;
    }

    public static SupplierInfo readFullSupplierInfo(Context ctx, SupplierInfo supplier) throws EASBizException, BOSException {
        SupplierInfo ct = supplier;
        if (supplier != null && supplier.getId() != null && !supplier.containsKey("bizAnalysisCode.id")) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("bizAnalysisCode.id"));
            ISupplier ie = null;
            ie = ctx == null ? SupplierFactory.getRemoteInstance() : SupplierFactory.getLocalInstance((Context)ctx);
            ct = ie.getSupplierInfo((IObjectPK)new ObjectStringPK(supplier.getId().toString()), selectors);
        }
        return ct;
    }

    public static boolean isContainCreditCustomer(Context ctx, String bizAnalysisCodeID) throws EASBizException, BOSException {
        if (bizAnalysisCodeID == null) {
            return false;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isCredited", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizAnalysisCode.id", (Object)bizAnalysisCodeID, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(selectors);
        ICustomer ie = null;
        ie = ctx == null ? CustomerFactory.getRemoteInstance() : CustomerFactory.getLocalInstance((Context)ctx);
        CustomerCollection cstColl = ie.getCustomerCollection(view);
        return cstColl != null && cstColl.size() > 0;
    }

    public static CurrencyInfo readFullCurrencyInfo(Context ctx, CurrencyInfo currency) throws EASBizException, BOSException {
        CurrencyInfo c = currency;
        if (currency != null && currency.getId() != null && (currency.getName() == null || currency.getPrecision() <= 0)) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("name"));
            selectors.add(new SelectorItemInfo("precision"));
            ICurrency ie = null;
            ie = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
            c = ie.getCurrencyInfo((IObjectPK)new ObjectStringPK(currency.getId().toString()), selectors);
        }
        return c;
    }

    public static boolean isRequireVerifyCreditAtAudit(Context ctx, OrgUnitInfo orgUnit, CustomerInfo customer, int scene) throws EASBizException, BOSException {
        return CreditUtils.isRequireVerifyCredit(ctx, orgUnit, customer, scene, 2);
    }

    public static boolean isRequireVerifyCreditAtSubmit(Context ctx, OrgUnitInfo orgUnit, CustomerInfo customer, int scene) throws EASBizException, BOSException {
        return CreditUtils.isRequireVerifyCredit(ctx, orgUnit, customer, scene, 1);
    }

    public static boolean isRequireVerifyCredit(Context ctx, OrgUnitInfo orgUnit, CustomerInfo customer, int scene, int controlAt) throws EASBizException, BOSException {
        boolean isRequire = false;
        if (ctx != null && orgUnit != null && customer != null) {
            CreditParamInfo paramInfo;
            customer = CreditUtils.readFullCustomerInfo(ctx, customer);
            CompanyOrgUnitInfo company = CreditOrgUnitUtils.readCompanyOrgUnitInfo(ctx, orgUnit);
            if (company != null && company.getId() != null && (paramInfo = CreditServerUtil.getCreditParamInfo(ctx, company.getId().toString())) != null && paramInfo.isCompnayCredited() && customer != null && customer.isIsCredited()) {
                BillControlStrategy billCtrlStrategy = ControlStategyFacotry.getStragy(CreditFormulaSceneEnum.getEnum(scene), paramInfo);
                if (controlAt == 3) {
                    return true;
                }
                isRequire = billCtrlStrategy.isControledCredit(ContrlTimeEnum.getEnum(controlAt));
            }
        }
        return isRequire;
    }

    public static boolean isRequireVerifyCredit(Context ctx, OrgUnitInfo orgUnit, CustomerInfo customer) throws EASBizException, BOSException {
        boolean isRequire = false;
        if (ctx != null && orgUnit != null && customer != null) {
            CreditParamInfo paramInfo;
            customer = CreditUtils.readFullCustomerInfo(ctx, customer);
            CompanyOrgUnitInfo company = CreditOrgUnitUtils.readCompanyOrgUnitInfo(ctx, orgUnit);
            if (company != null && company.getId() != null && (paramInfo = CreditServerUtil.getCreditParamInfo(ctx, company.getId().toString())) != null && paramInfo.isCompnayCredited() && customer != null && customer.isIsCredited()) {
                isRequire = true;
            }
        }
        return isRequire;
    }

    public static boolean isRequireVerifyCredit(Context ctx, OrgUnitInfo orgUnit, SupplierInfo supplier) throws EASBizException, BOSException {
        boolean isRequire = false;
        if (ctx != null && orgUnit != null && supplier != null) {
            CreditParamInfo paramInfo;
            supplier = CreditUtils.readFullSupplierInfo(ctx, supplier);
            CompanyOrgUnitInfo company = CreditOrgUnitUtils.readCompanyOrgUnitInfo(ctx, orgUnit);
            if (company != null && company.getId() != null && (paramInfo = CreditServerUtil.getCreditParamInfo(ctx, company.getId().toString())) != null && paramInfo.isCompnayCredited() && paramInfo.isBizCode() && supplier.getBizAnalysisCode() != null) {
                isRequire = CreditUtils.isContainCreditCustomer(ctx, supplier.getBizAnalysisCode().getId().toString());
            }
        }
        return isRequire;
    }

    public static BigDecimal sumPostbillLocalAmount(PostRequisitionInfo postBill) {
        BigDecimal totalAmount = SysConstant.BIGZERO;
        int size = postBill.getEntries().size();
        for (int i = 0; i < size; ++i) {
            PostRequisitionEntryInfo entry = postBill.getEntries().get(i);
            totalAmount = totalAmount.add(entry.getLocalAmount());
        }
        return totalAmount;
    }

    public static Map sumPostbillCustomerLocalAmount(PostRequisitionInfo postBill) {
        HashMap<String, BigDecimal> custAmtMap = new HashMap<String, BigDecimal>();
        int size = postBill.getEntries().size();
        for (int i = 0; i < size; ++i) {
            PostRequisitionEntryInfo entry = postBill.getEntries().get(i);
            String custId = entry.getOrderCustomer().getId().toString();
            if (custAmtMap.containsKey(custId)) {
                BigDecimal totalAmt = (BigDecimal)custAmtMap.get(custId);
                totalAmt = totalAmt.add(entry.getLocalAmount());
                custAmtMap.put(custId, totalAmt);
                continue;
            }
            custAmtMap.put(custId, entry.getLocalAmount());
        }
        return custAmtMap;
    }

    public static void checkPostbill(Context ctx, String companyId) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" select tmp.FID, count(*) billCount from (").append(" SELECT distinct t0.FID,t1.FDeliveryCustomerID ").append(" FROM T_SD_PostRequisition t0 ").append(" INNER JOIN T_SD_PostRequisitionEntry t1 ON  t0.FID = t1.FParentID ").append(" WHERE t0.FBaseStatus = 2 ");
        boolean isGroupControl = CreditServerUtil.isCreditParamG00X(ctx, "", "G005");
        Object[] params = new Object[]{};
        if (!isGroupControl) {
            strSQL.append(" AND t0.FCompanyOrgUnitId = ? ");
            params = new Object[]{companyId};
        }
        strSQL.append(" ) tmp Group by tmp.FID ");
        strSQL.append(" Having count(*) > 1 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params);
        try {
            if (rs.next() && rs.getInt("billCount") > 0) {
                throw new CreditControlException(CreditControlException.SINGLECUST_POSTBILL_CREDIT);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static final List array2List(Object[] objs) {
        ArrayList<Object> al = new ArrayList<Object>();
        if (objs != null) {
            for (int i = 0; i < objs.length; ++i) {
                al.add(objs[i]);
            }
        }
        return al;
    }

    public static Date getStartDate(Date da) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(da);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndDate(Date da) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(da);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static CreditFormulaSceneEnum getBillTypeByBosType(String billID) {
        String bosType = BOSUuid.getBOSObjectType((String)billID, (boolean)true).toString();
        CreditFormulaSceneEnum billType = null;
        if (bosType.equalsIgnoreCase("FC910EF3")) {
            billType = CreditFormulaSceneEnum.ARBILL;
        } else if (bosType.equalsIgnoreCase("48DA3A71")) {
            billType = CreditFormulaSceneEnum.APBILL;
        } else if (bosType.equalsIgnoreCase("FA44FD5B")) {
            billType = CreditFormulaSceneEnum.RECBILL;
        } else if (bosType.equalsIgnoreCase("40284E81")) {
            billType = CreditFormulaSceneEnum.PAYBILL;
        } else if (bosType.equalsIgnoreCase("9B112F80")) {
            billType = CreditFormulaSceneEnum.PROXYBILL;
        }
        return billType;
    }

    public static CreditFormulaSceneEnum getBillTypeByBosType(BOSObjectType objType) {
        String bosType = objType.toString();
        CreditFormulaSceneEnum billType = null;
        if (bosType.equalsIgnoreCase("FC910EF3")) {
            billType = CreditFormulaSceneEnum.ARBILL;
        } else if (bosType.equalsIgnoreCase("48DA3A71")) {
            billType = CreditFormulaSceneEnum.APBILL;
        } else if (bosType.equalsIgnoreCase("FA44FD5B")) {
            billType = CreditFormulaSceneEnum.RECBILL;
        } else if (bosType.equalsIgnoreCase("40284E81")) {
            billType = CreditFormulaSceneEnum.PAYBILL;
        } else if (bosType.equalsIgnoreCase("9B112F80")) {
            billType = CreditFormulaSceneEnum.PROXYBILL;
        }
        return billType;
    }

    public static BigDecimal getExchangeRate(Context ctx, IObjectPK exchangeTablePk, IObjectPK srcCurrencyPk, IObjectPK destCurrencyPk) throws EASBizException, BOSException {
        IExchangeRate iExchangeRate = null;
        iExchangeRate = ctx != null ? ExchangeRateFactory.getLocalInstance((Context)ctx) : ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo exchangeRateInfo = iExchangeRate.getExchangeRate(exchangeTablePk, srcCurrencyPk, destCurrencyPk, new Date());
        int percision = 10;
        BigDecimal exchangerate = SCMConstant.BIGDECIMAL_ONE;
        BigDecimal _exchangerate = exchangeRateInfo != null ? exchangeRateInfo.getConvertRate() : SCMConstant.BIGDECIMAL_ONE;
        exchangerate = exchangeRateInfo != null && exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE ? exchangerate.divide(_exchangerate, percision, 4) : exchangerate.multiply(_exchangerate);
        return exchangerate;
    }

    public static Date upTimestamp(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        GregorianCalendar calendarUp = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5) + 1);
        Date dateUp = new Date(calendarUp.getTime().getTime());
        return dateUp;
    }

    public static Date downTimestamp(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        GregorianCalendar calendarDown = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5));
        Date dateDown = new Date(calendarDown.getTime().getTime());
        return dateDown;
    }

    public static void insertCreditLogForSettle(String companyId, String custId, String id, ConsignSaleBillInfo consignSaleBillInfo, BigDecimal settleamount, CreditOperationEnum action) throws BOSException, EASBizException {
        CreditLogInfo info = new CreditLogInfo();
        Calendar cal = Calendar.getInstance();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)companyId));
        CustomerInfo customerInfo = new CustomerInfo();
        customerInfo.setId(BOSUuid.read((String)custId));
        info.setCompany(companyInfo);
        info.setCustomer(customerInfo);
        info.setCreditOperation(action);
        info.setOperateTime(ts);
        info.setBizDate(consignSaleBillInfo.getBizDate());
        info.setBillNumber(consignSaleBillInfo.getNumber());
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"ahdJYdFaYSXgU0A+qMB7EUY+1VI="));
        info.setBillType(billtype);
        info.setBillID(id);
        info.setUnArBillIssuedAmt(settleamount);
        CreditLogFactory.getRemoteInstance().save(info);
    }
}

