/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.ControlMethodEnum;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFormulaConstant;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.util.BillControlStrategy;

public class IssueBillControlStrtegy
extends BillControlStrategy {
    public IssueBillControlStrtegy(CreditParamInfo paramInfo) {
        super(paramInfo);
    }

    @Override
    public ContrlTimeEnum getControlTime() throws CreditControlException {
        this.checkParam();
        return ContrlTimeEnum.getEnum(this.paramInfo.getIssued_CtrlTime());
    }

    @Override
    public boolean isCtrlAmount(ContrlTimeEnum controlTime) throws CreditControlException {
        this.checkParam();
        return this.paramInfo.isCtrlIssuedAmount() && controlTime.getValue() == this.paramInfo.getIssued_CtrlTime();
    }

    @Override
    public boolean isCtrlTimelimit(ContrlTimeEnum controlTime) throws CreditControlException {
        this.checkParam();
        return this.paramInfo.isCtrlIssuedTimeLimit() && controlTime.getValue() == this.paramInfo.getIssued_CtrlTime();
    }

    @Override
    public String getFormulaForSave() {
        String formula = "FUnArBillIssuedAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5";
        if (this.paramInfo != null) {
            formula = this.paramInfo.getIssued_CtrlTime() == 2 ? "FUnArBillIssuedAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5" : "FUnAuditIssuedAmt+FUnArBillIssuedAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5";
        }
        return formula;
    }

    @Override
    public String getFormulaForDisplay() {
        String formula = CreditFormulaConstant.Issued_Amount_Formula_ATAUDIT_ForDisplay;
        if (this.paramInfo != null) {
            formula = this.paramInfo.getIssued_CtrlTime() == 2 ? CreditFormulaConstant.Issued_Amount_Formula_ATAUDIT_ForDisplay : CreditFormulaConstant.Issued_Amount_Formula_ATSUBMIT_ForDisplay;
        }
        return formula;
    }

    @Override
    public String getPassword() throws CreditControlException {
        this.checkParam();
        return this.paramInfo.getIssuedCtrlPassword();
    }

    @Override
    public ControlMethodEnum getControlMethod() throws CreditControlException {
        this.checkParam();
        return ControlMethodEnum.getEnum(this.paramInfo.getIssued_CreditCtrlMode());
    }

    @Override
    public String getBillName() {
        return this.getResource("ISSUEDBILL_NAME");
    }

    @Override
    public String getBillName(Context ctx) {
        return this.getResource("ISSUEDBILL_NAME", ctx);
    }

    @Override
    public boolean isCtrlAmount() throws CreditControlException {
        this.checkParam();
        return this.paramInfo.isCtrlIssuedAmount();
    }

    @Override
    public boolean isCtrlTimelimit() throws CreditControlException {
        this.checkParam();
        return this.paramInfo.isCtrlIssuedTimeLimit();
    }
}

