/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.ControlMethodEnum;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFormulaConstant;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.util.BillControlStrategy;

public class SaleOrderControlStrategy
extends BillControlStrategy {
    public SaleOrderControlStrategy(CreditParamInfo paramInfo) {
        super(paramInfo);
    }

    @Override
    public ContrlTimeEnum getControlTime() throws CreditControlException {
        this.checkParam();
        return ContrlTimeEnum.getEnum(this.paramInfo.getSO_CtrlTime());
    }

    @Override
    public boolean isCtrlAmount(ContrlTimeEnum controlTime) throws CreditControlException {
        this.checkParam();
        return this.paramInfo.isCtrlSaleOrderAmount() && controlTime.getValue() == this.paramInfo.getSO_CtrlTime();
    }

    @Override
    public boolean isCtrlTimelimit(ContrlTimeEnum controlTime) throws CreditControlException {
        this.checkParam();
        return this.paramInfo.isCtrlSaleOrderTimeLimit() && controlTime.getValue() == this.paramInfo.getSO_CtrlTime();
    }

    @Override
    public String getFormulaForSave() {
        String formula = "FUnArBillOrderAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5";
        if (this.paramInfo != null) {
            formula = this.paramInfo.getSO_CtrlTime() == 2 ? "FUnArBillOrderAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5" : "FUnAuditSOAmt+FUnArBillOrderAmt+FArBalance+FReserve1+FReserve2+FReserve3+FReserve4+FReserve5";
        }
        return formula;
    }

    @Override
    public String getFormulaForDisplay() {
        String formula = CreditFormulaConstant.SO_Amount_Formula_ATAUDIT_ForDisplay;
        if (this.paramInfo != null) {
            formula = this.paramInfo.getSO_CtrlTime() == 2 ? CreditFormulaConstant.SO_Amount_Formula_ATAUDIT_ForDisplay : CreditFormulaConstant.SO_Amount_Formula_ATSUBMIT_ForDisplay;
        }
        return formula;
    }

    @Override
    public String getPassword() throws CreditControlException {
        this.checkParam();
        return this.paramInfo.getSOCtrlPassword();
    }

    @Override
    public ControlMethodEnum getControlMethod() throws CreditControlException {
        this.checkParam();
        return ControlMethodEnum.getEnum(this.paramInfo.getSO_CreditCtrlMode());
    }

    @Override
    public String getBillName() {
        return this.getResource("SALEORDER_NAME");
    }

    @Override
    public String getBillName(Context ctx) {
        return this.getResource("SALEORDER_NAME", ctx);
    }

    @Override
    public boolean isCtrlAmount() throws CreditControlException {
        this.checkParam();
        return this.paramInfo.isCtrlSaleOrderAmount();
    }

    @Override
    public boolean isCtrlTimelimit() throws CreditControlException {
        this.checkParam();
        return this.paramInfo.isCtrlSaleOrderTimeLimit();
    }
}

