/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.util.StringUtil;
import com.kingdee.eas.base.form.web.WebBillEditPanel;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.orgext.ServiceOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.crm.common.CrmRoleInfo;
import com.kingdee.eas.scm.crm.common.RoleFacadeFactory;
import com.kingdee.eas.scm.crm.plugins.support.CRMBillPluginSupport;
import com.kingdee.eas.scm.crm.plugins.support.OperationFilterHelp;
import com.kingdee.eas.scm.crm.plugins.support.ServiceF7Filter;
import com.kingdee.eas.scm.crm.plugins.util.BillViewUtil;
import com.kingdee.eas.scm.crm.plugins.util.CRMPermissionHelper;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserCollection;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class ServiceRoleDistributeBillPlugin
extends CRMBillPluginSupport {
    private static final String CT_USER_KEY = "FbdShareUser";
    private String[] ids;
    private static final String VALUE_EDITPANEL_OPENTYPE = "2";
    private Entity entity;
    private boolean flag;

    public void storeShareDataOnInitalize() throws EASBizException, BOSException {
        this.ids = CommonUtil.initBillIDsForOpenWindow(this.application);
    }

    public void setF7DefaultFilter() throws EASBizException, BOSException {
        String parentFormID = this.application.getBillView().getParentFormView().getLayoutInfo().getFormId();
        this.application.setFieldFilter("FbdRole", "form.sourceBillId='" + parentFormID + "' and type!=-1");
        WebBillEditPanel billPanle = (WebBillEditPanel)this.application.getBillView().getParentFormView();
        ServiceOrgUnitInfo orgInfo = (ServiceOrgUnitInfo)billPanle.getBillModel().getBillValue().get("serviceOrgUnit");
        ServiceF7Filter.setOpAssociatedUserFilter(this.application, orgInfo);
    }

    public void carrayValue(DataChangeCommandArg arg) throws EASBizException, BOSException {
        UserInfo user;
        if (CT_USER_KEY.equalsIgnoreCase(arg.getKey()) && (user = (UserInfo)arg.getNewValue()) != null) {
            if (this.checkUserExist(user, arg.getRow())) {
                this.application.showMessage("\u4e0d\u80fd\u9009\u62e9\u91cd\u590d\u7684\u7528\u6237\u3002");
                this.application.setValue(CT_USER_KEY, null, arg.getRow());
            } else {
                String parentFormID = this.application.getBillView().getParentFormView().getLayoutInfo().getFormId();
                CrmRoleInfo view = CRMPermissionHelper.getShareUserRole(parentFormID);
                this.application.setValue("FbdRole", (Object)StringUtil.buildStringForObjNameAndNumber((Object[])new Object[]{view}), arg.getRow());
            }
        }
    }

    public void lockElementOnInitalize() throws EASBizException, BOSException {
        super.lockElementOnInitalize();
        this.lockSameRowElements(new String[]{CT_USER_KEY, "FbdRole"}, 0);
    }

    public void roleDistributeAction() throws EASBizException, BOSException, SQLException, ParserException {
        CoreBaseInfo info;
        OpAssociatedUserCollection shareUsers;
        List selectIDs = CommonUtil.array2List(this.ids);
        HashMap msgMap = new HashMap();
        boolean bo = false;
        this.entity = this.getEntity((DynamicFormApplication)this.application);
        OperationFilterHelp filterHelp = new OperationFilterHelp(this.entity, this.flag);
        String alerts = null;
        if (this.getParentData("isEnableCRMPermission") != null && this.getParentData("permissionName") != null) {
            msgMap.putAll(filterHelp.permissionFilter((DynamicFormApplication)this.application, selectIDs, (Boolean)this.getParentData("isEnableCRMPermission"), this.getParentData("permissionName").toString()));
            if (selectIDs.size() > 0) {
                msgMap.putAll(filterHelp.shareUserFilter((DynamicFormApplication)this.application, selectIDs, (Boolean)this.getParentData("isEnableCRMPermission"), this.getParentData("permissionName").toString()));
                bo = true;
            }
            alerts = filterHelp.getAlerts(msgMap, this.ids.length, selectIDs.size());
        }
        if ((shareUsers = (OpAssociatedUserCollection)((Object)(info = (CoreBaseInfo)this.application.getBillValue()).get("associatedUser"))) != null) {
            for (int i = 0; i < shareUsers.size(); ++i) {
                OpAssociatedUserInfo shareUser = shareUsers.get(i);
                if (shareUser.getUser() == null) {
                    this.application.showMessage("\u8bf7\u5728\u7b2c" + (i + 1) + "\u884c\u9009\u62e9\u4e00\u4e2a\u7528\u6237\u3002");
                    return;
                }
                if (shareUser.getRoles() != null) continue;
                this.application.showMessage("\u8bf7\u5728\u7b2c" + (i + 1) + "\u884c\u9009\u62e9\u89d2\u8272\u3002");
                return;
            }
            if (selectIDs.size() > 0 && !selectIDs.isEmpty()) {
                RoleFacadeFactory.getRemoteInstance().roleDistributeWithoutMerge(shareUsers, selectIDs.toArray(new String[selectIDs.size()]));
                IObjectPK[] pks = BillViewUtil.beforeLog(this.application, "roleDistribute", "\u5171\u4eab\u4eba\u7ba1\u7406", CommonUtil.list2Array(selectIDs));
                if (VALUE_EDITPANEL_OPENTYPE.equals(this.application.getCustomParameter("openSrc"))) {
                    BillViewUtil.afterLog(this.application, pks, CommonUtil.list2Array(selectIDs));
                    this.application.showMessage("\u5206\u914d\u5171\u4eab\u7528\u6237\u6210\u529f\u3002");
                } else {
                    this.application.showMessage(alerts);
                }
            } else if (VALUE_EDITPANEL_OPENTYPE.equals(this.application.getCustomParameter("openSrc"))) {
                if (bo) {
                    this.application.showMessage("\u8be5\u8bb0\u5f55\u6ca1\u6709\u8d1f\u8d23\u7528\u6237\uff0c\u4e0d\u80fd\u5206\u914d\u5171\u4eab\u7528\u6237\u3002");
                } else {
                    this.application.showMessage("\u53ea\u6709\u5355\u636e\u7684\u8d1f\u8d23\u4eba\u624d\u80fd\u64cd\u4f5c\u5f53\u524d\u529f\u80fd\u3002");
                }
            } else {
                this.application.showMessage(alerts);
            }
            this.closeAction();
        } else {
            this.application.showMessage("\u8bf7\u586b\u5199\u5171\u4eab\u6210\u5458\u4fe1\u606f\u3002");
        }
    }

    private Entity getEntity(DynamicFormApplication application) throws BOSException {
        this.flag = !VALUE_EDITPANEL_OPENTYPE.equals(application.getCustomParameter("openSrc"));
        BillApplication billApplication = (BillApplication)application;
        this.entity = CommonUtil.initEntityForOpenWindow(billApplication);
        return this.entity;
    }

    public void setDefaultValue() throws EASBizException, BOSException {
        WebBillEditPanel billPanle = (WebBillEditPanel)this.application.getBillView().getParentFormView();
        OpAssociatedUserCollection opAssociatedUserCollection = (OpAssociatedUserCollection)((Object)billPanle.getBillModel().getBillValue().get("associatedUser"));
        CoreBaseInfo info = (CoreBaseInfo)this.application.getBillValue();
        OpAssociatedUserCollection opAssociatedUsers = (OpAssociatedUserCollection)((Object)info.get("associatedUser"));
        opAssociatedUsers.addCollection(opAssociatedUserCollection);
    }

    private boolean checkUserExist(UserInfo user, int selectedRow) {
        boolean exist = false;
        OpAssociatedUserCollection shareUsers = (OpAssociatedUserCollection)((Object)this.application.getBillValue().get("associatedUser"));
        if (shareUsers != null) {
            for (int i = 0; i < shareUsers.size(); ++i) {
                UserInfo rowUser;
                if (i == selectedRow || (rowUser = (UserInfo)this.application.getValue(CT_USER_KEY, i)) == null || !rowUser.getId().equals((Object)user.getId())) continue;
                exist = true;
                return exist;
            }
        }
        return exist;
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        if (operation.getOperation().equalsIgnoreCase("DeleteEntry") && "FbtnDeleteShare".equalsIgnoreCase(this.buttonClickedKey) && this.application.getBillView().getSelectedRow("FShare") == 0) {
            this.application.showMessage("\u4e0d\u80fd\u5220\u9664\u7b2c\u4e00\u884c\u8bb0\u5f55\u3002");
            return false;
        }
        if (operation.getOperation().equalsIgnoreCase("InsertEntry") && "FbtnInsertShare".equalsIgnoreCase(this.buttonClickedKey) && this.application.getBillView().getSelectedRow("FShare") == 0) {
            this.application.showMessage("\u4e0d\u80fd\u5728\u7b2c\u4e00\u884c\u63d2\u5165\u8bb0\u5f55\u3002");
            return false;
        }
        return true;
    }

    public void closeAction() throws EASBizException, BOSException {
        this.application.close();
        this.application.setParentRefresh(true);
    }
}

