/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.customer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.common.BillTypeEnum;
import com.kingdee.eas.scm.crm.common.CrmRoleCollection;
import com.kingdee.eas.scm.crm.common.CrmRoleFactory;
import com.kingdee.eas.scm.crm.customer.ContactInfo;
import com.kingdee.eas.scm.crm.customer.CustomerInfo;
import com.kingdee.eas.scm.crm.plugins.bill.customer.AbstractCustomerModuleBillPlugin;
import com.kingdee.eas.scm.crm.plugins.util.CRMPermissionHelper;
import com.kingdee.eas.scm.crm.sm.BizOppContactFactory;
import com.kingdee.eas.scm.crm.sm.BizOppContactInfo;
import com.kingdee.eas.scm.crm.sm.BusinOpportInfo;
import com.kingdee.eas.scm.crm.sm.ClueContacorFactory;
import com.kingdee.eas.scm.crm.sm.ClueContacorInfo;
import com.kingdee.eas.scm.crm.sm.ClueInfo;
import com.kingdee.eas.scm.crm.sm.QuotationContactorFactory;
import com.kingdee.eas.scm.crm.sm.QuotationContactorInfo;
import com.kingdee.eas.scm.crm.sm.QuotationInfo;
import com.kingdee.eas.util.app.ContextUtil;

public class ContacterBillPlugin
extends AbstractCustomerModuleBillPlugin {
    private static final String CT_CUSTOMER_KEY = "FbdCustomer";
    private static final String CT_SUPERCONTACTER_KEY = "FbdSuperiorContact";

    protected void storeShareDataOnLoad() throws EASBizException, BOSException {
        super.storeShareDataOnInitalize();
        ContactInfo contact = (ContactInfo)this.application.getBillValue();
        this.application.getApplicationContext().putData("BillType", (Object)BillTypeEnum.CONTRACT);
        if (contact.getId() != null) {
            this.storeDataInPageScope("BillId", contact.getId().toString());
        }
    }

    public void setF7DefaultFilter() throws EASBizException, BOSException {
        super.setF7DefaultFilter();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.getContext());
        ContactInfo contactor = (ContactInfo)this.application.getBillValue();
        UserInfo creator = contactor.getCreator();
        if (creator == null) {
            creator = userInfo;
        }
        this.setSuperContacterFilter(contactor, creator);
        this.setCustomerFilter(creator);
    }

    private void setSuperContacterFilter(ContactInfo contactor, UserInfo creator) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("creator.id = '").append(creator.getId()).append("' and id != '");
        oql.append(contactor.getId()).append("' or id in ( select SHAREUSER.FEntityID from T_CRM_OpAssociatedUser SHAREUSER where SHAREUSER.FUserID='");
        oql.append(creator.getId()).append("' and SHAREUSER.FEntityID !='").append(contactor.getId()).append("')");
        this.application.setFieldFilter(CT_SUPERCONTACTER_KEY, oql.toString());
    }

    private void setCustomerFilter(UserInfo creator) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("( creator.id='").append(creator.getId()).append("' and isDeleted = 0)");
        oql.append(" or ( id in ( select SHAREUSER.FEntityID from T_CRM_OpAssociatedUser SHAREUSER where SHAREUSER.FUserID='").append(creator.getId()).append("') and isDeleted = 0 )");
        this.application.setFieldFilter(CT_CUSTOMER_KEY, oql.toString());
    }

    public void lockElementOnInitalize() throws EASBizException, BOSException {
        BOSUuid uuid;
        super.lockElementOnInitalize();
        String customerID = (String)this.getParentData("BillId");
        if (customerID != null && (uuid = BOSUuid.read((String)customerID)).getType().equals((Object)new CustomerInfo().getBOSType())) {
            this.application.lockElement(CT_CUSTOMER_KEY, true);
        }
        ContactInfo contactInfo = (ContactInfo)this.application.getBillValue();
        if (this.getBillID() != null && (BillTypeEnum.BIZ.equals(this.getParentData("BillType")) || BillTypeEnum.CLUE.equals(this.getParentData("BillType")) || BillTypeEnum.QUOTATION.equals(this.getParentData("BillType"))) && contactInfo.getCreator() != null && !this.isResponsible()) {
            this.application.lockElement("FdistributeUser", true);
            this.application.lockElement("FrecycleUser", true);
            this.application.lockElement("FdistributePerson", true);
            this.application.lockElement("FrecyclePerson", true);
            this.application.lockElement("btn", true);
            this.application.lockElement("btn21", true);
            this.application.lockElement("btn1", true);
            this.application.lockElement("btn211", true);
        }
    }

    public void setDefaultValue() throws EASBizException, BOSException {
        super.setDefaultValue();
        ContactInfo contactInfo = (ContactInfo)this.application.getBillModel().getBillValue();
        this.initParentInfo(contactInfo);
    }

    private void initParentInfo(ContactInfo contactInfo) {
        String customerID = (String)this.getParentData("BillId");
        if (customerID != null) {
            CustomerInfo customer = new CustomerInfo();
            customer.setId(BOSUuid.read((String)customerID));
            contactInfo.setCustomer(customer);
        }
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        super.afterOperation(operation);
        String mainEntityId = (String)this.getParentData("BillId");
        if (null != mainEntityId && "save".equalsIgnoreCase(operation.getOperation())) {
            BillTypeEnum type = (BillTypeEnum)((Object)this.getParentData("BillType"));
            if (BillTypeEnum.CLUE.equals((Object)type)) {
                ClueInfo clue = new ClueInfo();
                clue.setId(BOSUuid.read((String)mainEntityId));
                ClueContacorInfo clueContacorInfo = new ClueContacorInfo();
                clueContacorInfo.setContactor((ContactInfo)this.application.getBillValue());
                clueContacorInfo.setClue(clue);
                ClueContacorFactory.getRemoteInstance().addnew(clueContacorInfo);
            } else if (BillTypeEnum.BIZ.equals((Object)type)) {
                BusinOpportInfo businOpportInfo = new BusinOpportInfo();
                businOpportInfo.setId(BOSUuid.read((String)mainEntityId));
                BizOppContactInfo bizOppContactInfo = new BizOppContactInfo();
                bizOppContactInfo.setContactor((ContactInfo)this.application.getBillValue());
                bizOppContactInfo.setBiz(businOpportInfo);
                BizOppContactFactory.getRemoteInstance().addnew(bizOppContactInfo);
            } else if (BillTypeEnum.QUOTATION.equals((Object)type)) {
                QuotationInfo quotationInfo = new QuotationInfo();
                quotationInfo.setId(BOSUuid.read((String)mainEntityId));
                QuotationContactorInfo quotationContactorInfo = new QuotationContactorInfo();
                quotationContactorInfo.setContactor((ContactInfo)this.application.getBillValue());
                quotationContactorInfo.setQuotation(quotationInfo);
                QuotationContactorFactory.getRemoteInstance().addnew(quotationContactorInfo);
            }
        }
    }

    private boolean isResponsible() throws EASBizException, BOSException {
        boolean isResponsible = CRMPermissionHelper.isResponsible(this.getBillID(), this.getContext(), BOSObjectType.create((String)this.application.getBillModel().getBusinessInfo().getEntity(0).getBosType()));
        return isResponsible;
    }

    protected CrmRoleCollection getDefaultCarrayCrmRoleValue() throws BOSException {
        return CrmRoleFactory.getRemoteInstance().getCrmRoleCollection("select * where form.sourceBillId='" + this.application.getForm().getId() + "' and name='\u5168\u90e8\u5173\u8054\u6570\u636e\u67e5\u770b\u89d2\u8272'");
    }

    protected String getDistributeShareUserPermissionName() {
        return "crm_contact_distributePerson";
    }

    protected String getDistributeUserPermissionName() {
        return "crm_contact_distributUser";
    }

    protected String getRecycleSharerUserPermissionName() {
        return "crm_contact_recycleUser";
    }

    protected String getRecycleUserPermissionName() {
        return "crm_contact_recyclePerson";
    }

    public boolean isEnableCRMPermission() {
        return true;
    }

    protected String getPermRelProp() {
        return "contact";
    }

    protected boolean isCRMBaseData() {
        return true;
    }
}

