/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.customer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.core.OpenModeEnum;
import com.kingdee.eas.base.form.metadata.ButtonAppearance;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.IDynamicFormView;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.command.BaseDataFilterArg;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.util.FormActionUtil;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.base.form.util.StringUtil;
import com.kingdee.eas.base.form.web.WebBillEditPanel;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.crm.common.BillStatusEnum;
import com.kingdee.eas.scm.crm.common.BillTypeEnum;
import com.kingdee.eas.scm.crm.common.CrmBillBaseInfo;
import com.kingdee.eas.scm.crm.common.CrmRoleCollection;
import com.kingdee.eas.scm.crm.common.CrmRoleFactory;
import com.kingdee.eas.scm.crm.customer.CustomerAllocationFactory;
import com.kingdee.eas.scm.crm.customer.CustomerCompanyInfoFactory;
import com.kingdee.eas.scm.crm.customer.CustomerConversionFactory;
import com.kingdee.eas.scm.crm.customer.CustomerConversionInfo;
import com.kingdee.eas.scm.crm.customer.CustomerFactory;
import com.kingdee.eas.scm.crm.customer.CustomerGroupDetailCollection;
import com.kingdee.eas.scm.crm.customer.CustomerInfo;
import com.kingdee.eas.scm.crm.customer.CustomerSaleInfoFactory;
import com.kingdee.eas.scm.crm.plugins.bill.common.SyncBaseData;
import com.kingdee.eas.scm.crm.plugins.bill.common.SyncToEASException;
import com.kingdee.eas.scm.crm.plugins.bill.customer.AbstractCustomerModuleBillPlugin;
import com.kingdee.eas.scm.crm.plugins.support.defaultValue.CommonDefaultValueHelper;
import com.kingdee.eas.scm.crm.plugins.support.filter.CommonF7FilterHelper;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.sm.ClueCustomerFactory;
import com.kingdee.eas.scm.crm.sm.ClueCustomerInfo;
import com.kingdee.eas.scm.crm.sm.ClueInfo;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.HashMap;

public class CustomerBillPlugin
extends AbstractCustomerModuleBillPlugin {
    private static final String CT_SUPERCUSTOMER_KEY = "FbdSuperiorCustomer";
    private static final String CT_CUSTOMERGROUPSTANDARD_KEY = "FbdCustomerGroupStandard";
    private static final String BTN_GROUPDETAILENTRY_DELETEENTRY_KEY = "FbtnDeleteGroup";
    private static final String BTN_GROUPDETAILRENTRY_INSERTENTRY_KEY = "FbtnInsertGroup";
    private static final String CT_GROUPDETAILENTRY_KEY = "FGroup";

    public void lockElementOnInitalize() throws EASBizException, BOSException {
        super.lockElementOnInitalize();
        this.lockAllElementForCustomerConversion();
    }

    private void lockAllElementForCustomerConversion() {
        BillStatusEnum billStatus;
        IDynamicFormView firstView = this.application.getBillView().getParentFormView();
        if (firstView == null) {
            return;
        }
        IDynamicFormView secondView = firstView.getParentFormView();
        if (secondView != null && BillStatusEnum.AUDITED == (billStatus = (BillStatusEnum)((Object)secondView.getApplicationContext().getData("BillStatus")))) {
            ButtonAppearance[] allButton = ((WebBillEditPanel)this.application.getBillView()).getLayoutInfo().getAllButtonAppearances();
            for (int i = 0; i < allButton.length; ++i) {
                this.application.lockElement(allButton[i].getKey(), 0, true);
            }
        }
    }

    public void storeShareDataOnInitalize() throws EASBizException, BOSException {
        super.storeShareDataOnInitalize();
        this.storeDataInPageScope("BillType", (Object)BillTypeEnum.CUSTOMER);
        CrmBillBaseInfo baseInfo = (CrmBillBaseInfo)this.application.getBillValue();
        if (baseInfo.getId() != null) {
            this.storeDataInPageScope("BillId", baseInfo.getId().toString());
        }
    }

    public void setDefaultValue() throws EASBizException, BOSException {
        CSSPGroupStandardCollection coll;
        super.setDefaultValue();
        CrmBillBaseInfo baseInfo = (CrmBillBaseInfo)this.application.getBillValue();
        CustomerGroupDetailCollection details = (CustomerGroupDetailCollection)((Object)baseInfo.get("customerGroupDetails"));
        if (details != null && details.size() > 0 && (coll = CSSPGroupStandardFactory.getRemoteInstance().getCSSPGroupStandardCollection("select * where type=1 and isBasic=1")) != null && !coll.isEmpty()) {
            details.get(0).setCustomerGroupStandard(coll.get(0));
        }
    }

    public void doAfterDataChanged(DataChangeCommandArg arg) throws EASBizException, BOSException {
        CrmBillBaseInfo baseInfo;
        CustomerGroupDetailCollection details;
        super.doAfterDataChanged(arg);
        if (CT_CUSTOMERGROUPSTANDARD_KEY.equalsIgnoreCase(arg.getKey()) && (details = (CustomerGroupDetailCollection)((Object)(baseInfo = (CrmBillBaseInfo)this.application.getBillValue()).get("customerGroupDetails"))).size() > 1) {
            for (int i = 0; i < details.size() - 1; ++i) {
                CSSPGroupStandardInfo info = details.get(i).getCustomerGroupStandard();
                if (info == null || arg.getNewValue() == null || !arg.getNewValue().toString().equals(info.toString())) continue;
                this.application.showMessage("\u4e0d\u80fd\u9009\u62e9\u91cd\u590d\u7684\u5206\u7c7b\u6807\u51c6\u3002");
                this.application.setValue(CT_CUSTOMERGROUPSTANDARD_KEY, null, arg.getRow());
            }
        }
    }

    public void setF7DefaultFilter() throws EASBizException, BOSException {
        super.setF7DefaultFilter();
        CrmBillBaseInfo baseInfo = (CrmBillBaseInfo)this.application.getBillValue();
        StringBuffer oql = new StringBuffer();
        oql.append("CU.id = '").append(ContextUtil.getCurrentCtrlUnit((Context)this.getContext()).getId()).append("'");
        if (baseInfo.getId() != null) {
            oql.append(" and id != '").append(baseInfo.getId()).append("'");
        }
        this.application.setFieldFilter(CT_SUPERCUSTOMER_KEY, oql.toString());
        this.setCustomerGroupStandardFilter();
    }

    private void setCustomerGroupStandardFilter() throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("longNumber"));
        CtrlUnitInfo cu = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)this.getContext()).getId()), selector);
        CtrlUnitCollection cus = CommonUtil.getFullCu(cu);
        if (cus != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("CU.id in ( ");
            for (int i = 0; i < cus.size(); ++i) {
                sb.append("'").append(cus.get(i).getId()).append("',");
            }
            sb.append(")");
            if (sb.indexOf(",") != -1) {
                sb.deleteCharAt(sb.lastIndexOf(","));
            }
            this.application.setFieldFilter(CT_CUSTOMERGROUPSTANDARD_KEY, sb.toString());
        }
    }

    public void onGetFieldFilter(BaseDataFilterArg arg) throws EASBizException, BOSException {
        super.onGetFieldFilter(arg);
        CommonF7FilterHelper.setAreaFilter((DynamicFormApplication)this.application, arg, "FbdCountry", "FbdArea", "FbdProvince", "FbdCity", "FbdRegion");
        this.setCustomerGroupFilter(arg);
    }

    private void setCustomerGroupFilter(BaseDataFilterArg arg) throws EASBizException, BOSException {
        if ("FbdCustomerGroup".equalsIgnoreCase(arg.getKey())) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("longNumber"));
            CtrlUnitInfo cu = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)this.getContext()).getId()), selector);
            CtrlUnitCollection cus = CommonUtil.getFullCu(cu);
            if (cus != null) {
                CSSPGroupStandardInfo groupStandardInfo = (CSSPGroupStandardInfo)this.application.getValue(CT_CUSTOMERGROUPSTANDARD_KEY, arg.getRowIndex());
                StringBuffer oql = new StringBuffer();
                if (groupStandardInfo != null) {
                    oql.append("groupStandard.id='").append(groupStandardInfo.getId()).append("' and CU.id in (");
                } else {
                    oql.append("CU.id in (");
                }
                for (int i = 0; i < cus.size(); ++i) {
                    oql.append("'").append(cus.get(i).getId()).append("',");
                }
                oql.append(")");
                if (oql.indexOf(",") != -1) {
                    oql.deleteCharAt(oql.lastIndexOf(","));
                }
                arg.setOql(oql.toString());
            }
        }
    }

    protected String getPermRelProp() {
        return "customer";
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        if ("Save".equalsIgnoreCase(operation.getOperation())) {
            CrmBillBaseInfo baseInfo = (CrmBillBaseInfo)this.application.getBillValue();
            CustomerGroupDetailCollection details = (CustomerGroupDetailCollection)((Object)baseInfo.get("customerGroupDetails"));
            if (details == null) {
                this.application.showMessage("\u5ba2\u6237\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return false;
            }
            if (details.size() == 0) {
                this.application.showMessage("\u5ba2\u6237\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return false;
            }
        }
        if (operation.getOperation().equalsIgnoreCase("DeleteEntry") && BTN_GROUPDETAILENTRY_DELETEENTRY_KEY.equalsIgnoreCase(this.buttonClickedKey) && this.application.getBillView().getSelectedRow(CT_GROUPDETAILENTRY_KEY) == 0) {
            this.application.showMessage("\u4e0d\u80fd\u5220\u9664\u7b2c\u4e00\u884c\u8bb0\u5f55\u3002");
            return false;
        }
        if (operation.getOperation().equalsIgnoreCase("InsertEntry") && BTN_GROUPDETAILRENTRY_INSERTENTRY_KEY.equalsIgnoreCase(this.buttonClickedKey) && this.application.getBillView().getSelectedRow(CT_GROUPDETAILENTRY_KEY) == 0) {
            this.application.showMessage("\u4e0d\u80fd\u5728\u7b2c\u4e00\u884c\u63d2\u5165\u8bb0\u5f55\u3002");
            return false;
        }
        return super.beforeOperation(operation);
    }

    public void carrayValue(DataChangeCommandArg arg) throws EASBizException, BOSException {
        super.carrayValue(arg);
        if ("FbdCustomerGroup".equalsIgnoreCase(arg.getKey()) || CT_CUSTOMERGROUPSTANDARD_KEY.equalsIgnoreCase(arg.getKey())) {
            CSSPGroupInfo group;
            String name = null;
            if ("FbdCustomerGroup".equalsIgnoreCase(arg.getKey())) {
                group = (CSSPGroupInfo)arg.getNewValue();
                name = group != null ? group.getName() : null;
            } else if (CT_CUSTOMERGROUPSTANDARD_KEY.equalsIgnoreCase(arg.getKey())) {
                group = (CSSPGroupStandardInfo)arg.getNewValue();
                name = group != null ? group.getName() : null;
            }
            CSSPGroupStandardInfo standard = (CSSPGroupStandardInfo)this.application.getValue(CT_CUSTOMERGROUPSTANDARD_KEY, arg.getRow());
            if (name != null && standard != null) {
                this.application.setValue("FfullName", (Object)(name + "." + standard.getName()), arg.getRow());
            } else {
                this.application.setValue("FfullName", null, arg.getRow());
            }
        }
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        super.afterOperation(operation);
        if ("Save".equalsIgnoreCase(operation.getOperation())) {
            String mainEntityId = String.valueOf(this.getParentData("BillId"));
            BillTypeEnum type = (BillTypeEnum)((Object)this.getParentData("BillType"));
            if (BillTypeEnum.CLUE.equals((Object)type)) {
                ClueInfo clue = new ClueInfo();
                clue.setId(BOSUuid.read((String)mainEntityId));
                ClueCustomerInfo clueCustomerInfo = new ClueCustomerInfo();
                clueCustomerInfo.setCustomer((CustomerInfo)this.application.getBillValue());
                clueCustomerInfo.setClue(clue);
                ClueCustomerFactory.getRemoteInstance().addnew(clueCustomerInfo);
            }
        }
    }

    public void convertAction() throws Exception {
        CustomerInfo customer = (CustomerInfo)this.application.getBillValue();
        String param = ParamManager.getParamValue(null, null, (String)"CRM_Customer0003");
        if (param != null && Boolean.TRUE.toString().equals(param) && customer.getBillStatus() != BillStatusEnum.AUDITED) {
            this.application.showMessage("\u8bf7\u5148\u5ba1\u6838\u5ba2\u6237\u6863\u6848\u3002");
            return;
        }
        if (customer.getCustomerConversion() != null) {
            this.application.showMessage("\u5ba2\u6237\u8f6c\u6b63\u7533\u8bf7\u5355\u5df2\u7ecf\u751f\u6210\u3002");
            return;
        }
        String customerPK = customer.getId().toString();
        IObjectPK customerConvertionPK = this.copyCustomerToCustomerConvertion(customer);
        CustomerConversionInfo customerConversionInfo = new CustomerConversionInfo();
        customerConversionInfo.setId(BOSUuid.read((String)customerConvertionPK.toString()));
        this.copyCustomerDistributeToDB(customerPK, customerConversionInfo);
        this.copyCustomerConvertionSIToDB(customerPK, customerConversionInfo);
        this.copyCustomerConvertionFIToDB(customerPK, customerConversionInfo);
        customer.setCustomerConversion(customerConversionInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("customerConversion");
        CustomerFactory.getRemoteInstance().updatePartial(customer, sic);
        this.showCustomerConvertion(customerConvertionPK.toString());
    }

    private IObjectPK copyCustomerToCustomerConvertion(CustomerInfo customer) throws SyncToEASException, BOSException, EASBizException {
        HashMap<String, String> propertyMapping = new HashMap<String, String>();
        propertyMapping.put("customerGroupDetails:parent", "customerGroupDetails:customerCoversion");
        propertyMapping.put("busiLicence", "busLicence");
        HashMap<String, BillStatusEnum> specifiedValues = new HashMap<String, BillStatusEnum>();
        specifiedValues.put("billStatus", BillStatusEnum.TEMPORARILYSAVED);
        CustomerConversionInfo customerConversion = (CustomerConversionInfo)SyncBaseData.copyCoreBaseData(CustomerConversionInfo.class, (IObjectValue)customer, new String[]{"id", "auditor", "auditTime", "lastUpdateUser", "lastUpdateTime", "associatedUser"}, propertyMapping, specifiedValues);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)this.getContext());
        OpAssociatedUserInfo shareUser = new OpAssociatedUserInfo();
        shareUser.setUser(user);
        CrmRoleCollection infos = CrmRoleFactory.getRemoteInstance().getCrmRoleCollection("select * where form.sourceBillId='JwcwG79uTOKiIY1hJ3/8Q5p+rpI=' and name='\u8d1f\u8d23\u4eba'");
        if (infos != null && infos.size() > 0) {
            shareUser.setRoles(StringUtil.buildStringForObjNameAndNumber((Object[])new Object[]{infos.get(0)}));
        }
        shareUser.setCtrlUnit(user.getCU());
        customerConversion.getAssociatedUser().add(shareUser);
        customerConversion.setHandler(ContextUtil.getCurrentUserInfo((Context)this.getContext()));
        customerConversion.setCreateTime(new Timestamp(System.currentTimeMillis()));
        customerConversion.setCreator(ContextUtil.getCurrentUserInfo((Context)this.getContext()));
        customerConversion.setPerson(ContextUtil.getCurrentUserInfo((Context)this.getContext()).getPerson());
        customerConversion.setCreateOrg((FullOrgUnitInfo)ContextUtil.getCurrentOrgUnit((Context)this.getContext()));
        customerConversion.setCU(ContextUtil.getCurrentCtrlUnit((Context)this.getContext()));
        customerConversion.setDepartment(CommonDefaultValueHelper.getDept(ContextUtil.getCurrentUserInfo((Context)this.getContext()).getPerson(), this.getContext()));
        return CustomerConversionFactory.getRemoteInstance().addnew(customerConversion);
    }

    private void copyCustomerDistributeToDB(String customerPK, CustomerConversionInfo customerConversionInfo) throws SyncToEASException {
        CoreBaseCollection colls;
        try {
            colls = CustomerAllocationFactory.getRemoteInstance().getCollection("where customer.id='" + customerPK + "'");
        }
        catch (BOSException e) {
            throw new SyncToEASException("\u5ba2\u6237\u8f6c\u6b63\u5931\u8d25\u3002", e);
        }
        if (colls != null) {
            for (int i = 0; i < colls.size(); ++i) {
                colls.get(i).put("customerConversion", (Object)customerConversionInfo);
            }
            try {
                CustomerAllocationFactory.getRemoteInstance().update(colls);
            }
            catch (EASBizException e) {
                throw new SyncToEASException("\u5ba2\u6237\u8f6c\u6b63\u5931\u8d25\u3002", e);
            }
            catch (BOSException e) {
                throw new SyncToEASException("\u5ba2\u6237\u8f6c\u6b63\u5931\u8d25\u3002", e);
            }
        }
    }

    private void copyCustomerConvertionSIToDB(String customerPK, CustomerConversionInfo customerConversionInfo) throws SyncToEASException {
        CoreBaseCollection colls;
        try {
            colls = CustomerSaleInfoFactory.getRemoteInstance().getCollection("where customer.id='" + customerPK + "'");
        }
        catch (BOSException e) {
            throw new SyncToEASException("\u5ba2\u6237\u8f6c\u6b63\u5931\u8d25\u3002", e);
        }
        try {
            if (colls != null) {
                for (int i = 0; i < colls.size(); ++i) {
                    colls.get(i).put("customerConversion", (Object)customerConversionInfo);
                    colls.get(i).put("handler", (Object)ContextUtil.getCurrentUserInfo((Context)this.getContext()));
                    colls.get(i).put("createTime", (Object)new Timestamp(System.currentTimeMillis()));
                    colls.get(i).put("creator", (Object)ContextUtil.getCurrentUserInfo((Context)this.getContext()));
                    colls.get(i).put("person", (Object)ContextUtil.getCurrentUserInfo((Context)this.getContext()).getPerson());
                    colls.get(i).put("createOrg", (Object)((FullOrgUnitInfo)ContextUtil.getCurrentOrgUnit((Context)this.getContext())));
                    colls.get(i).put("CU", (Object)ContextUtil.getCurrentCtrlUnit((Context)this.getContext()));
                    colls.get(i).put("department", (Object)CommonDefaultValueHelper.getDept(ContextUtil.getCurrentUserInfo((Context)this.getContext()).getPerson(), this.getContext()));
                }
                CustomerSaleInfoFactory.getRemoteInstance().update(colls);
            }
        }
        catch (EASBizException e) {
            throw new SyncToEASException("\u5ba2\u6237\u8f6c\u6b63\u5931\u8d25\u3002", e);
        }
        catch (BOSException e) {
            throw new SyncToEASException("\u5ba2\u6237\u8f6c\u6b63\u5931\u8d25\u3002", e);
        }
    }

    private void copyCustomerConvertionFIToDB(String customerPK, CustomerConversionInfo customerConversionInfo) throws SyncToEASException {
        CoreBaseCollection colls;
        try {
            colls = CustomerCompanyInfoFactory.getRemoteInstance().getCollection("where customer.id='" + customerPK + "'");
        }
        catch (BOSException e) {
            throw new SyncToEASException("\u5ba2\u6237\u8f6c\u6b63\u5931\u8d25\u3002", e);
        }
        try {
            if (colls != null) {
                for (int i = 0; i < colls.size(); ++i) {
                    colls.get(i).put("customerConversion", (Object)customerConversionInfo);
                    colls.get(i).put("handler", (Object)ContextUtil.getCurrentUserInfo((Context)this.getContext()));
                    colls.get(i).put("createTime", (Object)new Timestamp(System.currentTimeMillis()));
                    colls.get(i).put("creator", (Object)ContextUtil.getCurrentUserInfo((Context)this.getContext()));
                    colls.get(i).put("person", (Object)ContextUtil.getCurrentUserInfo((Context)this.getContext()).getPerson());
                    colls.get(i).put("createOrg", (Object)((FullOrgUnitInfo)ContextUtil.getCurrentOrgUnit((Context)this.getContext())));
                    colls.get(i).put("CU", (Object)ContextUtil.getCurrentCtrlUnit((Context)this.getContext()));
                    colls.get(i).put("department", (Object)CommonDefaultValueHelper.getDept(ContextUtil.getCurrentUserInfo((Context)this.getContext()).getPerson(), this.getContext()));
                }
                CustomerCompanyInfoFactory.getRemoteInstance().update(colls);
            }
        }
        catch (EASBizException e) {
            throw new SyncToEASException("\u5ba2\u6237\u8f6c\u6b63\u5931\u8d25\u3002", e);
        }
        catch (BOSException e) {
            throw new SyncToEASException("\u5ba2\u6237\u8f6c\u6b63\u5931\u8d25\u3002", e);
        }
    }

    private void showCustomerConvertion(String customerConvertionPK) throws BOSException, EASBizException {
        JSONObject urlParam = new JSONObject();
        JSONObject winParam = new JSONObject();
        try {
            urlParam.put("statu", (Object)"VIEW");
            if (this.application.getForm().getName().indexOf("\u6211\u7684") != -1) {
                urlParam.put("formID", (Object)"WBydHaL+RjuUN5YVmb15aZp+rpI=");
                winParam.put("title", (Object)"\u6211\u7684\u5ba2\u6237\u8f6c\u6b63");
            } else {
                urlParam.put("formID", (Object)"JwcwG79uTOKiIY1hJ3/8Q5p+rpI=");
                winParam.put("title", (Object)"\u5ba2\u6237\u8f6c\u6b63");
            }
            urlParam.put("pk", (Object)customerConvertionPK);
            winParam.put("name", (Object)"convertion");
            winParam.put("x", 962);
            winParam.put("y", 1110);
            String url = ResourceUtil.buildUrlEncodeParam((String)"/easweb/servlet/BillServlet", null);
            FormActionUtil.invokeShowPopupAction((IFormApplication)this.application, (String)urlParam.toString(), (String)winParam.toString(), (String)url, (OpenModeEnum)OpenModeEnum.OpenDialog);
            this.application.close();
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean enableSubmitToAudit() throws EASBizException, BOSException {
        String param = ParamManager.getParamValue(null, null, (String)"CRM_Customer0001");
        return param != null && Boolean.TRUE.toString().equals(param);
    }

    protected boolean enableUnAudit() throws EASBizException, BOSException {
        String param = ParamManager.getParamValue(null, null, (String)"CRM_Customer0002");
        return param != null && Boolean.TRUE.toString().equals(param);
    }

    protected boolean isCRMBaseData() {
        return true;
    }

    protected String getDistributeShareUserPermissionName() {
        return "crm_customer_distributePerson";
    }

    protected String getDistributeUserPermissionName() {
        return "crm_customer_distributUser";
    }

    protected String getRecycleSharerUserPermissionName() {
        return "crm_customer_recyclePerson";
    }

    protected String getRecycleUserPermissionName() {
        return "crm_customer_recycleUser";
    }
}

