/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.market;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.model.command.BaseDataFilterArg;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.orgext.MarketOrgTypeAddNewInfo;
import com.kingdee.eas.basedata.orgext.MarketOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.market.CompeteProductInfo;
import com.kingdee.eas.scm.crm.plugins.bill.market.AbstractMarketModuleBillPlugin;
import com.kingdee.eas.scm.crm.plugins.util.FinanceUtil;
import java.math.BigDecimal;

public class CompeteProductBillPlugin
extends AbstractMarketModuleBillPlugin {
    private static final String KEY_CURRENCY = "FbdCurrency";
    private static final String KEY_RATE = "FRate";

    public void doOnLoad() {
    }

    public void doAfterCreateNewData() throws EASBizException, BOSException {
        CompeteProductInfo competeProductInfo = (CompeteProductInfo)this.application.getBillModel().getBillValue();
        MarketOrgUnitInfo marketOrgUnitInfo = (MarketOrgUnitInfo)this.application.getValue("ForgMarketOrgUnit", 0);
        if (marketOrgUnitInfo != null) {
            this.setDefaultValueForCompanyOrgUnit(competeProductInfo, marketOrgUnitInfo);
        }
    }

    private void setDefaultValueForCompanyOrgUnit(CompeteProductInfo competeProductInfo, MarketOrgUnitInfo marketOrgUnitInfo) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo;
        CompanyOrgUnitInfo companyUnitInfo = FinanceUtil.getCompanyOrgUnit(MarketOrgTypeAddNewInfo.newOrgType, marketOrgUnitInfo.getId());
        if (companyUnitInfo != null && (currencyInfo = FinanceUtil.getBaseCurrencyInfo(companyUnitInfo)) != null) {
            competeProductInfo.setCurrency(currencyInfo);
            BOSUuid exchangetableId = companyUnitInfo.getBaseExchangeTable().getId();
            BigDecimal exchangeRate = FinanceUtil.getExchangeRate(exchangetableId, currencyInfo.getId(), companyUnitInfo.getBaseCurrency().getId());
            competeProductInfo.setExchangeRate(exchangeRate);
        }
    }

    public void doDataChanged(DataChangeCommandArg dataChangeCommandArg) {
        CompeteProductInfo competeProductInfo = (CompeteProductInfo)this.application.getBillModel().getBillValue();
        try {
            CompanyOrgUnitInfo companyUnitInfo;
            if (dataChangeCommandArg.getKey().equalsIgnoreCase(KEY_CURRENCY) && (companyUnitInfo = FinanceUtil.getCompanyOrgUnit(MarketOrgTypeAddNewInfo.newOrgType, competeProductInfo.getMarketOrgUnit().getId())) != null) {
                BOSUuid exchangetableId = companyUnitInfo.getBaseExchangeTable().getId();
                CurrencyInfo currencyInfo = (CurrencyInfo)this.application.getValue(KEY_CURRENCY, 0);
                if (currencyInfo != null) {
                    BigDecimal exchangeRate = FinanceUtil.getExchangeRate(exchangetableId, currencyInfo.getId(), companyUnitInfo.getBaseCurrency().getId());
                    this.application.setValue(KEY_RATE, (Object)exchangeRate, 0);
                }
            }
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
    }

    public void doGetFieldFilter(BaseDataFilterArg arg) throws EASBizException, BOSException {
    }

    protected void doLockElementAfterBindData() throws EASBizException, BOSException {
    }

    protected boolean isEnableCRMPemission() {
        return false;
    }
}

