/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.sale;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.command.BaseDataFilterArg;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.customer.CustomerInfo;
import com.kingdee.eas.scm.crm.plugins.bill.customer.AbstractCustomerModuleBillPlugin;
import com.kingdee.eas.scm.crm.plugins.support.CarryValueHelper;
import com.kingdee.eas.scm.crm.plugins.support.defaultValue.SaleDefaultValueHelper;
import com.kingdee.eas.scm.crm.plugins.support.filter.CommonF7FilterHelper;
import com.kingdee.eas.scm.crm.plugins.support.filter.SaleF7FilterHelper;
import com.kingdee.eas.scm.crm.plugins.util.CRMPermissionHelper;
import com.kingdee.eas.scm.crm.plugins.util.FinanceUtil;

public abstract class AbstractSaleModuleBillPlugin
extends AbstractCustomerModuleBillPlugin {
    public static final String CT_SELLER_KEY = "FbdSalePerson";
    public static final String CT_SALEORG_KEY = "ForgSaleOrgUnit";
    public static final String CT_CONVERTMETHOD_KEY = "FConvertMode";
    public static final String CT_SALEGROUP_KEY = "FbdSaleGroup";
    public static final String CT_USER_KEY = "FbdUser";
    public static final String CT_SHAREUSER_KEY = "FbdShareUser";
    public static final String CT_CUSTOMER_KEY = "FbdCustomer";
    public static final String CT_CONTACTORE_KEY = "FContactor";
    public static final String CT_CURRENCY_KEY = "FbdCurrency";
    public static final String CT_EXCHANGERATE_KEY = "FExchangeRate";
    public static final String CT_COMPANTYORGUNIT_KEY = "ForgCompanyOrgUnit";
    public static final String CT_BIZDAT_KEY = "FBizDate";
    public boolean isCopy = false;

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        if ("Copy".equalsIgnoreCase(operation.getOperation())) {
            this.isCopy = true;
        }
        return super.beforeOperation(operation);
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        if ("Copy".equalsIgnoreCase(operation.getOperation())) {
            this.isCopy = false;
        }
        super.afterOperation(operation);
    }

    public void setF7DefaultFilter() throws EASBizException, BOSException {
        super.setF7DefaultFilter();
        SaleF7FilterHelper.setSaleOrgFilter((DynamicFormApplication)this.application, new String[]{CT_SALEORG_KEY}, this.getPermissionName("View"));
        CommonF7FilterHelper.setDeptFilter((DynamicFormApplication)this.application, "ForgDepartment");
        CommonF7FilterHelper.setSaleGroupFilter(this.application, CT_SALEGROUP_KEY, CT_SALEORG_KEY);
        String myDataFilter = CRMPermissionHelper.buildMyFilterF7(this.getContext());
        this.application.setFieldFilter(CT_CUSTOMER_KEY, CRMPermissionHelper.buildMyF7Filter(this.getContext()));
        this.application.setFieldFilter(CT_CONTACTORE_KEY, myDataFilter);
        SaleF7FilterHelper.getMaterialSalesFilterString(this.application);
    }

    public void doAfterDataChanged(DataChangeCommandArg arg) throws EASBizException, BOSException {
        super.doAfterDataChanged(arg);
        if (CT_CURRENCY_KEY.equalsIgnoreCase(arg.getKey())) {
            CurrencyInfo newCurrency;
            CurrencyInfo currency = newCurrency = (CurrencyInfo)arg.getNewValue();
            CompanyOrgUnitInfo companyOrgUnit = (CompanyOrgUnitInfo)this.application.getValue(CT_COMPANTYORGUNIT_KEY, 0);
            CurrencyInfo baseCurrency = null;
            if (companyOrgUnit != null) {
                companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select * where id='" + companyOrgUnit.getId() + "'");
                baseCurrency = FinanceUtil.getBaseCurrencyInfo(companyOrgUnit);
            }
            if (currency != null && baseCurrency != null) {
                if (baseCurrency.getId().equals((Object)currency.getId())) {
                    this.application.setEnabled(CT_EXCHANGERATE_KEY, false);
                } else {
                    OperationStatus operationStatus = this.application.getBillView().getOperationStatus();
                    if (!OperationStatus.VIEW.equals(operationStatus)) {
                        this.application.setEnabled(CT_EXCHANGERATE_KEY, true);
                    }
                }
            }
        }
    }

    public void carrayValue(DataChangeCommandArg arg) throws EASBizException, BOSException {
        super.carrayValue(arg);
        if (!this.isCopy) {
            CarryValueHelper.carryValueBySaleOrg((DynamicFormApplication)this.application, arg, CT_SELLER_KEY, CT_SALEORG_KEY, CT_SALEGROUP_KEY, "ForgDepartment", CT_USER_KEY, CT_COMPANTYORGUNIT_KEY, CT_CURRENCY_KEY);
            CarryValueHelper.carryValueByCurrency((DynamicFormApplication)this.application, arg, CT_CURRENCY_KEY, CT_COMPANTYORGUNIT_KEY, CT_EXCHANGERATE_KEY, CT_CONVERTMETHOD_KEY, CT_BIZDAT_KEY);
        }
    }

    public void onGetFieldFilter(BaseDataFilterArg arg) throws EASBizException, BOSException {
        super.onGetFieldFilter(arg);
        if (CT_SALEGROUP_KEY.equalsIgnoreCase(arg.getKey())) {
            SaleOrgUnitInfo saleOrg = (SaleOrgUnitInfo)this.application.getValue(CT_SALEORG_KEY, 0);
            if (null == saleOrg) {
                throw new BOSException("\u8bf7\u5148\u8f93\u5165\u9500\u552e\u7ec4\u7ec7\u3002");
            }
            arg.setOql(CommonF7FilterHelper.buildSaleGroupFilter(this.application, CT_SALEORG_KEY));
        }
        if (CT_CONTACTORE_KEY.equalsIgnoreCase(arg.getKey())) {
            CustomerInfo customerInfo = (CustomerInfo)this.application.getValue(CT_CUSTOMER_KEY, 0);
            if (customerInfo != null) {
                String customerId = customerInfo.getId().toString();
                arg.setOql(" customer.id='" + customerId + "' and " + CRMPermissionHelper.buildMyFilterF7(this.getContext()));
            } else {
                arg.setOql(CRMPermissionHelper.buildMyFilterF7(this.getContext()));
            }
        }
    }

    public void lockElementOnInitalize() throws EASBizException, BOSException {
        super.lockElementOnInitalize();
        CurrencyInfo currency = (CurrencyInfo)this.application.getValue(CT_CURRENCY_KEY, 0);
        CompanyOrgUnitInfo companyOrgUnit = (CompanyOrgUnitInfo)this.application.getValue(CT_COMPANTYORGUNIT_KEY, 0);
        CurrencyInfo baseCurrency = null;
        if (companyOrgUnit != null) {
            companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select * where id='" + companyOrgUnit.getId() + "'");
            baseCurrency = FinanceUtil.getBaseCurrencyInfo(companyOrgUnit);
        }
        if (currency != null && baseCurrency != null) {
            if (baseCurrency.getId().equals((Object)currency.getId())) {
                this.application.setEnabled(CT_EXCHANGERATE_KEY, false);
            } else {
                OperationStatus operationStatus = this.application.getBillView().getOperationStatus();
                this.application.setEnabled(CT_EXCHANGERATE_KEY, !operationStatus.equals(OperationStatus.VIEW));
            }
        }
    }

    public void setDefaultValue() throws EASBizException, BOSException {
        super.setDefaultValue();
        SaleDefaultValueHelper.setSaleOrgUnitValue(this.application, CT_SALEORG_KEY);
        SaleDefaultValueHelper.setSaleGroupValue(this.application, null, CT_SALEGROUP_KEY);
    }

    public void changeF7Filter(DataChangeCommandArg arg) throws EASBizException, BOSException {
        SaleOrgUnitInfo saleOrg;
        super.changeF7Filter(arg);
        if (CT_SALEORG_KEY.equalsIgnoreCase(arg.getKey())) {
            CommonF7FilterHelper.setSaleGroupFilter(this.application, CT_SALEGROUP_KEY, CT_SALEORG_KEY);
        }
        if (CT_SALEGROUP_KEY.equalsIgnoreCase(arg.getKey()) && null == (saleOrg = (SaleOrgUnitInfo)this.application.getValue(CT_SALEORG_KEY, 0))) {
            this.application.showMessage("\u8bf7\u5148\u8f93\u5165\u9500\u552e\u7ec4\u7ec7\u3002");
            return;
        }
    }

    protected boolean isCRMBaseData() {
        return false;
    }
}

