/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.sale;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.command.BaseDataFilterArg;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.crm.common.HandlerChangeHistoryFactory;
import com.kingdee.eas.scm.crm.plugins.bill.AbstractDistributePlugin;
import com.kingdee.eas.scm.crm.plugins.support.defaultValue.CommonDefaultValueHelper;
import com.kingdee.eas.scm.crm.plugins.support.defaultValue.SaleDefaultValueHelper;
import com.kingdee.eas.scm.crm.plugins.support.filter.CommonF7FilterHelper;
import com.kingdee.eas.scm.crm.plugins.util.BillViewUtil;
import com.kingdee.eas.scm.crm.plugins.util.CRMPermissionHelper;
import com.kingdee.eas.scm.crm.plugins.util.ChangeUserHistoryHelper;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.FinanceUtil;
import com.kingdee.eas.scm.crm.sm.ClueFactory;
import com.kingdee.eas.scm.crm.sm.ClueInfo;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserCollection;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserFactory;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.List;

public class ClueDistributeBillPlugin
extends AbstractDistributePlugin {
    protected void doDistribute(BillApplication application, List billIDs) throws EASBizException, BOSException {
        IObjectPK[] logPks = BillViewUtil.beforeLog(application, "clueAssign", "\u7ebf\u7d22\u5206\u914d", CommonUtil.initBillIDsForOpenWindow(application));
        Context ctx = application.getContext();
        UserInfo newUserInfo = (UserInfo)application.getValue("FbdUser", 0);
        SaleOrgUnitInfo newSaleOrgUnitInfo = (SaleOrgUnitInfo)application.getValue("ForgSaleOrgUnit", 0);
        SaleGroupInfo newSaleGroupInfo = (SaleGroupInfo)application.getValue("FbdSaleGroup", 0);
        UserCollection userCollection = CommonUtil.getUserCollection();
        int size = billIDs.size();
        for (int i = 0; i < size; ++i) {
            OpAssociatedUserCollection opAssociatedUserCollection;
            ClueInfo clueInfo = ClueFactory.getRemoteInstance().getClueInfo((IObjectPK)new ObjectUuidPK((String)billIDs.get(i)));
            OpAssociatedUserInfo opAssociatedUserInfo = OpAssociatedUserFactory.getRemoteInstance().getOpAssociatedUserInfo("select *  where    clue.id='" + billIDs.get(i).toString() + "'" + " and roles='" + CRMPermissionHelper.getAdmin("Ac1gWUBPQ0aVS9fk+YjFL5p+rpI=") + "' ");
            UserInfo olderHandler = opAssociatedUserInfo.getUser();
            if (null != olderHandler) {
                olderHandler = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK(String.valueOf(olderHandler.getId())));
            }
            if ((opAssociatedUserCollection = (OpAssociatedUserCollection)((Object)clueInfo.get("associatedUser"))) != null && opAssociatedUserCollection.size() > 0) {
                for (int j = 0; j < opAssociatedUserCollection.size(); ++j) {
                    opAssociatedUserInfo = opAssociatedUserCollection.get(j);
                    if (opAssociatedUserInfo.getUser() == null) continue;
                    if (opAssociatedUserInfo.getRoles().indexOf("\u8d1f\u8d23\u4eba") != -1) {
                        olderHandler = userCollection.get((Object)opAssociatedUserInfo.getUser().getId());
                        opAssociatedUserInfo.setUser(newUserInfo);
                        opAssociatedUserInfo.setCtrlUnit(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                        int shareUsersSize = opAssociatedUserCollection.size();
                        for (int k = 1; k < shareUsersSize; ++k) {
                            if (!opAssociatedUserCollection.get(k).getUser().getId().equals((Object)opAssociatedUserInfo.getUser().getId())) continue;
                            opAssociatedUserCollection.remove(opAssociatedUserCollection.get(k));
                        }
                        break;
                    }
                    clueInfo.put("associatedUser", (Object)this.getNewOpUserCollection(opAssociatedUserCollection, opAssociatedUserInfo, newUserInfo));
                }
            } else {
                clueInfo.put("associatedUser", (Object)this.getNewOpUserCollection(opAssociatedUserCollection, opAssociatedUserInfo, newUserInfo));
                olderHandler = (UserInfo)clueInfo.get("creator");
            }
            opAssociatedUserInfo.setUser(newUserInfo);
            opAssociatedUserInfo.setCtrlUnit(ContextUtil.getCurrentCtrlUnit((Context)application.getContext()));
            opAssociatedUserInfo.setCreateOrg((FullOrgUnitInfo)ContextUtil.getCurrentOrgUnit((Context)application.getContext()));
            clueInfo.setCreator(newUserInfo);
            clueInfo.setDepartment(CommonDefaultValueHelper.getDept(newUserInfo.getPerson(), ctx));
            clueInfo.setSaleOrgUnit(newSaleOrgUnitInfo);
            clueInfo.setPerson(newUserInfo.getPerson());
            clueInfo.setSaleGroup(newSaleGroupInfo);
            HandlerChangeHistoryFactory.getRemoteInstance().addnew(ChangeUserHistoryHelper.generateHistory(ctx, newUserInfo, olderHandler, billIDs.get(i).toString()));
            ClueFactory.getRemoteInstance().save((CoreBaseInfo)clueInfo);
            BillViewUtil.afterLog(application, logPks, CommonUtil.list2Array(billIDs));
            application.close();
            application.setParentRefresh(true);
        }
    }

    private OpAssociatedUserCollection getNewOpUserCollection(OpAssociatedUserCollection opAssociatedUserCollection, OpAssociatedUserInfo opAssociatedUserInfo, UserInfo userInfo) throws EASBizException, BOSException {
        Context ctx = this.application.getContext();
        OpAssociatedUserCollection userCollection = new OpAssociatedUserCollection();
        opAssociatedUserInfo = new OpAssociatedUserInfo();
        opAssociatedUserInfo.setUser(userInfo);
        opAssociatedUserInfo.setRoles(CRMPermissionHelper.getAdmin("Ac1gWUBPQ0aVS9fk+YjFL5p+rpI="));
        opAssociatedUserInfo.setCtrlUnit(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        opAssociatedUserInfo.setCreateOrg((FullOrgUnitInfo)ContextUtil.getCurrentOrgUnit((Context)ctx));
        userCollection.add(opAssociatedUserInfo);
        if (opAssociatedUserInfo != null) {
            int size = opAssociatedUserCollection.size();
            for (int i = 0; i < size; ++i) {
                if (!opAssociatedUserCollection.get(i).getUser().getId().equals((Object)opAssociatedUserInfo.getUser().getId())) continue;
                opAssociatedUserCollection.remove(opAssociatedUserCollection.get(i));
            }
        }
        if (opAssociatedUserCollection != null && !opAssociatedUserCollection.isEmpty()) {
            userCollection.addCollection(opAssociatedUserCollection);
        }
        return userCollection;
    }

    private void setDefaultValue(SaleOrgUnitInfo saleOrgUnitInfo, ClueInfo clueInfo) throws EASBizException, BOSException {
        if (saleOrgUnitInfo != null) {
            CompanyOrgUnitInfo companyOrg = FinanceUtil.getCompanyOrgUnit(OrgType.Sale, saleOrgUnitInfo.getId());
            clueInfo.setCompanyOrgUnit(companyOrg);
            if (companyOrg != null) {
                CurrencyInfo currency = FinanceUtil.getBaseCurrencyInfo(companyOrg);
                if (currency != null) {
                    clueInfo.setCurrency(currency);
                    clueInfo.setExchangeRate(new BigDecimal(1.0));
                } else {
                    clueInfo.setCurrency(null);
                    clueInfo.setExchangeRate(null);
                }
            } else {
                clueInfo.setCompanyOrgUnit(null);
                clueInfo.setCurrency(null);
            }
        } else {
            clueInfo.setCompanyOrgUnit(null);
            clueInfo.setCurrency(null);
        }
    }

    public void onGetFieldFilter(BaseDataFilterArg arg) throws EASBizException, BOSException {
        super.onGetFieldFilter(arg);
        if ("FbdSaleGroup".equalsIgnoreCase(arg.getKey())) {
            SaleOrgUnitInfo saleOrg = (SaleOrgUnitInfo)this.application.getValue("ForgSaleOrgUnit", 0);
            if (null == saleOrg) {
                throw new BOSException("\u8bf7\u5148\u8f93\u5165\u9500\u552e\u7ec4\u7ec7\u3002");
            }
            arg.setOql(CommonF7FilterHelper.setSaleGroupFilter(this.application, "ForgSaleOrgUnit", (UserInfo)this.application.getValue("FbdUser", 0)));
        }
    }

    public final void afterCreateNewData() throws EASBizException, BOSException {
        super.afterCreateNewData();
        SaleDefaultValueHelper.setSaleGroupValue(this.application, null, "FbdSaleGroup");
    }

    protected String getPermissionName() {
        return "crm_clue_assign";
    }

    protected BOSObjectType getBosObjectType() {
        return BOSObjectType.create((String)this.application.getForm().getBosType());
    }

    protected boolean isEnableCrmPermission() {
        return true;
    }
}

