/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.sale;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleUtils;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.model.command.NewEntryArg;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.crm.common.BillTypeEnum;
import com.kingdee.eas.scm.crm.common.CrmBillBaseInfo;
import com.kingdee.eas.scm.crm.customer.ContactFactory;
import com.kingdee.eas.scm.crm.customer.ContactInfo;
import com.kingdee.eas.scm.crm.customer.CustomerFactory;
import com.kingdee.eas.scm.crm.customer.CustomerInfo;
import com.kingdee.eas.scm.crm.plugins.bill.common.SyncBaseData;
import com.kingdee.eas.scm.crm.plugins.bill.common.SyncToEASException;
import com.kingdee.eas.scm.crm.plugins.bill.sale.AbstractSaleModuleBillPlugin;
import com.kingdee.eas.scm.crm.plugins.support.CarryValueHelper;
import com.kingdee.eas.scm.crm.plugins.support.DefaultValueHelper;
import com.kingdee.eas.scm.crm.plugins.support.filter.CommonF7FilterHelper;
import com.kingdee.eas.scm.crm.plugins.util.BillViewUtil;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.FinanceUtil;
import com.kingdee.eas.scm.crm.sm.BusinOpportInfo;
import com.kingdee.eas.scm.crm.sm.QuotationFactory;
import com.kingdee.eas.scm.crm.sm.QuotationInfo;
import com.kingdee.eas.scm.crm.sm.QuotationProductCollection;
import com.kingdee.eas.scm.crm.sm.QuotationProductInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class QuotationBillPlugin
extends AbstractSaleModuleBillPlugin {
    private static final String CT_COMPANTYORGUNIT_KEY = "ForgCompanyOrgUnit";
    private static final String CT_CURRENCY_KEY = "FbdCurrency";
    private static final String CT_EXCHANGERATE_KEY = "FRate";
    private static final String CT_CONVERTMETHOD_KEY = "FConvertMode";
    private static final String CT_BIZDAT_KEY = "FBizDate";
    private static final String CT_BIZ_KEY = "FbdBusinOpport";
    private static final String CT_ISPRESENT_KEY = "Fcheck1";
    private static final String CT_PRICE_KEY = "F7";
    private static final String CT_TAXPRICE_KEY = "F8";
    private static final String CT_DISCOUNTTYPE_KEY = "Flist2";
    private static final String CT_DISCOUNT_KEY = "Ffloat1";
    private static final String CT_DISCOUNTAMOUNT_KEY = "F23";
    private static final String CT_TAXAMOUNT_KEY = "F24";
    private static final String CT_TAX_KEY = "F25";
    private static final String CT_AMOUNT_KEY = "F11";
    private static final String CT_ACTUALPRICE_KEY = "F26";
    private static final String CT_ACTUALTAXPRICE_KEY = "F10";
    private static final String CT_CUSTOMER_KEY = "FbdCustomer";
    private static final String CT_PRODUCTNAME_KEY = "FMaterialName";
    private static final String CT_QTY_KEY = "F6";
    private static final String CT_UNIT_KEY = "Fbasedata4";
    private static final String CT_BASEUNITQTY_KEY = "F21";
    private static final String CT_BASEUNIT_KEY = "FbasedataProp1";
    private static final String CT_ASSISTUNIT_KEY = "Fbasedata5";
    private static final String CT_ASSISTUNITQTY_KEY = "F22";
    private static final String CT_TAXRATE_KEY = "Ffloat";
    private static final String CT_CONTACTER_KEY = "FContactor";
    private static final String CT_CONTACTERTELEPHONE_KEY = "Ftxt1";
    private static final String CT_CONTACTERMOBILEPHONE_KEY = "Ftxt4";
    private static final String CT_CONTACTERFAX_KEY = "Ftxt5";
    private static final String CT_SPMODEL = "FbasedataProp";
    private static final String CT_PRODUCTNUMBER_KEY = "FbasedataProp3";

    public void storeShareDataOnInitalize() throws EASBizException, BOSException {
        super.storeShareDataOnInitalize();
        this.storeDataInPageScope("BillType", (Object)BillTypeEnum.QUOTATION);
        CrmBillBaseInfo baseInfo = (CrmBillBaseInfo)this.application.getBillValue();
        if (baseInfo.getId() != null) {
            this.storeDataInPageScope("BillId", baseInfo.getId().toString());
        }
    }

    public void setDefaultValue() throws EASBizException, BOSException {
        super.setDefaultValue();
        if (!this.isCopy) {
            DefaultValueHelper.setDefaultValueForAmount(this.application, OrgType.Sale, CT_COMPANTYORGUNIT_KEY, CT_CURRENCY_KEY, CT_EXCHANGERATE_KEY, CT_CONVERTMETHOD_KEY, CT_BIZDAT_KEY);
            QuotationInfo quotationInfo = (QuotationInfo)this.application.getBillModel().getBillValue();
            quotationInfo.setEffectDate(this.dateAddByMonth(CommonUtil.createDateWithYYYYDDMM(), 1));
            this.initParentInfo(quotationInfo);
        }
    }

    private void initParentInfo(QuotationInfo quotationInfo) {
        String flag = (String)this.getParentData("operation");
        if (flag != null) {
            BusinOpportInfo businOpport = new BusinOpportInfo();
            businOpport.setId(null);
            quotationInfo.setCustomer(null);
            quotationInfo.setContact(null);
            quotationInfo.setBusinOpport(null);
            this.application.lockElement(CT_CUSTOMER_KEY, false);
            this.application.lockElement(CT_BIZ_KEY, false);
            this.application.lockElement(CT_CONTACTER_KEY, false);
            return;
        }
        String businOpportID = (String)this.getParentData("BillId");
        if (businOpportID != null) {
            BusinOpportInfo businOpport = new BusinOpportInfo();
            businOpport.setId(BOSUuid.read((String)businOpportID));
            quotationInfo.setBusinOpport(businOpport);
            String customerId = (String)this.getParentData("businCustomerId");
            CustomerInfo customerInfo = new CustomerInfo();
            customerInfo.setId(BOSUuid.read((String)customerId));
            quotationInfo.setCustomer(customerInfo);
            String contactId = (String)this.getParentData("businContactId");
            ContactInfo contactInfo = new ContactInfo();
            contactInfo.setId(BOSUuid.read((String)contactId));
            quotationInfo.setContact(contactInfo);
        }
    }

    public void setF7DefaultFilter() throws EASBizException, BOSException {
        super.setF7DefaultFilter();
        String myDataFilter = CommonF7FilterHelper.buildF7ShareUserFilter(this.getContext());
        this.application.setFieldFilter(CT_BIZ_KEY, myDataFilter);
    }

    public void carrayValue(DataChangeCommandArg arg) throws EASBizException, BOSException {
        super.carrayValue(arg);
        if (!this.isCopy) {
            ContactInfo contacter;
            CarryValueHelper.carryValueBySaleOrg((DynamicFormApplication)this.application, arg, "FbdSalePerson", "ForgSaleOrgUnit", "FbdSaleGroup", "ForgDepartment", "FbdUser", CT_COMPANTYORGUNIT_KEY, CT_CURRENCY_KEY);
            CarryValueHelper.carryValueByCurrency((DynamicFormApplication)this.application, arg, CT_CURRENCY_KEY, CT_COMPANTYORGUNIT_KEY, CT_EXCHANGERATE_KEY, CT_CONVERTMETHOD_KEY, CT_BIZDAT_KEY);
            CarryValueHelper.carryValueByProductNumber((DynamicFormApplication)this.application, arg, "ForgSaleOrgUnit", CT_PRODUCTNAME_KEY, CT_PRICE_KEY, CT_TAXRATE_KEY, CT_BASEUNIT_KEY, CT_UNIT_KEY, CT_ASSISTUNIT_KEY);
            CarryValueHelper.carryValueByUnitOrQty((DynamicFormApplication)this.application, arg, CT_QTY_KEY, CT_BASEUNITQTY_KEY, CT_PRODUCTNAME_KEY, CT_UNIT_KEY);
            if (CT_CONTACTER_KEY.equalsIgnoreCase(arg.getKey()) && (contacter = (ContactInfo)arg.getNewValue()) != null) {
                contacter = ContactFactory.getRemoteInstance().getContactInfo("select * where id='" + contacter.getId() + "'");
                this.application.setValue(CT_CONTACTERTELEPHONE_KEY, (Object)contacter.getTelephone(), 0);
                this.application.setValue(CT_CONTACTERMOBILEPHONE_KEY, (Object)contacter.getMobilePhone(), 0);
                this.application.setValue(CT_CONTACTERFAX_KEY, (Object)contacter.getFax(), 0);
            }
        }
    }

    public void doAfterDataChanged(DataChangeCommandArg arg) throws EASBizException, BOSException {
        Integer discountType;
        QuotationInfo quotationInfo = (QuotationInfo)this.application.getBillModel().getBillValue();
        int row = arg.getRow();
        if (CT_ISPRESENT_KEY.equalsIgnoreCase(arg.getKey())) {
            if ("true".equals(arg.getNewValue())) {
                this.lockSameRowElements(new String[]{CT_PRICE_KEY, CT_TAXPRICE_KEY, CT_DISCOUNTTYPE_KEY, CT_DISCOUNT_KEY, CT_DISCOUNTAMOUNT_KEY, CT_TAXAMOUNT_KEY, CT_TAX_KEY, CT_AMOUNT_KEY, CT_ACTUALPRICE_KEY, CT_ACTUALTAXPRICE_KEY}, row);
            } else {
                this.unLockSameRowElements(new String[]{CT_TAXPRICE_KEY, CT_DISCOUNTTYPE_KEY, CT_DISCOUNT_KEY, CT_DISCOUNTAMOUNT_KEY, CT_TAXAMOUNT_KEY, CT_TAX_KEY}, row);
            }
            QuotationProductCollection products = quotationInfo.getProduct();
            if (products != null) {
                for (int i = 0; i < products.size(); ++i) {
                    boolean flag = true;
                    flag = products.get(i).isIsPresent();
                    if (!flag) {
                        this.application.setEnabled("F13", flag);
                        break;
                    }
                    this.application.setEnabled("F13", flag);
                }
            }
        }
        if (CT_DISCOUNTTYPE_KEY.equalsIgnoreCase(arg.getKey())) {
            discountType = (Integer)this.application.getValue(CT_DISCOUNTTYPE_KEY, row);
            if (null == discountType) {
                return;
            }
            if (discountType == 0) {
                this.application.lockElement(CT_DISCOUNTAMOUNT_KEY, row, true);
                this.application.lockElement(CT_DISCOUNT_KEY, row, false);
            }
            if (discountType == 1) {
                this.application.lockElement(CT_DISCOUNT_KEY, row, true);
                this.application.lockElement(CT_DISCOUNTAMOUNT_KEY, row, false);
            }
        }
        if (CT_TAXPRICE_KEY.equalsIgnoreCase(arg.getKey()) || CT_DISCOUNTAMOUNT_KEY.equalsIgnoreCase(arg.getKey())) {
            discountType = (Integer)this.application.getValue(CT_DISCOUNTTYPE_KEY, row);
            if (null == discountType) {
                return;
            }
            if (null != discountType && discountType == 1) {
                QuotationInfo quotation = (QuotationInfo)this.application.getBillModel().getBillValue();
                QuotationProductCollection productCollection = quotation.getProduct();
                QuotationProductInfo quotationProductInfo = productCollection.get(arg.getRow());
                BigDecimal discountAmount = quotationProductInfo.getDiscountAmount();
                BigDecimal ratePrice = quotationProductInfo.getRatePrice();
                boolean flag = quotationProductInfo.isIsPresent();
                if (null != discountAmount && null != ratePrice && !flag && discountAmount.compareTo(ratePrice) > 0) {
                    this.application.showMessage("\u5f53\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u6298\u6263\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002");
                    return;
                }
            }
        }
        if (CT_PRODUCTNAME_KEY.equalsIgnoreCase(arg.getKey())) {
            MaterialInfo materialInfo = (MaterialInfo)this.application.getValue(CT_PRODUCTNAME_KEY, row);
            if (materialInfo == null) {
                this.application.setValue(CT_SPMODEL, null, row);
                this.application.setValue(CT_PRODUCTNUMBER_KEY, null, row);
                this.application.setValue(CT_ASSISTUNIT_KEY, null, row);
                this.application.setValue(CT_UNIT_KEY, null, row);
                this.application.setValue(CT_BASEUNIT_KEY, null, row);
            }
            if (materialInfo != null && materialInfo.getAssistUnit() == null) {
                this.application.setValue(CT_ASSISTUNITQTY_KEY, (Object)new BigDecimal("0.0000"), row);
                this.application.lockElement(CT_ASSISTUNITQTY_KEY, row, true);
            }
        }
        if (CT_ASSISTUNIT_KEY.equalsIgnoreCase(arg.getKey())) {
            MeasureUnitInfo measureUnit = (MeasureUnitInfo)this.application.getValue(CT_ASSISTUNIT_KEY, row);
            if (measureUnit != null) {
                this.application.lockElement(CT_ASSISTUNITQTY_KEY, row, false);
            } else {
                this.application.setValue(CT_ASSISTUNITQTY_KEY, (Object)new BigDecimal("0.0000"), row);
                this.application.lockElement(CT_ASSISTUNITQTY_KEY, row, true);
            }
        }
        if (CT_CURRENCY_KEY.equalsIgnoreCase(arg.getKey())) {
            QuotationInfo quotation;
            CurrencyInfo newCurrency = (CurrencyInfo)arg.getNewValue();
            CurrencyInfo oldCurrency = (CurrencyInfo)arg.getOldValue();
            CompanyOrgUnitInfo fiCompanyOrgInfo = (CompanyOrgUnitInfo)this.application.getValue(CT_COMPANTYORGUNIT_KEY, 0);
            if (fiCompanyOrgInfo != null) {
                fiCompanyOrgInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select * where id='" + fiCompanyOrgInfo.getId() + "'");
            }
            if ((quotation = (QuotationInfo)this.application.getBillModel().getBillValue()) != null && quotation.getProduct() != null) {
                CarryValueHelper.carryTaxPriceValueByCurrency((DynamicFormApplication)this.application, arg, fiCompanyOrgInfo, newCurrency, oldCurrency, CT_TAXPRICE_KEY, quotation.getProduct().size());
            }
        }
    }

    public void lockElementOnInitalize() throws EASBizException, BOSException {
        String flag;
        super.lockElementOnInitalize();
        QuotationInfo quotationInfo = (QuotationInfo)this.application.getBillModel().getBillValue();
        if (quotationInfo != null) {
            QuotationProductCollection products;
            CurrencyInfo currency = (CurrencyInfo)this.application.getValue(CT_CURRENCY_KEY, 0);
            CompanyOrgUnitInfo companyOrgUnit = (CompanyOrgUnitInfo)this.application.getValue(CT_COMPANTYORGUNIT_KEY, 0);
            CurrencyInfo baseCurrency = null;
            if (companyOrgUnit != null) {
                companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select * where id='" + companyOrgUnit.getId() + "'");
                baseCurrency = FinanceUtil.getBaseCurrencyInfo(companyOrgUnit);
            }
            if (currency != null && baseCurrency != null) {
                if (baseCurrency.getId().equals((Object)currency.getId())) {
                    this.application.setEnabled(CT_EXCHANGERATE_KEY, false);
                } else {
                    OperationStatus operationStatus = this.application.getBillView().getOperationStatus();
                    this.application.setEnabled(CT_EXCHANGERATE_KEY, !operationStatus.equals(OperationStatus.VIEW));
                }
            }
            if ((products = quotationInfo.getProduct()) != null) {
                int i;
                for (i = 0; i < products.size(); ++i) {
                    boolean flag2 = true;
                    flag2 = products.get(i).isIsPresent();
                    if (!flag2) {
                        this.application.setEnabled("F13", flag2);
                        break;
                    }
                    this.application.setEnabled("F13", flag2);
                }
                for (i = 0; i < products.size(); ++i) {
                    DiscountModeEnum discountType = products.get(i).getDiscountType();
                    if (discountType != null) {
                        if (discountType.getValue() == 0) {
                            this.application.lockElement(CT_DISCOUNTAMOUNT_KEY, i, true);
                            this.application.lockElement(CT_DISCOUNT_KEY, i, false);
                        }
                        if (discountType.getValue() == 1) {
                            this.application.lockElement(CT_DISCOUNT_KEY, i, true);
                            this.application.lockElement(CT_DISCOUNTAMOUNT_KEY, i, false);
                        }
                    }
                    if (products.get(i).getAssistUnit() == null) {
                        this.application.lockElement(CT_ASSISTUNITQTY_KEY, i, true);
                    } else {
                        this.application.lockElement(CT_ASSISTUNITQTY_KEY, i, false);
                    }
                    if (!products.get(i).isIsPresent()) continue;
                    this.lockSameRowElements(new String[]{CT_PRICE_KEY, CT_DISCOUNTTYPE_KEY, CT_TAXPRICE_KEY, CT_DISCOUNT_KEY, CT_DISCOUNTAMOUNT_KEY, CT_TAXAMOUNT_KEY, CT_TAX_KEY, CT_ACTUALTAXPRICE_KEY, CT_AMOUNT_KEY, CT_ACTUALPRICE_KEY}, i);
                }
            } else {
                this.application.setEnabled("F13", true);
            }
        }
        if ((flag = (String)this.getParentData("operation")) != null) {
            return;
        }
        String businOpportID = (String)this.getParentData("BillId");
        if (businOpportID != null) {
            this.application.lockElement(CT_CUSTOMER_KEY, true);
            this.application.lockElement(CT_BIZ_KEY, true);
        }
    }

    public void afterCreateNewEntry(NewEntryArg arg) throws EASBizException, BOSException {
        super.afterCreateNewEntry(arg);
        this.application.lockElement(CT_ASSISTUNITQTY_KEY, arg.getRow(), true);
        this.application.lockElement(CT_DISCOUNTAMOUNT_KEY, arg.getRow(), true);
    }

    public boolean isEnableCRMPermission() {
        return true;
    }

    protected String getPermRelProp() {
        return "quotation";
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        if ("Save".equalsIgnoreCase(operation.getOperation()) || "Submit".equalsIgnoreCase(operation.getOperation())) {
            QuotationInfo quotation = (QuotationInfo)this.application.getBillModel().getBillValue();
            QuotationProductCollection productCollection = quotation.getProduct();
            StringBuffer alert = new StringBuffer("\u4ea7\u54c1\u6e05\u5355\u7b2c");
            boolean checked = false;
            if (productCollection != null) {
                for (int i = 0; i < productCollection.size(); ++i) {
                    QuotationProductInfo qp = productCollection.get(i);
                    if (qp.isIsPresent() || qp.getMaterial() == null) continue;
                    if (qp.getRatePrice() == null) {
                        checked = true;
                        alert.append(i + 1).append("\u884c\uff0c");
                        continue;
                    }
                    if (!(qp.getRatePrice().doubleValue() <= 0.0)) continue;
                    checked = true;
                    alert.append(i + 1).append("\u884c\uff0c");
                }
            }
            if (checked) {
                alert.append("\u542b\u7a0e\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e\u96f6\u3002");
                alert.deleteCharAt(alert.lastIndexOf("\uff0c"));
                throw new BOSException(alert.toString());
            }
        }
        return super.beforeOperation(operation);
    }

    public void pushdownAction() throws Exception {
        QuotationInfo quotationInfo = (QuotationInfo)this.application.getBillModel().getBillValue();
        if (quotationInfo.isIsSwitch()) {
            this.application.showMessage("\u9500\u552e\u62a5\u4ef7\u5df2\u8f6c\u9500\u552e\u8ba2\u5355\u3002");
            return;
        }
        SaleOrgUnitInfo saleOrgUnitInfo = quotationInfo.getSaleOrgUnit();
        if (saleOrgUnitInfo != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("isBizUnit");
            saleOrgUnitInfo = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(saleOrgUnitInfo.getId()), sic);
            if (!saleOrgUnitInfo.isIsBizUnit()) {
                this.application.showMessage("\u5f53\u524dCRM\u9500\u552e\u62a5\u4ef7\u7684\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u662f\u5b9e\u4f53\u9500\u552e\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5904\u7406\u4e1a\u52a1\u64cd\u4f5c\u3002");
                return;
            }
        }
        if (quotationInfo.getSaleGroup() == null) {
            this.application.showMessage("\u9500\u552e\u62a5\u4ef7\u7684\u9500\u552e\u5c0f\u7ec4\u5fc5\u987b\u6709\u503c\uff0c\u624d\u80fd\u8fdb\u884c\u8be5\u4e1a\u52a1\u64cd\u4f5c\u3002");
            return;
        }
        if (!BillViewUtil.isHasEntryData(this.application, "F5")) {
            this.application.showMessage("\u4ea7\u54c1\u6e05\u5355\u5206\u5f55\u81f3\u5c11\u5b58\u5728\u4e00\u6761\u8bb0\u5f55\uff0c\u624d\u80fd\u8fdb\u884c\u8be5\u4e1a\u52a1\u64cd\u4f5c\u3002");
            return;
        }
        CustomerInfo customer = quotationInfo.getCustomer();
        if (customer != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("customerEAS.*");
            customer = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(customer.getId()), sic);
            if (!customer.isIsInsideCust()) {
                this.application.showMessage("\u5ba2\u6237\u672a\u505a\u8f6c\u6b63\u5904\u7406\uff0c\u8bf7\u5148\u5b8c\u6210\u5ba2\u6237\u8f6c\u6b63\u64cd\u4f5c\u3002");
                return;
            }
            if (customer.getCustomerEAS().getUsedStatus().getValue() != 1) {
                this.application.showMessage("\u9500\u552e\u62a5\u4ef7\u7684\u5ba2\u6237\uff08" + customer.getName() + "\uff09\u5bf9\u5e94\u7684EAS\u5ba2\u6237\u6570\u636e\uff08" + customer.getCustomerEAS().getName() + "\uff09\u672a\u5ba1\u6838\u3002");
                return;
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("saleOrgUnit"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("customer = '" + customer.getCustomerEAS().getId().toString() + "'"));
            filterInfo.getFilterItems().add(new FilterItemInfo("SaleOrgUnit = '" + quotationInfo.getSaleOrgUnit().getId() + "'"));
            viewInfo.setFilter(filterInfo);
            CustomerSaleInfoCollection BDCustomerSaleInfoCollection = CustomerSaleInfoFactory.getRemoteInstance().getCustomerSaleInfoCollection(viewInfo);
            if (BDCustomerSaleInfoCollection.size() < 1) {
                StringBuffer alerts = new StringBuffer("\u9500\u552e\u62a5\u4ef7\u7684");
                alerts.append(customer.getName());
                alerts.append("\u5ba2\u6237\u5bf9\u5e94\u7684EAS\u5ba2\u6237\u6570\u636e\uff08");
                alerts.append(customer.getCustomerEAS().getName());
                alerts.append("\uff09\u672a\u5206\u914d\u5230");
                alerts.append(quotationInfo.getSaleOrgUnit().getName());
                alerts.append("\u9500\u552e\u7ec4\u7ec7\u4e0a\uff0c\u4e0d\u80fd\u8fdb\u884c\u4e1a\u52a1\u64cd\u4f5c\u3002");
                this.application.showMessage(alerts.toString());
                return;
            }
            String sPK = this.copyQuotationToSaleOrder(quotationInfo, customer);
            this.rewriteQuotation(quotationInfo.getId().toString(), sPK);
            this.application.showMessage("\u9500\u552e\u8ba2\u5355\u5df2\u7ecf\u751f\u6210\u3002");
            this.application.getBillView().refresh();
        }
    }

    private String copyQuotationToSaleOrder(QuotationInfo quotationInfo, CustomerInfo customer) throws SyncToEASException, EASBizException, BOSException {
        ArrayList<String> ignoreProperties = new ArrayList<String>();
        ignoreProperties.add("id");
        ignoreProperties.add("billType");
        ignoreProperties.add("product");
        HashMap<String, Object> specifiedValues = new HashMap<String, Object>();
        specifiedValues.put("orderCustomer", customer.getCustomerEAS());
        specifiedValues.put("bizType", BizTypeFactory.getRemoteInstance().getBizTypeInfo("select id where name='\u666e\u901a\u9500\u552e'"));
        specifiedValues.put("isInTax", Boolean.TRUE);
        specifiedValues.put("baseStatus", BillBaseStatusEnum.TEMPORARILYSAVED);
        specifiedValues.put("sourceBillId", quotationInfo.getId().toString());
        specifiedValues.put("sourceBillType", "0RMNYC1Snkm06vPwdSq9XUY+1VI=");
        specifiedValues.put("bizDate", new Date());
        HashMap<String, String> propertyMapping = new HashMap<String, String>();
        propertyMapping.put("person", "salePerson");
        SaleOrderInfo saleOrder = (SaleOrderInfo)SyncBaseData.copyCoreBaseData2(SaleOrderInfo.class, (IObjectValue)quotationInfo, ignoreProperties, propertyMapping, specifiedValues);
        String number = CodingRuleUtils.getNumberByClient((IObjectValue)saleOrder, (String)ContextUtil.getCurrentOrgUnit((Context)this.application.getContext()).getId().toString());
        saleOrder.setNumber(number);
        this.copyEntries(quotationInfo, saleOrder);
        return SaleOrderFactory.getRemoteInstance().addnew((CoreBaseInfo)saleOrder).toString();
    }

    private void copyEntries(QuotationInfo quotationInfo, SaleOrderInfo saleOrder) throws SyncToEASException {
        QuotationProductCollection products = quotationInfo.getProduct();
        if (products != null) {
            ArrayList<String> ignoreProperties = new ArrayList<String>();
            ignoreProperties.add("id");
            HashMap<String, String> propertyMapping = new HashMap<String, String>();
            propertyMapping.put("quantity", "qty");
            propertyMapping.put("assistUnitQty", "assistQty");
            propertyMapping.put("baseUnitQty", "baseQty");
            propertyMapping.put("ratePrice", "taxPrice");
            propertyMapping.put("actRatePrice", "actualTaxPrice");
            propertyMapping.put("rate", "taxRate");
            HashMap<String, Object> specifiedValues = new HashMap<String, Object>();
            specifiedValues.put("sourceBillId", quotationInfo.getId().toString());
            specifiedValues.put("sourceBillNumber", quotationInfo.getNumber());
            for (int i = 0; i < products.size(); ++i) {
                QuotationProductInfo product = products.get(i);
                specifiedValues.put("sourceBillEntryId", product.getId().toString());
                specifiedValues.put("sourceBillEntrySeq", new Integer(product.getSeq()));
                specifiedValues.put("unit", product.getUnit());
                SaleOrderEntryInfo entryInfo = (SaleOrderEntryInfo)SyncBaseData.copyCoreBaseData2(SaleOrderEntryInfo.class, (IObjectValue)product, ignoreProperties, propertyMapping, specifiedValues);
                saleOrder.getEntries().add(entryInfo);
            }
        }
    }

    private void rewriteQuotation(String qPK, String sPK) throws EASBizException, BOSException {
        QuotationInfo quotationInfo = new QuotationInfo();
        quotationInfo.setIsSwitch(true);
        quotationInfo.setId(BOSUuid.read((String)qPK));
        SaleOrderInfo saleOrder = new SaleOrderInfo();
        saleOrder.setId(BOSUuid.read((String)sPK));
        quotationInfo.setSaleOrderEas(saleOrder);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("isSwitch");
        sic.add("saleOrderEas");
        QuotationFactory.getRemoteInstance().updatePartial(quotationInfo, sic);
    }

    protected boolean enableSubmitToAudit() throws EASBizException, BOSException {
        return BillViewUtil.isSystemParamConfigEnabled("CRM_Submit_Quotation0001", this.application);
    }

    protected boolean enableUnAudit() throws EASBizException, BOSException {
        return BillViewUtil.isSystemParamConfigEnabled("CRM_UnAudit_Quotation0002", this.application);
    }

    protected String getDistributeShareUserPermissionName() {
        return "crm_quotation_distributePerson";
    }

    protected String getDistributeUserPermissionName() {
        return "crm_quotation_distributUser";
    }

    protected String getRecycleSharerUserPermissionName() {
        return "crm_quotation_recyclePerson";
    }

    protected String getRecycleUserPermissionName() {
        return "crm_quotation_recycleUser";
    }

    private Date dateAddByMonth(Date date, int addMonth) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        c.set(2, month + 1);
        return c.getTime();
    }
}

