/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.util.StringUtil;
import com.kingdee.eas.base.form.web.WebBillEditPanel;
import com.kingdee.eas.base.form.web.WebListPanel;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.orgext.ServiceOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.crm.common.HandlerChangeHistoryFactory;
import com.kingdee.eas.scm.crm.common.IHandlerChangeHistory;
import com.kingdee.eas.scm.crm.plugins.support.CRMBillPluginSupport;
import com.kingdee.eas.scm.crm.plugins.support.ServiceF7Filter;
import com.kingdee.eas.scm.crm.plugins.util.BillViewUtil;
import com.kingdee.eas.scm.crm.plugins.util.CRMPermissionHelper;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.MyRemoteObjectUtil;
import com.kingdee.eas.scm.crm.service.IServiceBillBase;
import com.kingdee.eas.scm.crm.service.ServiceBillBaseInfo;
import com.kingdee.eas.scm.crm.service.ServiceQueueInfo;
import com.kingdee.eas.scm.crm.service.ServiceQueueMemberCollection;
import com.kingdee.eas.scm.crm.service.ServiceQueueMemberFactory;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserCollection;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class HandlerDistributeBillPlugin
extends CRMBillPluginSupport {
    private static final String CT_HANDLERUSER_KEY = "FHandlerUser";
    private List billIDs;
    protected static final String BTN_DISTRIBUTE = "FbtnAssign";
    private UserInfo userInfo;

    public void carrayValue(DataChangeCommandArg arg) throws EASBizException, BOSException {
        super.carrayValue(arg);
        if (arg.getKey().equalsIgnoreCase(CT_HANDLERUSER_KEY)) {
            this.userInfo = (UserInfo)this.application.getValue(CT_HANDLERUSER_KEY, 0);
        }
    }

    public void storeShareDataOnInitalize() throws EASBizException, BOSException {
        super.storeShareDataOnInitalize();
        this.billIDs = CommonUtil.array2List((String[])this.getParentData("BillIdS"));
    }

    protected boolean doDistribute(BillApplication application, List billIDs) throws EASBizException, BOSException, ParserException, SQLException {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)billIDs.get(0).toString(), (boolean)true);
        IServiceBillBase serviceBase = (IServiceBillBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosType, IServiceBillBase.class);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo(" associatedUser.*"));
        viewInfo.getSelector().add(new SelectorItemInfo(" creator.*"));
        viewInfo.setFilter(new FilterInfo(" id in (" + CommonUtil.listToString(billIDs) + ")"));
        CoreBaseCollection crmBaseCollection = serviceBase.getCollection(viewInfo.toString());
        IHandlerChangeHistory handlerChangeHistory = HandlerChangeHistoryFactory.getRemoteInstance();
        CoreBaseCollection historyCollection = new CoreBaseCollection();
        for (int i = 0; i < billIDs.size(); ++i) {
            UserInfo oldHandler = null;
            OpAssociatedUserCollection opAssociatedUserCollection = (OpAssociatedUserCollection)((Object)crmBaseCollection.get(i).get("associatedUser"));
            ServiceBillBaseInfo baseInfo = (ServiceBillBaseInfo)crmBaseCollection.get(i);
            boolean isReplace = false;
            oldHandler = (UserInfo)crmBaseCollection.get(i).get("creator");
            if (!opAssociatedUserCollection.isEmpty()) {
                OpAssociatedUserInfo opAssociatedUserInfo;
                WebListPanel parentFormView;
                String formId = null;
                int size = opAssociatedUserCollection.size();
                if (application.getBillView().getParentFormView() instanceof WebListPanel) {
                    parentFormView = (WebListPanel)application.getBillView().getParentFormView();
                    formId = parentFormView.getBusinessInfo().getForm().getId();
                } else {
                    parentFormView = (WebBillEditPanel)application.getBillView().getParentFormView();
                    formId = parentFormView.getBusinessInfo().getForm().getId();
                }
                String adminRole = StringUtil.buildStringForObjNameAndNumber((Object[])new Object[]{CRMPermissionHelper.getAdminRole(formId)});
                String viewRole = StringUtil.buildStringForObjNameAndNumber((Object[])new Object[]{CRMPermissionHelper.getShareUserRole(formId)});
                for (int j = 0; j < size; ++j) {
                    opAssociatedUserInfo = opAssociatedUserCollection.get(j);
                    if (!this.userInfo.getId().equals((Object)opAssociatedUserInfo.getUser().getId())) continue;
                    isReplace = true;
                    if (j <= 0) continue;
                    opAssociatedUserInfo.setRoles(adminRole);
                    OpAssociatedUserInfo tempObj = opAssociatedUserCollection.get(0);
                    tempObj.setRoles(viewRole);
                    opAssociatedUserCollection.swap(0, j);
                }
                if (!isReplace) {
                    OpAssociatedUserInfo tempObj = opAssociatedUserCollection.get(0);
                    tempObj.setRoles(viewRole);
                    opAssociatedUserInfo = new OpAssociatedUserInfo();
                    opAssociatedUserInfo.setUser(this.userInfo);
                    opAssociatedUserInfo.setRoles(adminRole);
                    opAssociatedUserInfo.setCtrlUnit(ContextUtil.getCurrentCtrlUnit((Context)this.getContext()));
                    opAssociatedUserInfo.setCreateOrg((FullOrgUnitInfo)ContextUtil.getCurrentOrgUnit((Context)this.getContext()));
                    opAssociatedUserCollection.insertObject(-1, (IObjectValue)opAssociatedUserInfo);
                }
            }
            baseInfo.setCreator(this.userInfo);
            Timestamp factStartDate = baseInfo.getFactStartDate();
            if (factStartDate == null) {
                baseInfo.setFactStartDate(new Timestamp(System.currentTimeMillis()));
            }
            if (this.userInfo.getId().equals((Object)oldHandler.getId())) continue;
            HandlerChangeHistoryFactory.getRemoteInstance().addNewRecord(historyCollection, this.userInfo, oldHandler, baseInfo.getId() != null ? baseInfo.getId().toString() : "");
        }
        serviceBase.save(crmBaseCollection);
        String handleStatusId = (String)this.getParentData("handleStatusID");
        String tableName = (String)this.getParentData("TableName");
        IObjectPK[] pks = BillViewUtil.beforeLog(application, "handlerDistribute", "\u5206\u914d\u8d1f\u8d23\u4eba", CommonUtil.list2Array(billIDs));
        MyRemoteObjectUtil.getInstance().execute(application.getContext(), "update " + tableName + " set FHandleStatusID= '" + handleStatusId + "' where  fid in (" + CommonUtil.listToString(billIDs) + ")");
        BillViewUtil.afterLog(application, pks, CommonUtil.list2Array(billIDs));
        handlerChangeHistory.addnew(historyCollection);
        return true;
    }

    public void doHandlerDistributeAction() throws EASBizException, BOSException, ParserException, SQLException {
        if (this.userInfo != null) {
            if (this.doDistribute(this.application, this.billIDs)) {
                this.application.showMessage("\u5206\u914d\u8d1f\u8d23\u4eba\u6210\u529f\uff01");
                this.closeAction();
            }
        } else {
            this.application.showMessage("\u8bf7\u60a8\u9009\u62e9\u65b0\u8d1f\u8d23\u4eba\u3002");
        }
    }

    public void closeAction() throws EASBizException, BOSException {
        this.application.close();
        this.application.getBillView().setParentRefresh(true);
    }

    public void setF7DefaultFilter() throws EASBizException, BOSException {
        super.setF7DefaultFilter();
        ServiceQueueInfo flag = (ServiceQueueInfo)this.getParentData("serviceQueue");
        if (null != flag && null != flag.getId()) {
            StringBuffer oqlfilter = new StringBuffer();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)flag.getId().toString(), CompareType.EQUALS));
            entityViewInfo.setFilter(filter);
            ServiceQueueMemberCollection sqmc = ServiceQueueMemberFactory.getRemoteInstance().getServiceQueueMemberCollection(entityViewInfo);
            if (null != sqmc && !sqmc.isEmpty()) {
                oqlfilter.append("isForbidden = 0 and id in (");
                int j = sqmc.size();
                for (int i = 0; i < j; ++i) {
                    oqlfilter.append("'").append(sqmc.get(i).getPerson().getId().toString()).append("',");
                }
                oqlfilter.append(")");
                oqlfilter.deleteCharAt(oqlfilter.lastIndexOf(","));
                this.application.setFieldFilter(CT_HANDLERUSER_KEY, oqlfilter.toString());
            }
        } else {
            String oqlfilter = ServiceF7Filter.getServiceOrgUserFilter((ServiceOrgUnitInfo)this.getParentData("serviceOrg"));
            this.application.setFieldFilter(CT_HANDLERUSER_KEY, oqlfilter);
        }
    }
}

