/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.model.command.NewEntryArg;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.plugins.bill.service.AbstractServiceModuleBillPlugin;
import com.kingdee.eas.scm.crm.service.ServiceFlowCollection;
import com.kingdee.eas.scm.crm.service.ServiceFlowFactory;
import com.kingdee.eas.scm.crm.service.ServiceFlowInfo;
import com.kingdee.eas.scm.crm.service.ServiceFlowStageCollection;
import com.kingdee.eas.scm.crm.service.ServiceFlowStageInfo;

public class ServiceFlowBillPlugin
extends AbstractServiceModuleBillPlugin {
    private static final String STAGENAME = "FStageName";
    private static final String FLOWSTAGE = "FflowStage";
    private static final String STAGEREMARK = "FStageRemark";

    public void doAfterDataChanged(DataChangeCommandArg arg) throws EASBizException, BOSException {
        if (arg.getKey().equalsIgnoreCase(STAGENAME)) {
            ServiceFlowInfo serviceFlowInfo = (ServiceFlowInfo)this.application.getBillModel().getBillValue();
            int row = arg.getRow();
            String newValue = (String)arg.getNewValue();
            ServiceFlowStageCollection v = serviceFlowInfo.getFlowStage();
            if (null == newValue || "".equals(newValue.trim())) {
                return;
            }
            for (int i = 0; i < v.size(); ++i) {
                if (i == row || !newValue.equals(v.get(i).getName())) continue;
                this.application.showMessage("\u9636\u6bb5\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
                this.application.setValue(STAGENAME, (Object)"", row);
                break;
            }
        }
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        ServiceFlowStageCollection v;
        ServiceFlowInfo serviceFlowInfo;
        int row;
        if (operation.getOperation().equals("DeleteEntry")) {
            row = this.application.getBillView().getSelectedRow(FLOWSTAGE);
            serviceFlowInfo = (ServiceFlowInfo)this.application.getBillModel().getBillValue();
            v = serviceFlowInfo.getFlowStage();
            if (null != v.get(row) && ("\u5f00\u59cb".equals(v.get(row).getName()) || "\u7ed3\u675f".equals(v.get(row).getName()))) {
                this.application.showMessage("\u5f00\u59cb\u9636\u6bb5\u548c\u7ed3\u675f\u9636\u6bb5\u4e0d\u80fd\u5220\u9664");
                return false;
            }
        }
        if (operation.getOperation().equals("InsertEntry")) {
            row = this.application.getBillView().getSelectedRow(FLOWSTAGE);
            serviceFlowInfo = (ServiceFlowInfo)this.application.getBillModel().getBillValue();
            v = serviceFlowInfo.getFlowStage();
            if (row > -1 && null != v.get(row).getName() && !"".equals(v.get(row).getName()) && v.get(row).getName().equals("\u5f00\u59cb")) {
                this.application.showMessage("\u5f00\u59cb\u9636\u6bb5\u662f\u7b2c\u4e00\u4e2a\u9636\u6bb5\uff0c\u8bf7\u9009\u62e9\u5176\u5b83\u884c\u65b0\u589e");
                return false;
            }
        }
        return super.beforeOperation(operation);
    }

    public void lockElementOnInitalize() throws EASBizException, BOSException {
        super.lockElementOnInitalize();
        ServiceFlowInfo serviceFlowInfo = (ServiceFlowInfo)this.application.getBillModel().getBillValue();
        this.lockEnableOnInitalize();
        ServiceFlowStageCollection flowStageCollection = serviceFlowInfo.getFlowStage();
        this.lockSameRowElements(new String[]{STAGENAME, STAGEREMARK}, 0);
        this.lockSameRowElements(new String[]{STAGENAME, STAGEREMARK}, flowStageCollection.size() - 1);
    }

    public void setDefaultValue() throws EASBizException, BOSException {
        super.setDefaultValue();
        ServiceFlowInfo serviceFlowInfo = (ServiceFlowInfo)this.application.getBillModel().getBillValue();
        if (serviceFlowInfo.getId() == null) {
            ServiceFlowStageInfo serviceFlowStageInfo = new ServiceFlowStageInfo();
            serviceFlowStageInfo.setSeq(2);
            serviceFlowStageInfo.setName("\u7ed3\u675f");
            serviceFlowStageInfo.setRemark("\u7cfb\u7edf\u9ed8\u8ba4\u9636\u6bb5");
            ServiceFlowStageCollection serviceFlowStageCollection = serviceFlowInfo.getFlowStage();
            serviceFlowStageCollection.get(0).setName("\u5f00\u59cb");
            serviceFlowStageCollection.get(0).setRemark("\u7cfb\u7edf\u9ed8\u8ba4\u9636\u6bb5");
            serviceFlowStageCollection.add(serviceFlowStageInfo);
        }
    }

    public void doEnableAction() throws EASBizException, BOSException {
        ServiceFlowInfo serviceFlowInfo = (ServiceFlowInfo)this.application.getBillModel().getBillValue();
        serviceFlowInfo.setIsEnable(true);
        ServiceFlowFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(serviceFlowInfo.getId()), serviceFlowInfo);
        this.application.showMessage("\u542f\u7528\u6210\u529f");
        this.application.getBillView().refresh();
    }

    public void doUnableAction() throws EASBizException, BOSException {
        ServiceFlowInfo serviceFlowInfo = (ServiceFlowInfo)this.application.getBillModel().getBillValue();
        serviceFlowInfo.setIsEnable(false);
        ServiceFlowFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(serviceFlowInfo.getId()), serviceFlowInfo);
        this.application.showMessage("\u7981\u7528\u6210\u529f");
        this.application.getBillView().refresh();
    }

    public boolean beforeSaveOrSubmitData() {
        try {
            ServiceFlowInfo serviceFlowInfo = (ServiceFlowInfo)this.application.getBillModel().getBillValue();
            if (serviceFlowInfo.getId() == null) {
                EntityViewInfo viewInfo = new EntityViewInfo("select * where name = '" + serviceFlowInfo.getName() + "' and flowType = " + serviceFlowInfo.getFlowType().getValue());
                ServiceFlowCollection info = ServiceFlowFactory.getRemoteInstance().getServiceFlowCollection(viewInfo.toString());
                if (!info.isEmpty()) {
                    this.application.showMessage("\u6d41\u7a0b\u540d\u79f0\uff1a\u8be5\u8f93\u5165\u9879\u5728'" + serviceFlowInfo.getFlowType().toString() + "'\u4e1a\u52a1\u7c7b\u578b\u4e0b\u5df2\u5b58\u5728");
                    return false;
                }
            } else {
                EntityViewInfo viewInfo = new EntityViewInfo("select * where id = '" + serviceFlowInfo.getId().toString() + "'");
                ServiceFlowCollection oldServiceFlow = ServiceFlowFactory.getRemoteInstance().getServiceFlowCollection(viewInfo.toString());
                if (!oldServiceFlow.get(0).getName().equals(serviceFlowInfo.getName())) {
                    viewInfo = new EntityViewInfo("select * where name = '" + serviceFlowInfo.getName() + "' and flowType = " + serviceFlowInfo.getFlowType().getValue());
                    ServiceFlowCollection info = ServiceFlowFactory.getRemoteInstance().getServiceFlowCollection(viewInfo.toString());
                    if (!info.isEmpty()) {
                        this.application.showMessage("\u6d41\u7a0b\u540d\u79f0\uff1a\u8be5\u8f93\u5165\u9879\u5728'" + serviceFlowInfo.getFlowType().toString() + "'\u4e1a\u52a1\u7c7b\u578b\u4e0b\u5df2\u5b58\u5728");
                        return false;
                    }
                }
            }
        }
        catch (ParserException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return super.beforeSaveOrSubmitData();
    }

    public void afterCreateNewEntry(NewEntryArg arg) throws EASBizException, BOSException {
        super.afterCreateNewEntry(arg);
        ServiceFlowInfo flowInfo = (ServiceFlowInfo)this.application.getBillModel().getBillValue();
        ServiceFlowStageCollection flowStageCollection = flowInfo.getFlowStage();
        for (int i = 0; i < flowStageCollection.size(); ++i) {
            this.unLockSameRowElements(new String[]{STAGENAME, STAGEREMARK}, i);
        }
        this.lockSameRowElements(new String[]{STAGENAME, STAGEREMARK}, 0);
        this.lockSameRowElements(new String[]{STAGENAME, STAGEREMARK}, flowStageCollection.size());
    }

    public boolean isEnableCRMPermission() {
        return false;
    }

    protected boolean isCRMBaseData() {
        return true;
    }
}

