/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.list.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.crm.common.BillStatusEnum;
import com.kingdee.eas.scm.crm.plugins.list.service.ServiceListPlugin;
import com.kingdee.eas.scm.crm.plugins.util.CRMPermissionHelper;
import com.kingdee.eas.scm.crm.service.ServiceAssetCollection;
import com.kingdee.eas.scm.crm.service.ServiceAssetFactory;
import com.kingdee.eas.scm.crm.service.ServiceAssetInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;

public class ServiceAssetListPlugin
extends ServiceListPlugin {
    protected boolean isCRMBaseData() {
        return true;
    }

    protected boolean isEnableCRMPermission() {
        return false;
    }

    public void setF7DefaultFilter() throws EASBizException, BOSException {
        super.setF7DefaultFilter();
        this.application.setFieldFilter("FCustomer", CRMPermissionHelper.buildF7ShareUserFilterByCU(this.getContext()));
    }

    public void doAuditAction() throws BOSException, EASBizException {
        String[] auditIds = this.application.getListView().getSelectedBillIds();
        StringBuffer alertMsg = new StringBuffer();
        String showMsg = null;
        CoreBaseCollection auditCollection = new CoreBaseCollection();
        if (auditIds.length == 0) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e");
            return;
        }
        ServiceAssetCollection serviceAssetCollection = ServiceAssetFactory.getRemoteInstance().getCollection(auditIds);
        int j = serviceAssetCollection.size();
        int successNum = 0;
        int loseNum = 0;
        for (int k = 0; k < j; ++k) {
            ServiceAssetInfo serviceAssetNum = serviceAssetCollection.get(k);
            if (serviceAssetNum.getBillStatus().compareTo((Object)BillStatusEnum.SUBMITED) == 0) {
                ++successNum;
                continue;
            }
            ++loseNum;
        }
        alertMsg.append("\u5ba1\u6838\u6210\u529f" + successNum + "\u6761\u8bb0\u5f55\uff0c\u5ba1\u6838\u5931\u8d25" + loseNum + "\u6761\u8bb0\u5f55\u3002<br><br><br>");
        alertMsg.append("\u8be6\u7ec6\u4fe1\u606f\uff1a<br>");
        for (int i = 0; i < j; ++i) {
            ServiceAssetInfo serviceAsset = serviceAssetCollection.get(i);
            int isSubmit = serviceAsset.getBillStatus().compareTo((Object)BillStatusEnum.SUBMITED);
            if (isSubmit != 0) {
                if (i + 1 != j) {
                    alertMsg.append(i + 1 + "\u3001" + serviceAsset.getNumber() + "\uff1a" + (Object)((Object)serviceAsset.getBillStatus()) + "\u72b6\u6001\u4e0d\u80fd\u5ba1\u6838\uff1b<br>");
                } else {
                    alertMsg.append(i + 1 + "\u3001" + serviceAsset.getNumber() + "\uff1a" + (Object)((Object)serviceAsset.getBillStatus()) + "\u72b6\u6001\u4e0d\u80fd\u5ba1\u6838\u3002");
                }
            } else {
                if (i + 1 != j) {
                    alertMsg.append(i + 1 + "\u3001" + serviceAsset.getNumber() + "\uff1a\u5ba1\u6838\u6210\u529f\uff1b<br>");
                } else {
                    alertMsg.append(i + 1 + "\u3001" + serviceAsset.getNumber() + "\uff1a\u5ba1\u6838\u6210\u529f\u3002");
                }
                serviceAsset.setBillStatus(BillStatusEnum.AUDITED);
                serviceAsset.setAuditor(ContextUtil.getCurrentUserInfo((Context)this.getContext()));
                serviceAsset.setAuditTime(new Date());
                auditCollection.add((CoreBaseInfo)serviceAsset);
            }
            if (alertMsg.length() <= 0) continue;
            showMsg = alertMsg.substring(0);
        }
        ServiceAssetFactory.getRemoteInstance().save(auditCollection);
        this.application.getListView().refresh();
        this.application.showMessage(showMsg);
    }

    public void doUnAuditAction() throws BOSException, EASBizException {
        String[] auditIds = this.application.getListView().getSelectedBillIds();
        StringBuffer alertMsg = new StringBuffer();
        String showMsg = null;
        CoreBaseCollection auditCollection = new CoreBaseCollection();
        if (auditIds.length == 0) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e");
            return;
        }
        ServiceAssetCollection serviceAssetCollection = ServiceAssetFactory.getRemoteInstance().getCollection(auditIds);
        int j = serviceAssetCollection.size();
        int successNum = 0;
        int loseNum = 0;
        for (int k = 0; k < j; ++k) {
            ServiceAssetInfo serviceAssetNum = serviceAssetCollection.get(k);
            if (serviceAssetNum.getBillStatus().compareTo((Object)BillStatusEnum.AUDITED) == 0) {
                ++successNum;
                continue;
            }
            ++loseNum;
        }
        alertMsg.append("\u53cd\u5ba1\u6838\u6210\u529f" + successNum + "\u6761\u8bb0\u5f55\uff0c\u53cd\u5ba1\u6838\u5931\u8d25" + loseNum + "\u6761\u8bb0\u5f55\u3002<br><br><br>");
        alertMsg.append("\u8be6\u7ec6\u4fe1\u606f\uff1a<br>");
        for (int i = 0; i < j; ++i) {
            ServiceAssetInfo serviceAsset = serviceAssetCollection.get(i);
            int isAudited = serviceAsset.getBillStatus().compareTo((Object)BillStatusEnum.AUDITED);
            if (isAudited != 0) {
                if (i + 1 != j) {
                    alertMsg.append(i + 1 + "\u3001" + serviceAsset.getNumber() + "\uff1a" + (Object)((Object)serviceAsset.getBillStatus()) + "\u72b6\u6001\u4e0d\u80fd\u53cd\u5ba1\u6838\uff1b<br>");
                    continue;
                }
                alertMsg.append(i + 1 + "\u3001" + serviceAsset.getNumber() + "\uff1a" + (Object)((Object)serviceAsset.getBillStatus()) + "\u72b6\u6001\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002");
                continue;
            }
            if (i + 1 != j) {
                alertMsg.append(i + 1 + "\u3001" + serviceAsset.getNumber() + "\uff1a\u53cd\u5ba1\u6838\u6210\u529f\uff1b<br>");
            } else {
                alertMsg.append(i + 1 + "\u3001" + serviceAsset.getNumber() + "\uff1a\u53cd\u5ba1\u6838\u6210\u529f\u3002");
            }
            serviceAsset.setBillStatus(BillStatusEnum.TEMPORARILYSAVED);
            serviceAsset.setAuditor(new UserInfo());
            serviceAsset.setAuditTime(null);
            auditCollection.add((CoreBaseInfo)serviceAsset);
        }
        if (alertMsg.length() > 0) {
            showMsg = alertMsg.substring(0);
        }
        ServiceAssetFactory.getRemoteInstance().save(auditCollection);
        this.application.getListView().refresh();
        this.application.showMessage(showMsg);
    }
}

