/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.list.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.crm.common.BillStatusEnum;
import com.kingdee.eas.scm.crm.plugins.list.service.ServiceListPlugin;
import com.kingdee.eas.scm.crm.plugins.support.filter.EnableHelper;
import com.kingdee.eas.scm.crm.service.ServiceFlowCollection;
import com.kingdee.eas.scm.crm.service.ServiceFlowFactory;
import com.kingdee.eas.scm.crm.service.ServiceFlowInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.SQLException;
import java.util.Date;

public class ServiceFlowListPlugin
extends ServiceListPlugin {
    private String status;

    protected boolean isCRMBaseData() {
        return true;
    }

    protected boolean isEnableCRMPermission() {
        return false;
    }

    public void setEnabledAction() throws BOSException, SQLException, EASBizException {
        String[] enabledIds = this.application.getListView().getSelectedBillIds();
        if (enabledIds.length == 0) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e");
            return;
        }
        this.status = "1";
        EnableHelper.setStatus(this.application, this.status);
    }

    public void setDisabledAction() throws BOSException, SQLException, EASBizException {
        String[] disabledIds = this.application.getListView().getSelectedBillIds();
        if (disabledIds.length == 0) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e");
            return;
        }
        this.status = "0";
        EnableHelper.setStatus(this.application, this.status);
    }

    public void doAuditAction() throws BOSException, EASBizException {
        String[] auditIds = this.application.getListView().getSelectedBillIds();
        StringBuffer alertMsg = new StringBuffer();
        String showMsg = null;
        CoreBaseCollection auditCollection = new CoreBaseCollection();
        if (auditIds.length == 0) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e");
            return;
        }
        ServiceFlowCollection serviceFlowCollection = ServiceFlowFactory.getRemoteInstance().getCollection(auditIds);
        int j = serviceFlowCollection.size();
        int successNum = 0;
        int loseNum = 0;
        for (int k = 0; k < j; ++k) {
            ServiceFlowInfo serviceFlowNum = serviceFlowCollection.get(k);
            if (serviceFlowNum.getBillStatus().compareTo((Object)BillStatusEnum.SUBMITED) == 0) {
                ++successNum;
                continue;
            }
            ++loseNum;
        }
        alertMsg.append("\u5ba1\u6838\u6210\u529f" + successNum + "\u6761\u8bb0\u5f55\uff0c\u5ba1\u6838\u5931\u8d25" + loseNum + "\u6761\u8bb0\u5f55\u3002<br><br><br>");
        alertMsg.append("\u8be6\u7ec6\u4fe1\u606f\uff1a<br>");
        for (int i = 0; i < j; ++i) {
            ServiceFlowInfo serviceFlow = serviceFlowCollection.get(i);
            int isSubmit = serviceFlow.getBillStatus().compareTo((Object)BillStatusEnum.SUBMITED);
            if (isSubmit != 0) {
                if (i + 1 != j) {
                    alertMsg.append(i + 1 + "\u3001" + serviceFlow.getNumber() + "\uff1a" + (Object)((Object)serviceFlow.getBillStatus()) + "\u72b6\u6001\u4e0d\u80fd\u5ba1\u6838\uff1b<br>");
                    continue;
                }
                alertMsg.append(i + 1 + "\u3001" + serviceFlow.getNumber() + "\uff1a" + (Object)((Object)serviceFlow.getBillStatus()) + "\u72b6\u6001\u4e0d\u80fd\u5ba1\u6838\u3002<br>");
                continue;
            }
            if (i + 1 != j) {
                alertMsg.append(i + 1 + "\u3001" + serviceFlow.getNumber() + "\uff1a\u5ba1\u6838\u6210\u529f\uff1b<br>");
            } else {
                alertMsg.append(i + 1 + "\u3001" + serviceFlow.getNumber() + "\uff1a\u5ba1\u6838\u6210\u529f\u3002<br>");
            }
            serviceFlow.setBillStatus(BillStatusEnum.AUDITED);
            serviceFlow.setAuditor(ContextUtil.getCurrentUserInfo((Context)this.getContext()));
            serviceFlow.setAuditTime(new Date());
            auditCollection.add((CoreBaseInfo)serviceFlow);
        }
        if (alertMsg.length() > 0) {
            showMsg = alertMsg.substring(0);
        }
        ServiceFlowFactory.getRemoteInstance().save(auditCollection);
        this.application.getListView().refresh();
        this.application.showMessage(showMsg);
    }

    public void doUnAuditAction() throws BOSException, EASBizException {
        String[] auditIds = this.application.getListView().getSelectedBillIds();
        StringBuffer alertMsg = new StringBuffer();
        String showMsg = null;
        CoreBaseCollection auditCollection = new CoreBaseCollection();
        if (auditIds.length == 0) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e");
            return;
        }
        ServiceFlowCollection serviceFlowCollection = ServiceFlowFactory.getRemoteInstance().getCollection(auditIds);
        int j = serviceFlowCollection.size();
        int successNum = 0;
        int loseNum = 0;
        for (int k = 0; k < j; ++k) {
            ServiceFlowInfo serviceFlowNum = serviceFlowCollection.get(k);
            if (serviceFlowNum.getBillStatus().compareTo((Object)BillStatusEnum.AUDITED) == 0) {
                ++successNum;
                continue;
            }
            ++loseNum;
        }
        alertMsg.append("\u53cd\u5ba1\u6838\u6210\u529f" + successNum + "\u6761\u8bb0\u5f55\uff0c\u53cd\u5ba1\u6838\u5931\u8d25" + loseNum + "\u6761\u8bb0\u5f55\u3002<br><br><br>");
        alertMsg.append("\u8be6\u7ec6\u4fe1\u606f\uff1a<br>");
        for (int i = 0; i < j; ++i) {
            ServiceFlowInfo serviceFlow = serviceFlowCollection.get(i);
            int isAudited = serviceFlow.getBillStatus().compareTo((Object)BillStatusEnum.AUDITED);
            if (isAudited != 0) {
                if (i + 1 != j) {
                    alertMsg.append(i + 1 + "\u3001" + serviceFlow.getNumber() + "\uff1a" + (Object)((Object)serviceFlow.getBillStatus()) + "\u72b6\u6001\u4e0d\u80fd\u53cd\u5ba1\u6838\uff1b<br>");
                    continue;
                }
                alertMsg.append(i + 1 + "\u3001" + serviceFlow.getNumber() + "\uff1a" + (Object)((Object)serviceFlow.getBillStatus()) + "\u72b6\u6001\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002<br>");
                continue;
            }
            if (i + 1 != j) {
                alertMsg.append(i + 1 + "\u3001" + serviceFlow.getNumber() + "\uff1a\u53cd\u5ba1\u6838\u6210\u529f\uff1b<br>");
            } else {
                alertMsg.append(i + 1 + "\u3001" + serviceFlow.getNumber() + "\uff1a\u53cd\u5ba1\u6838\u6210\u529f\u3002<br>");
            }
            serviceFlow.setBillStatus(BillStatusEnum.TEMPORARILYSAVED);
            serviceFlow.setAuditor(new UserInfo());
            serviceFlow.setAuditTime(null);
            auditCollection.add((CoreBaseInfo)serviceFlow);
        }
        if (alertMsg.length() > 0) {
            showMsg = alertMsg.substring(0);
        }
        ServiceFlowFactory.getRemoteInstance().save(auditCollection);
        this.application.getListView().refresh();
        this.application.showMessage(showMsg);
    }
}

