/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.command.BeforeDeleteArg;
import com.kingdee.eas.base.form.model.command.BeforeQueryArg;
import com.kingdee.eas.base.form.model.list.ListPlugin;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.plugins.support.filter.DeleteFilterHelper;
import com.kingdee.eas.scm.crm.plugins.support.filter.DeleteFilterSuit;
import com.kingdee.eas.scm.crm.plugins.support.filter.XmlFilter;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.ListViewUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class CRMBaseDataListpluginSupport
extends ListPlugin {
    public final void onBeforeDelete(BeforeDeleteArg arg) {
        try {
            super.onBeforeDelete(arg);
            this.doDeleteFilter(arg.getIdList());
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
    }

    private List doDeleteFilter(List ids) throws BOSException, SQLException, EASBizException {
        String tableName = this.getMainTableName();
        Map numMap = DeleteFilterHelper.getNumberMap(this.getContext(), ids, tableName);
        DeleteFilterSuit filterSuit = new DeleteFilterSuit(numMap);
        filterSuit.addFilter(new XmlFilter(tableName, numMap));
        String alerts = filterSuit.runFilter(this.getContext(), ids);
        this.application.showMessage(alerts);
        return ids;
    }

    private boolean logicDelete(FormOperation operation) throws EASBizException, BOSException {
        try {
            IObjectPK[] pks = ListViewUtil.beforeLog(this.application, operation);
            List ids2Delete = this.doDeleteFilter(CommonUtil.array2List(this.application.getListView().getSelectedBillIds()));
            ListViewUtil.logicDelete(this.application, ids2Delete);
            ListViewUtil.afterLog(this.application, pks, CommonUtil.list2Array(ids2Delete));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public final boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        boolean status = super.beforeOperation(operation);
        if ("Delete".equalsIgnoreCase(operation.getOperation())) {
            status = status && this.logicDelete(operation);
        }
        status = status && this.doBeforeOperation(operation);
        return status;
    }

    public boolean doBeforeOperation(FormOperation operation) throws EASBizException, BOSException {
        return true;
    }

    protected final String getMainTableName() {
        return this.application.getListModel().getBusinessInfo().getEntity(0).getTableName();
    }

    protected final Context getContext() {
        return this.application.getContext();
    }

    public void onBeforeQuery(BeforeQueryArg arg) {
        super.onBeforeQuery(arg);
        FilterInfo filter = arg.getFilterInfo();
        FilterInfo crmFilter = new FilterInfo();
        try {
            crmFilter.getFilterItems().add(this.buildLogicDeleteFilter());
            filter.mergeFilter(crmFilter, "and");
            if (this.isCRMBaseDataS4()) {
                filter.mergeFilter(ListViewUtil.buildS4Filter(this.application), "and");
            }
            arg.setFilterInfo(filter);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
    }

    private FilterItemInfo buildLogicDeleteFilter() {
        FilterItemInfo logicDeletedFilterItem = new FilterItemInfo("isDeleted = 0");
        return logicDeletedFilterItem;
    }

    protected boolean isCRMBaseDataS4() {
        return false;
    }
}

