/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.bill.BillModel;
import com.kingdee.eas.base.form.model.command.CommandArg;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.util.FormActionUtil;
import com.kingdee.eas.base.form.util.StringUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.scm.crm.common.BillStatusEnum;
import com.kingdee.eas.scm.crm.common.CrmBillBaseInfo;
import com.kingdee.eas.scm.crm.common.CrmRoleCollection;
import com.kingdee.eas.scm.crm.common.CrmRoleFactory;
import com.kingdee.eas.scm.crm.common.ICrmRole;
import com.kingdee.eas.scm.crm.plugins.support.AbstractCRMBaseBillPlugin;
import com.kingdee.eas.scm.crm.plugins.support.defaultValue.CommonDefaultValueHelper;
import com.kingdee.eas.scm.crm.plugins.util.BillStatusManageUtil;
import com.kingdee.eas.scm.crm.plugins.util.BillViewUtil;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserCollection;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.apache.commons.beanutils.MethodUtils;

public class CRMBillPluginSupport
extends AbstractCRMBaseBillPlugin {
    protected String buttonClickedKey = null;
    public static final String CT_DEPARTMENT_KEY = "ForgDepartment";

    public final void afterBindData() throws EASBizException, BOSException {
        super.afterBindData();
    }

    public final void afterCreateNewData() throws EASBizException, BOSException {
        super.afterCreateNewData();
        this.application.setValue("ForgControlUnit", (Object)ContextUtil.getCurrentCtrlUnit((Context)this.getContext()), 0);
        this.application.setValue("FCreateTime", (Object)new Date(), 0);
        this.application.setValue("FbdCreateOrg", (Object)ContextUtil.getCurrentOrgUnit((Context)this.getContext()), 0);
        CommonDefaultValueHelper.setDeptValue(this.application, CT_DEPARTMENT_KEY);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.getContext());
        if (null != userInfo && !this.isCopyForm()) {
            userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(userInfo.getId()));
            this.application.setValue("FbdPerson", (Object)userInfo.getPerson(), 0);
        }
        this.setDefaultValue();
    }

    public boolean isCopyForm() {
        Boolean isCopyForm = (Boolean)this.application.getApplicationContext().getData("Copy");
        return isCopyForm != null ? isCopyForm : false;
    }

    public void setDefaultValue() throws EASBizException, BOSException {
        OpAssociatedUserCollection shareUsers = (OpAssociatedUserCollection)((Object)this.application.getBillValue().get("associatedUser"));
        if (shareUsers != null && !this.isCopyForm()) {
            this.setDefaultRoles(shareUsers.get(0));
        }
    }

    private void setDefaultRoles(OpAssociatedUserInfo shareUser) throws BOSException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)this.getContext());
        shareUser.setUser(user);
        ICrmRole crmRole = CrmRoleFactory.getRemoteInstance();
        CrmRoleCollection infos = crmRole.getCrmRoleCollection("select * where form.sourceBillId='" + this.application.getForm().getId() + "' and name='\u8d1f\u8d23\u4eba'");
        if (infos != null && infos.size() > 0) {
            shareUser.setRoles(StringUtil.buildStringForObjNameAndNumber((Object[])new Object[]{infos.get(0)}));
            shareUser.setCtrlUnit(user.getCU());
        }
    }

    public final void crmBillInitalize() throws EASBizException, BOSException {
        this.storeShareDataOnInitalize();
        this.lockElementOnInitalize();
        this.setF7DefaultFilter();
    }

    protected final boolean isMine() {
        return this.application.getBillView().getLayoutInfo().getCaption().indexOf("\u6211\u7684") != -1;
    }

    public void storeShareDataOnInitalize() throws EASBizException, BOSException {
        if (!this.isNewBill()) {
            this.storeDataInPageScope("BillId", this.getBillID());
        } else {
            this.storeDataInPageScope("BillId", null);
        }
    }

    public void lockElementOnInitalize() throws EASBizException, BOSException {
        BillStatusManageUtil billStatusManageUtil = new BillStatusManageUtil(this.application);
        billStatusManageUtil.initBillButtons();
        this.application.lockElement("FbdShareUser", 0, true);
        this.application.lockElement("FbdRole", 0, true);
        CoreBaseInfo bizObjectValue = (CoreBaseInfo)this.application.getBillValue();
        BillStatusEnum billStatus = BillStatusEnum.getEnum(bizObjectValue.getInt("billStatus"));
        if (billStatus == BillStatusEnum.AUDITED) {
            billStatusManageUtil.lockElement("unAudit", !this.enableUnAudit());
        } else {
            billStatusManageUtil.lockElement("unAudit", true);
        }
    }

    public void setF7DefaultFilter() throws EASBizException, BOSException {
        this.application.setFieldFilter("FbdRole", "form.sourceBillId='" + this.application.getForm().getId() + "' and type!=-1");
    }

    public final void dataChanged(DataChangeCommandArg arg) {
        try {
            super.dataChanged(arg);
            this.carrayValue(arg);
            this.changeF7Filter(arg);
            this.doAfterDataChanged(arg);
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
    }

    public void carrayValue(DataChangeCommandArg arg) throws EASBizException, BOSException {
        UserInfo user;
        if ("FbdShareUser".equalsIgnoreCase(arg.getKey()) && (user = (UserInfo)arg.getNewValue()) != null) {
            if (this.checkUserExist(user, arg.getRow())) {
                this.application.showMessage("\u4e0d\u80fd\u9009\u62e9\u91cd\u590d\u7684\u7528\u6237\u3002");
                this.application.setValue("FbdShareUser", null, arg.getRow());
            } else {
                CrmRoleCollection infos = this.getDefaultCarrayCrmRoleValue();
                if (infos == null) {
                    infos = CrmRoleFactory.getRemoteInstance().getCrmRoleCollection("select * where form.sourceBillId='" + this.application.getForm().getId() + "' and name='\u4e2a\u4eba\u5173\u8054\u6570\u636e\u67e5\u770b\u89d2\u8272'");
                }
                if (infos != null && infos.size() > 0) {
                    this.application.setValue("FbdRole", (Object)StringUtil.buildStringForObjNameAndNumber((Object[])new Object[]{infos.get(0)}), arg.getRow());
                }
            }
        }
    }

    private boolean checkUserExist(UserInfo user, int selectedRow) {
        boolean exist = false;
        OpAssociatedUserCollection shareUsers = (OpAssociatedUserCollection)((Object)this.application.getBillValue().get("associatedUser"));
        if (shareUsers != null) {
            for (int i = 0; i < shareUsers.size(); ++i) {
                UserInfo rowUser;
                if (i == selectedRow || (rowUser = (UserInfo)this.application.getValue("FbdShareUser", i)) == null || !rowUser.getId().equals((Object)user.getId())) continue;
                exist = true;
                return exist;
            }
        }
        return exist;
    }

    public void fireButtonClick(CommandArg commandArg) throws EASBizException, BOSException {
        super.fireButtonClick(commandArg);
        this.buttonClickedKey = commandArg.getKey();
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        OpAssociatedUserCollection shareUsers;
        String roles;
        CrmBillBaseInfo baseInfo = (CrmBillBaseInfo)this.application.getBillValue();
        if ("Edit".equalsIgnoreCase(operation.getOperation()) && baseInfo.getBillStatus() == BillStatusEnum.AUDITED) {
            this.application.showMessage("\u5ba1\u6838\u7684\u5355\u636e\u4e0d\u80fd\u4fee\u6539\u3002");
            return false;
        }
        if (operation.getOperation().equalsIgnoreCase("DeleteEntry") && "FbtnDeleteShare".equalsIgnoreCase(this.buttonClickedKey) && this.application.getBillView().getSelectedRow("FShare") == 0 && (roles = (String)this.application.getValue("FbdRole", 0)).indexOf("\u8d1f\u8d23\u4eba") != -1) {
            this.application.showMessage("\u4e0d\u80fd\u5220\u9664\u7b2c\u4e00\u884c\u8bb0\u5f55\u3002");
            return false;
        }
        if (operation.getOperation().equalsIgnoreCase("InsertEntry") && "FbtnInsertShare".equalsIgnoreCase(this.buttonClickedKey)) {
            if (this.application.getValue("FbdUser", 0) == null) {
                this.application.showMessage("\u8bf7\u5148\u9009\u62e9\u8d1f\u8d23\u7528\u6237\u3002");
                return false;
            }
            if (this.application.getBillView().getSelectedRow("FShare") == 0 && (roles = (String)this.application.getValue("FbdRole", 0)).indexOf("\u8d1f\u8d23\u4eba") != -1) {
                this.application.showMessage("\u4e0d\u80fd\u5728\u7b2c\u4e00\u884c\u63d2\u5165\u8bb0\u5f55\u3002");
                return false;
            }
        }
        if (operation.getOperation().equalsIgnoreCase("NewEntry") && "FbtnNewShare".equalsIgnoreCase(this.buttonClickedKey) && this.application.getValue("FbdUser", 0) == null) {
            this.application.showMessage("\u8be5\u8bb0\u5f55\u6ca1\u6709\u8d1f\u8d23\u7528\u6237\uff0c\u4e0d\u80fd\u589e\u52a0\u5171\u4eab\u7528\u6237\u3002");
            return false;
        }
        if (operation.getOperation().equalsIgnoreCase("Save") && (shareUsers = (OpAssociatedUserCollection)((Object)this.application.getBillValue().get("associatedUser"))) != null) {
            for (int i = 0; i < shareUsers.size(); ++i) {
                UserInfo rowUser = (UserInfo)this.application.getValue("FbdShareUser", i);
                if (null != rowUser) continue;
                this.application.showMessage("\u5171\u4eab\u6210\u5458\u5206\u5f55\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
        }
        if (operation.getOperation().equalsIgnoreCase("Copy")) {
            this.storeDataInPageScope("Copy", Boolean.TRUE);
        }
        return super.beforeOperation(operation);
    }

    public void changeF7Filter(DataChangeCommandArg arg) throws EASBizException, BOSException {
    }

    public void doAfterDataChanged(DataChangeCommandArg arg) throws EASBizException, BOSException {
    }

    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        super.doCustomOperation(operation);
        try {
            MethodUtils.invokeMethod((Object)((Object)this), (String)(operation + "Action"), null);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException("\u8bf7\u68c0\u67e5\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u662f\u5426\u8bbe\u7f6e\u6b63\u786e\u3002", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException("\u8bf7\u68c0\u67e5\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u662f\u5426\u8bbe\u7f6e\u6b63\u786e\u3002", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException("\u8bf7\u68c0\u67e5\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u662f\u5426\u8bbe\u7f6e\u6b63\u786e\u3002", (Throwable)e);
        }
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        super.afterOperation(operation);
        if ("Audit".equalsIgnoreCase(operation.getOperation())) {
            CrmBillBaseInfo baseInfo = (CrmBillBaseInfo)this.application.getBillValue();
            baseInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)this.getContext()));
            baseInfo.setAuditTime(new Date());
            ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)baseInfo.getBOSType(), ICoreBillBase.class);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("auditor");
            selector.add("auditTime");
            coreBase.updatePartial((CoreBaseInfo)baseInfo, selector);
            ((BillModel)this.application.getBillModel()).setChanged(false);
            this.application.getBillView().refresh();
        }
        if ("Copy".equalsIgnoreCase(operation.getOperation())) {
            this.application.setValue("FAuditor", null, 0);
            this.application.setValue("FAuditTime", null, 0);
        }
        if ("Submit".equalsIgnoreCase(operation.getOperation()) && this.enableSubmitToAudit()) {
            FormActionUtil.invokeBillFunction((IFormApplication)this.application, (String)"Audit", (String)"FBillHead");
        }
    }

    protected boolean enableSubmitToAudit() throws EASBizException, BOSException {
        return false;
    }

    protected String getPermRelProp() {
        return null;
    }

    public void unAuditAction() throws EASBizException, BOSException {
        CoreBaseInfo bizObjectValue = (CoreBaseInfo)this.application.getBillValue();
        BillStatusEnum billStatus = BillStatusEnum.getEnum(bizObjectValue.getInt("billStatus"));
        if (BillStatusEnum.AUDITED == billStatus) {
            IObjectPK[] pks = BillViewUtil.beforeLog(this.application, "unAudit", "\u53cd\u5ba1\u6838", new String[]{bizObjectValue.getId().toString()});
            bizObjectValue.setInt("billStatus", 1);
            bizObjectValue.put("auditTime", null);
            bizObjectValue.put("auditor", null);
            ICoreBase destCoreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bizObjectValue.getBOSType(), ICoreBillBase.class);
            destCoreBase.save(bizObjectValue);
            BillViewUtil.afterLog(this.application, pks, new String[]{bizObjectValue.getId().toString()});
            this.application.showMessage("\u53cd\u5ba1\u6838\u6210\u529f\u3002");
            this.application.getBillView().refresh();
        } else {
            this.application.showMessage("\u53ea\u6709\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u53cd\u5ba1\u6838\u3002");
        }
    }

    protected boolean enableUnAudit() throws EASBizException, BOSException {
        return false;
    }

    protected final void lockSameRowElements(String[] keys, int row) {
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                this.application.lockElement(keys[i], row, true);
            }
        }
    }

    protected final void unLockSameRowElements(String[] keys, int row) {
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                this.application.lockElement(keys[i], row, false);
            }
        }
    }

    protected final void storeDataInPageScope(String key, Object o) {
        this.application.getApplicationContext().putData(key, o);
    }

    protected boolean isCRMBaseData() {
        return false;
    }

    protected CrmRoleCollection getDefaultCarrayCrmRoleValue() throws BOSException {
        return null;
    }
}

