/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.command.BeforeCommandArg;
import com.kingdee.eas.base.form.model.command.CommandArg;
import com.kingdee.eas.base.form.model.list.ListApplication;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.base.form.web.DynamicWebFormPanel;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.crm.plugins.support.MutexResult;
import com.kingdee.eas.scm.crm.plugins.support.MutexSession;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sql.RowSet;

public class MutexHelper {
    private static final Map LIST_MUTEXT_BUTTON = new HashMap();
    private static final Map BILL_MUTEXT_BUTTON = new HashMap();

    private static final boolean isNeedMutex(DynamicFormApplication application, String btnKey) {
        if (application instanceof BillApplication) {
            return BILL_MUTEXT_BUTTON.containsKey(btnKey.toLowerCase());
        }
        return LIST_MUTEXT_BUTTON.containsKey(btnKey.toLowerCase());
    }

    private static final boolean isLockNext(DynamicFormApplication application, String btnKey) {
        String key = btnKey.toLowerCase();
        Boolean o = application instanceof BillApplication ? (Boolean)BILL_MUTEXT_BUTTON.get(key) : (Boolean)LIST_MUTEXT_BUTTON.get(key);
        return o != null ? o : false;
    }

    public static final void requestMutexForBill(BillApplication applicaiton) throws EASBizException, BOSException {
        String[] ids;
        DynamicWebFormPanel parentView = MutexHelper.getParentView(applicaiton);
        if (parentView == null) {
            return;
        }
        if (MutexSession.isNeedMutex(MutexHelper.getParentView(applicaiton).getApplicationContext()) && (ids = MutexHelper.getParentSelectId(applicaiton)) != null && ids.length > 0) {
            ArrayList<String> lockedIds = null;
            try {
                lockedIds = new ArrayList<String>(ids.length);
                for (int i = 0; i < ids.length; ++i) {
                    MutexHelper.requestObjIDForUpdate(applicaiton.getContext(), ids[i].toString());
                    lockedIds.add(ids[i].toString());
                }
                MutexSession.addMutexIds(applicaiton.getApplicationContext(), applicaiton.getForm().getId(), ids);
            }
            catch (EASBizException e) {
                throw new EASBizException(new NumericExceptionSubItem("100", e.getMessage()));
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (lockedIds != null && lockedIds.size() < ids.length) {
                    for (int i = 0; i < lockedIds.size(); ++i) {
                        MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate(lockedIds.get(i).toString());
                    }
                }
            }
        }
    }

    public static final void releaseMutextForBill(BillApplication applicaiton) throws BOSException {
        String[] ids = MutexSession.getMutexIds(applicaiton.getApplicationContext(), applicaiton.getForm().getId());
        if (ids != null && ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                MutexHelper.releaseObjIDForUpdate(ids[i]);
            }
            MutexSession.clearnMutexIds(applicaiton.getApplicationContext(), applicaiton.getForm().getId());
        }
    }

    public static final void checkMutexForBillView(BillApplication application, CommandArg commandArg) throws EASBizException, BOSException {
        OperationStatus operationStatus = application.getBillView().getOperationStatus();
        if ("View".equalsIgnoreCase(operationStatus.getStatus())) {
            MutexHelper.checkMutexForBill(application, commandArg);
        }
    }

    public static final void checkMutexForBill(BillApplication application, CommandArg commandArg) throws BOSException, EASBizException {
        if (!MutexHelper.isNeedMutex((DynamicFormApplication)application, commandArg.getKey())) {
            return;
        }
        String[] ids = new String[]{((ObjectBaseInfo)application.getBillValue()).getId().toString()};
        HashMap<String, String> numberMap = new HashMap<String, String>(2);
        numberMap.put(ids[0], "\u5f53\u524d\u5355\u636e");
        MutexHelper.checkMutex((DynamicFormApplication)application, ids, commandArg.getKey(), numberMap);
    }

    public static final void checkMutexForList(BeforeCommandArg arg, ListApplication application) throws BOSException, EASBizException {
        if (!MutexHelper.isNeedMutex((DynamicFormApplication)application, arg.getKey())) {
            return;
        }
        String[] ids = application.getListView().getSelectedBillIds();
        if (ids == null || ids.length == 0) {
            return;
        }
        Map numberMap = MutexHelper.getNumberMap(ids, application);
        MutexHelper.checkMutex((DynamicFormApplication)application, ids, arg.getKey(), numberMap);
    }

    private static final Map getNumberMap(String[] ids, ListApplication application) throws BOSException {
        HashMap<String, String> numberMap = new HashMap<String, String>(ids.length);
        try {
            IRowSet row = application.getListModel().getAllData();
            if (MutexHelper.existCol((RowSet)row, "Fbillnumber")) {
                while (row.next()) {
                    numberMap.put(row.getString("fid"), row.getString("Fbillnumber"));
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return numberMap;
    }

    private static final boolean existCol(RowSet row, String colName) throws SQLException {
        ResultSetMetaData metaData;
        ResultSetMetaData resultSetMetaData = metaData = row != null ? row.getMetaData() : null;
        if (metaData != null) {
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String colLable = metaData.getColumnLabel(i);
                if (colLable == null || !colLable.toString().equalsIgnoreCase(colName)) continue;
                return true;
            }
        }
        return false;
    }

    private static final void checkMutex(DynamicFormApplication application, String[] ids, String commandKey, Map numberMap) throws EASBizException {
        String formId = application.getDynamicFormModel().getBusinessInfo().getForm().getId();
        MutexSession.clearSelect4Mutexid(application.getApplicationContext(), formId);
        MutexSession.disableMutex(application.getApplicationContext());
        MutexResult mutexResult = MutexHelper.checkMutex(application.getContext(), ids);
        if (mutexResult.getUnavailableIdList() != null && mutexResult.getUnavailableIdList().size() > 0) {
            for (int i = 0; i < mutexResult.getUnavailableIdList().size(); ++i) {
                String id = mutexResult.getUnavailableIdList().get(i).toString();
                mutexResult.addErrMessage(numberMap != null && numberMap.get(id) != null ? numberMap.get(id).toString() : "\u5f53\u524d\u64cd\u4f5c\u7684\u5355\u636e");
            }
            throw new EASBizException(new NumericExceptionSubItem("100", mutexResult.getErrMessage() + "\u88ab\u5176\u5b83\u64cd\u4f5c\u9501\u5b9a"));
        }
        if (MutexHelper.isLockNext(application, commandKey)) {
            MutexSession.enableMutex(application.getApplicationContext());
            MutexSession.addSelect4Mutexid(application.getApplicationContext(), formId, ids);
        }
    }

    public static final MutexResult checkMutex(Context ctx, String[] ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        MutexResult mutexResult = new MutexResult();
        String id = null;
        for (int i = 0; i < ids.length; ++i) {
            try {
                id = ids[i];
                MutexHelper.checkMutex(ctx, id);
                mutexResult.addAvailableId(id);
                continue;
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            mutexResult.addUnavailableId(id);
        }
        return mutexResult;
    }

    public static final void checkMutex(Context ctx, String id) throws EASBizException, BOSException {
        MutexHelper.requestObjIDForUpdate(ctx, id);
        MutexHelper.releaseObjIDForUpdate(id);
    }

    public static final void requestObjIDForUpdate(Context ctx, String id) throws EASBizException, BOSException {
        ResourceUtil.requestObjIDForUpdate((Context)ctx, (String)id);
    }

    public static final void releaseObjIDForUpdate(String id) throws BOSException {
        MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate(id);
    }

    private static final String[] getParentSelectId(BillApplication applicaiton) {
        DynamicWebFormPanel parentView = MutexHelper.getParentView(applicaiton);
        return MutexSession.getSelect4Mutexids(parentView.getApplicationContext(), parentView.getBusinessInfo().getForm().getId());
    }

    private static final DynamicWebFormPanel getParentView(BillApplication applicaiton) {
        if (applicaiton.getBillView().getParentFormView() != null) {
            return (DynamicWebFormPanel)applicaiton.getBillView().getParentFormView();
        }
        return null;
    }

    static {
        LIST_MUTEXT_BUTTON.put("mnuEditAudit".toLowerCase(), Boolean.FALSE);
        LIST_MUTEXT_BUTTON.put("mnuEditSubmit".toLowerCase(), Boolean.FALSE);
        LIST_MUTEXT_BUTTON.put("mnuEditDelete".toLowerCase(), Boolean.FALSE);
        LIST_MUTEXT_BUTTON.put("tbAssginClue".toLowerCase(), Boolean.TRUE);
        LIST_MUTEXT_BUTTON.put("FBtnDistributeUser".toLowerCase(), Boolean.TRUE);
        LIST_MUTEXT_BUTTON.put("FBtnRecycleUser".toLowerCase(), Boolean.TRUE);
        LIST_MUTEXT_BUTTON.put("FBtnDistributeShareUser".toLowerCase(), Boolean.TRUE);
        LIST_MUTEXT_BUTTON.put("FBtnRecycleShareUser".toLowerCase(), Boolean.TRUE);
        LIST_MUTEXT_BUTTON.put("mnuDistribute".toLowerCase(), Boolean.TRUE);
        BILL_MUTEXT_BUTTON.put("FdistributeUser".toLowerCase(), Boolean.TRUE);
        BILL_MUTEXT_BUTTON.put("FrecycleUser".toLowerCase(), Boolean.FALSE);
        BILL_MUTEXT_BUTTON.put("FdistributePerson".toLowerCase(), Boolean.TRUE);
        BILL_MUTEXT_BUTTON.put("FrecyclePerson".toLowerCase(), Boolean.FALSE);
        BILL_MUTEXT_BUTTON.put("FbtnSubmit".toLowerCase(), Boolean.FALSE);
        BILL_MUTEXT_BUTTON.put("FbtnAudit".toLowerCase(), Boolean.FALSE);
        BILL_MUTEXT_BUTTON.put("Fisubmit".toLowerCase(), Boolean.FALSE);
        BILL_MUTEXT_BUTTON.put("Fiaudit".toLowerCase(), Boolean.FALSE);
        BILL_MUTEXT_BUTTON.put("Ficlose".toLowerCase(), Boolean.TRUE);
        BILL_MUTEXT_BUTTON.put("FIdistribute".toLowerCase(), Boolean.TRUE);
        BILL_MUTEXT_BUTTON.put("Fishareusers".toLowerCase(), Boolean.TRUE);
        BILL_MUTEXT_BUTTON.put("fiaccessories", Boolean.TRUE);
        BILL_MUTEXT_BUTTON.put("fichargeitem", Boolean.TRUE);
    }
}

